/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    final Logger LOGGER = LoggerFactory.getLogger(NimClientCodegen.class);
    public static final String PROJECT_NAME = "projectName";
    protected String packageName = "openapiclient";
    protected String packageVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "nim";
    }

    @Override
    public String getHelp() {
        return "Generates a nim client (beta).";
    }

    public NimClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "nim";
        this.modelTemplateFiles.put("model.mustache", ".nim");
        this.apiTemplateFiles.put("api.mustache", ".nim");
        this.templateDir = "nim-client";
        this.embeddedTemplateDir = "nim-client";
        this.apiPackage = File.separator + this.packageName + File.separator + "apis";
        this.modelPackage = File.separator + this.packageName + File.separator + "models";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("sample_client.mustache", "", "sample_client.nim"));
        this.supportingFiles.add(new SupportingFile("config.mustache", "", "config.nim"));
        this.setReservedWordsLowerCase(Arrays.asList("addr", "and", "as", "asm", "bind", "block", "break", "case", "cast", "concept", "const", "continue", "converter", "defer", "discard", "distinct", "div", "do", "elif", "else", "end", "enum", "except", "export", "finally", "for", "from", "func", "if", "import", "in", "include", "interface", "is", "isnot", "iterator", "let", "macro", "method", "mixin", "mod", "nil", "not", "notin", "object", "of", "or", "out", "proc", "ptr", "raise", "ref", "return", "shl", "shr", "static", "template", "try", "tuple", "type", "using", "var", "when", "while", "xor", "yield"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("array", "map"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "int8", "int16", "int32", "int64", "uint", "uint8", "uint16", "uint32", "uint64", "float", "float32", "float64", "bool", "char", "string", "cstring", "pointer"));
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "float64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("file", "string");
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.apiPackage = File.separator + this.packageName + File.separator + "apis";
        this.modelPackage = File.separator + this.packageName + File.separator + "models";
        this.supportingFiles.add(new SupportingFile("lib.mustache", "", this.packageName + ".nim"));
    }

    @Override
    public String escapeReservedWord(String name) {
        this.LOGGER.warn("A reserved word \"{}\" is used. Consider renaming the field name", (Object)name);
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "`" + name + "`";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name = name.replaceAll("-", "_"))) {
            return "model_" + StringUtils.underscore((String)this.importMapping.get(name));
        }
        return "model_" + StringUtils.underscore(name);
    }

    @Override
    public String toApiImport(String name) {
        if (this.importMapping.containsKey(name = name.replaceAll("-", "_"))) {
            return "api_" + StringUtils.underscore((String)this.importMapping.get(name));
        }
        return "api_" + StringUtils.underscore(name);
    }

    @Override
    public String toModelFilename(String name) {
        name = name.replaceAll("-", "_");
        return "model_" + StringUtils.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return "api_" + StringUtils.underscore(name);
    }

    @Override
    public String toOperationId(String operationId) {
        Object sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord((String)sanitizedOperationId)) {
            sanitizedOperationId = "call" + StringUtils.camelize((String)sanitizedOperationId);
        }
        return StringUtils.camelize((String)sanitizedOperationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            operation.httpMethod = operation.httpMethod.toLowerCase(Locale.ROOT);
        }
        return objs;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            if (inner == null) {
                return null;
            }
            return "seq[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            if (inner == null) {
                inner = new StringSchema();
            }
            return "Table[string, " + this.getTypeDeclaration(inner) + "]";
        }
        String schemaType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (schemaType.matches("\\d.*")) {
            return "`" + schemaType + "`";
        }
        return schemaType;
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName((String)name, "\\W-[\\$]"))) {
            name = "_u";
        }
        if (((String)name).matches("^\\d.*")) {
            name = "`" + (String)name + "`";
        }
        if (((String)name).matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_LETTER)))) {
            name = this.escapeReservedWord((String)name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    protected boolean needToImport(String type) {
        if (this.defaultIncludes.contains(type)) {
            return false;
        }
        if (this.languageSpecificPrimitives.contains(type)) {
            return false;
        }
        return !this.typeMapping.containsKey(type) || !this.languageSpecificPrimitives.contains(this.typeMapping.get(type));
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String name = StringUtils.camelize(property.name);
        if (name.matches("\\d.*")) {
            return "`" + name + "`";
        }
        return name;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        name = name.replace(" ", "_");
        if ((name = StringUtils.camelize(name)).matches("\\d.*")) {
            return "`" + name + "`";
        }
        return name;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.NIM;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }
}

