/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.languages.features.SwaggerUIFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KotlinSpringServerCodegen
extends AbstractKotlinCodegen
implements BeanValidationFeatures,
DocumentationProviderFeatures,
SwaggerUIFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(KotlinSpringServerCodegen.class);
    private static final HashSet<String> VARIABLE_RESERVED_WORDS = new HashSet<String>(Arrays.asList("ApiClient", "ApiException", "ApiResponse"));
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String TITLE = "title";
    public static final String SERVER_PORT = "serverPort";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String SPRING_BOOT = "spring-boot";
    public static final String SPRING_CLOUD_LIBRARY = "spring-cloud";
    public static final String EXCEPTION_HANDLER = "exceptionHandler";
    public static final String GRADLE_BUILD_FILE = "gradleBuildFile";
    public static final String SERVICE_INTERFACE = "serviceInterface";
    public static final String SERVICE_IMPLEMENTATION = "serviceImplementation";
    public static final String SKIP_DEFAULT_INTERFACE = "skipDefaultInterface";
    public static final String REACTIVE = "reactive";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String USE_FEIGN_CLIENT_URL = "useFeignClientUrl";
    public static final String USE_FEIGN_CLIENT = "useFeignClient";
    public static final String DELEGATE_PATTERN = "delegatePattern";
    public static final String USE_TAGS = "useTags";
    public static final String BEAN_QUALIFIERS = "beanQualifiers";
    public static final String USE_SPRING_BOOT3 = "useSpringBoot3";
    public static final String APPEND_REQUEST_TO_HANDLER = "appendRequestToHandler";
    public static final String REQUEST_MAPPING_OPTION = "requestMappingMode";
    public static final String USE_REQUEST_MAPPING_ON_CONTROLLER = "useRequestMappingOnController";
    public static final String USE_REQUEST_MAPPING_ON_INTERFACE = "useRequestMappingOnInterface";
    private String basePackage;
    protected String configPackage;
    private String invokerPackage;
    private String serverPort = "8080";
    private String title = "OpenAPI Kotlin Spring";
    private boolean useBeanValidation = true;
    private boolean skipDefaultInterface = false;
    private boolean exceptionHandler = true;
    private boolean gradleBuildFile = true;
    private boolean useSwaggerUI = true;
    private boolean serviceInterface = false;
    private boolean serviceImplementation = false;
    private boolean reactive = false;
    private boolean interfaceOnly = false;
    protected boolean useFeignClientUrl = true;
    protected boolean useFeignClient = false;
    private boolean delegatePattern = false;
    protected boolean useTags = false;
    private boolean beanQualifiers = false;
    protected boolean useSpringBoot3 = false;
    protected RequestMappingMode requestMappingMode = RequestMappingMode.controller;
    private DocumentationProviderFeatures.DocumentationProvider documentationProvider;
    private DocumentationProviderFeatures.AnnotationLibrary annotationLibrary;

    public KotlinSpringServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, new SecurityFeature[]{SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_AuthorizationCode})).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.reservedWords.addAll(VARIABLE_RESERVED_WORDS);
        this.outputFolder = "generated-code/kotlin-spring";
        this.templateDir = "kotlin-spring";
        this.embeddedTemplateDir = "kotlin-spring";
        this.artifactId = "openapi-spring";
        this.invokerPackage = "org.openapitools";
        this.basePackage = "org.openapitools";
        this.configPackage = "org.openapitools.configuration";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.updateOption("artifactId", this.artifactId);
        this.additionalProperties.put("openbrace", OPEN_BRACE);
        this.additionalProperties.put("closebrace", CLOSE_BRACE);
        this.typeMapping.put("array", "kotlin.collections.List");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("file", "org.springframework.core.io.Resource");
        this.addOption(TITLE, "server title name or client service name", this.title);
        this.addOption(CONFIG_PACKAGE, "configuration package for generated code", this.getConfigPackage());
        this.addOption(BASE_PACKAGE, "base package (invokerPackage) for generated code", this.basePackage);
        this.addOption(SERVER_PORT, "configuration the port in which the sever is to run on", this.serverPort);
        this.addOption("modelPackage", "model package for generated code", this.modelPackage);
        this.addOption("apiPackage", "api package for generated code", this.apiPackage);
        this.addSwitch(EXCEPTION_HANDLER, "generate default global exception handlers (not compatible with reactive. enabling reactive will disable exceptionHandler )", this.exceptionHandler);
        this.addSwitch(GRADLE_BUILD_FILE, "generate a gradle build file using the Kotlin DSL", this.gradleBuildFile);
        this.addSwitch("useSwaggerUI", "Open the OpenApi specification in swagger-ui. Will also import and configure needed dependencies", this.useSwaggerUI);
        this.addSwitch(SERVICE_INTERFACE, "generate service interfaces to go alongside controllers. In most cases this option would be used to update an existing project, so not to override implementations. Useful to help facilitate the generation gap pattern", this.serviceInterface);
        this.addSwitch(SERVICE_IMPLEMENTATION, "generate stub service implementations that extends service interfaces. If this is set to true service interfaces will also be generated", this.serviceImplementation);
        this.addSwitch("useBeanValidation", "Use BeanValidation API annotations to validate data types", this.useBeanValidation);
        this.addSwitch(SKIP_DEFAULT_INTERFACE, "Whether to skip generation of default implementations for interfaces", this.skipDefaultInterface);
        this.addSwitch(REACTIVE, "use coroutines for reactive behavior", this.reactive);
        this.addSwitch(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.", this.interfaceOnly);
        this.addSwitch(USE_FEIGN_CLIENT_URL, "Whether to generate Feign client with url parameter.", this.useFeignClientUrl);
        this.addSwitch(DELEGATE_PATTERN, "Whether to generate the server files using the delegate pattern", this.delegatePattern);
        this.addSwitch(USE_TAGS, "Whether to use tags for creating interface and controller class names", this.useTags);
        this.addSwitch(BEAN_QUALIFIERS, "Whether to add fully-qualifier class names as bean qualifiers in @Component and @RestController annotations. May be used to prevent bean names clash if multiple generated libraries (contexts) added to single project.", this.beanQualifiers);
        this.addSwitch(USE_SPRING_BOOT3, "Generate code and provide dependencies for use with Spring Boot 3.x. (Use jakarta instead of javax in imports). Enabling this option will also enable `useJakartaEe`.", this.useSpringBoot3);
        this.addSwitch(APPEND_REQUEST_TO_HANDLER, "Append ServerHttpRequest to handler method for getting request stuff", false);
        this.supportedLibraries.put(SPRING_BOOT, "Spring-boot Server application.");
        this.supportedLibraries.put(SPRING_CLOUD_LIBRARY, "Spring-Cloud-Feign client with Spring-Boot auto-configured settings.");
        this.setLibrary(SPRING_BOOT);
        CliOption cliOpt = new CliOption("library", "library template (sub-template)");
        cliOpt.setDefault(SPRING_BOOT);
        cliOpt.setEnum(this.supportedLibraries);
        this.cliOptions.add(cliOpt);
        CliOption requestMappingOpt = new CliOption(REQUEST_MAPPING_OPTION, "Where to generate the class level @RequestMapping annotation.").defaultValue(this.requestMappingMode.name());
        for (RequestMappingMode mode : RequestMappingMode.values()) {
            requestMappingOpt.addEnum(mode.name(), mode.getDescription());
        }
        this.cliOptions.add(requestMappingOpt);
        if (null != this.defaultDocumentationProvider()) {
            CliOption documentationProviderCliOption = new CliOption("documentationProvider", "Select the OpenAPI documentation provider.").defaultValue(this.defaultDocumentationProvider().toCliOptValue());
            this.supportedDocumentationProvider().forEach(dp -> documentationProviderCliOption.addEnum(dp.toCliOptValue(), dp.getDescription()));
            this.cliOptions.add(documentationProviderCliOption);
            CliOption annotationLibraryCliOption = new CliOption("annotationLibrary", "Select the complementary documentation annotation library.").defaultValue(this.defaultDocumentationProvider().getPreferredAnnotationLibrary().toCliOptValue());
            this.supportedAnnotationLibraries().forEach(al -> annotationLibraryCliOption.addEnum(al.toCliOptValue(), al.getDescription()));
            this.cliOptions.add(annotationLibraryCliOption);
        }
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider getDocumentationProvider() {
        return this.documentationProvider;
    }

    @Override
    public void setDocumentationProvider(DocumentationProviderFeatures.DocumentationProvider documentationProvider) {
        this.documentationProvider = documentationProvider;
    }

    @Override
    public DocumentationProviderFeatures.AnnotationLibrary getAnnotationLibrary() {
        return this.annotationLibrary;
    }

    @Override
    public void setAnnotationLibrary(DocumentationProviderFeatures.AnnotationLibrary annotationLibrary) {
        this.annotationLibrary = annotationLibrary;
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider defaultDocumentationProvider() {
        return DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC;
    }

    @Override
    public List<DocumentationProviderFeatures.DocumentationProvider> supportedDocumentationProvider() {
        return Arrays.asList(DocumentationProviderFeatures.DocumentationProvider.NONE, DocumentationProviderFeatures.DocumentationProvider.SOURCE, DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX, DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC);
    }

    @Override
    public List<DocumentationProviderFeatures.AnnotationLibrary> supportedAnnotationLibraries() {
        return Arrays.asList(DocumentationProviderFeatures.AnnotationLibrary.NONE, DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1, DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2);
    }

    private boolean selectedDocumentationProviderRequiresSwaggerUiBootstrap() {
        return this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX) || this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SOURCE);
    }

    public boolean getExceptionHandler() {
        return this.exceptionHandler;
    }

    public boolean getGradleBuildFile() {
        return this.gradleBuildFile;
    }

    public boolean getUseSwaggerUI() {
        return this.useSwaggerUI;
    }

    @Override
    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    public boolean getServiceInterface() {
        return this.serviceInterface;
    }

    public boolean getServiceImplementation() {
        return this.serviceImplementation;
    }

    public boolean getUseBeanValidation() {
        return this.useBeanValidation;
    }

    public boolean isAppendRequestToHandler() {
        return Boolean.parseBoolean(((Object)this.additionalProperties.getOrDefault(APPEND_REQUEST_TO_HANDLER, false)).toString());
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "kotlin-spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin Spring application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
            this.LOGGER.warn("The springfox documentation provider is deprecated for removal. Use the springdoc provider instead.");
        }
        if (null != this.defaultDocumentationProvider()) {
            this.documentationProvider = DocumentationProviderFeatures.DocumentationProvider.ofCliOption(this.additionalProperties.getOrDefault("documentationProvider", this.defaultDocumentationProvider().toCliOptValue()));
            if (!this.supportedDocumentationProvider().contains((Object)this.documentationProvider)) {
                String msg = String.format(Locale.ROOT, "The [%s] Documentation Provider is not supported by this generator", this.documentationProvider.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.annotationLibrary = DocumentationProviderFeatures.AnnotationLibrary.ofCliOption(this.additionalProperties.getOrDefault("annotationLibrary", this.documentationProvider.getPreferredAnnotationLibrary().toCliOptValue()));
            if (!this.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The Annotation Library [%s] is not supported by this generator", this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            if (!this.documentationProvider.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The [%s] documentation provider does not support [%s] as complementary annotation library", this.documentationProvider.toCliOptValue(), this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.additionalProperties.put("documentationProvider", this.documentationProvider.toCliOptValue());
            this.additionalProperties.put(this.documentationProvider.getPropertyName(), true);
            this.additionalProperties.put("annotationLibrary", this.annotationLibrary.toCliOptValue());
            this.additionalProperties.put(this.annotationLibrary.getPropertyName(), true);
        } else {
            this.additionalProperties.put("documentationProvider", DocumentationProviderFeatures.DocumentationProvider.NONE);
            this.additionalProperties.put("annotationLibrary", DocumentationProviderFeatures.AnnotationLibrary.NONE);
        }
        if (this.isModelMutable()) {
            this.typeMapping.put("array", "kotlin.collections.MutableList");
            this.typeMapping.put("list", "kotlin.collections.MutableList");
            this.typeMapping.put("set", "kotlin.collections.MutableSet");
            this.typeMapping.put("map", "kotlin.collections.MutableMap");
        }
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (!this.additionalProperties.containsKey("library")) {
            this.additionalProperties.put("library", this.library);
        }
        if (!this.additionalProperties.containsKey(BASE_PACKAGE) && this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            this.LOGGER.info("Set base package to invoker package ({})", (Object)this.basePackage);
        }
        if (this.additionalProperties.containsKey(REQUEST_MAPPING_OPTION)) {
            RequestMappingMode optValue = RequestMappingMode.valueOf(String.valueOf(this.additionalProperties.get(REQUEST_MAPPING_OPTION)));
            this.setRequestMappingMode(optValue);
            this.additionalProperties.remove(REQUEST_MAPPING_OPTION);
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        } else {
            this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(SERVER_PORT)) {
            this.setServerPort((String)this.additionalProperties.get(SERVER_PORT));
        } else {
            this.additionalProperties.put(SERVER_PORT, this.serverPort);
        }
        if (this.additionalProperties.containsKey(EXCEPTION_HANDLER)) {
            this.setExceptionHandler(Boolean.parseBoolean(this.additionalProperties.get(EXCEPTION_HANDLER).toString()));
        }
        this.writePropertyBack(EXCEPTION_HANDLER, this.exceptionHandler);
        if (this.additionalProperties.containsKey(GRADLE_BUILD_FILE)) {
            this.setGradleBuildFile(Boolean.parseBoolean(this.additionalProperties.get(GRADLE_BUILD_FILE).toString()));
        }
        this.writePropertyBack(GRADLE_BUILD_FILE, this.gradleBuildFile);
        if (this.additionalProperties.containsKey("useSwaggerUI")) {
            this.setUseSwaggerUI(Boolean.parseBoolean(this.additionalProperties.get("useSwaggerUI").toString()));
        }
        if (this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.NONE)) {
            this.setUseSwaggerUI(false);
        }
        this.writePropertyBack("useSwaggerUI", this.useSwaggerUI);
        if (this.additionalProperties.containsKey(SERVICE_INTERFACE)) {
            this.setServiceInterface(Boolean.parseBoolean(this.additionalProperties.get(SERVICE_INTERFACE).toString()));
        }
        this.writePropertyBack(SERVICE_INTERFACE, this.serviceInterface);
        if (this.additionalProperties.containsKey(SERVICE_IMPLEMENTATION)) {
            this.setServiceImplementation(Boolean.parseBoolean(this.additionalProperties.get(SERVICE_IMPLEMENTATION).toString()));
        }
        this.writePropertyBack(SERVICE_IMPLEMENTATION, this.serviceImplementation);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(SKIP_DEFAULT_INTERFACE)) {
            this.setSkipDefaultInterface(this.convertPropertyToBoolean(SKIP_DEFAULT_INTERFACE));
        }
        this.writePropertyBack(SKIP_DEFAULT_INTERFACE, this.skipDefaultInterface);
        if (this.additionalProperties.containsKey(REACTIVE)) {
            if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
                throw new IllegalArgumentException("Currently, reactive option doesn't supported by Spring Cloud");
            }
            if (this.library.equals(SPRING_BOOT)) {
                this.setReactive(this.convertPropertyToBoolean(REACTIVE));
                this.setExceptionHandler(false);
            }
        }
        this.writePropertyBack(REACTIVE, this.reactive);
        this.writePropertyBack(EXCEPTION_HANDLER, this.exceptionHandler);
        if (this.additionalProperties.containsKey(BEAN_QUALIFIERS) && this.library.equals(SPRING_BOOT)) {
            this.setBeanQualifiers(this.convertPropertyToBoolean(BEAN_QUALIFIERS));
        }
        this.writePropertyBack(BEAN_QUALIFIERS, this.beanQualifiers);
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.library.equals(SPRING_CLOUD_LIBRARY)) {
            this.setInterfaceOnly(true);
            this.setUseFeignClient(true);
            this.additionalProperties.put(USE_FEIGN_CLIENT, true);
        }
        if (this.additionalProperties.containsKey(USE_FEIGN_CLIENT_URL)) {
            this.setUseFeignClientUrl(Boolean.parseBoolean(this.additionalProperties.get(USE_FEIGN_CLIENT_URL).toString()));
        }
        this.writePropertyBack(USE_FEIGN_CLIENT_URL, this.useFeignClientUrl);
        if (this.additionalProperties.containsKey(DELEGATE_PATTERN)) {
            this.setDelegatePattern(Boolean.parseBoolean(this.additionalProperties.get(DELEGATE_PATTERN).toString()));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.parseBoolean(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if (this.additionalProperties.containsKey(USE_SPRING_BOOT3)) {
            this.setUseSpringBoot3(this.convertPropertyToBoolean(USE_SPRING_BOOT3));
        }
        if (this.isUseSpringBoot3()) {
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                throw new IllegalArgumentException(DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.getPropertyName() + " is not supported with Spring Boot > 3.x");
            }
            if (DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1.equals((Object)this.getAnnotationLibrary())) {
                throw new IllegalArgumentException(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1.getPropertyName() + " is not supported with Spring Boot > 3.x");
            }
            this.useJakartaEe = true;
            this.additionalProperties.put("useJakartaEe", this.useJakartaEe);
            this.applyJakartaPackage();
        }
        this.writePropertyBack(USE_SPRING_BOOT3, this.isUseSpringBoot3());
        this.modelTemplateFiles.put("model.mustache", ".kt");
        if (!this.interfaceOnly && this.delegatePattern) {
            this.apiTemplateFiles.put("apiInterface.mustache", ".kt");
            this.apiTemplateFiles.put("apiController.mustache", "Controller.kt");
        } else if (this.interfaceOnly) {
            this.apiTemplateFiles.put("apiInterface.mustache", ".kt");
        } else {
            this.apiTemplateFiles.put("api.mustache", "Controller.kt");
            this.apiTestTemplateFiles.put("api_test.mustache", ".kt");
        }
        if (this.serviceInterface) {
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
        } else if (this.serviceImplementation) {
            this.LOGGER.warn("If you set `serviceImplementation` to true, `serviceInterface` will also be set to true");
            this.additionalProperties.put(SERVICE_INTERFACE, true);
            this.apiTemplateFiles.put("service.mustache", "Service.kt");
            this.apiTemplateFiles.put("serviceImpl.mustache", "ServiceImpl.kt");
        }
        if (this.delegatePattern) {
            this.additionalProperties.put("isDelegate", "true");
            this.apiTemplateFiles.put("apiDelegate.mustache", "Delegate.kt");
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (this.exceptionHandler && !this.library.equals(SPRING_CLOUD_LIBRARY)) {
            this.supportingFiles.add(new SupportingFile("exceptions.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.apiPackage), "Exceptions.kt"));
        }
        if (this.library.equals(SPRING_BOOT)) {
            this.LOGGER.info("Setup code generator for Kotlin Spring Boot");
            this.supportingFiles.add(new SupportingFile("apiUtil.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtil.kt"));
            if (this.isUseSpringBoot3()) {
                this.supportingFiles.add(new SupportingFile("pom-sb3.mustache", "", "pom.xml"));
            } else {
                this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
            }
            if (this.gradleBuildFile) {
                if (this.isUseSpringBoot3()) {
                    this.supportingFiles.add(new SupportingFile("buildGradle-sb3-Kts.mustache", "", "build.gradle.kts"));
                } else {
                    this.supportingFiles.add(new SupportingFile("buildGradleKts.mustache", "", "build.gradle.kts"));
                }
                this.supportingFiles.add(new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
            }
            if (!this.interfaceOnly) {
                if (this.documentationProvider != DocumentationProviderFeatures.DocumentationProvider.NONE) {
                    this.supportingFiles.add(new SupportingFile("homeController.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "HomeController.kt"));
                    this.supportingFiles.add(new SupportingFile("openapi.mustache", this.resourcesFolder.replace("/", File.separator), "openapi.yaml"));
                }
                this.supportingFiles.add(new SupportingFile("application.mustache", this.resourcesFolder, "application.yaml"));
                this.supportingFiles.add(new SupportingFile("springBootApplication.mustache", KotlinSpringServerCodegen.sanitizeDirectory(this.sourceFolder + File.separator + this.basePackage), "Application.kt"));
                if (this.useSwaggerUI && this.selectedDocumentationProviderRequiresSwaggerUiBootstrap()) {
                    this.supportingFiles.add(new SupportingFile("swagger-ui.mustache", this.resourcesFolder + "/static", "swagger-ui.html"));
                }
            }
        }
        if (this.library.equals(SPRING_CLOUD_LIBRARY)) {
            this.LOGGER.info("Setup code generator for Kotlin Spring Cloud Client");
            if (this.isUseSpringBoot3()) {
                this.supportingFiles.add(new SupportingFile("pom-sb3.mustache", "pom.xml"));
            } else {
                this.supportingFiles.add(new SupportingFile("pom.mustache", "pom.xml"));
            }
            if (this.gradleBuildFile) {
                if (this.isUseSpringBoot3()) {
                    this.supportingFiles.add(new SupportingFile("buildGradle-sb3-Kts.mustache", "build.gradle.kts"));
                } else {
                    this.supportingFiles.add(new SupportingFile("buildGradleKts.mustache", "build.gradle.kts"));
                }
                this.supportingFiles.add(new SupportingFile("settingsGradle.mustache", "settings.gradle"));
            }
            this.setRequestMappingMode(RequestMappingMode.none);
            this.supportingFiles.add(new SupportingFile("apiKeyRequestInterceptor.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ApiKeyRequestInterceptor.kt"));
            this.supportingFiles.add(new SupportingFile("clientConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientConfiguration.kt"));
            this.apiTemplateFiles.put("apiClient.mustache", "Client.kt");
            this.apiTestTemplateFiles.clear();
        }
        if (!this.reactive && !this.library.equals(SPRING_CLOUD_LIBRARY)) {
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                this.supportingFiles.add(new SupportingFile("springfoxDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "SpringFoxConfiguration.kt"));
            } else if (DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC.equals((Object)this.getDocumentationProvider())) {
                this.supportingFiles.add(new SupportingFile("springdocDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "SpringDocConfiguration.kt"));
            }
        }
        switch (this.getRequestMappingMode()) {
            case api_interface: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_INTERFACE, true);
                break;
            }
            case controller: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_CONTROLLER, true);
                break;
            }
            case none: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_INTERFACE, false);
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_CONTROLLER, false);
            }
        }
        this.additionalProperties.put("jackson", "true");
        this.additionalProperties.put("lambdaEscapeInNormalString", (fragment, writer) -> writer.write(fragment.execute().replaceAll("([$\"\\\\])", "\\\\$1")));
        this.additionalProperties.put("lambdaRemoveLineBreak", (fragment, writer) -> writer.write(fragment.execute().replaceAll("[\\r\\n]", "")));
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"escapeDoubleQuote", (Object)new EscapeLambda("\"", "\\\""));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.library.equals(SPRING_BOOT) && !this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.isEmpty()) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
        } else {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, 8080));
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (model.discriminator != null && this.additionalProperties.containsKey("jackson")) {
            model.imports.addAll(Arrays.asList("JsonSubTypes", "JsonTypeInfo"));
        }
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        objs.getModels().stream().map(ModelMap::getModel).filter(cm -> Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null).forEach(cm -> {
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            cm.imports.add((String)this.importMapping.get("JsonProperty"));
            HashMap<String, String> itemJsonValue = new HashMap<String, String>();
            itemJsonValue.put("import", (String)this.importMapping.get("JsonValue"));
            imports.add(itemJsonValue);
            HashMap<String, String> itemJsonProperty = new HashMap<String, String>();
            itemJsonProperty.put("import", (String)this.importMapping.get("JsonProperty"));
            imports.add(itemJsonProperty);
        });
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            ops.forEach(operation -> {
                List<CodegenParameter> allParams;
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    responses.forEach(resp -> {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        resp.baseType = this.getNonMutableContainerTypeIfNeeded(resp.baseType);
                        this.doDataTypeAssignment(resp.dataType, new AbstractKotlinCodegen.DataTypeAssigner((CodegenResponse)resp){
                            final /* synthetic */ CodegenResponse val$resp;
                            {
                                this.val$resp = codegenResponse;
                            }

                            @Override
                            public void setReturnType(String returnType) {
                                this.val$resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                this.val$resp.containerType = returnContainer;
                            }
                        });
                    });
                }
                if ((allParams = operation.allParams) != null) {
                    if (this.isAppendRequestToHandler()) {
                        allParams.add(new RequestCodegenParameter(true));
                    }
                    allParams.forEach(param -> {
                        param.dataType = this.getNonMutableContainerTypeIfNeeded(param.dataType);
                    });
                }
                this.doDataTypeAssignment(operation.returnType, new AbstractKotlinCodegen.DataTypeAssigner((CodegenOperation)operation){
                    final /* synthetic */ CodegenOperation val$operation;
                    {
                        this.val$operation = codegenOperation;
                    }

                    @Override
                    public void setReturnType(String returnType) {
                        this.val$operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        this.val$operation.returnContainer = returnContainer;
                    }
                });
            });
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return objs;
    }

    private String getNonMutableContainerTypeIfNeeded(String type) {
        if (type != null && type.contains("kotlin.collections.Mutable")) {
            return type.replaceAll("kotlin\\.collections\\.Mutable", "kotlin.collections.");
        }
        return type;
    }

    private static String sanitizeDirectory(String in) {
        return in.replace(".", File.separator);
    }

    @Override
    public String toModelName(String name) {
        if (name.startsWith("org.springframework.")) {
            return name;
        }
        return super.toModelName(name);
    }

    @Override
    protected boolean needToImport(String type) {
        return !type.startsWith("org.springframework.") && super.needToImport(type);
    }

    public RequestMappingMode getRequestMappingMode() {
        return this.requestMappingMode;
    }

    public void setRequestMappingMode(RequestMappingMode requestMappingMode) {
        this.requestMappingMode = requestMappingMode;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setSkipDefaultInterface(boolean skipDefaultInterface) {
        this.skipDefaultInterface = skipDefaultInterface;
    }

    public void setExceptionHandler(boolean exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setGradleBuildFile(boolean gradleBuildFile) {
        this.gradleBuildFile = gradleBuildFile;
    }

    public void setServiceInterface(boolean serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceImplementation(boolean serviceImplementation) {
        this.serviceImplementation = serviceImplementation;
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setUseFeignClientUrl(boolean useFeignClientUrl) {
        this.useFeignClientUrl = useFeignClientUrl;
    }

    public void setUseFeignClient(boolean useFeignClient) {
        this.useFeignClient = useFeignClient;
    }

    public void setDelegatePattern(boolean delegatePattern) {
        this.delegatePattern = delegatePattern;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setBeanQualifiers(boolean beanQualifiers) {
        this.beanQualifiers = beanQualifiers;
    }

    public boolean isUseSpringBoot3() {
        return this.useSpringBoot3;
    }

    public void setUseSpringBoot3(boolean useSpringBoot3) {
        this.useSpringBoot3 = useSpringBoot3;
    }

    static class RequestCodegenParameter
    extends CodegenParameter {
        boolean isRequestObject;

        public RequestCodegenParameter(boolean isRequestObject) {
            this.isRequestObject = isRequestObject;
        }

        public boolean isRequestObject() {
            return this.isRequestObject;
        }

        public void setRequestObject(boolean isRequestObject) {
            this.isRequestObject = isRequestObject;
        }

        @Override
        public String toString() {
            return "KotlinSpringServerCodegen.RequestCodegenParameter(isRequestObject=" + this.isRequestObject() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestCodegenParameter)) {
                return false;
            }
            RequestCodegenParameter other = (RequestCodegenParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.isRequestObject() == other.isRequestObject();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestCodegenParameter;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + (this.isRequestObject() ? 79 : 97);
            return result;
        }
    }

    private static class EscapeLambda
    implements Mustache.Lambda {
        private final String from;
        private final String to;

        EscapeLambda(String from, String to) {
            this.from = from;
            this.to = Matcher.quoteReplacement(to);
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll(this.from, this.to));
        }
    }

    public static enum RequestMappingMode {
        api_interface("Generate the @RequestMapping annotation on the generated Api Interface."),
        controller("Generate the @RequestMapping annotation on the generated Api Controller Implementation."),
        none("Do not add a class level @RequestMapping annotation.");

        private String description;

        public String getDescription() {
            return this.description;
        }

        private RequestMappingMode(String description) {
            this.description = description;
        }
    }
}

