/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.templating.mustache.EscapeChar;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKotlinCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String MODEL_MUTABLE = "modelMutable";
    public static final String MODEL_MUTABLE_DESC = "Create mutable models";
    public static final String ADDITIONAL_MODEL_TYPE_ANNOTATIONS = "additionalModelTypeAnnotations";
    public static final String JAVAX_PACKAGE = "javaxPackage";
    public static final String USE_JAKARTA_EE = "useJakartaEe";
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractKotlinCodegen.class);
    protected String artifactId;
    protected String artifactVersion = "1.0.0";
    protected String groupId = "org.openapitools";
    protected String packageName = "org.openapitools";
    protected String apiSuffix = "Api";
    protected String sourceFolder = "src/main/kotlin";
    protected String testFolder = "src/test/kotlin";
    protected String resourcesFolder = "src/main/resources";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean parcelizeModels = false;
    protected boolean serializableModel = false;
    protected boolean useJakartaEe = false;
    protected boolean nonPublicApi = false;
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.original;
    protected Set<String> propertyAdditionalKeywords = new HashSet<String>(Arrays.asList("entries", "keys", "size", "values"));
    private final Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();
    protected List<String> additionalModelTypeAnnotations = new LinkedList<String>();

    public AbstractKotlinCodegen() {
        this.supportsInheritance = true;
        this.setSortModelPropertiesByRequiredFlag(true);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.String", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.MutableList", "kotlin.collections.Map", "kotlin.collections.MutableMap", "kotlin.collections.Set", "kotlin.collections.MutableSet"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ApiResponse", "abstract", "actual", "annotation", "as", "break", "class", "companion", "const", "constructor", "continue", "contract", "crossinline", "data", "delegate", "do", "dynamic", "else", "enum", "expect", "external", "false", "field", "final", "finally", "for", "fun", "if", "import", "in", "infix", "init", "inline", "inner", "interface", "internal", "is", "it", "lateinit", "noinline", "null", "object", "open", "operator", "out", "override", "package", "param", "private", "property", "protected", "public", "receiver", "reified", "return", "sealed", "setparam", "super", "suspend", "tailrec", "this", "throw", "true", "try", "typealias", "typeof", "val", "value", "var", "vararg", "when", "where", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("kotlin.Byte", "kotlin.ByteArray", "kotlin.Short", "kotlin.Int", "kotlin.Long", "kotlin.Float", "kotlin.Double", "kotlin.Boolean", "kotlin.Char", "kotlin.Array", "kotlin.collections.List", "kotlin.collections.MutableList", "kotlin.collections.Set", "kotlin.collections.MutableSet", "kotlin.collections.Map", "kotlin.collections.MutableMap"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "kotlin.String");
        this.typeMapping.put("boolean", "kotlin.Boolean");
        this.typeMapping.put("integer", "kotlin.Int");
        this.typeMapping.put("float", "kotlin.Float");
        this.typeMapping.put("long", "kotlin.Long");
        this.typeMapping.put("double", "kotlin.Double");
        this.typeMapping.put("ByteArray", "kotlin.ByteArray");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("decimal", "java.math.BigDecimal");
        this.typeMapping.put("date-time", "java.time.OffsetDateTime");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("file", "java.io.File");
        this.typeMapping.put("array", "kotlin.Array");
        this.typeMapping.put("list", "kotlin.collections.List");
        this.typeMapping.put("set", "kotlin.collections.Set");
        this.typeMapping.put("map", "kotlin.collections.Map");
        this.typeMapping.put("object", "kotlin.Any");
        this.typeMapping.put("binary", "kotlin.ByteArray");
        this.typeMapping.put("Date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.OffsetDateTime");
        this.typeMapping.put("AnyType", "kotlin.Any");
        this.instantiationTypes.put("array", "kotlin.collections.ArrayList");
        this.instantiationTypes.put("list", "kotlin.collections.ArrayList");
        this.instantiationTypes.put("map", "kotlin.collections.HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.time.LocalDate");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("DateTime", "java.time.OffsetDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.specialCharReplacements.put(";", "Semicolon");
        this.cliOptions.clear();
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageName", "Generated artifact package name.", this.packageName);
        this.addOption("apiSuffix", "suffix for api classes", this.apiSuffix);
        this.addOption("groupId", "Generated artifact package's organization (i.e. maven groupId).", this.groupId);
        this.addOption("artifactId", "Generated artifact id (name of jar).", this.artifactId);
        this.addOption("artifactVersion", "Generated artifact's package version.", this.artifactVersion);
        CliOption enumPropertyNamingOpt = new CliOption("enumPropertyNaming", "Naming convention for enum properties: 'camelCase', 'PascalCase', 'snake_case', 'UPPERCASE', and 'original'");
        this.cliOptions.add(enumPropertyNamingOpt.defaultValue(this.enumPropertyNaming.name()));
        this.cliOptions.add(new CliOption("parcelizeModels", "toggle \"@Parcelize\" for generated models"));
        this.cliOptions.add(new CliOption("serializableModel", "boolean - toggle \"implements Serializable\" for generated models"));
        this.cliOptions.add(new CliOption("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters."));
        this.cliOptions.add(new CliOption("sortModelPropertiesByRequiredFlag", "Sort model properties to place required parameters before optional parameters."));
        this.cliOptions.add(CliOption.newBoolean(MODEL_MUTABLE, MODEL_MUTABLE_DESC, false));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, "Additional annotations for model type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + File.separator + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + File.separator + this.testFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + File.separator + this.testFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeReservedWord(String name) {
        return String.format(Locale.ROOT, "`%s`", name);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setEnumPropertyNaming(String enumPropertyNamingType) {
        try {
            this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(enumPropertyNamingType);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumPropertyNamingType + " is an invalid enum property naming option. Please choose from:");
            for (CodegenConstants.ENUM_PROPERTY_NAMING_TYPE t : CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = this.unaliasSchema(p);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = ModelUtils.getSchemaItems(schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = ModelUtils.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<kotlin.String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        objs = super.updateAllModels(objs);
        if (!this.additionalModelTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                Map models = objs.get(modelName);
                models.put(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, this.additionalModelTypeAnnotations);
            }
        }
        return objs;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        block0: for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (cm.getDiscriminator() != null) {
                cm.vendorExtensions.put("x-has-data-class-body", true);
                break;
            }
            for (CodegenProperty var : cm.vars) {
                if (!var.isEnum && !this.isSerializableModel()) continue;
                cm.vendorExtensions.put("x-has-data-class-body", true);
                continue block0;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("KOTLIN_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable KOTLIN_POST_PROCESS_FILE not defined so the Kotlin code may not be properly formatted. To define it, try 'export KOTLIN_POST_PROCESS_FILE=\"/usr/local/bin/ktlint -F\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(MODEL_MUTABLE)) {
            this.additionalProperties.put(MODEL_MUTABLE, Boolean.parseBoolean(this.additionalProperties.get(MODEL_MUTABLE).toString()));
        }
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            if (!this.additionalProperties.containsKey("modelPackage")) {
                this.setModelPackage(this.packageName + ".models");
            }
            if (!this.additionalProperties.containsKey("apiPackage")) {
                this.setApiPackage(this.packageName + ".apis");
            }
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("apiSuffix")) {
            this.setApiSuffix((String)this.additionalProperties.get("apiSuffix"));
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn("{} with {} generator is ignored. Use {}.", new Object[]{"invokerPackage", this.getName(), "packageName"});
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(this.convertPropertyToBooleanAndWriteBack("serializableModel"));
        } else {
            this.additionalProperties.put("serializableModel", this.serializableModel);
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("parcelizeModels")) {
            this.setParcelizeModels(this.convertPropertyToBooleanAndWriteBack("parcelizeModels"));
        } else {
            this.additionalProperties.put("parcelizeModels", this.parcelizeModels);
        }
        if (this.additionalProperties.containsKey("nonPublicApi")) {
            this.setNonPublicApi(this.convertPropertyToBooleanAndWriteBack("nonPublicApi"));
        } else {
            this.additionalProperties.put("nonPublicApi", this.nonPublicApi);
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_MODEL_TYPE_ANNOTATIONS)) {
            String additionalAnnotationsList = this.additionalProperties.get(ADDITIONAL_MODEL_TYPE_ANNOTATIONS).toString();
            this.setAdditionalModelTypeAnnotations(Arrays.asList(additionalAnnotationsList.trim().split("\\s*(;|\\r?\\n)\\s*")));
        }
        this.additionalProperties.put("sortParamsByRequiredFlag", this.getSortParamsByRequiredFlag());
        this.additionalProperties.put("sortModelPropertiesByRequiredFlag", this.getSortModelPropertiesByRequiredFlag());
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.isModelMutable()) {
            this.typeMapping.put("list", "kotlin.collections.MutableList");
            this.typeMapping.put("set", "kotlin.collections.MutableSet");
            this.typeMapping.put("map", "kotlin.collections.MutableMap");
        }
        if (this.additionalProperties.containsKey(USE_JAKARTA_EE)) {
            this.setUseJakartaEe(Boolean.parseBoolean(this.additionalProperties.get(USE_JAKARTA_EE).toString()));
        }
        this.additionalProperties.put(USE_JAKARTA_EE, this.useJakartaEe);
        if (this.useJakartaEe) {
            this.applyJakartaPackage();
        } else {
            this.applyJavaxPackage();
        }
    }

    protected boolean isModelMutable() {
        return Boolean.TRUE.equals(this.additionalProperties.get(MODEL_MUTABLE));
    }

    public Boolean getParcelizeModels() {
        return this.parcelizeModels;
    }

    public void setParcelizeModels(Boolean parcelizeModels) {
        this.parcelizeModels = parcelizeModels;
    }

    public boolean nonPublicApi() {
        return this.nonPublicApi;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String modified;
        if (this.enumNameMapping.containsKey(value)) {
            return (String)this.enumNameMapping.get(value);
        }
        if (value.isEmpty()) {
            modified = "EMPTY";
        } else {
            modified = value;
            modified = this.sanitizeKotlinSpecificNames(modified);
        }
        switch (this.getEnumPropertyNaming()) {
            case original: {
                modified = value;
                break;
            }
            case camelCase: {
                modified = StringUtils.camelize(modified, CamelizeOption.LOWERCASE_FIRST_LETTER);
                break;
            }
            case PascalCase: {
                String result = StringUtils.camelize(modified);
                modified = this.titleCase(result);
                break;
            }
            case snake_case: {
                modified = StringUtils.underscore(modified);
                break;
            }
            case UPPERCASE: {
                modified = StringUtils.underscore(modified).toUpperCase(Locale.ROOT);
            }
        }
        if (this.reservedWords.contains(modified)) {
            return this.escapeReservedWord(modified);
        }
        return this.sanitizeKotlinSpecificNames(modified);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return property.nameInPascalCase;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.apiSuffix.isEmpty() ? StringUtils.camelize(name) : StringUtils.camelize(name) + this.apiSuffix;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(name)) {
            return super.toModelImport(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaKeyToModelNameCache.containsKey(name)) {
            return this.schemaKeyToModelNameCache.get(name);
        }
        if (name.startsWith("kotlin.") || name.startsWith("java.")) {
            return name;
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String modifiedName = name.replaceAll("\\.", "").replaceAll("-", "_");
        Object nameWithPrefixSuffix = this.sanitizeKotlinSpecificNames(modifiedName);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(modifiedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + modifiedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)modifiedName, (Object)modelName);
            return modelName;
        }
        if (modifiedName.matches("^\\d.*")) {
            String modelName = "Model" + modifiedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        this.schemaKeyToModelNameCache.put(name, this.titleCase(modifiedName));
        return this.schemaKeyToModelNameCache.get(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), CamelizeOption.LOWERCASE_FIRST_LETTER))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)CamelizeOption.LOWERCASE_FIRST_LETTER);
            operationId = StringUtils.camelize("call_" + operationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        return operationId;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    private String sanitizeKotlinSpecificNames(String name) {
        Object word = name;
        for (Map.Entry<String, String> entry : this.specialCharReplacements.entrySet()) {
            word = this.replaceSpecialCharacters((String)word, entry);
        }
        word = Pattern.compile("\\W+", 256).matcher((CharSequence)word).replaceAll("_");
        if (((String)word).matches("\\d.*")) {
            word = "_" + (String)word;
        }
        if (((String)word).matches("^_*$")) {
            word = ((String)word).replaceAll("\\Q_\\E", "Underscore");
        }
        return word;
    }

    private String replaceSpecialCharacters(String word, Map.Entry<String, String> specialCharacters) {
        String specialChar = specialCharacters.getKey();
        String replacementChar = specialCharacters.getValue();
        if (!specialChar.equals("_") && word.contains(specialChar)) {
            return this.replaceCharacters(word, specialChar, replacementChar);
        }
        return word;
    }

    private String replaceCharacters(String word, String oldValue, String newValue) {
        if (!word.contains(oldValue)) {
            return word;
        }
        if (word.equals(oldValue)) {
            return newValue;
        }
        int i = word.indexOf(oldValue);
        String start = word.substring(0, i);
        String end = this.recurseOnEndOfWord(word, oldValue, newValue, i);
        return start + newValue + end;
    }

    private String recurseOnEndOfWord(String word, String oldValue, String newValue, int lastReplacedValue) {
        String end = word.substring(lastReplacedValue + 1);
        if (!end.isEmpty()) {
            end = this.titleCase(end);
            end = this.replaceCharacters(end, oldValue, newValue);
        }
        return end;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    protected void applyJavaxPackage() {
        this.writePropertyBack(JAVAX_PACKAGE, "javax");
    }

    protected void applyJakartaPackage() {
        this.writePropertyBack(JAVAX_PACKAGE, "jakarta");
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    protected boolean needToImport(String type) {
        return !type.startsWith("kotlin.") && !type.startsWith("java.") && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type) && !type.contains(".");
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel m = super.fromModel(name, schema);
        m.optionalVars = m.optionalVars.stream().distinct().collect(Collectors.toList());
        Map allVarsMap = m.allVars.stream().collect(Collectors.toMap(CodegenProperty::getBaseName, Function.identity()));
        allVarsMap.keySet().removeAll(m.vars.stream().map(CodegenProperty::getBaseName).collect(Collectors.toSet()));
        allVarsMap.values().forEach(p -> {
            p.isInherited = true;
        });
        Stream.of(m.requiredVars, m.optionalVars).flatMap(Collection::stream).filter(p -> allVarsMap.containsKey(p.baseName)).forEach(p -> {
            p.isInherited = true;
        });
        return m;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("kotlin.Int".equals(datatype) || "kotlin.Long".equals(datatype)) {
            return value;
        }
        if ("kotlin.Double".equals(datatype)) {
            if (value.contains(".")) {
                return value;
            }
            return value + ".0";
        }
        if ("kotlin.Float".equals(datatype)) {
            return value + "f";
        }
        return "\"" + value + "\"";
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType) || "kotlin.String".equals(dataType);
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVariableName(name);
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if (this.propertyAdditionalKeywords.contains(name = this.toVariableName(name))) {
            return StringUtils.camelize("property_" + name, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        return name;
    }

    protected String toVariableName(String name) {
        name = this.sanitizeName((String)name, "\\W-[\\$]");
        if (((String)(name = this.sanitizeKotlinSpecificNames((String)name))).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (((String)name).matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters((String)name)) {
            name = ((String)name).substring(0, 2).toLowerCase(Locale.ROOT) + ((String)name).substring(2);
        }
        if (((String)name).chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = StringUtils.escape((String)name, this.specialCharReplacements, allowedCharacters, "_");
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name, CamelizeOption.LOWERCASE_FIRST_LETTER))) || ((String)name).matches("(^\\d.*)|(.*[$].*)")) {
            name = this.escapeReservedWord((String)name);
        }
        return name;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String kotlinPostProcessFile = System.getenv("KOTLIN_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)kotlinPostProcessFile)) {
            return;
        }
        if ("kt".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = kotlinPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    private String fixNumberValue(String number, Schema p) {
        if (ModelUtils.isFloatSchema(p)) {
            return number + "f";
        }
        if (ModelUtils.isDoubleSchema(p)) {
            if (number.contains(".")) {
                return number;
            }
            return number + ".0";
        }
        if (ModelUtils.isLongSchema(p)) {
            return number + "L";
        }
        return number;
    }

    @Override
    public String toDefaultValue(CodegenProperty cp, Schema schema) {
        if (ModelUtils.isBooleanSchema(schema = ModelUtils.getReferencedSchema(this.openAPI, (Schema)schema))) {
            if (schema.getDefault() != null) {
                return schema.getDefault().toString();
            }
        } else {
            if (ModelUtils.isDateSchema(schema)) {
                return null;
            }
            if (ModelUtils.isDateTimeSchema(schema)) {
                return null;
            }
            if (ModelUtils.isNumberSchema(schema)) {
                if (schema.getDefault() != null) {
                    return this.fixNumberValue(schema.getDefault().toString(), schema);
                }
            } else if (ModelUtils.isIntegerSchema(schema)) {
                if (schema.getDefault() != null) {
                    return this.fixNumberValue(schema.getDefault().toString(), schema);
                }
            } else if (ModelUtils.isURISchema(schema)) {
                if (schema.getDefault() != null) {
                    return (String)this.importMapping.get("URI") + ".create(\"" + schema.getDefault() + "\")";
                }
            } else {
                if (ModelUtils.isArraySchema(schema)) {
                    return this.toArrayDefaultValue(cp, schema);
                }
                if (ModelUtils.isStringSchema(schema)) {
                    if (schema.getDefault() != null) {
                        String _default = String.valueOf(schema.getDefault());
                        if (schema.getEnum() == null) {
                            return "\"" + this.escapeText(_default) + "\"";
                        }
                        return _default;
                    }
                    return null;
                }
                if (ModelUtils.isObjectSchema(schema)) {
                    if (schema.getDefault() != null) {
                        return super.toDefaultValue(schema);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private String toArrayDefaultValue(CodegenProperty cp, Schema schema) {
        if (schema.getDefault() != null) {
            String arrInstantiationType;
            String string = arrInstantiationType = ModelUtils.isSet(schema) ? "set" : "arrayList";
            if (!(schema.getDefault() instanceof ArrayNode)) {
                return null;
            }
            ArrayNode _default = (ArrayNode)schema.getDefault();
            if (_default.isEmpty()) {
                return arrInstantiationType + "Of()";
            }
            StringBuilder defaultContent = new StringBuilder();
            Schema<?> itemsSchema = ModelUtils.getSchemaItems(schema);
            _default.elements().forEachRemaining(element -> {
                String defaultValue = element.asText();
                if (defaultValue != null) {
                    if (cp.items.getIsEnumOrRef()) {
                        String className = cp.items.datatypeWithEnum;
                        String enumVarName = this.toEnumVarName(defaultValue, cp.items.dataType);
                        defaultContent.append(className).append(".").append(enumVarName).append(",");
                    } else {
                        itemsSchema.setDefault((Object)defaultValue);
                        defaultValue = this.toDefaultValue(cp, itemsSchema);
                        defaultContent.append(defaultValue).append(",");
                    }
                }
            });
            defaultContent.deleteCharAt(defaultContent.length() - 1);
            return arrInstantiationType + "Of(" + defaultContent + ")";
        }
        return null;
    }

    public String toDefaultParameterValue(CodegenProperty cp, Schema schema) {
        return this.toDefaultValue(cp, schema);
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.KOTLIN;
    }

    @Override
    protected void updateModelForObject(CodegenModel m, Schema schema) {
        if (schema.getProperties() != null || schema.getRequired() != null && !ModelUtils.isComposedSchema(schema)) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        if (ModelUtils.isMapSchema(schema)) {
            this.addAdditionPropertiesToCodeGenModel(m, schema);
        } else {
            m.setIsMap(false);
            if (ModelUtils.isFreeFormObject(schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
            }
        }
        this.setAddProps(schema, m);
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"escapeDollar", (Object)new EscapeChar("(?<!\\\\)\\$", "\\\\\\$"));
    }

    protected void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        if (returnType == null) {
            dataTypeAssigner.setReturnType("Unit");
        } else if (returnType.startsWith("kotlin.collections.List")) {
            int end2 = returnType.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (returnType.startsWith("kotlin.collections.MutableList")) {
            int end3 = returnType.lastIndexOf(">");
            if (end3 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.MutableList<".length(), end3).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (returnType.startsWith("kotlin.collections.Map")) {
            int end4 = returnType.lastIndexOf(">");
            if (end4 > 0) {
                dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.Map<".length(), end4).split(",")[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (returnType.startsWith("kotlin.collections.MutableMap") && (end = returnType.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(returnType.substring("kotlin.collections.MutableMap<".length(), end).split(",")[1].trim());
            dataTypeAssigner.setReturnContainer("Map");
        }
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setApiSuffix(String apiSuffix) {
        this.apiSuffix = apiSuffix;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public boolean isSerializableModel() {
        return this.serializableModel;
    }

    public void setSerializableModel(boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    public void setUseJakartaEe(boolean useJakartaEe) {
        this.useJakartaEe = useJakartaEe;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    public CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    public List<String> getAdditionalModelTypeAnnotations() {
        return this.additionalModelTypeAnnotations;
    }

    public void setAdditionalModelTypeAnnotations(List<String> additionalModelTypeAnnotations) {
        this.additionalModelTypeAnnotations = additionalModelTypeAnnotations;
    }

    protected static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

