/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.languages.features.SwaggerUIFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.templating.mustache.SplitStringLambda;
import org.openapitools.codegen.templating.mustache.TrimWhitespaceLambda;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
OptionalFeatures,
SwaggerUIFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(SpringCodegen.class);
    public static final String TITLE = "title";
    public static final String SERVER_PORT = "serverPort";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String DELEGATE_PATTERN = "delegatePattern";
    public static final String SINGLE_CONTENT_TYPES = "singleContentTypes";
    public static final String VIRTUAL_SERVICE = "virtualService";
    public static final String SKIP_DEFAULT_INTERFACE = "skipDefaultInterface";
    public static final String ASYNC = "async";
    public static final String REACTIVE = "reactive";
    public static final String RESPONSE_WRAPPER = "responseWrapper";
    public static final String USE_TAGS = "useTags";
    public static final String SPRING_BOOT = "spring-boot";
    public static final String SPRING_CLOUD_LIBRARY = "spring-cloud";
    public static final String API_FIRST = "apiFirst";
    public static final String SPRING_CONTROLLER = "useSpringController";
    public static final String HATEOAS = "hateoas";
    public static final String RETURN_SUCCESS_CODE = "returnSuccessCode";
    public static final String UNHANDLED_EXCEPTION_HANDLING = "unhandledException";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    protected String title = "OpenAPI Spring";
    protected String configPackage = "org.openapitools.configuration";
    protected String basePackage = "org.openapitools";
    protected boolean interfaceOnly = false;
    protected boolean delegatePattern = false;
    protected boolean delegateMethod = false;
    protected boolean singleContentTypes = false;
    protected boolean async = false;
    protected boolean reactive = false;
    protected String responseWrapper = "";
    protected boolean skipDefaultInterface = false;
    protected boolean useTags = false;
    protected boolean useBeanValidation = true;
    protected boolean performBeanValidation = false;
    protected boolean apiFirst = false;
    protected boolean useOptional = false;
    protected boolean virtualService = false;
    protected boolean hateoas = false;
    protected boolean returnSuccessCode = false;
    protected boolean unhandledException = false;
    protected boolean useSpringController = false;
    protected boolean useSwaggerUI = true;

    public SpringCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, new SecurityFeature[]{SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.ApiKey, SecurityFeature.BasicAuth})).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/javaSpring";
        this.templateDir = "JavaSpring";
        this.embeddedTemplateDir = "JavaSpring";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-spring";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.apiTestTemplateFiles.clear();
        this.additionalProperties.put("jackson", "true");
        this.additionalProperties.put("openbrace", OPEN_BRACE);
        this.additionalProperties.put("closebrace", CLOSE_BRACE);
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code").defaultValue(this.getConfigPackage()));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package (invokerPackage) for generated code").defaultValue(this.getBasePackage()));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.", this.interfaceOnly));
        this.cliOptions.add(CliOption.newBoolean(DELEGATE_PATTERN, "Whether to generate the server files using the delegate pattern", this.delegatePattern));
        this.cliOptions.add(CliOption.newBoolean(SINGLE_CONTENT_TYPES, "Whether to select only one produces/consumes content-type by operation.", this.singleContentTypes));
        this.cliOptions.add(CliOption.newBoolean(SKIP_DEFAULT_INTERFACE, "Whether to generate default implementations for java8 interfaces", this.skipDefaultInterface));
        this.cliOptions.add(CliOption.newBoolean(ASYNC, "use async Callable controllers", this.async));
        this.cliOptions.add(CliOption.newBoolean(REACTIVE, "wrap responses in Mono/Flux Reactor types (spring-boot only)", this.reactive));
        this.cliOptions.add(new CliOption(RESPONSE_WRAPPER, "wrap the responses in given type (Future, Callable, CompletableFuture,ListenableFuture, DeferredResult, RxObservable, RxSingle or fully qualified type)"));
        this.cliOptions.add(CliOption.newBoolean(VIRTUAL_SERVICE, "Generates the virtual service. For more details refer - https://github.com/virtualansoftware/virtualan/wiki"));
        this.cliOptions.add(CliOption.newBoolean(USE_TAGS, "use tags for creating interface and controller classnames", this.useTags));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Use Bean Validation Impl. to perform BeanValidation", this.performBeanValidation));
        this.cliOptions.add(CliOption.newBoolean(API_FIRST, "Generate the API from the OAI spec at server compile time (API first approach)", this.apiFirst));
        this.cliOptions.add(CliOption.newBoolean("useOptional", "Use Optional container for optional parameters", this.useOptional));
        this.cliOptions.add(CliOption.newBoolean(HATEOAS, "Use Spring HATEOAS library to allow adding HATEOAS links", this.hateoas));
        this.cliOptions.add(CliOption.newBoolean(RETURN_SUCCESS_CODE, "Generated server returns 2xx code", this.returnSuccessCode));
        this.cliOptions.add(CliOption.newBoolean(SPRING_CONTROLLER, "Annotate the generated API as a Spring Controller", this.useSpringController));
        this.cliOptions.add(CliOption.newBoolean(UNHANDLED_EXCEPTION_HANDLING, "Declare operation methods to throw a generic exception and allow unhandled exceptions (useful for Spring `@ControllerAdvice` directives).", this.unhandledException));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerUI", "Open the OpenApi specification in swagger-ui. Will also import and configure needed dependencies", this.useSwaggerUI));
        this.supportedLibraries.put(SPRING_BOOT, "Spring-boot Server application.");
        this.supportedLibraries.put(SPRING_CLOUD_LIBRARY, "Spring-Cloud-Feign client with Spring-Boot auto-configured settings.");
        this.setLibrary(SPRING_BOOT);
        CliOption library = new CliOption("library", "library template (sub-template)").defaultValue(SPRING_BOOT);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Java SpringBoot Server application using the SpringFox integration.";
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider defaultDocumentationProvider() {
        return DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC;
    }

    @Override
    public List<DocumentationProviderFeatures.DocumentationProvider> supportedDocumentationProvider() {
        ArrayList<DocumentationProviderFeatures.DocumentationProvider> supportedProviders = new ArrayList<DocumentationProviderFeatures.DocumentationProvider>();
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.NONE);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SOURCE);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC);
        return supportedProviders;
    }

    @Override
    public List<DocumentationProviderFeatures.AnnotationLibrary> supportedAnnotationLibraries() {
        ArrayList<DocumentationProviderFeatures.AnnotationLibrary> supportedLibraries = new ArrayList<DocumentationProviderFeatures.AnnotationLibrary>();
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.NONE);
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1);
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2);
        return supportedLibraries;
    }

    private boolean selectedDocumentationProviderRequiresSwaggerUiBootstrap() {
        return this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX) || this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SOURCE);
    }

    @Override
    public void processOpts() {
        List configOptions = this.additionalProperties.entrySet().stream().filter(e -> !Arrays.asList(API_FIRST, "hideGenerationTimestamp").contains(e.getKey())).filter(e -> this.cliOptions.stream().map(CliOption::getOpt).anyMatch(opt -> opt.equals(e.getKey()))).map(e -> Pair.of(e.getKey(), (Object)e.getValue().toString())).collect(Collectors.toList());
        this.additionalProperties.put("configOptions", configOptions);
        this.reservedWords.remove("file");
        this.LOGGER.info("----------------------------------");
        if (!this.additionalProperties.containsKey("dateLibrary")) {
            this.setDateLibrary("java8");
        }
        if (!this.additionalProperties.containsKey(BASE_PACKAGE) && this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            this.LOGGER.info("Set base package to invoker package ({})", (Object)this.basePackage);
        }
        super.processOpts();
        this.useOneOfInterfaces = true;
        this.legacyDiscriminatorBehavior = false;
        if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
            this.LOGGER.warn("The springfox documentation provider is deprecated for removal. Use the springdoc provider instead.");
        }
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        } else {
            this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(VIRTUAL_SERVICE)) {
            this.setVirtualService(Boolean.parseBoolean(this.additionalProperties.get(VIRTUAL_SERVICE).toString()));
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey(DELEGATE_PATTERN)) {
            this.setDelegatePattern(Boolean.parseBoolean(this.additionalProperties.get(DELEGATE_PATTERN).toString()));
        }
        if (this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
            this.setSingleContentTypes(Boolean.parseBoolean(this.additionalProperties.get(SINGLE_CONTENT_TYPES).toString()));
        }
        if (this.additionalProperties.containsKey(SKIP_DEFAULT_INTERFACE)) {
            this.setSkipDefaultInterface(Boolean.parseBoolean(this.additionalProperties.get(SKIP_DEFAULT_INTERFACE).toString()));
        }
        if (this.additionalProperties.containsKey(ASYNC)) {
            this.setAsync(Boolean.parseBoolean(this.additionalProperties.get(ASYNC).toString()));
            this.convertPropertyToBooleanAndWriteBack(ASYNC);
        }
        if (this.additionalProperties.containsKey(REACTIVE)) {
            if (!SPRING_BOOT.equals(this.library)) {
                throw new IllegalArgumentException("Currently, reactive option is only supported with Spring-boot");
            }
            this.setReactive(Boolean.parseBoolean(this.additionalProperties.get(REACTIVE).toString()));
        }
        if (this.additionalProperties.containsKey(RESPONSE_WRAPPER)) {
            this.setResponseWrapper((String)this.additionalProperties.get(RESPONSE_WRAPPER));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.parseBoolean(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey("performBeanValidation")) {
            this.setPerformBeanValidation(this.convertPropertyToBoolean("performBeanValidation"));
        }
        this.writePropertyBack("performBeanValidation", this.performBeanValidation);
        if (this.additionalProperties.containsKey("useOptional")) {
            this.setUseOptional(this.convertPropertyToBoolean("useOptional"));
        }
        if (this.additionalProperties.containsKey(API_FIRST)) {
            this.setApiFirst(Boolean.parseBoolean(this.additionalProperties.get(API_FIRST).toString()));
        }
        if (this.additionalProperties.containsKey(HATEOAS)) {
            this.setHateoas(Boolean.parseBoolean(this.additionalProperties.get(HATEOAS).toString()));
        }
        if (this.additionalProperties.containsKey(SPRING_CONTROLLER)) {
            this.setUseSpringController(this.convertPropertyToBoolean(SPRING_CONTROLLER));
        }
        this.writePropertyBack(SPRING_CONTROLLER, this.useSpringController);
        if (this.additionalProperties.containsKey(RETURN_SUCCESS_CODE)) {
            this.setReturnSuccessCode(Boolean.parseBoolean(this.additionalProperties.get(RETURN_SUCCESS_CODE).toString()));
        }
        if (this.additionalProperties.containsKey("useSwaggerUI")) {
            this.setUseSwaggerUI(this.convertPropertyToBoolean("useSwaggerUI"));
        }
        if (this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.NONE)) {
            this.setUseSwaggerUI(false);
        }
        this.writePropertyBack("useSwaggerUI", this.useSwaggerUI);
        if (this.additionalProperties.containsKey(UNHANDLED_EXCEPTION_HANDLING)) {
            this.setUnhandledException(Boolean.parseBoolean(this.additionalProperties.get(UNHANDLED_EXCEPTION_HANDLING).toString()));
        }
        this.additionalProperties.put(UNHANDLED_EXCEPTION_HANDLING, this.isUnhandledException());
        this.typeMapping.put("file", "org.springframework.core.io.Resource");
        this.importMapping.put("org.springframework.core.io.Resource", "org.springframework.core.io.Resource");
        this.importMapping.put("Pageable", "org.springframework.data.domain.Pageable");
        this.importMapping.put("DateTimeFormat", "org.springframework.format.annotation.DateTimeFormat");
        this.importMapping.put("ApiIgnore", "springfox.documentation.annotations.ApiIgnore");
        this.importMapping.put("ParameterObject", "org.springdoc.api.annotations.ParameterObject");
        if (this.useOptional) {
            this.writePropertyBack("useOptional", this.useOptional);
        }
        if (this.interfaceOnly && this.delegatePattern) {
            this.delegateMethod = true;
            this.additionalProperties.put("delegate-method", true);
        }
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (!this.interfaceOnly) {
            if (SPRING_BOOT.equals(this.library)) {
                if (this.useSwaggerUI && this.selectedDocumentationProviderRequiresSwaggerUiBootstrap()) {
                    this.supportingFiles.add(new SupportingFile("swagger-ui.mustache", "src/main/resources/static", "swagger-ui.html"));
                }
                this.supportingFiles.add(new SupportingFile("openapi2SpringBoot.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "OpenApiGeneratorApplication.java"));
                this.supportingFiles.add(new SupportingFile("SpringBootTest.mustache", (this.testFolder + File.separator + this.basePackage).replace(".", File.separator), "OpenApiGeneratorApplicationTests.java"));
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "RFC3339DateFormat.java"));
            }
            if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
                this.supportingFiles.add(new SupportingFile("apiKeyRequestInterceptor.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ApiKeyRequestInterceptor.java"));
                this.supportingFiles.add(new SupportingFile("clientConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientConfiguration.java"));
                this.apiTemplateFiles.put("apiClient.mustache", "Client.java");
                if (!this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
                    this.additionalProperties.put(SINGLE_CONTENT_TYPES, "true");
                    this.setSingleContentTypes(true);
                }
            } else {
                this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
                this.supportingFiles.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.properties"));
                this.supportingFiles.add(new SupportingFile("homeController.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "HomeController.java"));
                this.supportingFiles.add(new SupportingFile("openapi.mustache", "src/main/resources".replace("/", File.separator), "openapi.yaml"));
                if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider()) && !this.reactive && !this.apiFirst) {
                    this.supportingFiles.add(new SupportingFile("openapiDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SpringFoxConfiguration.java"));
                }
            }
        }
        if (!SPRING_CLOUD_LIBRARY.equals(this.library)) {
            this.supportingFiles.add(new SupportingFile("apiUtil.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtil.java"));
        }
        if (!this.delegatePattern || this.delegateMethod) {
            this.additionalProperties.put("jdk8-no-delegate", true);
        }
        if (this.delegatePattern && !this.delegateMethod) {
            this.additionalProperties.put("isDelegate", "true");
            this.apiTemplateFiles.put("apiDelegate.mustache", "Delegate.java");
        }
        this.additionalProperties.put("javaVersion", "1.8");
        if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
            this.additionalProperties.put("jdk8-default-interface", false);
        } else {
            this.additionalProperties.put("jdk8-default-interface", !this.skipDefaultInterface);
        }
        if (this.async) {
            this.additionalProperties.put(RESPONSE_WRAPPER, "CompletableFuture");
        }
        if (this.reactive) {
            this.additionalProperties.put(RESPONSE_WRAPPER, "Mono");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.responseWrapper)) {
            this.additionalProperties.put("jdk8-default-interface", false);
            switch (this.responseWrapper) {
                case "Future": 
                case "Callable": 
                case "CompletableFuture": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "java.util.concurrent." + this.responseWrapper);
                    break;
                }
                case "ListenableFuture": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.util.concurrent.ListenableFuture");
                    break;
                }
                case "DeferredResult": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.web.context.request.async.DeferredResult");
                    break;
                }
                case "RxObservable": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Observable");
                    break;
                }
                case "RxSingle": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Single");
                    break;
                }
            }
        }
        this.additionalProperties.put("lambdaRemoveDoubleQuote", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement(""))));
        this.additionalProperties.put("lambdaEscapeDoubleQuote", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement("\\\""))));
        this.additionalProperties.put("lambdaRemoveLineBreak", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\\r|\\n", "")));
        this.additionalProperties.put("lambdaTrimWhitespace", new TrimWhitespaceLambda());
        this.additionalProperties.put("lambdaSplitString", new SplitStringLambda());
        this.additionalProperties.put("_api_controller_impl_", false);
        if (this.apiFirst) {
            this.apiTemplateFiles.clear();
            this.modelTemplateFiles.clear();
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (SPRING_BOOT.equals(this.library) && !this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.isEmpty()) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
        } else {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, 8080));
        }
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        tags.add(value);
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (final CodegenOperation operation : ops) {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }
                });
                this.handleImplicitHeaders(operation);
            }
            objs.put("tagDescription", ((CodegenOperation)ops.get((int)0)).tags.get(0).getDescription());
        }
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        String rt = returnType;
        if (rt == null) {
            dataTypeAssigner.setReturnType("Void");
        } else if (rt.startsWith("List") || rt.startsWith("java.util.List")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (rt.startsWith("Map") || rt.startsWith("java.util.Map")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).split(",", 2)[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (rt.startsWith("Set") || rt.startsWith("java.util.Set")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).trim());
                dataTypeAssigner.setReturnContainer("Set");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List authMethods;
        this.generateYAMLSpecFile(objs);
        if (SPRING_CLOUD_LIBRARY.equals(this.library) && (authMethods = (List)objs.get("authMethods")) != null) {
            for (CodegenSecurity authMethod : authMethods) {
                authMethod.name = StringUtils.camelize(this.sanitizeName(authMethod.name), true);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("File".equals(type)) {
            String example = p.defaultValue == null ? p.example : p.defaultValue;
            if (example == null) {
                example = "/path/to/file";
            }
            p.example = example = "new org.springframework.core.io.FileSystemResource(new java.io.File(\"" + this.escapeText(example) + "\"))";
        } else {
            super.setParameterExampleValue(p);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public boolean isUnhandledException() {
        return this.unhandledException;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setDelegatePattern(boolean delegatePattern) {
        this.delegatePattern = delegatePattern;
    }

    public void setSingleContentTypes(boolean singleContentTypes) {
        this.singleContentTypes = singleContentTypes;
    }

    public void setSkipDefaultInterface(boolean skipDefaultInterface) {
        this.skipDefaultInterface = skipDefaultInterface;
    }

    public void setVirtualService(boolean virtualService) {
        this.virtualService = virtualService;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setResponseWrapper(String responseWrapper) {
        this.responseWrapper = responseWrapper;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setApiFirst(boolean apiFirst) {
        this.apiFirst = apiFirst;
    }

    public void setHateoas(boolean hateoas) {
        this.hateoas = hateoas;
    }

    public void setUseSpringController(boolean useSpringController) {
        this.useSpringController = useSpringController;
    }

    public void setReturnSuccessCode(boolean returnSuccessCode) {
        this.returnSuccessCode = returnSuccessCode;
    }

    public void setUnhandledException(boolean unhandledException) {
        this.unhandledException = unhandledException;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (property.isDate || property.isDateTime) {
            model.imports.add("DateTimeFormat");
        }
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (property.isByteArray) {
            model.imports.add("Arrays");
        }
        if (model.getVendorExtensions().containsKey("x-jackson-optional-nullable-helpers")) {
            model.imports.add("Arrays");
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (this.getAnnotationLibrary() != DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1) {
            codegenModel.imports.remove("ApiModelProperty");
            codegenModel.imports.remove("ApiModel");
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        codegenOperation.allParams.stream().filter(p -> p.isDate || p.isDateTime).findFirst().ifPresent(p -> codegenOperation.imports.add("DateTimeFormat"));
        if (codegenOperation.vendorExtensions.containsKey("x-spring-paginated")) {
            codegenOperation.imports.add("Pageable");
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                codegenOperation.imports.add("ApiIgnore");
            }
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC.equals((Object)this.getDocumentationProvider())) {
                codegenOperation.imports.add("ParameterObject");
            }
        }
        if (this.reactive && DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
            codegenOperation.imports.add("ApiIgnore");
        }
        return codegenOperation;
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    @Override
    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    @Override
    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        List<VendorExtension> extensions = super.getSupportedVendorExtensions();
        extensions.add(VendorExtension.X_SPRING_PAGINATED);
        return extensions;
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

