/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DryRunStatus;
import org.openapitools.codegen.api.TemplatingGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenerator
implements TemplatingGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenerator.class);
    protected boolean dryRun = false;
    protected Map<String, DryRunStatus> dryRunStatusMap = new HashMap<String, DryRunStatus>();

    public abstract boolean getEnableMinimalUpdate();

    public File writeToFile(String filename, String contents) throws IOException {
        return this.writeToFile(filename, contents.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToFile(String filename, byte[] contents) throws IOException {
        if (this.getEnableMinimalUpdate()) {
            String tempFilename = filename + ".tmp";
            File outputFile = Paths.get(filename, new String[0]).toFile();
            File tempFile = null;
            try {
                tempFile = this.writeToFileRaw(tempFilename, contents);
                if (!this.filesEqual(tempFile, outputFile)) {
                    LOGGER.info("writing file " + filename);
                    Files.move(tempFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    tempFile = null;
                } else {
                    LOGGER.info("skipping unchanged file " + filename);
                }
            }
            finally {
                if (tempFile != null && tempFile.exists()) {
                    try {
                        tempFile.delete();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error removing temporary file " + tempFile, (Throwable)ex);
                    }
                }
            }
            return outputFile;
        }
        LOGGER.info("writing file " + filename);
        return this.writeToFileRaw(filename, contents);
    }

    private boolean filesEqual(File file1, File file2) throws IOException {
        return file1.exists() && file2.exists() && Arrays.equals(Files.readAllBytes(file1.toPath()), Files.readAllBytes(file2.toPath()));
    }

    private File writeToFileRaw(String filename, byte[] contents) throws IOException {
        File output = Paths.get(filename, new String[0]).toFile();
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = Paths.get(output.getParent(), new String[0]).toFile();
            parent.mkdirs();
        }
        Files.write(output.toPath(), contents, new OpenOption[0]);
        return output;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            return new InputStreamReader(is, "UTF-8");
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    private String buildLibraryFilePath(String dir, String library, String file) {
        return dir + File.separator + "libraries" + File.separator + library + File.separator + file;
    }

    public String getFullTemplateFile(CodegenConfig config, String templateFile) {
        String embeddedLibTemplateFile;
        String libTemplateFile;
        String library = config.getLibrary();
        if (StringUtils.isNotEmpty((CharSequence)library) && (new File(libTemplateFile = this.buildLibraryFilePath(config.templateDir(), library, templateFile)).exists() || this.getClass().getClassLoader().getResource(libTemplateFile) != null)) {
            return libTemplateFile;
        }
        String template = config.templateDir() + File.separator + templateFile;
        if (new File(template).exists() || this.getClass().getClassLoader().getResource(template) != null) {
            return template;
        }
        if (StringUtils.isNotEmpty((CharSequence)library) && this.embeddedTemplateExists(embeddedLibTemplateFile = this.buildLibraryFilePath(config.embeddedTemplateDir(), library, templateFile))) {
            return embeddedLibTemplateFile;
        }
        return config.embeddedTemplateDir() + File.separator + templateFile;
    }

    public String readResourceContents(String resourceFilePath) {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(this.getClass().getResourceAsStream(this.getCPResourcePath(resourceFilePath)), "UTF-8");
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    public boolean embeddedTemplateExists(String name) {
        return this.getClass().getClassLoader().getResource(this.getCPResourcePath(name)) != null;
    }

    public String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }
}

