/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.ServiceProvider;
import org.openide.util.lookup.ServiceProviders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.openide.util.lookup.ServiceProvider", "org.openide.util.lookup.ServiceProviders"})
public class ServiceProviderProcessor
extends AbstractProcessor {
    private final Map<String, List<String>> outputFiles = new HashMap<String, List<String>>();
    private final Map<String, List<Element>> originatingElements = new HashMap<String, List<Element>>();

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Annotation annotation;
        TypeElement typeElement;
        if (roundEnvironment.errorRaised()) {
            return false;
        }
        if (roundEnvironment.processingOver()) {
            this.writeServices();
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ServiceProvider.class)) {
            typeElement = (TypeElement)element;
            if (!this.verifyServiceProviderSignature(typeElement)) continue;
            annotation = typeElement.getAnnotation(ServiceProvider.class);
            this.register(typeElement, (ServiceProvider)annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ServiceProviders.class)) {
            typeElement = (TypeElement)element;
            if (!this.verifyServiceProviderSignature(typeElement)) continue;
            annotation = typeElement.getAnnotation(ServiceProviders.class);
            for (ServiceProvider serviceProvider : annotation.value()) {
                this.register(typeElement, serviceProvider);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(TypeElement typeElement, ServiceProvider serviceProvider) {
        try {
            serviceProvider.service();
            assert (false);
            return;
        }
        catch (MirroredTypeException mirroredTypeException) {
            int n;
            TypeMirror typeMirror = mirroredTypeException.getTypeMirror();
            String string = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
            String string2 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror)).toString();
            if (!this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), typeMirror)) {
                AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, ServiceProvider.class);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string + " is not assignable to " + string2, typeElement, annotationMirror, this.findAnnotationValue(annotationMirror, "service"));
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, string + " to be registered as a " + string2);
            String string3 = (serviceProvider.path().length() > 0 ? "META-INF/namedservices/" + serviceProvider.path() + "/" : "META-INF/services/") + string2;
            List<Object> list = this.originatingElements.get(string3);
            if (list == null) {
                list = new ArrayList<Element>();
                this.originatingElements.put(string3, list);
            }
            list.add(typeElement);
            list = this.outputFiles.get(string3);
            if (list == null) {
                list = new ArrayList();
                try {
                    try {
                        FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", string3);
                        fileObject.openInputStream().close();
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + string3 + " because it already exists in sources: " + fileObject.toUri());
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", string3);
                            InputStream inputStream = fileObject.openInputStream();
                            try {
                                String string4;
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                                while ((string4 = bufferedReader.readLine()) != null) {
                                    list.add(string4);
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException2) {}
                    }
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.toString());
                    return;
                }
                this.outputFiles.put(string3, list);
            }
            if ((n = list.indexOf(string)) != -1) {
                list.remove(n);
                while (list.size() > n && ((String)list.get(n)).matches("#position=.+|#-.+")) {
                    list.remove(n);
                }
            }
            list.add(string);
            if (serviceProvider.position() != Integer.MAX_VALUE) {
                list.add("#position=" + serviceProvider.position());
            }
            for (String string5 : serviceProvider.supersedes()) {
                list.add("#-" + (String)string5);
            }
            return;
        }
    }

    private boolean verifyServiceProviderSignature(TypeElement typeElement) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, ServiceProvider.class);
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must be public", typeElement, annotationMirror);
            return false;
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must not be abstract", typeElement, annotationMirror);
            return false;
        }
        boolean bl = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must have a public no-argument constructor", typeElement, annotationMirror);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<String, List<String>> entry : this.outputFiles.entrySet()) {
            try {
                FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", entry.getKey(), this.originatingElements.get(entry.getKey()).toArray(new Element[0]));
                OutputStream outputStream = fileObject.openOutputStream();
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                    for (String string : entry.getValue()) {
                        printWriter.println(string);
                    }
                    printWriter.flush();
                    printWriter.close();
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + iOException.toString());
            }
        }
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> clazz) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(clazz.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(string)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

