/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.compiler.CompiledAccExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class DeepAssignmentNode
extends ASTNode
implements Assignment {
    private String property;
    private CompiledAccExpression acc;
    private ExecutableStatement statement;

    public DeepAssignmentNode(char[] expr, int start, int offset, int fields, int operation, String name, ParserContext pCtx) {
        super(pCtx);
        this.fields |= 2 | fields;
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        if (operation != -1) {
            this.property = name;
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(this.property, expr, start, offset, operation), pCtx);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int mark = ParseTools.find(expr, start, offset, '=');
            if (mark != -1) {
                this.property = ParseTools.createStringTrimmed(expr, start, mark - start);
                this.start = ParseTools.skipWhitespace(expr, mark + 1);
                if (this.start >= start + offset) {
                    throw new CompileException("unexpected end of statement", expr, mark + 1);
                }
                this.offset = offset - (this.start - start);
                if ((fields & 0x10) != 0) {
                    this.statement = (ExecutableStatement)ParseTools.subCompileExpression(expr, this.start, this.offset, pCtx);
                }
            } else {
                this.property = new String(expr);
            }
        }
        if ((fields & 0x10) != 0) {
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), start, offset, pCtx);
        }
    }

    public DeepAssignmentNode(char[] expr, int start, int offset, int fields, ParserContext pCtx) {
        this(expr, start, offset, fields, -1, null, pCtx);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset);
            this.acc = (CompiledAccExpression)MVEL.compileSetExpression(this.property.toCharArray(), this.statement.getKnownEgressType(), this.pCtx);
        }
        Object object = ctx;
        ctx = this.statement.getValue(ctx, thisValue, factory);
        this.acc.setValue(object, thisValue, factory, ctx);
        return ctx;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object object = ctx;
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        PropertyAccessor.set(object, factory, this.property, ctx, this.pCtx);
        return ctx;
    }

    public String getAbsoluteName() {
        return this.property.substring(0, this.property.indexOf(46));
    }

    public String getAssignmentVar() {
        return this.property;
    }

    public char[] getExpression() {
        return ParseTools.subArray(this.expr, this.start, this.offset);
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public boolean isAssignment() {
        return true;
    }

    public void setValueStatement(ExecutableStatement stmt) {
        this.statement = stmt;
    }
}

