/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.it;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tools.StringTools;

public final class MorfologikItalianSpellerRule
extends MorfologikSpellerRule {
    private static final String RESOURCE_FILENAME = "/it/hunspell/it_IT.dict";

    public MorfologikItalianSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_IT_IT";
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        ArrayList<String> originalSuggestionsStr = new ArrayList<String>();
        for (SuggestedReplacement suggestion : suggestions) {
            originalSuggestionsStr.add(suggestion.getReplacement());
        }
        for (SuggestedReplacement suggestion : suggestions) {
            String suggestionStr = suggestion.getReplacement();
            if (!StringTools.isCapitalizedWord((String)word) && StringTools.isCapitalizedWord((String)suggestionStr) && originalSuggestionsStr.contains(suggestionStr.toLowerCase())) continue;
            newSuggestions.add(suggestion);
        }
        return newSuggestions;
    }
}

