/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.German;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.de.GermanTools;
import org.languagetool.rules.de.LineExpander;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.rules.spelling.CommonFileTypes;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final String adjSuffix = "(affin|basiert|konform|widrig|f\u00e4hig|haltig|bedingt|gerecht|w\u00fcrdig|relevant|\u00fcbergreifend|tauglich|untauglich|artig|bezogen|orientiert|fremd|liebend|hassend|bildend|hemmend|abh\u00e4ngig|zentriert|f\u00f6rmig|m\u00e4\u00dfig|pflichtig|\u00e4hnlich|spezifisch|vertr\u00e4glich|technisch|typisch|frei|arm|freundlich|feindlich|gem\u00e4\u00df|neutral|seitig|begeistert|geeignet|ungeeignet|berechtigt|sicher|s\u00fcchtig|resistent)";
    private static final Pattern missingAdjPattern = Pattern.compile("[a-z\u00f6\u00e4\u00fc\u00df]{3,25}(affin|basiert|konform|widrig|f\u00e4hig|haltig|bedingt|gerecht|w\u00fcrdig|relevant|\u00fcbergreifend|tauglich|untauglich|artig|bezogen|orientiert|fremd|liebend|hassend|bildend|hemmend|abh\u00e4ngig|zentriert|f\u00f6rmig|m\u00e4\u00dfig|pflichtig|\u00e4hnlich|spezifisch|vertr\u00e4glich|technisch|typisch|frei|arm|freundlich|feindlich|gem\u00e4\u00df|neutral|seitig|begeistert|geeignet|ungeeignet|berechtigt|sicher|s\u00fcchtig|resistent)(er|es|en|em|e)?");
    private static final Pattern compoundPatternWithHeit = Pattern.compile(".*(heit|keit|ion|it\u00e4t|schaft|ung|t\u00e4t)s");
    private static final Pattern compoundPatternWithAction = Pattern.compile("Action|Session|Champion|Jung|Wahrung");
    private static final Pattern compoundPatternWithFirst = Pattern.compile("First|Firsten");
    private static final Pattern compoundPatternSpecialEnding = Pattern.compile(".*(mus|ss|z|\u00df|innen|chen)");
    private static final Set<String> lcDoNotSuggestWords = new HashSet<String>(Arrays.asList("verjuden", "verjudet", "verjudeter", "verjudetes", "verjudeter", "verjudeten", "verjudetem", "entjuden", "entjudet", "entjudete", "entjudetes", "entjudeter", "entjudeten", "entjudetem", "auschwitzmythos", "judensippe", "judensippen", "judensippschaft", "judensippschaften", "nigger", "niggern", "niggers", "rassejude", "rassejuden", "rassej\u00fcdin", "rassej\u00fcdinnen", "m\u00f6se", "m\u00f6sen", "fotze", "fotzen", "judenfrei", "judenfreie", "judenfreier", "judenfreies", "judenfreien", "judenfreiem", "judenrein", "judenreine", "judenreiner", "judenreines", "judenreinen", "judenreinem", "judenmord", "judenmorden", "judenm\u00f6rder"));
    private static final int MAX_TOKEN_LENGTH = 200;
    private static final Pattern GENDER_STAR_PATTERN = Pattern.compile("([A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df]{1,25}|[A-Z\u00d6\u00c4\u00dc]{1,10}-[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df]{1,25})[*:_][a-z\u00f6\u00e4\u00fc\u00df]{1,25}");
    private static final Pattern FILE_UNDERLINE_PATTERN = Pattern.compile("[a-zA-Z0-9-]{1,25}_[a-zA-Z0-9-]{1,25}\\.[a-zA-Z]{1,5}");
    private static final Pattern MENTION_UNDERLINE_PATTERN = Pattern.compile("@[a-zA-Z0-9-]{1,25}_[a-zA-Z0-9_-]{1,25}");
    private static final Pattern FIRST_UPPER_CASE = Pattern.compile("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df-]+");
    private static final Pattern HYPHENED_UPPER_WORD = Pattern.compile("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df]+-[\\\\-\\\\s]?[a-z\u00f6\u00e4\u00fc\u00df]+");
    private static final Pattern HYPHENED_WORD = Pattern.compile("[a-z\u00f6\u00e4\u00fc\u00df]+-[\\-\\s][A-Z\u00d6\u00c4\u00dca-z\u00f6\u00e4\u00fc\u00df]+");
    private static final Pattern START_WITH_SPIEL = Pattern.compile("Spielzugs?|Spielzugangs?|Spielzuganges|Spielzugbuchs?|Spielzugb\u00fcchern?|Spielzuges|Spielzugverluste?|Spielzugverluste[ns]");
    private static final Pattern END_WITH_SCHAFTE = Pattern.compile("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00df-]+schafte");
    private static final Pattern WORD_WITH_PUNCT = Pattern.compile("\\w\\p{Punct}?");
    private static final Pattern LOWER_CASE_WORD = Pattern.compile("[a-z\u00f6\u00e4\u00fc]-.+");
    private static final Pattern SPECIAL_CASE = Pattern.compile(".{3,25}(tum|ing|ling|heit|keit|schaft|ung|ion|t\u00e4t|at|um)");
    private static final Pattern SPECIAL_CASE_WITH_S = Pattern.compile(".{3,25}(tum|ing|ling|heit|keit|schaft|ung|ion|t\u00e4t|at|um)s");
    private static final Pattern AUTENTISCH_WITH_CASES = Pattern.compile("[Aa]utentisch(e[nmsr]?|ste[nmsr]?|ere[nmsr]?)?");
    private static final Pattern SYMPHATISCH = Pattern.compile("symphatisch(e[nmsr]?|ste[nmsr]?|ere[nmsr]?)?");
    private static final Pattern BRILLIANT_WITH_CASES = Pattern.compile("brilliant(e[nmsr]?|ere[nmsr]?|este[nmsr]?)?");
    private static final Pattern RECHTMASIG_WITH_CASES = Pattern.compile("rechtm\u00e4ssig(e[nmsr]?|ere[nmsr]?|ste[nmsr]?)?");
    private static final Pattern HOLZ_SPIEGEL_PANEL_COMPOUND = Pattern.compile("(Holz|Spiegel)panel(s|en?)?");
    private static final Pattern SBHAN_PREFIX = Pattern.compile("SBahn(en|hofs?|zug(e?s)?|z\u00fcgen?|h\u00f6fen?|netz(e[ns]?)?|tunnel[sn]?|linien?)?");
    private static final Pattern UBAHN_PREFIX = Pattern.compile("UBahn(en|hofs?|zug(e?s)?|z\u00fcgen?|h\u00f6fen?|netz(e[ns]?)?|tunnel[sn]?|linien?)?");
    private static final Pattern SCHAF_PATTERN = Pattern.compile(".{3,}schaf(s|en)?");
    private static final Pattern SCHAFE_PATTERN = Pattern.compile("(Alpenschaf|Berberschaf|Bergschaf|Blauschaf|Brillenschaf|Dachsteinschaf|Deichschaf|Dickhornschaf|Feinwollschaf|Fettschwanzschaf|Fleischschaf|Fuchsschaf|Gl\u00fccksschaf|Hausschaf|Jungschaf|Karakulschaf|Klonschaf|Merinoschaf|Milchschaf|Mondschaf|Nutzschaf|Rh\u00f6nschaf|Riesenwildschaf|Schaukelschaf|Schneeschaf|Steinschaf|Steppenschaf|Superschaf|Waldschaf|Weideschaf|Wildschaf|Wollschaf|Zackelschaf|Zuchtschaf|Zwergblauschaf)(s|en)?");
    private static final Pattern START_WITH_NEGER = Pattern.compile("neger.*");
    private static final Pattern CONTAINS_NEGER = Pattern.compile(".+neger(s|n|in|innen)?");
    private static final Pattern CONTAINS_UNCOMMON_LOWERCASED_NOUN_AT_BEGINNING = Pattern.compile("^(hunger|zeit|k\u00e4se|zwiebel|kommoden?|lager|angst|freund|feind)\\s.+");
    private static final Pattern CONTAINS_UNCOMMON_LOWERCASED_NOUN_AT_END = Pattern.compile(".+\\s(hunger|zeit|k\u00e4se|zwiebel|kommoden?|lager|angst|freund|feind)$");
    private static final Pattern ENDS_WITH_IBELKEIT_IBLICHKEIT = Pattern.compile(".*ibel[hk]eit$");
    private static final Pattern ALLMAHLLIG = Pattern.compile("[aA]llm\u00e4hll?i(g|ch)(e[mnrs]?)?");
    private static final Pattern CONTAINS_MAYONNAISE = Pattern.compile(".*[mM]a[jy]onn?[\u00e4e]se.*");
    private static final Pattern CONTAINS_MASZNAME = Pattern.compile(".*[mM]a(ss|\u00df)namen?.*");
    private static final Pattern CONTAINS_RESERVIERUNG = Pattern.compile(".*[rR]es(a|er)[vw]i[he]?rung(en)?");
    private static final Pattern STARTS_WITH_RESCHASCHIER = Pattern.compile("[rR]eschaschier.+");
    private static final Pattern ENDS_WITH_LABORANTS = Pattern.compile(".*[lL]aborants$");
    private static final Pattern PROFESSIONELL = Pattern.compile("[pP]roff?ess?ion([\u00e4e])h?ll?(e[mnrs]?)?");
    private static final Pattern VERSTANDNIS = Pattern.compile("[vV]erstehendniss?(es?)?");
    private static final Pattern STARTS_WITH_DIAGNOSZIER = Pattern.compile("diagno[sz]ier.*");
    private static final Pattern STARTING_WITH_SINGLE_CHAR = Pattern.compile("\\p{L} \\p{L}+");
    private static final Pattern SPECIAL_CASE_THIRD = Pattern.compile("[A-Z\u00d6\u00c4\u00dc][a-z\u00f6\u00e4\u00fc\u00df]{2,}(ei|\u00f6l)$");
    private static final Pattern ZB = Pattern.compile("z[bB]");
    private static final Pattern STARTS_WITH_ZB = Pattern.compile("z[bB].");
    private static final Pattern DIRECTION = Pattern.compile("nord|ost|s\u00fcd|west");
    private static final Pattern SS = Pattern.compile("ss");
    private static final List<Pattern> PREVENT_SUGGESTION_PATTERNS = new ArrayList<Pattern>();
    private final Set<String> wordsToBeIgnoredInCompounds = new HashSet<String>();
    private final Set<String> wordStartsToBeProhibited = new HashSet<String>();
    private final Set<String> wordEndingsToBeProhibited = new HashSet<String>();
    private final Set<String> wordsNeedingInfixS = new HashSet<String>();
    private final Set<String> wordsWithoutInfixS = new HashSet<String>();
    private final Set<String> germanPrefixes = new HashSet<String>();
    private static final Map<StringMatcher, Function<String, List<String>>> ADDITIONAL_SUGGESTIONS = new HashMap<StringMatcher, Function<String, List<String>>>();
    private static final GermanWordSplitter splitter;
    private final LineExpander lineExpander = new LineExpander();
    private final GermanCompoundTokenizer compoundTokenizer;
    private final GermanCompoundTokenizer nonStrictCompoundTokenizer;
    private final Synthesizer synthesizer;

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        RuleMatch[] matches = super.match(sentence);
        return this.removeGenderCompoundMatches(sentence, matches);
    }

    @NotNull
    private RuleMatch[] removeGenderCompoundMatches(AnalyzedSentence sentence, RuleMatch[] matches) {
        List<Object> filteredMatches = Arrays.asList(matches);
        Matcher genderPattern = GENDER_STAR_PATTERN.matcher(sentence.getText());
        int pos = 0;
        while (genderPattern.find(pos)) {
            if (!this.isMisspelled(genderPattern.group().replaceFirst("[*:_]", ""))) {
                filteredMatches = filteredMatches.stream().filter(k -> genderPattern.start() >= k.getFromPos() || genderPattern.end() != k.getToPos()).filter(k -> genderPattern.start() != k.getFromPos() || genderPattern.end() <= k.getToPos()).collect(Collectors.toList());
            }
            pos = genderPattern.end();
        }
        Matcher filePattern = FILE_UNDERLINE_PATTERN.matcher(sentence.getText());
        pos = 0;
        while (filePattern.find(pos)) {
            filteredMatches = filteredMatches.stream().filter(k -> filePattern.start() > k.getFromPos() || filePattern.end() < k.getToPos()).collect(Collectors.toList());
            pos = filePattern.end();
        }
        Matcher mentionPattern = MENTION_UNDERLINE_PATTERN.matcher(sentence.getText());
        pos = 0;
        while (mentionPattern.find(pos)) {
            filteredMatches = filteredMatches.stream().filter(k -> mentionPattern.start() > k.getFromPos() || mentionPattern.end() < k.getToPos()).collect(Collectors.toList());
            pos = mentionPattern.end();
        }
        return filteredMatches.toArray(RuleMatch.EMPTY_ARRAY);
    }

    private static void putRepl(String wordPattern, String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(StringMatcher.regexp((String)wordPattern), w -> Collections.singletonList(w.replaceFirst(pattern, replacement)));
    }

    private static void put(String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(StringMatcher.regexp((String)pattern), w -> Collections.singletonList(replacement));
    }

    private static void put(String pattern, Function<String, List<String>> f) {
        ADDITIONAL_SUGGESTIONS.put(StringMatcher.regexp((String)pattern), f);
    }

    private static GermanWordSplitter getSplitter() {
        try {
            return new GermanWordSplitter(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GermanSpellerRule(ResourceBundle messages, German language) {
        this(messages, language, null, null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict) {
        this(messages, language, userConfig, languageVariantPlainTextDict, Collections.emptyList(), null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, (Language)language, language.getNonStrictCompoundSplitter(), () -> GermanSpellerRule.getSpeller(language, userConfig, languageVariantPlainTextDict), userConfig, altLanguages, languageModel);
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = language.getStrictCompoundTokenizer();
        this.nonStrictCompoundTokenizer = GermanCompoundTokenizer.getNonStrictInstance();
        this.synthesizer = language.getSynthesizer();
        this.loadFile("/de/words_infix_s.txt", this.wordsNeedingInfixS);
        this.loadFile("/de/words_no_infix_s.txt", this.wordsWithoutInfixS);
        this.loadFile("/de/german_prefix.txt", this.germanPrefixes);
    }

    private void loadFile(String fileInClasspath, Set<String> set) {
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(fileInClasspath);
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            set.add(line.trim());
        }
    }

    protected synchronized void init() throws IOException {
        super.init();
        this.ignoreWordsWithLength = 1;
        String pattern = "(" + this.nonWordPattern.pattern() + "|(?<=[\\d\u00b0])-|-(?=\\d+))";
        this.nonWordPattern = Pattern.compile(pattern);
    }

    public String getId() {
        return RULE_ID;
    }

    protected boolean isIgnoredNoCase(String word) {
        return this.wordsToBeIgnored.contains(word) || FIRST_UPPER_CASE.matcher(word).matches() && this.wordsToBeIgnored.contains(word.toLowerCase(this.language.getLocale())) || this.ignoreWordsWithLength > 0 && word.length() <= this.ignoreWordsWithLength;
    }

    @NotNull
    protected String getMessage(String origWord, SuggestedReplacement firstSuggestion) {
        int firstSz;
        if (SS.matcher(origWord).replaceFirst("\u00df").equals(firstSuggestion.getReplacement()) && (firstSz = origWord.indexOf("ss")) >= 2) {
            char prevPrevChar = origWord.charAt(firstSz - 2);
            char prevChar = origWord.charAt(firstSz - 1);
            if (GermanTools.isVowel(prevPrevChar) && GermanTools.isVowel(prevChar)) {
                return "Nach einer Silbe aus zwei Vokalen (hier: " + prevPrevChar + prevChar + ") schreibt man '\u00df' statt 'ss'.";
            }
            return "Nach einer lang gesprochenen Silbe (hier: " + prevChar + ") schreibt man '\u00df' statt 'ss'.";
        }
        return this.messages.getString("spelling");
    }

    public List<String> getCandidates(String word) {
        ArrayList partList;
        try {
            partList = splitter.getAllSplits(word);
        }
        catch (InputTooLongException e) {
            partList = new ArrayList();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (List parts : partList) {
            List tmp = super.getCandidates(parts);
            tmp = tmp.stream().filter(k -> !HYPHENED_UPPER_WORD.matcher((CharSequence)k).matches() && !HYPHENED_WORD.matcher((CharSequence)k).matches()).collect(Collectors.toList());
            tmp = tmp.stream().filter(k -> !k.contains("-s-")).collect(Collectors.toList());
            if (!word.endsWith("-")) {
                tmp = tmp.stream().filter(k -> !k.endsWith("-")).collect(Collectors.toList());
            }
            candidates.addAll(tmp);
            if (parts.size() == 2) {
                candidates.add((String)parts.get(0) + " " + (String)parts.get(1));
                if (this.isNounOrProperNoun(StringTools.uppercaseFirstChar((String)((String)parts.get(1))))) {
                    candidates.add((String)parts.get(0) + " " + StringTools.uppercaseFirstChar((String)((String)parts.get(1))));
                }
            }
            if (parts.size() == 2 && !((String)parts.get(0)).endsWith("s")) {
                candidates.add((String)parts.get(0) + "s" + (String)parts.get(1));
            }
            if (parts.size() != 2 || !((String)parts.get(1)).startsWith("s")) continue;
            String firstPart = (String)parts.get(0);
            String secondPart = (String)parts.get(1);
            candidates.addAll(super.getCandidates(Arrays.asList(firstPart + "s", secondPart.substring(1))));
        }
        return candidates;
    }

    protected boolean isProhibited(String word) {
        return super.isProhibited(word) || this.wordStartsToBeProhibited.stream().anyMatch(w -> word.startsWith((String)w)) || this.wordEndingsToBeProhibited.stream().anyMatch(w -> word.endsWith((String)w));
    }

    protected void addIgnoreWords(String origLine) {
        String line;
        String string = line = this.language.getShortCodeWithCountryAndVariant().equals("de-CH") ? origLine.replace("\u00df", "ss") : origLine;
        if (origLine.endsWith("-*")) {
            this.wordsToBeIgnoredInCompounds.add(line.substring(0, line.length() - 2));
            return;
        }
        List<String> words = this.expandLine(line);
        for (String word : words) {
            super.addIgnoreWords(word);
        }
    }

    protected List<String> expandLine(String line) {
        return this.lineExpander.expandLine(line);
    }

    protected RuleMatch createWrongSplitMatch(AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int pos, String coveredWord, String suggestion1, String suggestion2, int prevPos) {
        if (LOWER_CASE_WORD.matcher(suggestion2).matches()) {
            return null;
        }
        return super.createWrongSplitMatch(sentence, ruleMatchesSoFar, pos, coveredWord, suggestion1, suggestion2, prevPos);
    }

    public List<String> getSuggestions(String word) throws IOException {
        List<String> suggestions = super.getSuggestions(word);
        suggestions = suggestions.stream().filter(this::acceptSuggestion).collect(Collectors.toList());
        if (word.endsWith(".")) {
            suggestions.replaceAll(s -> s.endsWith(".") ? s : s + ".");
        }
        suggestions = suggestions.stream().filter(k -> !k.equals(word) && (!k.endsWith("-") || word.endsWith("-")) && !STARTING_WITH_SINGLE_CHAR.matcher((CharSequence)k).matches()).collect(Collectors.toList());
        return suggestions;
    }

    protected boolean acceptSuggestion(String s) {
        return !PREVENT_SUGGESTION_PATTERNS.stream().anyMatch(p -> p.matcher(s).matches()) && !s.contains("--") && !s.endsWith("roulett") && !s.endsWith("-s") && !s.endsWith(" de") && !s.endsWith(" en") && !s.endsWith(" Artigen") && !s.endsWith(" Artige") && !s.endsWith(" artigen") && !s.endsWith(" artiges") && !s.endsWith(" artiger") && !s.endsWith(" artige") && !s.endsWith(" artig") && !s.endsWith(" gen") && !s.endsWith(" ehe") && !s.endsWith(" ende") && !s.endsWith(" enden") && !s.endsWith(" enge") && !s.endsWith(" f\u00f6rmig") && !s.endsWith(" f\u00f6rmige") && !s.endsWith(" f\u00f6rmigen") && !s.endsWith(" f\u00f6rmiger") && !s.endsWith(" f\u00f6rmiges") && !s.startsWith("Doppel ") && !s.startsWith("Kombi ");
    }

    @NotNull
    protected static List<String> getSpellingFilePaths(String langCode) {
        ArrayList<String> paths = new ArrayList<String>(CompoundAwareHunspellRule.getSpellingFilePaths((String)langCode));
        paths.add("/" + langCode + "/hunspell/spelling_recommendation.txt");
        return paths;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static MorfologikMultiSpeller getSpeller(Language language, UserConfig userConfig, String languageVariantPlainTextDict) {
        try {
            String langCode = language.getShortCode();
            String morfoFile = "/" + langCode + "/hunspell/" + langCode + "_" + language.getCountries()[0] + ".dict";
            if (!JLanguageTool.getDataBroker().resourceExists(morfoFile)) return null;
            ArrayList<String> paths = new ArrayList<String>(GermanSpellerRule.getSpellingFilePaths(langCode));
            if (languageVariantPlainTextDict != null) {
                paths.add(languageVariantPlainTextDict);
            }
            List streams = GermanSpellerRule.getStreams(paths);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), StandardCharsets.UTF_8));){
                BufferedReader variantReader = GermanSpellerRule.getVariantReader(languageVariantPlainTextDict);
                MorfologikMultiSpeller morfologikMultiSpeller = new MorfologikMultiSpeller(morfoFile, (BufferedReader)new ExpandingReader(br), paths, variantReader, languageVariantPlainTextDict, userConfig, 2, null);
                return morfologikMultiSpeller;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    @Nullable
    private static BufferedReader getVariantReader(String languageVariantPlainTextDict) {
        ExpandingReader variantReader = null;
        if (languageVariantPlainTextDict != null && !languageVariantPlainTextDict.isEmpty()) {
            InputStream variantStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextDict);
            variantReader = new ExpandingReader(new BufferedReader(new InputStreamReader(variantStream, StandardCharsets.UTF_8)));
        }
        return variantReader;
    }

    protected void filterForLanguage(List<String> suggestions) {
        if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH")) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String s2 = suggestions.get(i);
                suggestions.set(i, s2.replace("\u00df", "ss"));
            }
        }
        suggestions.removeIf(s -> Arrays.stream(s.split(" ")).anyMatch(k -> WORD_WITH_PUNCT.matcher((CharSequence)k).matches()));
        suggestions.removeIf(s -> s.length() > 1 && s.startsWith("-"));
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        ArrayList<String> filteredSuggestions = new ArrayList<String>();
        List readingsList = new ArrayList();
        try {
            readingsList = this.getTagger().tag(suggestions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String lemmaToFilter = "";
        String formToAccept = "";
        for (AnalyzedTokenReadings readings : readingsList) {
            if (!readings.hasAnyPartialPosTag(new String[]{"ADJ"}) && !readings.hasAnyPartialPosTag(new String[]{"SUB"}) && !readings.hasAnyPartialPosTag(new String[]{"PA1:"}) && !readings.hasAnyPartialPosTag(new String[]{"PA2:"}) || !readings.getToken().endsWith(misspelling.substring(misspelling.length() - 2))) continue;
            formToAccept = readings.getToken();
            lemmaToFilter = readings.getAnalyzedToken(0).getLemma();
            break;
        }
        if (!lemmaToFilter.isEmpty() && !formToAccept.isEmpty() && misspelling.length() > 1) {
            for (int i = 0; i < suggestions.size(); ++i) {
                if (!suggestions.get(i).equals(formToAccept) && ((AnalyzedTokenReadings)readingsList.get(i)).hasAnyLemma(new String[]{lemmaToFilter}) || filteredSuggestions.contains(suggestions.get(i))) continue;
                filteredSuggestions.add(suggestions.get(i));
            }
        } else {
            filteredSuggestions.addAll(suggestions);
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> topSuggestions = new ArrayList<String>();
        for (String suggestion : filteredSuggestions) {
            if (misspelling.equalsIgnoreCase(suggestion)) {
                topSuggestions.add(suggestion);
                continue;
            }
            if (suggestion.contains(" ")) {
                String[] words = suggestion.replaceFirst("\\.$", "").split(" ", 2);
                if (this.languageModel != null && words.length == 2) {
                    Probability nonSplit = this.languageModel.getPseudoProbability(Collections.singletonList(words[0] + words[1]));
                    Probability split = this.languageModel.getPseudoProbability(Arrays.asList(words));
                    if (nonSplit.getProb() > split.getProb() || split.getProb() == 0.0) {
                        result.add(suggestion);
                        continue;
                    }
                    topSuggestions.add(suggestion);
                    continue;
                }
                topSuggestions.add(suggestion);
                continue;
            }
            result.add(suggestion);
        }
        result.addAll(0, topSuggestions);
        return result;
    }

    protected List<String> getFilteredSuggestions(List<String> wordsOrPhrases) {
        ArrayList<String> result = new ArrayList<String>();
        for (String wordOrPhrase : wordsOrPhrases) {
            String[] words = this.tokenizeText(wordOrPhrase);
            if (words.length >= 2 && this.isAdjOrNounOrUnknown(words[0]) && this.isNounOrUnknown(words[1]) && StringTools.startsWithUppercase((String)words[0]) && StringTools.startsWithUppercase((String)words[1]) || words.length == 2 && this.isAdjBaseForm(words[0]) && !StringTools.startsWithUppercase((String)words[0]) && this.isSubVerInf(words[1])) continue;
            result.add(wordOrPhrase);
        }
        return result;
    }

    private boolean isNounOrUnknown(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.isPosTagUnknown());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isOnlyNoun(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            for (AnalyzedTokenReadings reading2 : readings) {
                boolean accept = reading2.getReadings().stream().allMatch(k -> k.getPOSTag() != null && k.getPOSTag().startsWith("SUB:"));
                if (accept) continue;
                return false;
            }
            return readings.stream().allMatch(reading -> reading.matchesPosTagRegex("SUB:.*"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdjOrNounOrUnknown(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.hasPosTagStartingWith("ADJ") || reading.isPosTagUnknown());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNounOrProperNoun(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("SUB") || reading.hasPosTagStartingWith("EIG"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSubVerInf(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.matchesPosTagRegex("SUB:.*:INF"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdjBaseForm(String word) {
        try {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            return readings.stream().anyMatch(reading -> reading.hasPosTagStartingWith("ADJ:PRD:GRU"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean ignoreElative(String word) {
        if (StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"bitter", "dunkel", "erz", "extra", "fr\u00fch", "gemein", "hyper", "lau", "mega", "minder", "stock", "super", "tod", "ultra", "ur"})) {
            String lastPart = RegExUtils.removePattern((String)word, (String)"^(bitter|dunkel|erz|extra|fr\u00fch|gemein|grund|hyper|lau|mega|minder|stock|super|tod|ultra|ur|voll)");
            return lastPart.length() >= 3 && !this.isMisspelled(lastPart);
        }
        return false;
    }

    public boolean isMisspelled(String word) {
        String variant;
        if (SCHAF_PATTERN.matcher(word).matches() && !SCHAFE_PATTERN.matcher(word).matches() && !this.isMisspelled(variant = word.replaceFirst("schaf$", "schaft").replaceFirst("schafs$", "schaft").replaceFirst("schafen$", "schaften"))) {
            return true;
        }
        if (word.startsWith("Spielzug") && !START_WITH_SPIEL.matcher(word).matches()) {
            return true;
        }
        if (!(!word.startsWith("Standart") || word.equals("Standarte") || word.equals("Standarten") || word.startsWith("Standartentr\u00e4ger") || word.startsWith("Standartenf\u00fchrer"))) {
            return true;
        }
        if (word.endsWith("schafte") && END_WITH_SCHAFTE.matcher(word).matches()) {
            return true;
        }
        return super.isMisspelled(word);
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        String word = words.get(idx);
        if (word.length() > 200) {
            return true;
        }
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(StringUtils.uncapitalize((String)words.get(0)));
        boolean ignoreByHyphen = false;
        boolean ignoreBulletPointCase = false;
        if (!ignoreUncapitalizedWord) {
            ignoreBulletPointCase = !ignore && idx == 1 && words.get(0).isEmpty() && StringTools.startsWithUppercase((String)word) && this.isMisspelled(word) && !this.isMisspelled(word.toLowerCase());
        }
        boolean ignoreHyphenatedCompound = false;
        if (!ignore && !ignoreUncapitalizedWord) {
            if (word.contains("-")) {
                if (idx > 0 && "".equals(words.get(idx - 1)) && StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"stel-", "tel-"})) {
                    return !this.isMisspelled(StringUtils.substringAfter((String)word, (String)"-"));
                }
                ignoreByHyphen = word.endsWith("-") && this.ignoreByHangingHyphen(words, idx);
            }
            boolean bl = ignoreHyphenatedCompound = !ignoreByHyphen && this.ignoreCompoundWithIgnoredWord(word);
        }
        if (CommonFileTypes.getSuffixPattern().matcher(word).matches()) {
            return true;
        }
        if (missingAdjPattern.matcher(word).matches()) {
            String firstPart = StringTools.uppercaseFirstChar((String)word.replaceFirst("(affin|basiert|konform|widrig|f\u00e4hig|haltig|bedingt|gerecht|w\u00fcrdig|relevant|\u00fcbergreifend|tauglich|untauglich|artig|bezogen|orientiert|fremd|liebend|hassend|bildend|hemmend|abh\u00e4ngig|zentriert|f\u00f6rmig|m\u00e4\u00dfig|pflichtig|\u00e4hnlich|spezifisch|vertr\u00e4glich|technisch|typisch|frei|arm|freundlich|feindlich|gem\u00e4\u00df|neutral|seitig|begeistert|geeignet|ungeeignet|berechtigt|sicher|s\u00fcchtig|resistent)(er|es|en|em|e)?", ""));
            if (this.isMisspelled(word)) {
                if (!this.isMisspelled(firstPart) && !SPECIAL_CASE.matcher(firstPart).matches() && this.isOnlyNoun(firstPart) && !this.isMisspelled(firstPart + "test")) {
                    return true;
                }
                if (this.isMisspelled(firstPart) || SPECIAL_CASE.matcher(firstPart).matches()) {
                    if (firstPart.endsWith("s") && !this.isMisspelled(firstPart.replaceFirst("s$", "")) && SPECIAL_CASE_WITH_S.matcher(firstPart).matches() && this.isOnlyNoun(firstPart.replaceFirst("s$", "")) && !this.isMisspelled(firstPart + "test")) {
                        return true;
                    }
                    if (!firstPart.endsWith("s") || this.isMisspelled(firstPart.replaceFirst("s$", "")) || SPECIAL_CASE.matcher(firstPart).matches()) {
                        // empty if block
                    }
                }
            }
        }
        if ((word.endsWith("mitarbeitende") || word.endsWith("mitarbeitenden")) && this.hunspell.spell(word.replaceFirst("mitarbeitenden?", "mitarbeiter"))) {
            return true;
        }
        if (idx + 1 < words.size() && (word.endsWith(".mp") || word.endsWith(".woff")) && words.get(idx + 1).equals("") || idx > 0 && "".equals(words.get(idx - 1)) && StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{"sat", "stel", "tel", "stels", "tels"})) {
            return true;
        }
        return ignore || ignoreUncapitalizedWord || ignoreBulletPointCase || ignoreByHyphen || ignoreHyphenatedCompound || this.ignoreElative(word);
    }

    protected boolean ignorePotentiallyMisspelledWord(String word) throws IOException {
        String part2;
        String part1;
        if (word.length() <= 5 || word.length() >= 40 || StringTools.startsWithLowercase((String)word) || this.isProhibited(word)) {
            return false;
        }
        if (word.endsWith("gru\u00dfe") || word.endsWith("schaf") || word.endsWith("schafs") || word.endsWith("schafen")) {
            return false;
        }
        String wordNoDot = word.endsWith(".") ? word.substring(0, word.length() - 1) : word;
        List<String> parts = this.compoundTokenizer.tokenize(wordNoDot);
        boolean nonStrictMode = false;
        if (parts.size() == 1) {
            parts = this.nonStrictCompoundTokenizer.tokenize(wordNoDot);
            nonStrictMode = true;
        }
        boolean hasInfixS = false;
        if (parts.size() == 2) {
            part1 = parts.get(0);
            part2 = parts.get(1);
            if (nonStrictMode && part2.startsWith("s") && this.isMisspelled(part2) && !this.isMisspelled(StringTools.uppercaseFirstChar((String)part2.substring(1)))) {
                part1 = part1 + "s";
                part2 = part2.substring(1);
                hasInfixS = true;
            }
        } else if (parts.size() == 3 && parts.get(1).equals("s") && word.contains("-") && StringTools.startsWithUppercase((String)parts.get(2))) {
            part1 = parts.get(0) + "s";
            part2 = StringTools.lowercaseFirstChar((String)parts.get(2));
            hasInfixS = true;
        } else {
            if (parts.size() == 3 && !word.contains("-")) {
                String part12 = parts.get(0);
                String part22 = parts.get(1);
                String compound1 = parts.get(0) + parts.get(1);
                String compound1noS = compound1.replaceFirst("s$", "");
                String compound2 = StringTools.uppercaseFirstChar((String)parts.get(1)) + parts.get(2);
                boolean compound1ok = false;
                compound1ok = this.germanPrefixes.contains(part22) ? (!this.isMisspelled(part12) && !this.isMisspelled(part12 + parts.get(2)) || this.ignorePotentiallyMisspelledWord(part12 + parts.get(2))) && parts.get(2).length() >= 3 || !this.isMisspelled(compound1) || this.ignorePotentiallyMisspelledWord(compound1) || !this.isMisspelled(compound1noS) || this.ignorePotentiallyMisspelledWord(compound1noS) : !this.isMisspelled(compound1) || this.ignorePotentiallyMisspelledWord(compound1) || !this.isMisspelled(compound1noS) || this.ignorePotentiallyMisspelledWord(compound1noS);
                boolean compound2ok = (!this.isMisspelled(compound2) || this.ignorePotentiallyMisspelledWord(compound2)) && this.isNoun(compound2);
                return compound1ok && compound2ok;
            }
            return false;
        }
        if (word.contains("-" + part2)) {
            return false;
        }
        if ((hasInfixS || part1.endsWith("s")) && part1.length() >= 4 && part2.length() >= 3 && StringTools.startsWithLowercase((String)part2)) {
            String part1noInfix = part1.substring(0, part1.length() - 1);
            String part2uc = StringTools.uppercaseFirstChar((String)part2);
            if ((compoundPatternWithHeit.matcher(part1).matches() || this.wordsNeedingInfixS.contains(part1noInfix)) && this.isNoun(part2uc)) {
                return !compoundPatternWithAction.matcher(part1noInfix).matches() && !compoundPatternWithFirst.matcher(part2uc).matches() && !part1.endsWith("schwungs") && !part1.endsWith("sprungs") && !this.isMisspelled(part1noInfix) && !this.isMisspelled(part2uc);
            }
        }
        String part2uc = StringTools.uppercaseFirstChar((String)part2);
        if (!hasInfixS && part1.length() >= 3 && part2.length() >= 4 && !part2.contains("-") && StringTools.startsWithLowercase((String)part2) && !part1.equals("Lass") && (this.wordsWithoutInfixS.contains(part1) || compoundPatternSpecialEnding.matcher(part1).matches() && this.isNoun(part2uc)) && !this.isMisspelled(part1) && this.isNoun(part2uc)) {
            System.out.println("compound: " + part1 + " " + part2 + " (" + word + ")");
            return true;
        }
        return false;
    }

    private boolean isAdjective(String word) throws IOException {
        return this.getTagger().tag(Collections.singletonList(word)).stream().anyMatch(k -> k.hasPosTagStartingWith("ADJ:"));
    }

    private boolean isNoun(String word) throws IOException {
        return this.getTagger().tag(Collections.singletonList(word)).stream().anyMatch(k -> k.hasPosTagStartingWith("SUB:"));
    }

    private boolean isPluralNoun(String word) throws IOException {
        return this.getTagger().tag(Collections.singletonList(word)).stream().anyMatch(k -> k.hasPosTagStartingWith("SUB:NOM:PLU:"));
    }

    private boolean isOnlyPluralNoun(String word) throws IOException {
        return this.isPluralNoun(word) && word.endsWith("en") && this.isOnlyNoun(word);
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        String[] words;
        String ucWord;
        String suggestion;
        if ("WIFI".equalsIgnoreCase(word)) {
            return Collections.singletonList("Wi-Fi");
        }
        if ("W-Lan".equalsIgnoreCase(word)) {
            return Collections.singletonList("WLAN");
        }
        if ("Endstadion".equals(word)) {
            return Collections.singletonList("Endstadium");
        }
        if ("Endstadions".equals(word)) {
            return Collections.singletonList("Endstadiums");
        }
        if ("genomen".equals(word)) {
            return Collections.singletonList("genommen");
        }
        if ("Preis-Leistungsverh\u00e4ltnis".equals(word)) {
            return Collections.singletonList("Preis-Leistungs-Verh\u00e4ltnis");
        }
        if ("getz".equals(word)) {
            return Arrays.asList("jetzt", "geht's");
        }
        if ("Trons".equals(word)) {
            return Collections.singletonList("Trance");
        }
        if ("ei".equals(word)) {
            return Collections.singletonList("ein");
        }
        if ("jo".equals(word) || "jepp".equals(word) || "jopp".equals(word)) {
            return Collections.singletonList("ja");
        }
        if ("Jo".equals(word) || "Jepp".equals(word) || "Jopp".equals(word)) {
            return Collections.singletonList("Ja");
        }
        if ("Ne".equals(word)) {
            return Arrays.asList("Nein", "Eine");
        }
        if ("is".equals(word)) {
            return Collections.singletonList("ist");
        }
        if ("Is".equals(word)) {
            return Collections.singletonList("Ist");
        }
        if ("un".equals(word)) {
            return Collections.singletonList("und");
        }
        if ("Un".equals(word)) {
            return Collections.singletonList("Und");
        }
        if ("Std".equals(word)) {
            return Collections.singletonList("Std.");
        }
        if (ENDS_WITH_IBELKEIT_IBLICHKEIT.matcher(word).matches()) {
            suggestion = word.replaceFirst("el[hk]eit$", "ilit\u00e4t");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("aquise")) {
            suggestion = word.replaceFirst("aquise$", "akquise");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standart")) {
            suggestion = word.replaceFirst("standart$", "standard");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standarts")) {
            suggestion = word.replaceFirst("standarts$", "standards");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tips")) {
            suggestion = word.replaceFirst("tips$", "tipps");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tip")) {
            suggestion = word + "p";
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("entfehlung")) {
            suggestion = word.replaceFirst("ent", "emp");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("oullie")) {
            suggestion = word.replaceFirst("oullie$", "ouille");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("Bundstift")) {
            suggestion = word.replaceFirst("^Bundstift", "Buntstift");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (ALLMAHLLIG.matcher(word).matches()) {
            suggestion = word.replaceFirst("llm\u00e4hll?i(g|ch)", "llm\u00e4hlich");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (CONTAINS_MAYONNAISE.matcher(word).matches()) {
            suggestion = word.replaceFirst("a[jy]onn?[\u00e4e]se", "ayonnaise");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (CONTAINS_RESERVIERUNG.matcher(word).matches()) {
            suggestion = word.replaceFirst("es(a|er)[vw]i[he]?rung", "eservierung");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (STARTS_WITH_RESCHASCHIER.matcher(word).matches()) {
            suggestion = word.replaceFirst("schaschier", "cherchier");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (ENDS_WITH_LABORANTS.matcher(word).matches()) {
            suggestion = word.replaceFirst("ts$", "ten");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (PROFESSIONELL.matcher(word).matches()) {
            suggestion = word.replaceFirst("roff?ess?ion([\u00e4e])h?l{1,2}", "rofessionell");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (VERSTANDNIS.matcher(word).matches()) {
            suggestion = word.replaceFirst("[vV]erstehendnis", "Verst\u00e4ndnis");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("koregier")) {
            suggestion = word.replace("reg", "rrig");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (STARTS_WITH_DIAGNOSZIER.matcher(word).matches()) {
            suggestion = word.replaceAll("gno[sz]ier", "gnostizier");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.contains("eiss")) {
            suggestion = word.replace("eiss", "ei\u00df");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.contains("uess")) {
            suggestion = word.replace("uess", "\u00fc\u00df");
            if (this.hunspell.spell(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else {
            if (word.equals("gin")) {
                return Collections.singletonList("ging");
            }
            if (word.equals("dh") || word.equals("dh.")) {
                return Collections.singletonList("d.\u202fh.");
            }
            if (word.equals("ua") || word.equals("ua.")) {
                return Collections.singletonList("u.\u202fa.");
            }
            if (ZB.matcher(word).matches() || STARTS_WITH_ZB.matcher(word).matches()) {
                return Collections.singletonList("z.\u202fB.");
            }
            if (word.equals("uvm") || word.equals("uvm.")) {
                return Collections.singletonList("u.\u202fv.\u202fm.");
            }
            if (word.equals("udgl") || word.equals("udgl.")) {
                return Collections.singletonList("u.\u202fdgl.");
            }
            if (word.equals("Ruhigkeit")) {
                return Collections.singletonList("Ruhe");
            }
            if (word.equals("angepreist")) {
                return Collections.singletonList("angepriesen");
            }
            if (word.equals("halo")) {
                return Collections.singletonList("hallo");
            }
            if (word.equalsIgnoreCase("zumindestens")) {
                return Collections.singletonList(word.replace("ens", ""));
            }
            if (word.equals("ca")) {
                return Collections.singletonList("ca.");
            }
            if (word.equals("Jezt")) {
                return Collections.singletonList("Jetzt");
            }
            if (word.equals("Wollst")) {
                return Collections.singletonList("Wolltest");
            }
            if (word.equals("wollst")) {
                return Collections.singletonList("wolltest");
            }
            if (word.equals("Rolladen")) {
                return Collections.singletonList("Rollladen");
            }
            if (word.equals("Ma\u00dfname")) {
                return Collections.singletonList("Ma\u00dfnahme");
            }
            if (word.equals("Ma\u00dfnamen")) {
                return Collections.singletonList("Ma\u00dfnahmen");
            }
            if (word.equals("nanten")) {
                return Collections.singletonList("nannten");
            }
            if (word.equals("diees")) {
                return Arrays.asList("dieses", "dies");
            }
            if (word.equals("Diees")) {
                return Arrays.asList("Dieses", "Dies");
            }
            if (word.endsWith("ies")) {
                if (word.equals("Lobbies")) {
                    return Collections.singletonList("Lobbys");
                }
                if (word.equals("Parties")) {
                    return Collections.singletonList("Partys");
                }
                if (word.equals("Babies")) {
                    return Collections.singletonList("Babys");
                }
                if (word.endsWith("derbies") ? this.hunspell.spell(suggestion = word.replaceFirst("derbies$", "derbys")) : (word.endsWith("stories") ? this.hunspell.spell(suggestion = word.replaceFirst("stories$", "storys")) : word.endsWith("parties") && this.hunspell.spell(suggestion = word.replaceFirst("parties$", "partys")))) {
                    return Collections.singletonList(suggestion);
                }
            } else {
                if (word.equals("Hallochen")) {
                    return Arrays.asList("Hall\u00f6chen", "hall\u00f6chen");
                }
                if (word.equals("hallochen")) {
                    return Collections.singletonList("hall\u00f6chen");
                }
                if (word.equals("ok")) {
                    return Arrays.asList("okay", "O.\u202fK.");
                }
                if (word.equals("gesuchen")) {
                    return Arrays.asList("gesuchten", "gesucht");
                }
                if (word.equals("Germanistiker")) {
                    return Arrays.asList("Germanist", "Germanisten");
                }
                if (word.equals("Abschlepper")) {
                    return Arrays.asList("Abschleppdienst", "Abschleppwagen");
                }
                if (word.equals("par")) {
                    return Collections.singletonList("paar");
                }
                if (word.equals("iwie")) {
                    return Collections.singletonList("irgendwie");
                }
                if (word.equals("bzgl")) {
                    return Collections.singletonList("bzgl.");
                }
                if (word.equals("bau")) {
                    return Collections.singletonList("baue");
                }
                if (word.equals("sry")) {
                    return Collections.singletonList("sorry");
                }
                if (word.equals("Sry")) {
                    return Collections.singletonList("Sorry");
                }
                if (word.equals("thx")) {
                    return Collections.singletonList("danke");
                }
                if (word.equals("Thx")) {
                    return Collections.singletonList("Danke");
                }
                if (word.equals("Zynik")) {
                    return Collections.singletonList("Zynismus");
                }
                if (word.equalsIgnoreCase("email")) {
                    return Collections.singletonList("E-Mail");
                }
                if (word.length() > 9 && word.startsWith("Email")) {
                    String suffix = word.substring(5);
                    if (!this.hunspell.spell(suffix)) {
                        List suffixSuggestions = this.hunspell.suggest(StringTools.uppercaseFirstChar((String)suffix));
                        suffix = suffixSuggestions.isEmpty() ? suffix : (String)suffixSuggestions.get(0);
                    }
                    return Collections.singletonList("E-Mail-" + Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1));
                }
                if (word.equals("wiederspiegeln")) {
                    return Collections.singletonList("widerspiegeln");
                }
                if (word.equals("ch")) {
                    return Collections.singletonList("ich");
                }
                for (Map.Entry<StringMatcher, Function<String, List<String>>> entry : ADDITIONAL_SUGGESTIONS.entrySet()) {
                    if (!entry.getKey().matches(word)) continue;
                    return entry.getValue().apply(word);
                }
            }
        }
        if (!StringTools.startsWithUppercase((String)word) && !suggestions.contains(ucWord = StringTools.uppercaseFirstChar((String)word)) && this.hunspell.spell(ucWord) && !ucWord.endsWith(".")) {
            return Collections.singletonList(ucWord);
        }
        String verbSuggestion = this.getPastTenseVerbSuggestion(word);
        if (verbSuggestion != null) {
            return Collections.singletonList(verbSuggestion);
        }
        String participleSuggestion = this.getParticipleSuggestion(word);
        if (participleSuggestion != null) {
            return Collections.singletonList(participleSuggestion);
        }
        String abbreviationSuggestion = this.getAbbreviationSuggestion(word);
        if (abbreviationSuggestion != null) {
            return Collections.singletonList(abbreviationSuggestion);
        }
        if (suggestions.isEmpty() && word.contains("-") && (words = word.split("-")).length > 1) {
            ArrayList<List<String>> suggestionLists = new ArrayList<List<String>>(words.length);
            int startAt = 0;
            int stopAt = words.length;
            String partialWord = words[0] + "-" + words[1];
            if (super.ignoreWord(partialWord) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                startAt = 2;
                suggestionLists.add(Collections.singletonList(words[0] + "-" + words[1]));
            }
            if (super.ignoreWord(partialWord = words[words.length - 2] + "-" + words[words.length - 1]) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                stopAt = words.length - 2;
            }
            for (int idx = startAt; idx < stopAt; ++idx) {
                if (!this.hunspell.spell(words[idx])) {
                    List<String> list = this.sortSuggestionByQuality(words[idx], super.getSuggestions(words[idx]));
                    suggestionLists.add(list);
                    continue;
                }
                suggestionLists.add(Collections.singletonList(words[idx]));
            }
            if (stopAt < words.length - 1) {
                suggestionLists.add(Collections.singletonList(partialWord));
            }
            if (suggestionLists.size() <= 3) {
                ArrayList<String> additionalSuggestions = (ArrayList<String>)suggestionLists.get(0);
                for (int idx = 1; idx < suggestionLists.size(); ++idx) {
                    List suggestionList = (List)suggestionLists.get(idx);
                    ArrayList<String> newList = new ArrayList<String>(additionalSuggestions.size() * suggestionList.size());
                    for (String additionalSuggestion : additionalSuggestions) {
                        for (String aSuggestionList : suggestionList) {
                            newList.add(additionalSuggestion + "-" + aSuggestionList);
                        }
                    }
                    additionalSuggestions = newList;
                }
                return additionalSuggestions.subList(0, Math.min(5, additionalSuggestions.size()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private String getPastTenseVerbSuggestion(String word) {
        if (word.endsWith("e")) {
            String wordStem = word.substring(0, word.length() - 1);
            try {
                AnalyzedToken token;
                String[] forms;
                String lemma = this.baseForThirdPersonSingularVerb(wordStem);
                if (lemma != null && (forms = this.synthesizer.synthesize(token = new AnalyzedToken(lemma, null, lemma), "VER:3:SIN:PRT:.*", true)).length > 0) {
                    return forms[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String baseForThirdPersonSingularVerb(String word) throws IOException {
        List readings = this.getTagger().tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings reading : readings) {
            if (!reading.hasPosTagStartingWith("VER:3:SIN")) continue;
            return ((AnalyzedToken)reading.getReadings().get(0)).getLemma();
        }
        return null;
    }

    @Nullable
    private String getParticipleSuggestion(String word) {
        if (word.startsWith("ge") && word.endsWith("t")) {
            String baseform = word.substring(2, word.length() - 1) + "en";
            try {
                String participle = this.getParticipleForBaseform(baseform);
                if (participle != null) {
                    return participle;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String getParticipleForBaseform(String baseform) throws IOException {
        AnalyzedToken token = new AnalyzedToken(baseform, null, baseform);
        String[] forms = this.synthesizer.synthesize(token, "VER:PA2:.*", true);
        if (forms.length > 0 && this.hunspell.spell(forms[0])) {
            return forms[0];
        }
        return null;
    }

    private String getAbbreviationSuggestion(String word) throws IOException {
        if (word.length() < 5) {
            List readings = this.getTagger().tag(Collections.singletonList(word));
            for (AnalyzedTokenReadings reading : readings) {
                if (!reading.hasPosTagStartingWith("ABK")) continue;
                return word + ".";
            }
        }
        return null;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) throws IOException {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx + 1);
        boolean bl = isCompound = (nextWord = StringUtils.removeEnd((String)nextWord, (String)".")) != null && (this.compoundTokenizer.tokenize(nextWord).size() > 1 || nextWord.indexOf(45) > 0 || SPECIAL_CASE_THIRD.matcher(nextWord).matches());
        if (isCompound) {
            boolean isMisspelled;
            boolean bl2 = isMisspelled = !this.hunspell.spell(word = StringUtils.removeEnd((String)word, (String)"-"));
            if (isMisspelled && (super.ignoreWord(word) || this.wordsToBeIgnoredInCompounds.contains(word))) {
                isMisspelled = false;
            } else if (isMisspelled && word.endsWith("s") && this.isNeedingFugenS(StringUtils.removeEnd((String)word, (String)"s"))) {
                isMisspelled = !this.hunspell.spell(StringUtils.removeEnd((String)word, (String)"s"));
            }
            return !isMisspelled;
        }
        return false;
    }

    private boolean isNeedingFugenS(String word) {
        return StringUtils.endsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"tum", "ling", "ion", "t\u00e4t", "keit", "schaft", "sicht", "ung", "en"});
    }

    @Nullable
    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            String word = words.get(i);
            if (word.endsWith("-") || StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{",", "/", "&", "und", "oder", "bzw.", "beziehungsweise", "sowie", "statt"}) || word.trim().isEmpty()) continue;
            return word;
        }
        return null;
    }

    private boolean ignoreCompoundWithIgnoredWord(String word) throws IOException {
        if (!StringTools.startsWithUppercase((String)word) && !StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"nord", "west", "ost", "s\u00fcd"})) {
            return false;
        }
        String[] words = word.split("-");
        if (words.length < 2) {
            int end = super.startsWithIgnoredWord(word, true);
            if (end < 3) {
                if (word.startsWith("ost") || word.startsWith("s\u00fcd")) {
                    end = 3;
                } else if (word.startsWith("west") || word.startsWith("nord")) {
                    end = 4;
                } else {
                    return false;
                }
            }
            String ignoredWord = word.substring(0, end);
            String partialWord = word.substring(end);
            partialWord = partialWord.endsWith(".") ? partialWord.substring(0, partialWord.length() - 1) : partialWord;
            boolean isNoun = this.isNoun(partialWord);
            boolean isUppercaseNoun = false;
            if (!isNoun && !StringTools.startsWithUppercase((String)partialWord)) {
                isUppercaseNoun = this.isNoun(StringTools.uppercaseFirstChar((String)partialWord));
            }
            boolean isDirection = DIRECTION.matcher(ignoredWord).matches();
            boolean isAdjective = this.isAdjective(ignoredWord);
            boolean isDirectionalAdjective = isDirection && (isAdjective || partialWord.matches(".+ische?[mnrs]?"));
            boolean isCandidateForNonHyphenatedCompound = !(!isDirectionalAdjective && !isNoun && !isUppercaseNoun || StringUtils.isAllUpperCase((CharSequence)ignoredWord) || !StringUtils.isAllLowerCase((CharSequence)partialWord) && !ignoredWord.endsWith("-"));
            boolean needFugenS = this.isNeedingFugenS(ignoredWord);
            if (isCandidateForNonHyphenatedCompound && !needFugenS && partialWord.length() > 2) {
                return this.hunspell.spell(partialWord) || this.hunspell.spell(StringUtils.capitalize((String)partialWord));
            }
            if (isCandidateForNonHyphenatedCompound && needFugenS && partialWord.length() > 2) {
                partialWord = partialWord.startsWith("s") ? partialWord.substring(1) : partialWord;
                return this.hunspell.spell(partialWord) || this.hunspell.spell(StringUtils.capitalize((String)partialWord));
            }
            return false;
        }
        boolean hasIgnoredWord = false;
        ArrayList<String> toSpellCheck = new ArrayList<String>(3);
        String stripFirst = word.substring(words[0].length() + 1);
        String stripLast = word.substring(0, word.length() - words[words.length - 1].length() - 1);
        if (super.ignoreWord(stripFirst) || this.wordsToBeIgnoredInCompounds.contains(stripFirst)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[0])) {
                toSpellCheck.add(words[0]);
            }
        } else if (super.ignoreWord(stripLast) || this.wordsToBeIgnoredInCompounds.contains(stripLast)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[words.length - 1])) {
                toSpellCheck.add(words[words.length - 1]);
            }
        } else {
            for (String word1 : words) {
                if (super.ignoreWord(word1) || this.wordsToBeIgnoredInCompounds.contains(word1)) {
                    hasIgnoredWord = true;
                    continue;
                }
                toSpellCheck.add(word1);
            }
        }
        if (hasIgnoredWord) {
            for (String w : toSpellCheck) {
                if (this.hunspell.spell(w)) continue;
                return false;
            }
        }
        return hasIgnoredWord;
    }

    private Tagger getTagger() {
        return this.language.getTagger();
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        if (idx > 3 && token.startsWith("-")) {
            return StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 1].getToken(), (CharSequence[])new CharSequence[]{"\u201c", "\""}) && StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 3].getToken(), (CharSequence[])new CharSequence[]{"\u201e", "\""});
        }
        return false;
    }

    protected void addProhibitedWords(List<String> words) {
        if (words.size() == 1 && words.get(0).endsWith(".*")) {
            this.wordStartsToBeProhibited.add(words.get(0).substring(0, words.get(0).length() - 2));
        } else if (words.get(0).startsWith(".*")) {
            words.stream().forEach(word -> this.wordEndingsToBeProhibited.add(word.substring(2)));
        } else {
            super.addProhibitedWords(words);
        }
    }

    protected List<SuggestedReplacement> filterNoSuggestWords(List<SuggestedReplacement> l) {
        return l.stream().filter(k -> !lcDoNotSuggestWords.contains(k.getReplacement().toLowerCase())).filter(k -> !START_WITH_NEGER.matcher(k.getReplacement().toLowerCase()).matches()).filter(k -> !CONTAINS_NEGER.matcher(k.getReplacement().toLowerCase()).matches()).filter(k -> !CONTAINS_UNCOMMON_LOWERCASED_NOUN_AT_END.matcher(k.getReplacement()).matches()).filter(k -> !CONTAINS_UNCOMMON_LOWERCASED_NOUN_AT_BEGINNING.matcher(k.getReplacement()).matches()).collect(Collectors.toList());
    }

    protected List<SuggestedReplacement> getOnlySuggestions(String word) {
        if (SYMPHATISCH.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("symphatisch", "sympathisch"));
        }
        if (AUTENTISCH_WITH_CASES.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("utent", "uthent"));
        }
        if (BRILLIANT_WITH_CASES.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("brilliant", "brillant"));
        }
        if (RECHTMASIG_WITH_CASES.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("m\u00e4ssig", "m\u00e4\u00dfig"));
        }
        if (CONTAINS_MASZNAME.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("a(ss|\u00df)name", "a\u00dfnahme"));
        }
        if (HOLZ_SPIEGEL_PANEL_COMPOUND.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("panel", "paneel"));
        }
        if (SBHAN_PREFIX.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("SBahn", "S-Bahn"));
        }
        if (UBAHN_PREFIX.matcher(word).matches()) {
            return SuggestedReplacement.topMatch((String)word.replaceFirst("UBahn", "U-Bahn"));
        }
        switch (word) {
            case "B\u00fcffet": 
            case "Buffett": 
            case "Bufett": 
            case "B\u00fcffett": 
            case "Bufet": 
            case "B\u00fcfet": {
                if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH") || this.language.getShortCodeWithCountryAndVariant().equals("de-AT")) {
                    return SuggestedReplacement.topMatch((String)"Buffet", (String)"zum Verzehr bereitgestellte Speisen");
                }
                return SuggestedReplacement.topMatch((String)"B\u00fcfett", (String)"zum Verzehr bereitgestellte Speisen");
            }
            case "do": {
                return SuggestedReplacement.topMatch((String)"so");
            }
            case "Blackweek": {
                return SuggestedReplacement.topMatch((String)"Black Week");
            }
            case "Blackfriday": {
                return SuggestedReplacement.topMatch((String)"Black Friday");
            }
            case "Blackweeks": {
                return SuggestedReplacement.topMatch((String)"Black Weeks");
            }
            case "Blackfridays": {
                return SuggestedReplacement.topMatch((String)"Black Fridays");
            }
            case "Au-Pair": {
                return SuggestedReplacement.topMatch((String)"Au-pair");
            }
            case "Au-Pairs": {
                return SuggestedReplacement.topMatch((String)"Au-pairs");
            }
            case "deluxe": {
                return SuggestedReplacement.topMatch((String)"de luxe");
            }
            case "Deluxe": {
                return SuggestedReplacement.topMatch((String)"de luxe");
            }
            case "Design-Op": {
                return SuggestedReplacement.topMatch((String)"Design-OP");
            }
            case "AppStore": {
                return SuggestedReplacement.topMatch((String)"App Store");
            }
            case "AppStores": {
                return SuggestedReplacement.topMatch((String)"App Stores");
            }
            case "AppleStore": {
                return SuggestedReplacement.topMatch((String)"Apple Store");
            }
            case "AppleStores": {
                return SuggestedReplacement.topMatch((String)"Apple Stores");
            }
            case "AirFrance": {
                return SuggestedReplacement.topMatch((String)"Air France");
            }
            case "Wiederspruch": {
                return SuggestedReplacement.topMatch((String)"Widerspruch");
            }
            case "Wiederspruchs": {
                return SuggestedReplacement.topMatch((String)"Widerspruchs");
            }
            case "Wiederspr\u00fcche": {
                return SuggestedReplacement.topMatch((String)"Widerspr\u00fcche");
            }
            case "Wiederspr\u00fcchen": {
                return SuggestedReplacement.topMatch((String)"Widerspr\u00fcchen");
            }
            case "Vorraussetzung": {
                return SuggestedReplacement.topMatch((String)"Voraussetzung");
            }
            case "Vorraussetzungen": {
                return SuggestedReplacement.topMatch((String)"Voraussetzungen");
            }
            case "Schalosie": {
                return SuggestedReplacement.topMatch((String)"Jalousie", (String)"bewegliche Lamellen zum Sicht- und Sonnenschutz");
            }
            case "Schalosien": {
                return SuggestedReplacement.topMatch((String)"Jalousien", (String)"bewegliche Lamellen zum Sicht- und Sonnenschutz");
            }
            case "offensichtlicherweise": {
                return SuggestedReplacement.topMatch((String)"offensichtlich");
            }
            case "Offensichtlicherweise": {
                return SuggestedReplacement.topMatch((String)"Offensichtlich");
            }
            case "wohlwissend": {
                return SuggestedReplacement.topMatch((String)"wohl wissend");
            }
            case "Visas": {
                return SuggestedReplacement.topMatch((String)"Visa", (String)"Plural von 'Visum'");
            }
            case "Interresse": {
                return SuggestedReplacement.topMatch((String)"Interesse");
            }
            case "Interressen": {
                return SuggestedReplacement.topMatch((String)"Interessen");
            }
            case "Terasse": {
                return SuggestedReplacement.topMatch((String)"Terrasse");
            }
            case "Terassen": {
                return SuggestedReplacement.topMatch((String)"Terrassen");
            }
            case "Reisverschluss": {
                return SuggestedReplacement.topMatch((String)"Rei\u00dfverschluss");
            }
            case "Reisverschlusses": {
                return SuggestedReplacement.topMatch((String)"Rei\u00dfverschlusses");
            }
            case "Reiszwecke": {
                return SuggestedReplacement.topMatch((String)"Rei\u00dfzwecke", (String)"kurzer Nagel mit flachem Kopf");
            }
            case "Reiszwecken": {
                return SuggestedReplacement.topMatch((String)"Rei\u00dfzwecken", (String)"kurzer Nagel mit flachem Kopf");
            }
            case "up-to-date": {
                return SuggestedReplacement.topMatch((String)"up to date");
            }
            case "falscherweise": {
                return SuggestedReplacement.topMatch((String)"f\u00e4lschlicherweise");
            }
            case "schliesslich": {
                return SuggestedReplacement.topMatch((String)"schlie\u00dflich");
            }
            case "Schliesslich": {
                return SuggestedReplacement.topMatch((String)"Schlie\u00dflich");
            }
            case "da\u00df": {
                return SuggestedReplacement.topMatch((String)"dass");
            }
            case "Da\u00df": {
                return SuggestedReplacement.topMatch((String)"Dass");
            }
            case "mu\u00dft": {
                return SuggestedReplacement.topMatch((String)"musst");
            }
            case "Mu\u00dft": {
                return SuggestedReplacement.topMatch((String)"Musst");
            }
            case "m\u00fc\u00dft": {
                return SuggestedReplacement.topMatch((String)"m\u00fcsst");
            }
            case "M\u00fc\u00dft": {
                return SuggestedReplacement.topMatch((String)"M\u00fcsst");
            }
            case "heisst": {
                return SuggestedReplacement.topMatch((String)"hei\u00dft");
            }
            case "Heisst": {
                return SuggestedReplacement.topMatch((String)"Hei\u00dft");
            }
            case "heisse": {
                return SuggestedReplacement.topMatch((String)"hei\u00dfe");
            }
            case "heissen": {
                return SuggestedReplacement.topMatch((String)"hei\u00dfen");
            }
            case "beisst": {
                return SuggestedReplacement.topMatch((String)"bei\u00dft");
            }
            case "beissen": {
                return SuggestedReplacement.topMatch((String)"bei\u00dfen");
            }
            case "mu\u00dften": {
                return SuggestedReplacement.topMatch((String)"mussten");
            }
            case "mu\u00dfte": {
                return SuggestedReplacement.topMatch((String)"musste");
            }
            case "mu\u00dftest": {
                return SuggestedReplacement.topMatch((String)"musstest");
            }
            case "m\u00fc\u00dftest": {
                return SuggestedReplacement.topMatch((String)"m\u00fcsstest");
            }
            case "m\u00fc\u00dfen": {
                return SuggestedReplacement.topMatch((String)"m\u00fcssen");
            }
            case "m\u00fc\u00dften": {
                return SuggestedReplacement.topMatch((String)"m\u00fcssten");
            }
            case "m\u00fc\u00dfte": {
                return SuggestedReplacement.topMatch((String)"m\u00fcsste");
            }
            case "wu\u00dfte": {
                return SuggestedReplacement.topMatch((String)"wusste");
            }
            case "wu\u00dften": {
                return SuggestedReplacement.topMatch((String)"wussten");
            }
            case "w\u00fc\u00dfte": {
                return SuggestedReplacement.topMatch((String)"w\u00fcsste");
            }
            case "w\u00fc\u00dften": {
                return SuggestedReplacement.topMatch((String)"w\u00fcssten");
            }
            case "bescheid": {
                return SuggestedReplacement.topMatch((String)"Bescheid");
            }
            case "Facetime": {
                return SuggestedReplacement.topMatch((String)"FaceTime");
            }
            case "Facetimes": {
                return SuggestedReplacement.topMatch((String)"FaceTimes");
            }
            case "ausversehen": {
                return SuggestedReplacement.topMatch((String)"aus Versehen");
            }
            case "St\u00fcckweit": {
                return SuggestedReplacement.topMatch((String)"St\u00fcck weit");
            }
            case "Uranium": {
                return SuggestedReplacement.topMatch((String)"Uran");
            }
            case "Uraniums": {
                return SuggestedReplacement.topMatch((String)"Urans");
            }
            case "Luxenburg": {
                return SuggestedReplacement.topMatch((String)"Luxemburg");
            }
            case "Luxenburgs": {
                return SuggestedReplacement.topMatch((String)"Luxemburgs");
            }
            case "Lichtenstein": {
                return SuggestedReplacement.topMatch((String)"Liechtenstein");
            }
            case "Lichtensteins": {
                return SuggestedReplacement.topMatch((String)"Liechtensteins");
            }
            case "immernoch": {
                return SuggestedReplacement.topMatch((String)"immer noch");
            }
            case "Rechtshcreibfehler": {
                return SuggestedReplacement.topMatch((String)"Rechtschreibfehler");
            }
            case "markirt": {
                return SuggestedReplacement.topMatch((String)"markiert");
            }
            case "Johannesbeere": {
                return SuggestedReplacement.topMatch((String)"Johannisbeere");
            }
            case "Johannesbeeren": {
                return SuggestedReplacement.topMatch((String)"Johannisbeeren");
            }
            case "Endgeld": {
                return SuggestedReplacement.topMatch((String)"Entgeld");
            }
            case "Ent\u00e4uschung": {
                return SuggestedReplacement.topMatch((String)"Entt\u00e4uschung");
            }
            case "Ent\u00e4uschungen": {
                return SuggestedReplacement.topMatch((String)"Entt\u00e4uschungen");
            }
            case "Triologie": {
                return SuggestedReplacement.topMatch((String)"Trilogie", (String)"Werk (z.B. Film), das aus drei Teilen besteht");
            }
            case "ausserdem": {
                return SuggestedReplacement.topMatch((String)"au\u00dferdem");
            }
            case "Ausserdem": {
                return SuggestedReplacement.topMatch((String)"Au\u00dferdem");
            }
            case "ausser": {
                return SuggestedReplacement.topMatch((String)"au\u00dfer");
            }
            case "Ausser": {
                return SuggestedReplacement.topMatch((String)"Au\u00dfer");
            }
            case "bischen": {
                return SuggestedReplacement.topMatch((String)"bisschen");
            }
            case "bi\u00dfchen": {
                return SuggestedReplacement.topMatch((String)"bisschen");
            }
            case "mei\u00dft": {
                return SuggestedReplacement.topMatch((String)"meist");
            }
            case "mei\u00dften": {
                return SuggestedReplacement.topMatch((String)"meisten");
            }
            case "mei\u00dftens": {
                return SuggestedReplacement.topMatch((String)"meistens");
            }
            case "Babyphone": {
                return SuggestedReplacement.topMatch((String)"Babyfon");
            }
            case "Baby-Phone": {
                return SuggestedReplacement.topMatch((String)"Babyfon");
            }
            case "gescheint": {
                return SuggestedReplacement.topMatch((String)"geschienen");
            }
            case "staubgesaugt": {
                return SuggestedReplacement.topMatch((String)"gestaubsaugt");
            }
            case "geupdated": {
                return SuggestedReplacement.topMatch((String)"upgedatet");
            }
            case "geupdatet": {
                return SuggestedReplacement.topMatch((String)"upgedatet");
            }
            case "gedownloaded": {
                return SuggestedReplacement.topMatch((String)"downgeloadet");
            }
            case "gedownloadet": {
                return SuggestedReplacement.topMatch((String)"downgeloadet");
            }
            case "gedownloadete": {
                return SuggestedReplacement.topMatch((String)"downgeloadete");
            }
            case "gedownloadeter": {
                return SuggestedReplacement.topMatch((String)"downgeloadeter");
            }
            case "gedownloadetes": {
                return SuggestedReplacement.topMatch((String)"downgeloadetes");
            }
            case "gedownloadeten": {
                return SuggestedReplacement.topMatch((String)"downgeloadeten");
            }
            case "gedownloadetem": {
                return SuggestedReplacement.topMatch((String)"downgeloadetem");
            }
            case "geuploaded": {
                return SuggestedReplacement.topMatch((String)"upgeloadet");
            }
            case "geuploadet": {
                return SuggestedReplacement.topMatch((String)"upgeloadet");
            }
            case "geuploadete": {
                return SuggestedReplacement.topMatch((String)"upgeloadete");
            }
            case "geuploadeter": {
                return SuggestedReplacement.topMatch((String)"upgeloadeter");
            }
            case "geuploadetes": {
                return SuggestedReplacement.topMatch((String)"upgeloadetes");
            }
            case "geuploadeten": {
                return SuggestedReplacement.topMatch((String)"upgeloadeten");
            }
            case "geuploadetem": {
                return SuggestedReplacement.topMatch((String)"upgeloadetem");
            }
            case "Frauenhofer": {
                return SuggestedReplacement.topMatch((String)"Fraunhofer");
            }
            case "h\u00f6rensagen": {
                return SuggestedReplacement.topMatch((String)"H\u00f6rensagen");
            }
            case "Mwst": {
                return SuggestedReplacement.topMatch((String)"MwSt");
            }
            case "MwSt": {
                return SuggestedReplacement.topMatch((String)"MwSt.");
            }
            case "MWST": {
                return SuggestedReplacement.topMatch((String)"MwSt.");
            }
            case "exkl": {
                return SuggestedReplacement.topMatch((String)"exkl.");
            }
            case "inkl": {
                return SuggestedReplacement.topMatch((String)"inkl.");
            }
            case "h\u00e4lst": {
                return SuggestedReplacement.topMatch((String)"h\u00e4ltst");
            }
            case "Rythmus": {
                return SuggestedReplacement.topMatch((String)"Rhythmus");
            }
            case "Rhytmus": {
                return SuggestedReplacement.topMatch((String)"Rhythmus");
            }
            case "Rhytmen": {
                return SuggestedReplacement.topMatch((String)"Rhythmen");
            }
            case "Hobbies": {
                return SuggestedReplacement.topMatch((String)"Hobbys");
            }
            case "Stehgreif": {
                return SuggestedReplacement.topMatch((String)"Stegreif");
            }
            case "brilliant": {
                return SuggestedReplacement.topMatch((String)"brillant");
            }
            case "brilliante": {
                return SuggestedReplacement.topMatch((String)"brillante");
            }
            case "brilliantes": {
                return SuggestedReplacement.topMatch((String)"brillantes");
            }
            case "brillianter": {
                return SuggestedReplacement.topMatch((String)"brillanter");
            }
            case "brillianten": {
                return SuggestedReplacement.topMatch((String)"brillanten");
            }
            case "brilliantem": {
                return SuggestedReplacement.topMatch((String)"brillantem");
            }
            case "Billiard": {
                return SuggestedReplacement.topMatch((String)"Billard");
            }
            case "garnicht": {
                return SuggestedReplacement.topMatch((String)"gar nicht");
            }
            case "garnich": {
                return SuggestedReplacement.topMatch((String)"gar nicht");
            }
            case "garnichts": {
                return SuggestedReplacement.topMatch((String)"gar nichts");
            }
            case "assozial": {
                return SuggestedReplacement.topMatch((String)"asozial");
            }
            case "assoziale": {
                return SuggestedReplacement.topMatch((String)"asoziale");
            }
            case "assoziales": {
                return SuggestedReplacement.topMatch((String)"asoziales");
            }
            case "assozialer": {
                return SuggestedReplacement.topMatch((String)"asozialer");
            }
            case "assozialen": {
                return SuggestedReplacement.topMatch((String)"asozialen");
            }
            case "assozialem": {
                return SuggestedReplacement.topMatch((String)"asozialem");
            }
            case "Verwandschaft": {
                return SuggestedReplacement.topMatch((String)"Verwandtschaft");
            }
            case "vorraus": {
                return SuggestedReplacement.topMatch((String)"voraus");
            }
            case "Vorraus": {
                return SuggestedReplacement.topMatch((String)"Voraus");
            }
            case "Reperatur": {
                return SuggestedReplacement.topMatch((String)"Reparatur");
            }
            case "Reperaturen": {
                return SuggestedReplacement.topMatch((String)"Reparaturen");
            }
            case "Bzgl": {
                return SuggestedReplacement.topMatch((String)"Bzgl.");
            }
            case "bzgl": {
                return SuggestedReplacement.topMatch((String)"bzgl.");
            }
            case "Eigtl": {
                return SuggestedReplacement.topMatch((String)"Eigtl.");
            }
            case "eigtl": {
                return SuggestedReplacement.topMatch((String)"eigtl.");
            }
            case "Mo-Di": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013Di.");
            }
            case "Mo-Mi": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013Mi.");
            }
            case "Mo-Do": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013Do.");
            }
            case "Mo-Fr": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013Fr.");
            }
            case "Mo-Sa": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013Sa.");
            }
            case "Mo-So": {
                return SuggestedReplacement.topMatch((String)"Mo.\u2013So.");
            }
            case "Di-Mi": {
                return SuggestedReplacement.topMatch((String)"Di.\u2013Mi.");
            }
            case "Di-Do": {
                return SuggestedReplacement.topMatch((String)"Di.\u2013Do.");
            }
            case "Di-Fr": {
                return SuggestedReplacement.topMatch((String)"Di.\u2013Fr.");
            }
            case "Di-Sa": {
                return SuggestedReplacement.topMatch((String)"Di.\u2013Sa.");
            }
            case "Di-So": {
                return SuggestedReplacement.topMatch((String)"Di.\u2013So.");
            }
            case "Mi-Do": {
                return SuggestedReplacement.topMatch((String)"Mi.\u2013Do.");
            }
            case "Mi-Fr": {
                return SuggestedReplacement.topMatch((String)"Mi.\u2013Fr.");
            }
            case "Mi-Sa": {
                return SuggestedReplacement.topMatch((String)"Mi.\u2013Sa.");
            }
            case "Mi-So": {
                return SuggestedReplacement.topMatch((String)"Mi.\u2013So.");
            }
            case "Do-Fr": {
                return SuggestedReplacement.topMatch((String)"Do.\u2013Fr.");
            }
            case "Do-Sa": {
                return SuggestedReplacement.topMatch((String)"Do.\u2013Sa.");
            }
            case "Do-So": {
                return SuggestedReplacement.topMatch((String)"Do.\u2013So.");
            }
            case "Fr-Sa": {
                return SuggestedReplacement.topMatch((String)"Fr.\u2013Sa.");
            }
            case "Fr-So": {
                return SuggestedReplacement.topMatch((String)"Fr.\u2013So.");
            }
            case "Sa-So": {
                return SuggestedReplacement.topMatch((String)"Sa.\u2013So.");
            }
            case "Achso": {
                return SuggestedReplacement.topMatch((String)"Ach so");
            }
            case "achso": {
                return SuggestedReplacement.topMatch((String)"ach so");
            }
            case "Huskies": {
                return SuggestedReplacement.topMatch((String)"Huskys");
            }
            case "Jedesmal": {
                return SuggestedReplacement.topMatch((String)"Jedes Mal");
            }
            case "jedesmal": {
                return SuggestedReplacement.topMatch((String)"jedes Mal");
            }
            case "Lybien": {
                return SuggestedReplacement.topMatch((String)"Libyen");
            }
            case "Lybiens": {
                return SuggestedReplacement.topMatch((String)"Libyens");
            }
            case "Youtube": {
                return SuggestedReplacement.topMatch((String)"YouTube");
            }
            case "Youtuber": {
                return SuggestedReplacement.topMatch((String)"YouTuber");
            }
            case "Youtuberin": {
                return SuggestedReplacement.topMatch((String)"YouTuberin");
            }
            case "Youtuberinnen": {
                return SuggestedReplacement.topMatch((String)"YouTuberinnen");
            }
            case "Youtubers": {
                return SuggestedReplacement.topMatch((String)"YouTubers");
            }
            case "Reflektion": {
                return SuggestedReplacement.topMatch((String)"Reflexion");
            }
            case "Reflektionen": {
                return SuggestedReplacement.topMatch((String)"Reflexionen");
            }
            case "unrelevant": {
                return SuggestedReplacement.topMatch((String)"irrelevant");
            }
            case "inflagranti": {
                return SuggestedReplacement.topMatch((String)"in flagranti");
            }
            case "Storie": {
                return SuggestedReplacement.topMatch((String)"Story");
            }
            case "Stories": {
                return SuggestedReplacement.topMatch((String)"Storys");
            }
            case "Ladies": {
                return SuggestedReplacement.topMatch((String)"Ladys");
            }
            case "Parties": {
                return SuggestedReplacement.topMatch((String)"Partys");
            }
            case "Lobbies": {
                return SuggestedReplacement.topMatch((String)"Lobbys");
            }
            case "Nestle": {
                return SuggestedReplacement.topMatch((String)"Nestl\u00e9");
            }
            case "Nestles": {
                return SuggestedReplacement.topMatch((String)"Nestl\u00e9s");
            }
            case "vollzeit": {
                return SuggestedReplacement.topMatch((String)"Vollzeit");
            }
            case "teilzeit": {
                return SuggestedReplacement.topMatch((String)"Teilzeit");
            }
            case "Dnake": {
                return SuggestedReplacement.topMatch((String)"Danke");
            }
            case "Muehe": {
                return SuggestedReplacement.topMatch((String)"M\u00fche");
            }
            case "Muehen": {
                return SuggestedReplacement.topMatch((String)"M\u00fchen");
            }
            case "Torschusspanik": {
                return SuggestedReplacement.topMatch((String)"Torschlusspanik");
            }
            case "ggf": {
                return SuggestedReplacement.topMatch((String)"ggf.");
            }
            case "Ggf": {
                return SuggestedReplacement.topMatch((String)"Ggf.");
            }
            case "zzgl": {
                return SuggestedReplacement.topMatch((String)"zzgl.");
            }
            case "Zzgl": {
                return SuggestedReplacement.topMatch((String)"Zzgl.");
            }
            case "aufgehangen": {
                return SuggestedReplacement.topMatch((String)"aufgeh\u00e4ngt");
            }
            case "Pieks": {
                return SuggestedReplacement.topMatch((String)"Piks");
            }
            case "Piekse": {
                return SuggestedReplacement.topMatch((String)"Pikse");
            }
            case "Piekses": {
                return SuggestedReplacement.topMatch((String)"Pikses");
            }
            case "Pieksen": {
                return SuggestedReplacement.topMatch((String)"Piksen");
            }
            case "Annektion": {
                return SuggestedReplacement.topMatch((String)"Annexion");
            }
            case "Annektionen": {
                return SuggestedReplacement.topMatch((String)"Annexionen");
            }
            case "unkonsistent": {
                return SuggestedReplacement.topMatch((String)"inkonsistent");
            }
            case "Wei\u00dfheitszahn": {
                return SuggestedReplacement.topMatch((String)"Weisheitszahn");
            }
            case "Weissheitszahn": {
                return SuggestedReplacement.topMatch((String)"Weisheitszahn");
            }
            case "Wei\u00dfheitszahns": {
                return SuggestedReplacement.topMatch((String)"Weisheitszahns");
            }
            case "Weissheitszahns": {
                return SuggestedReplacement.topMatch((String)"Weisheitszahns");
            }
            case "Wei\u00dfheitsz\u00e4hne": {
                return SuggestedReplacement.topMatch((String)"Weisheitsz\u00e4hne");
            }
            case "Weissheitsz\u00e4hne": {
                return SuggestedReplacement.topMatch((String)"Weisheitsz\u00e4hne");
            }
            case "Wei\u00dfheitsz\u00e4hnen": {
                return SuggestedReplacement.topMatch((String)"Weisheitsz\u00e4hnen");
            }
            case "Weissheitsz\u00e4hnen": {
                return SuggestedReplacement.topMatch((String)"Weisheitsz\u00e4hnen");
            }
            case "raufschauen": {
                return SuggestedReplacement.topMatch((String)"draufschauen");
            }
            case "raufzuschauen": {
                return SuggestedReplacement.topMatch((String)"draufzuschauen");
            }
            case "raufgeschaut": {
                return SuggestedReplacement.topMatch((String)"draufgeschaut");
            }
            case "raufschaue": {
                return SuggestedReplacement.topMatch((String)"draufschaue");
            }
            case "raufschaust": {
                return SuggestedReplacement.topMatch((String)"draufschaust");
            }
            case "raufschaut": {
                return SuggestedReplacement.topMatch((String)"draufschaut");
            }
            case "raufschaute": {
                return SuggestedReplacement.topMatch((String)"draufschaute");
            }
            case "raufschauten": {
                return SuggestedReplacement.topMatch((String)"draufschauten");
            }
            case "raufgucken": {
                return SuggestedReplacement.topMatch((String)"draufgucken");
            }
            case "raufzugucken": {
                return SuggestedReplacement.topMatch((String)"draufzugucken");
            }
            case "raufgeguckt": {
                return SuggestedReplacement.topMatch((String)"draufgeguckt");
            }
            case "raufgucke": {
                return SuggestedReplacement.topMatch((String)"draufgucke");
            }
            case "raufguckst": {
                return SuggestedReplacement.topMatch((String)"draufguckst");
            }
            case "raufguckt": {
                return SuggestedReplacement.topMatch((String)"draufguckt");
            }
            case "raufguckte": {
                return SuggestedReplacement.topMatch((String)"draufguckte");
            }
            case "raufguckten": {
                return SuggestedReplacement.topMatch((String)"draufguckten");
            }
            case "raufhauen": {
                return SuggestedReplacement.topMatch((String)"draufhauen");
            }
            case "raufzuhauen": {
                return SuggestedReplacement.topMatch((String)"draufzuhauen");
            }
            case "raufgehaut": {
                return SuggestedReplacement.topMatch((String)"draufgehaut");
            }
            case "raufhaue": {
                return SuggestedReplacement.topMatch((String)"draufhaue");
            }
            case "raufhaust": {
                return SuggestedReplacement.topMatch((String)"draufhaust");
            }
            case "raufhaut": {
                return SuggestedReplacement.topMatch((String)"draufhaut");
            }
            case "raufhaute": {
                return SuggestedReplacement.topMatch((String)"draufhaute");
            }
            case "raufhauten": {
                return SuggestedReplacement.topMatch((String)"draufhauten");
            }
            case "wohlm\u00f6glich": {
                return SuggestedReplacement.topMatch((String)"wom\u00f6glich");
            }
            case "geschalten": {
                return SuggestedReplacement.topMatch((String)"geschaltet");
            }
            case "angeschalten": {
                return SuggestedReplacement.topMatch((String)"angeschaltet");
            }
            case "abgeschalten": {
                return SuggestedReplacement.topMatch((String)"abgeschaltet");
            }
            case "hiess": {
                return SuggestedReplacement.topMatch((String)"hie\u00df");
            }
            case "Click": {
                return SuggestedReplacement.topMatch((String)"Klick");
            }
            case "Clicks": {
                return SuggestedReplacement.topMatch((String)"Klicks");
            }
            case "jenachdem": {
                return SuggestedReplacement.topMatch((String)"je nachdem");
            }
            case "bsp": {
                return SuggestedReplacement.topMatch((String)"bspw");
            }
            case "vorallem": {
                return SuggestedReplacement.topMatch((String)"vor allem");
            }
            case "draussen": {
                return SuggestedReplacement.topMatch((String)"drau\u00dfen");
            }
            case "\u00fcrbigens": {
                return SuggestedReplacement.topMatch((String)"\u00fcbrigens");
            }
            case "Whatsapp": {
                return SuggestedReplacement.topMatch((String)"WhatsApp");
            }
            case "kucken": {
                return SuggestedReplacement.topMatch((String)"gucken");
            }
            case "kuckten": {
                return SuggestedReplacement.topMatch((String)"guckten");
            }
            case "kucke": {
                return SuggestedReplacement.topMatch((String)"gucke");
            }
            case "aelter": {
                return SuggestedReplacement.topMatch((String)"\u00e4lter");
            }
            case "\u00e4ussern": {
                return SuggestedReplacement.topMatch((String)"\u00e4u\u00dfern");
            }
            case "\u00e4usserst": {
                return SuggestedReplacement.topMatch((String)"\u00e4u\u00dferst");
            }
            case "ge\u00e4ussert": {
                return SuggestedReplacement.topMatch((String)"ge\u00e4u\u00dfert");
            }
            case "\u00c4usserst": {
                return SuggestedReplacement.topMatch((String)"\u00c4u\u00dferst");
            }
            case "Dnk": {
                return SuggestedReplacement.topMatch((String)"Dank");
            }
            case "schleswig-holstein": {
                return SuggestedReplacement.topMatch((String)"Schleswig-Holstein");
            }
            case "Stahlkraft": {
                return SuggestedReplacement.topMatch((String)"Strahlkraft");
            }
            case "tr\u00fcmmern": {
                return SuggestedReplacement.topMatch((String)"Tr\u00fcmmern");
            }
            case "gradeaus": {
                return SuggestedReplacement.topMatch((String)"geradeaus");
            }
            case "Anschliessend": {
                return SuggestedReplacement.topMatch((String)"Anschlie\u00dfend");
            }
            case "anschliessend": {
                return SuggestedReplacement.topMatch((String)"anschlie\u00dfend");
            }
            case "Abschliessend": {
                return SuggestedReplacement.topMatch((String)"Abschlie\u00dfend");
            }
            case "abschliessend": {
                return SuggestedReplacement.topMatch((String)"abschlie\u00dfend");
            }
            case "Ruckmeldung": {
                return SuggestedReplacement.topMatch((String)"R\u00fcckmeldung");
            }
            case "Gepaeck": {
                return SuggestedReplacement.topMatch((String)"Gep\u00e4ck");
            }
            case "Gr\u00fcsse": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfe");
            }
            case "Gr\u00fcssen": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfen");
            }
            case "entg\u00fcltig": {
                return SuggestedReplacement.topMatch((String)"endg\u00fcltig");
            }
            case "entg\u00fcltige": {
                return SuggestedReplacement.topMatch((String)"endg\u00fcltige");
            }
            case "entg\u00fcltiges": {
                return SuggestedReplacement.topMatch((String)"endg\u00fcltiges");
            }
            case "entg\u00fcltiger": {
                return SuggestedReplacement.topMatch((String)"endg\u00fcltiger");
            }
            case "entg\u00fcltigen": {
                return SuggestedReplacement.topMatch((String)"endg\u00fcltigen");
            }
            case "des\u00f6fteren": {
                return SuggestedReplacement.topMatch((String)"des \u00d6fteren");
            }
            case "desweiteren": {
                return SuggestedReplacement.topMatch((String)"des Weiteren");
            }
            case "weitesgehend": {
                return SuggestedReplacement.topMatch((String)"weitestgehend");
            }
            case "Tschibo": {
                return SuggestedReplacement.topMatch((String)"Tchibo");
            }
            case "Tschibos": {
                return SuggestedReplacement.topMatch((String)"Tchibos");
            }
            case "Tiktok": {
                return SuggestedReplacement.topMatch((String)"TikTok");
            }
            case "Tiktoks": {
                return SuggestedReplacement.topMatch((String)"TikToks");
            }
            case "soda\u00df": {
                return SuggestedReplacement.topMatch((String)"sodass");
            }
            case "regelm\u00e4ssig": {
                return SuggestedReplacement.topMatch((String)"regelm\u00e4\u00dfig");
            }
            case "Carplay": {
                return SuggestedReplacement.topMatch((String)"CarPlay");
            }
            case "Tiktoker": {
                return SuggestedReplacement.topMatch((String)"TikToker");
            }
            case "Tiktokerin": {
                return SuggestedReplacement.topMatch((String)"TikTokerin");
            }
            case "Tiktokerinnen": {
                return SuggestedReplacement.topMatch((String)"TikTokerinnen");
            }
            case "Tiktokers": {
                return SuggestedReplacement.topMatch((String)"TikTokers");
            }
            case "Tiktokern": {
                return SuggestedReplacement.topMatch((String)"TikTokern");
            }
            case "languagetool": {
                return SuggestedReplacement.topMatch((String)"LanguageTool");
            }
            case "languagetools": {
                return SuggestedReplacement.topMatch((String)"LanguageTools");
            }
            case "Languagetool": {
                return SuggestedReplacement.topMatch((String)"LanguageTool");
            }
            case "Languagetools": {
                return SuggestedReplacement.topMatch((String)"LanguageTools");
            }
            case "liket": {
                return SuggestedReplacement.topMatch((String)"likt");
            }
            case "nagut": {
                return SuggestedReplacement.topMatch((String)"na gut");
            }
            case "Nagut": {
                return SuggestedReplacement.topMatch((String)"Na gut");
            }
            case "HAllo": {
                return SuggestedReplacement.topMatch((String)"Hallo");
            }
            case "HEy": {
                return SuggestedReplacement.topMatch((String)"Hey");
            }
            case "SEhr": {
                return SuggestedReplacement.topMatch((String)"Sehr");
            }
            case "abhol": {
                return SuggestedReplacement.topMatch((String)"abhole");
            }
            case "amazon": {
                return SuggestedReplacement.topMatch((String)"Amazon");
            }
            case "irgendeins": {
                return SuggestedReplacement.topMatch((String)"irgendeines");
            }
            case "Communities": {
                return SuggestedReplacement.topMatch((String)"Communitys");
            }
            case "ansich": {
                return SuggestedReplacement.topMatch((String)"an sich");
            }
            case "Spass": {
                return SuggestedReplacement.topMatch((String)"Spa\u00df");
            }
            case "garkein": {
                return SuggestedReplacement.topMatch((String)"gar kein");
            }
            case "garkeine": {
                return SuggestedReplacement.topMatch((String)"gar keine");
            }
            case "garkeinen": {
                return SuggestedReplacement.topMatch((String)"gar keinen");
            }
            case "wieviel": {
                return SuggestedReplacement.topMatch((String)"wie viel");
            }
            case "Wieviel": {
                return SuggestedReplacement.topMatch((String)"Wie viel");
            }
            case "gets": {
                return SuggestedReplacement.topMatch((String)"gehts");
            }
            case "Quillbot": {
                return SuggestedReplacement.topMatch((String)"QuillBot");
            }
            case "ebensowenig": {
                return SuggestedReplacement.topMatch((String)"ebenso wenig");
            }
            case "Wiedersehn": {
                return SuggestedReplacement.topMatch((String)"Wiedersehen");
            }
            case "wiedersehn": {
                return SuggestedReplacement.topMatch((String)"wiedersehen");
            }
            case "Ohje": {
                return SuggestedReplacement.topMatch((String)"Oje");
            }
            case "ohje": {
                return SuggestedReplacement.topMatch((String)"oje");
            }
            case "schwupps": {
                return SuggestedReplacement.topMatch((String)"schwups");
            }
            case "Schwupps": {
                return SuggestedReplacement.topMatch((String)"Schwups");
            }
            case "Massnahme": {
                return SuggestedReplacement.topMatch((String)"Ma\u00dfnahme");
            }
            case "Massnahmen": {
                return SuggestedReplacement.topMatch((String)"Ma\u00dfnahmen");
            }
            case "Linkedin": {
                return SuggestedReplacement.topMatch((String)"LinkedIn");
            }
            case "Wordpress": {
                return SuggestedReplacement.topMatch((String)"WordPress");
            }
            case "gleichzeit": {
                return SuggestedReplacement.topMatch((String)"gleichzeitig");
            }
            case "DAnke": {
                return SuggestedReplacement.topMatch((String)"Danke");
            }
            case "Interior": {
                return SuggestedReplacement.topMatch((String)"Interieur");
            }
            case "Interiors": {
                return SuggestedReplacement.topMatch((String)"Interieurs");
            }
            case "trifftigen": {
                return SuggestedReplacement.topMatch((String)"triftigen");
            }
            case "trifftigem": {
                return SuggestedReplacement.topMatch((String)"triftigem");
            }
            case "trifftige": {
                return SuggestedReplacement.topMatch((String)"triftige");
            }
            case "trifftiges": {
                return SuggestedReplacement.topMatch((String)"triftiges");
            }
            case "trifftiger": {
                return SuggestedReplacement.topMatch((String)"triftiger");
            }
            case "gehhrte": {
                return SuggestedReplacement.topMatch((String)"geehrte");
            }
            case "gehhrten": {
                return SuggestedReplacement.topMatch((String)"geehrten");
            }
            case "gehhrtes": {
                return SuggestedReplacement.topMatch((String)"geehrtes");
            }
            case "Iphone": {
                return SuggestedReplacement.topMatch((String)"iPhone");
            }
            case "Iphones": {
                return SuggestedReplacement.topMatch((String)"iPhones");
            }
            case "iphone": {
                return SuggestedReplacement.topMatch((String)"iPhone");
            }
            case "iphones": {
                return SuggestedReplacement.topMatch((String)"iPhones");
            }
            case "Ipad": {
                return SuggestedReplacement.topMatch((String)"iPad");
            }
            case "Ipads": {
                return SuggestedReplacement.topMatch((String)"iPads");
            }
            case "ipad": {
                return SuggestedReplacement.topMatch((String)"iPad");
            }
            case "ipads": {
                return SuggestedReplacement.topMatch((String)"iPads");
            }
            case "letzlich": {
                return SuggestedReplacement.topMatch((String)"letztlich");
            }
            case "Letzlich": {
                return SuggestedReplacement.topMatch((String)"Letztlich");
            }
            case "gef\u00fchlsdusselig": {
                return SuggestedReplacement.topMatch((String)"gef\u00fchlsduselig");
            }
            case "gef\u00fchlsdusselige": {
                return SuggestedReplacement.topMatch((String)"gef\u00fchlsduselige");
            }
            case "gef\u00fchlsdusseliger": {
                return SuggestedReplacement.topMatch((String)"gef\u00fchlsduseliger");
            }
            case "gef\u00fchlsdusseliges": {
                return SuggestedReplacement.topMatch((String)"gef\u00fchlsduseliges");
            }
            case "gef\u00fchlsdusseligen": {
                return SuggestedReplacement.topMatch((String)"gef\u00fchlsduseligen");
            }
            case "gegebenfalls": {
                return SuggestedReplacement.topMatch((String)"gegebenenfalls");
            }
            case "Gegebenfalls": {
                return SuggestedReplacement.topMatch((String)"Gegebenenfalls");
            }
            case "zugebenerma\u00dfen": {
                return SuggestedReplacement.topMatch((String)"zugegebenerma\u00dfen");
            }
            case "beispielweise": {
                return SuggestedReplacement.topMatch((String)"beispielsweise");
            }
            case "pdf": {
                return SuggestedReplacement.topMatch((String)"PDF");
            }
            case "Pdf": {
                return SuggestedReplacement.topMatch((String)"PDF");
            }
            case "pdfs": {
                return SuggestedReplacement.topMatch((String)"PDFs");
            }
            case "Pdfs": {
                return SuggestedReplacement.topMatch((String)"PDFs");
            }
            case "gekriecht": {
                return SuggestedReplacement.topMatch((String)"gekrochen");
            }
            case "einzigst": {
                return SuggestedReplacement.topMatch((String)"einzig");
            }
            case "Einzigst": {
                return SuggestedReplacement.topMatch((String)"Einzig");
            }
            case "Eifelturm": {
                return SuggestedReplacement.topMatch((String)"Eiffelturm", (String)"Der Eiffelturm in Paris ist nach seinem Erbauer Gustave Eiffel benannt");
            }
            case "Eifelturms": {
                return SuggestedReplacement.topMatch((String)"Eiffelturms", (String)"Der Eiffelturm in Paris ist nach seinem Erbauer Gustave Eiffel benannt");
            }
            case "Eifelturmes": {
                return SuggestedReplacement.topMatch((String)"Eiffelturmes", (String)"Der Eiffelturm in Paris ist nach seinem Erbauer Gustave Eiffel benannt");
            }
            case "Jojo-Effekt": {
                return SuggestedReplacement.topMatch((String)"Jo-Jo-Effekt");
            }
            case "Jojo-Effekts": {
                return SuggestedReplacement.topMatch((String)"Jo-Jo-Effekts");
            }
            case "Enschuldigen": {
                return SuggestedReplacement.topMatch((String)"Entschuldigen");
            }
            case "Anschrifft": {
                return SuggestedReplacement.topMatch((String)"Anschrift");
            }
            case "vertrauenserweckend": {
                return SuggestedReplacement.topMatch((String)"vertrauenerweckend");
            }
            case "homepage": {
                return SuggestedReplacement.topMatch((String)"Homepage");
            }
            case "interesse": {
                return SuggestedReplacement.topMatch((String)"Interesse");
            }
            case "moglich": {
                return SuggestedReplacement.topMatch((String)"m\u00f6glich");
            }
            case "zusammenf\u00e4sst": {
                return SuggestedReplacement.topMatch((String)"zusammenfasst");
            }
            case "grosse": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfe");
            }
            case "grossen": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfen");
            }
            case "grosser": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfer");
            }
            case "grosses": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfes");
            }
            case "geniesse": {
                return SuggestedReplacement.topMatch((String)"genie\u00dfe");
            }
            case "geniessen": {
                return SuggestedReplacement.topMatch((String)"genie\u00dfen");
            }
            case "grossartig": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfartig");
            }
            case "grossz\u00fcgig": {
                return SuggestedReplacement.topMatch((String)"gro\u00dfz\u00fcgig");
            }
            case "moeglich": {
                return SuggestedReplacement.topMatch((String)"m\u00f6glich");
            }
            case "naturlich": {
                return SuggestedReplacement.topMatch((String)"nat\u00fcrlich");
            }
            case "natuerlich": {
                return SuggestedReplacement.topMatch((String)"nat\u00fcrlich");
            }
            case "unregelm\u00e4ssig": {
                return SuggestedReplacement.topMatch((String)"unregelm\u00e4\u00dfig");
            }
            case "unregelm\u00e4ssige": {
                return SuggestedReplacement.topMatch((String)"unregelm\u00e4\u00dfige");
            }
            case "unaktiv": {
                return SuggestedReplacement.topMatch((String)"inaktiv");
            }
            case "unaktive": {
                return SuggestedReplacement.topMatch((String)"inaktive");
            }
            case "unaktiver": {
                return SuggestedReplacement.topMatch((String)"inaktiver");
            }
            case "unaktives": {
                return SuggestedReplacement.topMatch((String)"inaktives");
            }
            case "unaktiven": {
                return SuggestedReplacement.topMatch((String)"inaktiven");
            }
            case "uneffektiv": {
                return SuggestedReplacement.topMatch((String)"ineffektiv");
            }
            case "uneffezient": {
                return SuggestedReplacement.topMatch((String)"ineffizient");
            }
            case "rechtstaatlich": {
                return SuggestedReplacement.topMatch((String)"rechtsstaatlich");
            }
            case "verh\u00e4ltnism\u00e4ssig": {
                return SuggestedReplacement.topMatch((String)"verh\u00e4ltnism\u00e4\u00dfig");
            }
            case "unverh\u00e4ltnism\u00e4ssig": {
                return SuggestedReplacement.topMatch((String)"unverh\u00e4ltnism\u00e4\u00dfig");
            }
            case "Hauptstrasse": {
                return SuggestedReplacement.topMatch((String)"Hauptstra\u00dfe");
            }
            case "Gespraech": {
                return SuggestedReplacement.topMatch((String)"Gespr\u00e4ch");
            }
            case "Gespraechs": {
                return SuggestedReplacement.topMatch((String)"Gespr\u00e4chs");
            }
            case "Aussenbereich": {
                return SuggestedReplacement.topMatch((String)"Au\u00dfenbereich");
            }
            case "Aussenbereichs": {
                return SuggestedReplacement.topMatch((String)"Au\u00dfenbereichs");
            }
            case "Portrait": {
                return SuggestedReplacement.topMatch((String)"Portr\u00e4t");
            }
            case "Portraits": {
                return SuggestedReplacement.topMatch((String)"Portr\u00e4ts");
            }
            case "weinachten": {
                return SuggestedReplacement.topMatch((String)"Weihnachten");
            }
            case "Weinachten": {
                return SuggestedReplacement.topMatch((String)"Weihnachten");
            }
            case "unterst\u00fczt": {
                return SuggestedReplacement.topMatch((String)"unterst\u00fctzt");
            }
            case "unters\u00fctzt": {
                return SuggestedReplacement.topMatch((String)"unterst\u00fctzt");
            }
            case "sontag": {
                return SuggestedReplacement.topMatch((String)"Sonntag");
            }
            case "nichtsagend": {
                return SuggestedReplacement.topMatch((String)"nichtssagend");
            }
            case "nichtsagende": {
                return SuggestedReplacement.topMatch((String)"nichtssagende");
            }
            case "nichtsagender": {
                return SuggestedReplacement.topMatch((String)"nichtssagender");
            }
            case "nichtsagendes": {
                return SuggestedReplacement.topMatch((String)"nichtssagendes");
            }
            case "nichtsagenden": {
                return SuggestedReplacement.topMatch((String)"nichtssagenden");
            }
            case "nichtsagendem": {
                return SuggestedReplacement.topMatch((String)"nichtssagendem");
            }
            case "nirgendswo": {
                return SuggestedReplacement.topMatch((String)"nirgendwo");
            }
            case "durchfuehren": {
                return SuggestedReplacement.topMatch((String)"durchf\u00fchren");
            }
            case "durchgefuehrt": {
                return SuggestedReplacement.topMatch((String)"durchgef\u00fchrt");
            }
            case "erh\u00e4lst": {
                return SuggestedReplacement.topMatch((String)"erh\u00e4ltst");
            }
            case "erh\u00e4hlst": {
                return SuggestedReplacement.topMatch((String)"erh\u00e4ltst");
            }
            case "Nirgendswo": {
                return SuggestedReplacement.topMatch((String)"Nirgendwo");
            }
            case "Typescript": {
                return SuggestedReplacement.topMatch((String)"TypeScript");
            }
            case "mitinbegriffen": {
                return SuggestedReplacement.topMatch((String)"mit inbegriffen");
            }
            case "miteinbegriffen": {
                return SuggestedReplacement.topMatch((String)"mit einbegriffen");
            }
            case "unterj\u00e4hrlich": {
                return SuggestedReplacement.topMatch((String)"unterj\u00e4hrig");
            }
            case "mehrj\u00e4hrlich": {
                return SuggestedReplacement.topMatch((String)"mehrj\u00e4hrig");
            }
            case "mehrj\u00e4hrliche": {
                return SuggestedReplacement.topMatch((String)"mehrj\u00e4hrige");
            }
            case "mehrj\u00e4hrlichen": {
                return SuggestedReplacement.topMatch((String)"mehrj\u00e4hrigen");
            }
            case "mehrj\u00e4hrlicher": {
                return SuggestedReplacement.topMatch((String)"mehrj\u00e4hriger");
            }
            case "mehrj\u00e4hrliches": {
                return SuggestedReplacement.topMatch((String)"mehrj\u00e4hriges");
            }
            case "genausogut": {
                return SuggestedReplacement.topMatch((String)"genauso gut");
            }
            case "Sylvester": {
                return SuggestedReplacement.topMatch((String)"Silvester");
            }
            case "Au\u00dferden": {
                return SuggestedReplacement.topMatch((String)"Au\u00dferdem");
            }
            case "ausserhalb": {
                return SuggestedReplacement.topMatch((String)"au\u00dferhalb");
            }
            case "Ausserhalb": {
                return SuggestedReplacement.topMatch((String)"Au\u00dferhalb");
            }
            case "Add-On": {
                return SuggestedReplacement.topMatch((String)"Add-on");
            }
            case "Add-Ons": {
                return SuggestedReplacement.topMatch((String)"Add-ons");
            }
            case "zweitenmal": {
                return SuggestedReplacement.topMatch((String)"zweiten Mal");
            }
            case "Zweitenmal": {
                return SuggestedReplacement.topMatch((String)"Zweiten Mal");
            }
            case "N\u00e4chstesmal": {
                return SuggestedReplacement.topMatch((String)"N\u00e4chstes Mal");
            }
            case "Walldorfschule": {
                return SuggestedReplacement.topMatch((String)"Waldorfschule");
            }
            case "Walldorfschulen": {
                return SuggestedReplacement.topMatch((String)"Waldorfschulen");
            }
            case "ertragsreich": {
                return SuggestedReplacement.topMatch((String)"ertragreich");
            }
            case "ertragsreiche": {
                return SuggestedReplacement.topMatch((String)"ertragreiche");
            }
            case "ertragsreiches": {
                return SuggestedReplacement.topMatch((String)"ertragreiches");
            }
            case "ertragsreichen": {
                return SuggestedReplacement.topMatch((String)"ertragreichen");
            }
            case "einzigste": {
                return SuggestedReplacement.topMatch((String)"einzige");
            }
            case "einzigstes": {
                return SuggestedReplacement.topMatch((String)"einziges");
            }
            case "einzigster": {
                return SuggestedReplacement.topMatch((String)"einziger");
            }
            case "einzigsten": {
                return SuggestedReplacement.topMatch((String)"einzigen");
            }
            case "einzigstem": {
                return SuggestedReplacement.topMatch((String)"einzigem");
            }
            case "Youngstar": {
                return SuggestedReplacement.topMatch((String)"Youngster");
            }
            case "Youngstars": {
                return SuggestedReplacement.topMatch((String)"Youngsters");
            }
            case "aussergew\u00f6hnlichen": {
                return SuggestedReplacement.topMatch((String)"au\u00dfergew\u00f6hnlichen");
            }
            case "aussergew\u00f6hnliche": {
                return SuggestedReplacement.topMatch((String)"au\u00dfergew\u00f6hnliche");
            }
            case "aussergew\u00f6hnlicher": {
                return SuggestedReplacement.topMatch((String)"au\u00dfergew\u00f6hnlicher");
            }
            case "aussergew\u00f6hnliches": {
                return SuggestedReplacement.topMatch((String)"au\u00dfergew\u00f6hnliches");
            }
            case "aussergew\u00f6hnlich": {
                return SuggestedReplacement.topMatch((String)"au\u00dfergew\u00f6hnlich");
            }
            case "Gluckwunsch": {
                return SuggestedReplacement.topMatch((String)"Gl\u00fcckwunsch");
            }
            case "Gluckwunsche": {
                return SuggestedReplacement.topMatch((String)"Gl\u00fcckw\u00fcnsche");
            }
            case "Gl\u00fcckwunsche": {
                return SuggestedReplacement.topMatch((String)"Gl\u00fcckw\u00fcnsche");
            }
            case "au\u00dferden": {
                return SuggestedReplacement.topMatch((String)"au\u00dferdem");
            }
            case "gleichermassen": {
                return SuggestedReplacement.topMatch((String)"gleicherma\u00dfen");
            }
            case "massgeblich": {
                return SuggestedReplacement.topMatch((String)"ma\u00dfgeblich");
            }
            case "tschuldige": {
                return SuggestedReplacement.topMatch((String)"entschuldige");
            }
            case "Tschuldigung": {
                return SuggestedReplacement.topMatch((String)"Entschuldigung");
            }
            case "Schuldigung": {
                return SuggestedReplacement.topMatch((String)"Entschuldigung");
            }
            case "Anteilname": {
                return SuggestedReplacement.topMatch((String)"Anteilnahme");
            }
            case "Mahnungswesen": {
                return SuggestedReplacement.topMatch((String)"Mahnwesen");
            }
            case "Mahnungswesens": {
                return SuggestedReplacement.topMatch((String)"Mahnwesens");
            }
            case "Geruchsinn": {
                return SuggestedReplacement.topMatch((String)"Geruchssinn");
            }
            case "Geruchsinns": {
                return SuggestedReplacement.topMatch((String)"Geruchssinns");
            }
            case "Optin": {
                return SuggestedReplacement.topMatch((String)"Opt-in");
            }
            case "Stk": {
                return SuggestedReplacement.topMatch((String)"Stk.");
            }
            case "T-shirt": {
                return SuggestedReplacement.topMatch((String)"T-Shirt");
            }
            case "t-shirt": {
                return SuggestedReplacement.topMatch((String)"T-Shirt");
            }
            case "T-shirts": {
                return SuggestedReplacement.topMatch((String)"T-Shirts");
            }
            case "t-shirts": {
                return SuggestedReplacement.topMatch((String)"T-Shirts");
            }
            case "umgangsprachlich": {
                return SuggestedReplacement.topMatch((String)"umgangssprachlich");
            }
            case "E-Mai": {
                return SuggestedReplacement.topMatch((String)"E-Mail");
            }
            case "E-Mais": {
                return SuggestedReplacement.topMatch((String)"E-Mails");
            }
            case "Gelantine": {
                return SuggestedReplacement.topMatch((String)"Gelatine");
            }
            case "angehangenen": {
                return SuggestedReplacement.topMatch((String)"angeh\u00e4ngten");
            }
            case "ausmahlen": {
                return SuggestedReplacement.topMatch((String)"ausmalen");
            }
            case "ausgemahlt": {
                return SuggestedReplacement.topMatch((String)"ausgemalt");
            }
            case "weisst": {
                return SuggestedReplacement.topMatch((String)"wei\u00dft");
            }
            case "Weisst": {
                return SuggestedReplacement.topMatch((String)"Wei\u00dft");
            }
            case "Rehgipsplatte": {
                return SuggestedReplacement.topMatch((String)"Rigipsplatte");
            }
            case "Rehgipsplatten": {
                return SuggestedReplacement.topMatch((String)"Rigipsplatten");
            }
            case "Rehgips-Platte": {
                return SuggestedReplacement.topMatch((String)"Rigips-Platte");
            }
            case "Rehgips-Platten": {
                return SuggestedReplacement.topMatch((String)"Rigips-Platten");
            }
            case "Rehgips": {
                return SuggestedReplacement.topMatch((String)"Rigips");
            }
            case "rundumerneuert": {
                return SuggestedReplacement.topMatch((String)"runderneuert");
            }
            case "rundumerneuerte": {
                return SuggestedReplacement.topMatch((String)"runderneuerte");
            }
            case "rundumerneuertes": {
                return SuggestedReplacement.topMatch((String)"runderneuertes");
            }
            case "rundumerneuerter": {
                return SuggestedReplacement.topMatch((String)"runderneuerter");
            }
            case "rundumerneuerten": {
                return SuggestedReplacement.topMatch((String)"runderneuerten");
            }
            case "rundumerneuertem": {
                return SuggestedReplacement.topMatch((String)"runderneuertem");
            }
            case "Davidswache": {
                return SuggestedReplacement.topMatch((String)"Davidwache");
            }
            case "Pinwand": {
                return SuggestedReplacement.topMatch((String)"Pinnwand");
            }
            case "Kreisaal": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfsaal");
            }
            case "Kreisaals": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfsaals");
            }
            case "Kreissaal": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfsaal");
            }
            case "Kreiss\u00e4le": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfs\u00e4le");
            }
            case "Kreiss\u00e4len": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfs\u00e4len");
            }
            case "Kreissaals": {
                return SuggestedReplacement.topMatch((String)"Krei\u00dfsaals");
            }
            case "Laola-Welle": {
                return SuggestedReplacement.topMatch((String)"La-Ola-Welle");
            }
            case "Laola-Wellen": {
                return SuggestedReplacement.topMatch((String)"La-Ola-Wellen");
            }
            case "BayArea": {
                return SuggestedReplacement.topMatch((String)"Bay Area");
            }
            case "kontaktfreundlich": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudig");
            }
            case "kontaktfreundliche": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudige");
            }
            case "kontaktfreundlicher": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudiger");
            }
            case "kontaktfreundliches": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudiges");
            }
            case "kontaktfreundlichen": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudigen");
            }
            case "kontaktfreundlichem": {
                return SuggestedReplacement.topMatch((String)"kontaktfreudigem");
            }
            case "Wirtschaftsingenieurswesen": {
                return SuggestedReplacement.topMatch((String)"Wirtschaftsingenieurwesen");
            }
            case "Wirtschaftsingenieurswesens": {
                return SuggestedReplacement.topMatch((String)"Wirtschaftsingenieurwesens");
            }
            case "wiederspiegeln": {
                return SuggestedReplacement.topMatch((String)"widerspiegeln");
            }
            case "wiederspiegelt": {
                return SuggestedReplacement.topMatch((String)"widerspiegelt");
            }
            case "wiederspiegelst": {
                return SuggestedReplacement.topMatch((String)"widerspiegelst");
            }
            case "wiedergespiegelt": {
                return SuggestedReplacement.topMatch((String)"widergespiegelt");
            }
            case "Wiederhall": {
                return SuggestedReplacement.topMatch((String)"Widerhall");
            }
            case "Wiederhalls": {
                return SuggestedReplacement.topMatch((String)"Widerhalls");
            }
            case "Ebensowenig": {
                return SuggestedReplacement.topMatch((String)"Ebenso wenig");
            }
            case "Ebensooft": {
                return SuggestedReplacement.topMatch((String)"Ebenso oft");
            }
            case "ebensooft": {
                return SuggestedReplacement.topMatch((String)"ebenso oft");
            }
            case "Ebensogut": {
                return SuggestedReplacement.topMatch((String)"Ebenso gut");
            }
            case "ebensogut": {
                return SuggestedReplacement.topMatch((String)"ebenso gut");
            }
            case "Ebensoleicht": {
                return SuggestedReplacement.topMatch((String)"Ebenso leicht");
            }
            case "ebensoleicht": {
                return SuggestedReplacement.topMatch((String)"ebenso leicht");
            }
            case "eigendlich": {
                return SuggestedReplacement.topMatch((String)"eigentlich");
            }
            case "eigendliche": {
                return SuggestedReplacement.topMatch((String)"eigentliche");
            }
            case "eigendlicher": {
                return SuggestedReplacement.topMatch((String)"eigentlicher");
            }
            case "eigendliches": {
                return SuggestedReplacement.topMatch((String)"eigentliches");
            }
            case "eigendlichen": {
                return SuggestedReplacement.topMatch((String)"eigentlichen");
            }
            case "eigendlichem": {
                return SuggestedReplacement.topMatch((String)"eigentlichem");
            }
            case "r\u00fcberst\u00fclpen": {
                return SuggestedReplacement.topMatch((String)"\u00fcberst\u00fclpen");
            }
            case "r\u00fcberst\u00fclpe": {
                return SuggestedReplacement.topMatch((String)"\u00fcberst\u00fclpe");
            }
            case "r\u00fcbergest\u00fclpt": {
                return SuggestedReplacement.topMatch((String)"\u00fcbergest\u00fclpt");
            }
            case "Websiten": {
                return SuggestedReplacement.topMatch((String)"Webseiten");
            }
            case "freiverf\u00fcgbar": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbar");
            }
            case "freiverf\u00fcgbare": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbare");
            }
            case "freiverf\u00fcgbares": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbares");
            }
            case "freiverf\u00fcgbarer": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbarer");
            }
            case "freiverf\u00fcgbaren": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbaren");
            }
            case "freiverf\u00fcgbarem": {
                return SuggestedReplacement.topMatch((String)"frei verf\u00fcgbarem");
            }
            case "freiverk\u00e4uflich": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4uflich");
            }
            case "freiverk\u00e4ufliche": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4ufliche");
            }
            case "freiverk\u00e4ufliches": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4ufliches");
            }
            case "freiverk\u00e4uflicher": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4uflicher");
            }
            case "freiverk\u00e4uflichen": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4uflichen");
            }
            case "freiverk\u00e4uflichem": {
                return SuggestedReplacement.topMatch((String)"frei verk\u00e4uflichem");
            }
            case "Mfg": {
                return SuggestedReplacement.topMatch((String)"MfG");
            }
            case "Gefahrenstoffe": {
                return SuggestedReplacement.topMatch((String)"Gefahrstoffe");
            }
            case "Gefahrenstoffen": {
                return SuggestedReplacement.topMatch((String)"Gefahrstoffen");
            }
            case "Resource": {
                return SuggestedReplacement.topMatch((String)"Ressource");
            }
            case "Resourcen": {
                return SuggestedReplacement.topMatch((String)"Ressourcen");
            }
            case "Resources": {
                return SuggestedReplacement.topMatch((String)"Ressourcen");
            }
            case "Tzatziki": {
                return SuggestedReplacement.topMatch((String)"Zaziki");
            }
            case "Selenski": {
                return SuggestedReplacement.topMatch((String)"Selenskyj");
            }
            case "armzurechnen": {
                return SuggestedReplacement.topMatch((String)"arm zu rechnen");
            }
            case "armrechne": {
                return SuggestedReplacement.topMatch((String)"arm rechne");
            }
            case "armrechnest": {
                return SuggestedReplacement.topMatch((String)"arm rechnest");
            }
            case "armrechnet": {
                return SuggestedReplacement.topMatch((String)"arm rechnet");
            }
            case "armrechnen": {
                return SuggestedReplacement.topMatch((String)"arm rechnen");
            }
            case "armgerechnet": {
                return SuggestedReplacement.topMatch((String)"arm gerechnet");
            }
            case "ernstnimmst": {
                return SuggestedReplacement.topMatch((String)"ernst nimmst");
            }
            case "ernstnimmt": {
                return SuggestedReplacement.topMatch((String)"ernst nimmt");
            }
            case "ernstnehme": {
                return SuggestedReplacement.topMatch((String)"ernst nehme");
            }
            case "ernstnehmen": {
                return SuggestedReplacement.topMatch((String)"ernst nehmen");
            }
            case "ernstzunehmen": {
                return SuggestedReplacement.topMatch((String)"ernst zu nehmen");
            }
            case "ernstgenommen": {
                return SuggestedReplacement.topMatch((String)"ernst genommen");
            }
            case "ernstmeinst": {
                return SuggestedReplacement.topMatch((String)"ernst meinst");
            }
            case "ernstmeine": {
                return SuggestedReplacement.topMatch((String)"ernst meine");
            }
            case "ernstmeinte": {
                return SuggestedReplacement.topMatch((String)"ernst meinte");
            }
            case "ernstmeinen": {
                return SuggestedReplacement.topMatch((String)"ernst meinen");
            }
            case "ernstzumeinen": {
                return SuggestedReplacement.topMatch((String)"ernst zu meinen");
            }
            case "ernstgemeinet": {
                return SuggestedReplacement.topMatch((String)"ernst gemeint");
            }
            case "fertigschreiben": {
                return SuggestedReplacement.topMatch((String)"fertig schreiben");
            }
            case "fertigzuschreiben": {
                return SuggestedReplacement.topMatch((String)"fertig zu schreiben");
            }
            case "fertiggeschrieben": {
                return SuggestedReplacement.topMatch((String)"fertig geschrieben");
            }
            case "fertigschreibt": {
                return SuggestedReplacement.topMatch((String)"fertig schreibt");
            }
            case "freigedacht": {
                return SuggestedReplacement.topMatch((String)"frei gedacht");
            }
            case "freidenken": {
                return SuggestedReplacement.topMatch((String)"frei denken");
            }
            case "freizudenken": {
                return SuggestedReplacement.topMatch((String)"frei zu denken");
            }
            case "freiliegen": {
                return SuggestedReplacement.topMatch((String)"frei liegen");
            }
            case "freischreiben": {
                return SuggestedReplacement.topMatch((String)"frei schreiben");
            }
            case "freizuschreiben": {
                return SuggestedReplacement.topMatch((String)"frei zu schreiben");
            }
            case "freigeschrieben": {
                return SuggestedReplacement.topMatch((String)"frei geschrieben");
            }
            case "freischlagen": {
                return SuggestedReplacement.topMatch((String)"frei schlagen");
            }
            case "freizuschlagen": {
                return SuggestedReplacement.topMatch((String)"frei zu schlagen");
            }
            case "freigeschlagen": {
                return SuggestedReplacement.topMatch((String)"frei geschlagen");
            }
            case "geheimhalten": {
                return SuggestedReplacement.topMatch((String)"geheim halten");
            }
            case "geheimhaltet": {
                return SuggestedReplacement.topMatch((String)"geheim haltet");
            }
            case "geheimzuhalten": {
                return SuggestedReplacement.topMatch((String)"geheim zu halten");
            }
            case "geheimgehalten": {
                return SuggestedReplacement.topMatch((String)"geheim gehalten");
            }
            case "geheimh\u00e4ltst": {
                return SuggestedReplacement.topMatch((String)"geheim h\u00e4ltst");
            }
            case "gleichlauten": {
                return SuggestedReplacement.topMatch((String)"gleich lauten");
            }
            case "gutd\u00fcnken": {
                return SuggestedReplacement.topMatch((String)"Gutd\u00fcnken");
            }
            case "langfahren": {
                return SuggestedReplacement.topMatch((String)"entlangfahren");
            }
            case "langfuhren": {
                return SuggestedReplacement.topMatch((String)"entlangfuhren");
            }
            case "langzufahren": {
                return SuggestedReplacement.topMatch((String)"entlangzufahren");
            }
            case "langfahre": {
                return SuggestedReplacement.topMatch((String)"entlangfahre");
            }
            case "langf\u00e4hrst": {
                return SuggestedReplacement.topMatch((String)"entlangf\u00e4hrst");
            }
            case "langgefahren": {
                return SuggestedReplacement.topMatch((String)"entlanggefahren");
            }
            case "langlaufen": {
                return SuggestedReplacement.topMatch((String)"entlanglaufen");
            }
            case "langliefen": {
                return SuggestedReplacement.topMatch((String)"entlangliefen");
            }
            case "langzulaufen": {
                return SuggestedReplacement.topMatch((String)"entlangzulaufen");
            }
            case "langlaufe": {
                return SuggestedReplacement.topMatch((String)"entlanglaufe");
            }
            case "langl\u00e4ufst": {
                return SuggestedReplacement.topMatch((String)"entlangl\u00e4ufst");
            }
            case "langgelaufen": {
                return SuggestedReplacement.topMatch((String)"entlanggelaufen");
            }
            case "langgehen": {
                return SuggestedReplacement.topMatch((String)"entlanggehen");
            }
            case "langgingen": {
                return SuggestedReplacement.topMatch((String)"entlanggingen");
            }
            case "langzugehen": {
                return SuggestedReplacement.topMatch((String)"entlangzugehen");
            }
            case "langgehe": {
                return SuggestedReplacement.topMatch((String)"entlanggehe");
            }
            case "langging": {
                return SuggestedReplacement.topMatch((String)"entlangging");
            }
            case "langgegangen": {
                return SuggestedReplacement.topMatch((String)"entlanggegangen");
            }
            case "lustigmachen": {
                return SuggestedReplacement.topMatch((String)"lustig machen");
            }
            case "lustigmache": {
                return SuggestedReplacement.topMatch((String)"lustig mache");
            }
            case "lustigmachst": {
                return SuggestedReplacement.topMatch((String)"lustig machst");
            }
            case "lustigmachten": {
                return SuggestedReplacement.topMatch((String)"lustig machten");
            }
            case "lustigzumachen": {
                return SuggestedReplacement.topMatch((String)"lustig zu machen");
            }
            case "lustiggemacht": {
                return SuggestedReplacement.topMatch((String)"lustig gemacht");
            }
            case "niederschlagreich": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreich");
            }
            case "niederschlagreiche": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreiche");
            }
            case "niederschlagreicher": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreicher");
            }
            case "niederschlagreiches": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreiches");
            }
            case "niederschlagreichem": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreichem");
            }
            case "niederschlagreichen": {
                return SuggestedReplacement.topMatch((String)"niederschlagsreichen");
            }
            case "rechtgeben": {
                return SuggestedReplacement.topMatch((String)"recht geben");
            }
            case "rechtzugeben": {
                return SuggestedReplacement.topMatch((String)"recht zu geben");
            }
            case "rechtgegeben": {
                return SuggestedReplacement.topMatch((String)"recht gegeben");
            }
            case "rechtgibst": {
                return SuggestedReplacement.topMatch((String)"recht gibst");
            }
            case "rechtgibt": {
                return SuggestedReplacement.topMatch((String)"recht gibt");
            }
            case "rechtgab": {
                return SuggestedReplacement.topMatch((String)"recht gab");
            }
            case "rechthaben": {
                return SuggestedReplacement.topMatch((String)"recht haben");
            }
            case "rechthabe": {
                return SuggestedReplacement.topMatch((String)"recht habe");
            }
            case "rechtzuhaben": {
                return SuggestedReplacement.topMatch((String)"recht zu haben");
            }
            case "rechtgehabt": {
                return SuggestedReplacement.topMatch((String)"recht gehabt");
            }
            case "rechthatte": {
                return SuggestedReplacement.topMatch((String)"recht hatte");
            }
            case "rechthast": {
                return SuggestedReplacement.topMatch((String)"recht hast");
            }
            case "rechthabt": {
                return SuggestedReplacement.topMatch((String)"recht habt");
            }
            case "rechtmachen": {
                return SuggestedReplacement.topMatch((String)"recht machen");
            }
            case "rechtzumachen": {
                return SuggestedReplacement.topMatch((String)"recht zu machen");
            }
            case "rechtgemacht": {
                return SuggestedReplacement.topMatch((String)"recht gemacht");
            }
            case "rechtmacht": {
                return SuggestedReplacement.topMatch((String)"recht macht");
            }
            case "rechtmache": {
                return SuggestedReplacement.topMatch((String)"recht mache");
            }
            case "rechtmachte": {
                return SuggestedReplacement.topMatch((String)"recht machte");
            }
            case "rechtmachten": {
                return SuggestedReplacement.topMatch((String)"recht machten");
            }
            case "rechtmachst": {
                return SuggestedReplacement.topMatch((String)"recht machst");
            }
            case "taubstellen": {
                return SuggestedReplacement.topMatch((String)"taub stellen");
            }
            case "taubzustellen": {
                return SuggestedReplacement.topMatch((String)"taub zu stellen");
            }
            case "taubgestellt": {
                return SuggestedReplacement.topMatch((String)"taub gestellt");
            }
            case "taubstelle": {
                return SuggestedReplacement.topMatch((String)"taub stelle");
            }
            case "taubstellt": {
                return SuggestedReplacement.topMatch((String)"taub stellt");
            }
            case "taubstellst": {
                return SuggestedReplacement.topMatch((String)"taub stellst");
            }
            case "wachgeblieben": {
                return SuggestedReplacement.topMatch((String)"wach geblieben");
            }
            case "wachbleiben": {
                return SuggestedReplacement.topMatch((String)"wach bleiben");
            }
            case "wachbleibe": {
                return SuggestedReplacement.topMatch((String)"wach bleibe");
            }
            case "wachzubleiben": {
                return SuggestedReplacement.topMatch((String)"wach zu bleiben");
            }
            case "wachbleibst": {
                return SuggestedReplacement.topMatch((String)"wach bleibst");
            }
            case "wachblieb": {
                return SuggestedReplacement.topMatch((String)"wach blieb");
            }
            case "wachblieben": {
                return SuggestedReplacement.topMatch((String)"wach blieben");
            }
            case "ewiggleich": {
                return SuggestedReplacement.topMatch((String)"ewig gleich");
            }
            case "ewiggleiche": {
                return SuggestedReplacement.topMatch((String)"ewig gleiche");
            }
            case "ewiggleicher": {
                return SuggestedReplacement.topMatch((String)"ewig gleicher");
            }
            case "ewiggleiches": {
                return SuggestedReplacement.topMatch((String)"ewig gleiches");
            }
            case "ewiggleichem": {
                return SuggestedReplacement.topMatch((String)"ewig gleichem");
            }
            case "ewiggleichen": {
                return SuggestedReplacement.topMatch((String)"ewig gleichen");
            }
            case "sattessen": {
                return SuggestedReplacement.topMatch((String)"satt essen");
            }
            case "gem\u00e4ss": {
                return SuggestedReplacement.topMatch((String)"gem\u00e4\u00df");
            }
            case "upgedated": {
                return SuggestedReplacement.topMatch((String)"upgedatet");
            }
            case "E.On": {
                return SuggestedReplacement.topMatch((String)"E.ON");
            }
            case "E.on": {
                return SuggestedReplacement.topMatch((String)"E.ON");
            }
            case "Juergen": {
                return SuggestedReplacement.topMatch((String)"J\u00fcrgen");
            }
            case "deligieren": {
                return SuggestedReplacement.topMatch((String)"delegieren");
            }
            case "deligiert": {
                return SuggestedReplacement.topMatch((String)"delegiert");
            }
            case "telephonisch": {
                return SuggestedReplacement.topMatch((String)"telefonisch");
            }
            case "telephonische": {
                return SuggestedReplacement.topMatch((String)"telefonische");
            }
            case "telephonischen": {
                return SuggestedReplacement.topMatch((String)"telefonischen");
            }
            case "telephonischem": {
                return SuggestedReplacement.topMatch((String)"telefonischem");
            }
            case "telephonischer": {
                return SuggestedReplacement.topMatch((String)"telefonischer");
            }
            case "telephonisches": {
                return SuggestedReplacement.topMatch((String)"telefonisches");
            }
            case "beindruckend": {
                return SuggestedReplacement.topMatch((String)"beeindruckend");
            }
            case "beindruckende": {
                return SuggestedReplacement.topMatch((String)"beeindruckende");
            }
            case "beindruckender": {
                return SuggestedReplacement.topMatch((String)"beeindruckender");
            }
            case "beindruckendes": {
                return SuggestedReplacement.topMatch((String)"beeindruckendes");
            }
            case "beindruckenden": {
                return SuggestedReplacement.topMatch((String)"beeindruckenden");
            }
            case "beindruckendem": {
                return SuggestedReplacement.topMatch((String)"beeindruckendem");
            }
            case "beindruckt": {
                return SuggestedReplacement.topMatch((String)"beeindruckt");
            }
            case "beindruckte": {
                return SuggestedReplacement.topMatch((String)"beeindruckte");
            }
            case "heilsbringend": {
                return SuggestedReplacement.topMatch((String)"heilbringend");
            }
            case "heilsbringende": {
                return SuggestedReplacement.topMatch((String)"heilbringende");
            }
            case "heilsbringenden": {
                return SuggestedReplacement.topMatch((String)"heilbringenden");
            }
            case "heilsbringendem": {
                return SuggestedReplacement.topMatch((String)"heilbringendem");
            }
            case "heilsbringender": {
                return SuggestedReplacement.topMatch((String)"heilbringender");
            }
            case "heilsbringendes": {
                return SuggestedReplacement.topMatch((String)"heilbringendes");
            }
            case "vielfaltig": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltig");
            }
            case "vielfaltige": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltige");
            }
            case "vielfaltiger": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltiger");
            }
            case "vielfaltiges": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltiges");
            }
            case "vielfaltigen": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltigen");
            }
            case "vielfaltigem": {
                return SuggestedReplacement.topMatch((String)"vielf\u00e4ltigem");
            }
            case "barfuss": {
                return SuggestedReplacement.topMatch((String)"barfu\u00df");
            }
            case "nord-s\u00fcdlich": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdlich");
            }
            case "nord-s\u00fcdliche": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdliche");
            }
            case "nord-s\u00fcdlicher": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdlicher");
            }
            case "nord-s\u00fcdliches": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdliches");
            }
            case "nord-s\u00fcdlichen": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdlichen");
            }
            case "nord-s\u00fcdlichem": {
                return SuggestedReplacement.topMatch((String)"nords\u00fcdlichem");
            }
            case "nord-\u00f6stlich": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stlich");
            }
            case "nord-\u00f6stliche": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stliche");
            }
            case "nord-\u00f6stlicher": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stlicher");
            }
            case "nord-\u00f6stliches": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stliches");
            }
            case "nord-\u00f6stlichen": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stlichen");
            }
            case "nord-\u00f6stlichem": {
                return SuggestedReplacement.topMatch((String)"nord\u00f6stlichem");
            }
            case "nord-westlich": {
                return SuggestedReplacement.topMatch((String)"nordwestlich");
            }
            case "nord-westliche": {
                return SuggestedReplacement.topMatch((String)"nordwestliche");
            }
            case "nord-westlicher": {
                return SuggestedReplacement.topMatch((String)"nordwestlicher");
            }
            case "nord-westliches": {
                return SuggestedReplacement.topMatch((String)"nordwestliches");
            }
            case "nord-westlichen": {
                return SuggestedReplacement.topMatch((String)"nordwestlichen");
            }
            case "nord-westlichem": {
                return SuggestedReplacement.topMatch((String)"nordwestlichem");
            }
            case "s\u00fcd-westlich": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestlich");
            }
            case "s\u00fcd-westliche": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestliche");
            }
            case "s\u00fcd-westlicher": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestlicher");
            }
            case "s\u00fcd-westliches": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestliches");
            }
            case "s\u00fcd-westlichen": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestlichen");
            }
            case "s\u00fcd-westlichem": {
                return SuggestedReplacement.topMatch((String)"s\u00fcdwestlichem");
            }
            case "s\u00fcd-\u00f6stlich": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stlich");
            }
            case "s\u00fcd-\u00f6stliche": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stliche");
            }
            case "s\u00fcd-\u00f6stlicher": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stlicher");
            }
            case "s\u00fcd-\u00f6stliches": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stliches");
            }
            case "s\u00fcd-\u00f6stlichen": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stlichen");
            }
            case "s\u00fcd-\u00f6stlichem": {
                return SuggestedReplacement.topMatch((String)"s\u00fcd\u00f6stlichem");
            }
            case "ost-westlich": {
                return SuggestedReplacement.topMatch((String)"ostwestlich");
            }
            case "ost-westliche": {
                return SuggestedReplacement.topMatch((String)"ostwestliche");
            }
            case "ost-westlicher": {
                return SuggestedReplacement.topMatch((String)"ostwestlicher");
            }
            case "ost-westliches": {
                return SuggestedReplacement.topMatch((String)"ostwestliches");
            }
            case "ost-westlichen": {
                return SuggestedReplacement.topMatch((String)"ostwestlichen");
            }
            case "ost-westlichem": {
                return SuggestedReplacement.topMatch((String)"ostwestlichem");
            }
            case "afro-amerikanisch": {
                return SuggestedReplacement.topMatch((String)"afroamerikanisch");
            }
            case "afro-amerikanische": {
                return SuggestedReplacement.topMatch((String)"afroamerikanische");
            }
            case "afro-amerikanischer": {
                return SuggestedReplacement.topMatch((String)"afroamerikanischer");
            }
            case "afro-amerikanisches": {
                return SuggestedReplacement.topMatch((String)"afroamerikanisches");
            }
            case "afro-amerikanischen": {
                return SuggestedReplacement.topMatch((String)"afroamerikanischen");
            }
            case "afro-amerikanischem": {
                return SuggestedReplacement.topMatch((String)"afroamerikanischem");
            }
            case "tatsachlich": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chlich");
            }
            case "tatsachliche": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chliche");
            }
            case "tatsachlicher": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chlicher");
            }
            case "tatsachliches": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chliches");
            }
            case "tatsachlichen": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chlichen");
            }
            case "tatsachlichem": {
                return SuggestedReplacement.topMatch((String)"tats\u00e4chlichem");
            }
            case "ungelungen": {
                return SuggestedReplacement.topMatch((String)"misslungen");
            }
            case "ungelungene": {
                return SuggestedReplacement.topMatch((String)"misslungene");
            }
            case "ungelungener": {
                return SuggestedReplacement.topMatch((String)"misslungener");
            }
            case "ungelungenes": {
                return SuggestedReplacement.topMatch((String)"misslungenes");
            }
            case "ungelungenen": {
                return SuggestedReplacement.topMatch((String)"misslungenen");
            }
            case "ungelungenem": {
                return SuggestedReplacement.topMatch((String)"misslungenem");
            }
            case "totkrank": {
                return SuggestedReplacement.topMatch((String)"todkrank");
            }
            case "totkranke": {
                return SuggestedReplacement.topMatch((String)"todkranke");
            }
            case "totkranker": {
                return SuggestedReplacement.topMatch((String)"todkranker");
            }
            case "totkrankes": {
                return SuggestedReplacement.topMatch((String)"todkrankes");
            }
            case "totkranken": {
                return SuggestedReplacement.topMatch((String)"todkranken");
            }
            case "totkrankem": {
                return SuggestedReplacement.topMatch((String)"todkrankem");
            }
            case "SnapChat": {
                return SuggestedReplacement.topMatch((String)"Snapchat");
            }
            case "SnapChats": {
                return SuggestedReplacement.topMatch((String)"Snapchats");
            }
            case "jmd": {
                return SuggestedReplacement.topMatch((String)"jmd.");
            }
            case "Sparringpartner": {
                return SuggestedReplacement.topMatch((String)"Sparringspartner");
            }
            case "Sparringpartners": {
                return SuggestedReplacement.topMatch((String)"Sparringspartners");
            }
            case "Sparringpartnern": {
                return SuggestedReplacement.topMatch((String)"Sparringspartnern");
            }
            case "ausserordentlich": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentlich");
            }
            case "ausserordentliche": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentliche");
            }
            case "ausserordentlichen": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentlichen");
            }
            case "ausserordentlichem": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentlichem");
            }
            case "ausserordentlicher": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentlicher");
            }
            case "ausserordentliches": {
                return SuggestedReplacement.topMatch((String)"au\u00dferordentliches");
            }
            case "unzippen": {
                return SuggestedReplacement.topMatch((String)"entzippen");
            }
            case "unzippt": {
                return SuggestedReplacement.topMatch((String)"entzippt");
            }
            case "unzippst": {
                return SuggestedReplacement.topMatch((String)"entzippst");
            }
            case "unzippe": {
                return SuggestedReplacement.topMatch((String)"entzippe");
            }
            case "Moet": {
                return SuggestedReplacement.topMatch((String)"Mo\u00ebt");
            }
            case "Prigozhin": {
                return SuggestedReplacement.topMatch((String)"Prigoschin");
            }
            case "Prigozhins": {
                return SuggestedReplacement.topMatch((String)"Prigoschins");
            }
            case "unhilfreich": {
                return SuggestedReplacement.topMatch((String)"unbehilflich");
            }
            case "gestriffen": {
                return SuggestedReplacement.topMatch((String)"gestreift");
            }
            case "dererseits": {
                return SuggestedReplacement.topMatch((String)"ihrerseits");
            }
            case "Regattas": {
                return SuggestedReplacement.topMatch((String)"Regatten");
            }
            case "Segelregattas": {
                return SuggestedReplacement.topMatch((String)"Segelregatten");
            }
            case "Brics-Staat": {
                return SuggestedReplacement.topMatch((String)"BRICS-Staat");
            }
            case "Brics-Staats": {
                return SuggestedReplacement.topMatch((String)"BRICS-Staats");
            }
            case "Brics-Staaten": {
                return SuggestedReplacement.topMatch((String)"BRICS-Staaten");
            }
            case "Rene": {
                return SuggestedReplacement.topMatch((String)"Ren\u00e9");
            }
            case "Renes": {
                return SuggestedReplacement.topMatch((String)"Ren\u00e9s");
            }
            case "einigermassen": {
                return SuggestedReplacement.topMatch((String)"einigerma\u00dfen");
            }
            case "Eurocup": {
                return SuggestedReplacement.topMatch((String)"EuroCup");
            }
            case "Eurocups": {
                return SuggestedReplacement.topMatch((String)"EuroCups");
            }
            case "etc": {
                return SuggestedReplacement.topMatch((String)"etc.");
            }
            case "Ressorthotel": {
                return SuggestedReplacement.topMatch((String)"Resorthotel");
            }
            case "Ressorthotels": {
                return SuggestedReplacement.topMatch((String)"Resorthotels");
            }
            case "Kleidungst\u00fcck": {
                return SuggestedReplacement.topMatch((String)"Kleidungsst\u00fcck");
            }
            case "Kleidungst\u00fccks": {
                return SuggestedReplacement.topMatch((String)"Kleidungsst\u00fccks");
            }
            case "Kleidungst\u00fcckes": {
                return SuggestedReplacement.topMatch((String)"Kleidungsst\u00fcckes");
            }
            case "Kleidungst\u00fccke": {
                return SuggestedReplacement.topMatch((String)"Kleidungsst\u00fccke");
            }
            case "Kleidungst\u00fccken": {
                return SuggestedReplacement.topMatch((String)"Kleidungsst\u00fccken");
            }
            case "unrentierlich": {
                return SuggestedReplacement.topMatch((String)"unrentabel");
            }
            case "unrentierliche": {
                return SuggestedReplacement.topMatch((String)"unrentable");
            }
            case "unrentierlicher": {
                return SuggestedReplacement.topMatch((String)"unrentabler");
            }
            case "unrentierliches": {
                return SuggestedReplacement.topMatch((String)"unrentables");
            }
            case "unrentierlichen": {
                return SuggestedReplacement.topMatch((String)"unrentablen");
            }
            case "unrentierlichem": {
                return SuggestedReplacement.topMatch((String)"unrentablem");
            }
            case "Hinterweltlerin": {
                return SuggestedReplacement.topMatch((String)"Hinterw\u00e4ldlerin");
            }
            case "Hinterweltlerinnen": {
                return SuggestedReplacement.topMatch((String)"Hinterw\u00e4ldlerinnen");
            }
            case "Hinterweltler": {
                return SuggestedReplacement.topMatch((String)"Hinterw\u00e4ldler");
            }
            case "Hinterweltlers": {
                return SuggestedReplacement.topMatch((String)"Hinterw\u00e4ldlers");
            }
            case "Hinterweltlern": {
                return SuggestedReplacement.topMatch((String)"Hinterw\u00e4ldlern");
            }
            case "erstrecht": {
                return SuggestedReplacement.topMatch((String)"erst recht");
            }
            case "klangheimlich": {
                return SuggestedReplacement.topMatch((String)"klammheimlich");
            }
            case "klangheimliche": {
                return SuggestedReplacement.topMatch((String)"klammheimliche");
            }
            case "klangheimlicher": {
                return SuggestedReplacement.topMatch((String)"klammheimlicher");
            }
            case "klangheimliches": {
                return SuggestedReplacement.topMatch((String)"klammheimliches");
            }
            case "klangheimlichen": {
                return SuggestedReplacement.topMatch((String)"klammheimlichen");
            }
            case "klangheimlichem": {
                return SuggestedReplacement.topMatch((String)"klammheimlichem");
            }
            case "raufklicken": {
                return SuggestedReplacement.topMatch((String)"draufklicken");
            }
            case "raufzuklicken": {
                return SuggestedReplacement.topMatch((String)"draufzuklicken");
            }
            case "raufgeklickt": {
                return SuggestedReplacement.topMatch((String)"draufgeklickt");
            }
            case "raufklicke": {
                return SuggestedReplacement.topMatch((String)"draufklicke");
            }
            case "raufklickst": {
                return SuggestedReplacement.topMatch((String)"draufklickst");
            }
            case "Aquaplanning": {
                return SuggestedReplacement.topMatch((String)"Aquaplaning");
            }
            case "Aquaplannings": {
                return SuggestedReplacement.topMatch((String)"Aquaplanings");
            }
            case "Kibbutz": {
                return SuggestedReplacement.topMatch((String)"Kibbuz");
            }
            case "Prozentteil": {
                return SuggestedReplacement.topMatch((String)"Prozentanteil");
            }
            case "Strebergarten": {
                return SuggestedReplacement.topMatch((String)"Schrebergarten");
            }
            case "Strebergartens": {
                return SuggestedReplacement.topMatch((String)"Schrebergartens");
            }
            case "Streberg\u00e4rten": {
                return SuggestedReplacement.topMatch((String)"Schreberg\u00e4rten");
            }
            case "gunsten": {
                return SuggestedReplacement.topMatch((String)"Gunsten");
            }
            case "ungunsten": {
                return SuggestedReplacement.topMatch((String)"Ungunsten");
            }
            case "Situp": {
                return SuggestedReplacement.topMatch((String)"Sit-up");
            }
            case "Situps": {
                return SuggestedReplacement.topMatch((String)"Sit-ups");
            }
            case "Feb": {
                return SuggestedReplacement.topMatch((String)"Feb.");
            }
            case "Apr": {
                return SuggestedReplacement.topMatch((String)"Apr.");
            }
            case "Okt": {
                return SuggestedReplacement.topMatch((String)"Okt.");
            }
            case "Nov": {
                return SuggestedReplacement.topMatch((String)"Nov.");
            }
            case "aussen": {
                return SuggestedReplacement.topMatch((String)"au\u00dfen");
            }
            case "bestm\u00f6glichst": {
                return SuggestedReplacement.topMatch((String)"bestm\u00f6glich");
            }
            case "n\u00e4chstm\u00f6glichst": {
                return SuggestedReplacement.topMatch((String)"n\u00e4chstm\u00f6glich");
            }
            case "markaber": {
                return SuggestedReplacement.topMatch((String)"makaber");
            }
            case "nachgeharkt": {
                return SuggestedReplacement.topMatch((String)"nachgehakt");
            }
            case "nachgeharckt": {
                return SuggestedReplacement.topMatch((String)"nachgehackt");
            }
            case "nachharken": {
                return SuggestedReplacement.topMatch((String)"nachhaken");
            }
            case "nachhacken": {
                return SuggestedReplacement.topMatch((String)"nachhaken");
            }
            case "Babies": {
                return SuggestedReplacement.topMatch((String)"Babys");
            }
            case "Gummies": {
                return SuggestedReplacement.topMatch((String)"Gummis");
            }
            case "Gr\u00fczi": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fcezi");
            }
            case "fuer": {
                return SuggestedReplacement.topMatch((String)"f\u00fcr");
            }
            case "Fuer": {
                return SuggestedReplacement.topMatch((String)"F\u00fcr");
            }
            case "Gruss": {
                return SuggestedReplacement.topMatch((String)"Gru\u00df");
            }
            case "Gruesse": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfe");
            }
            case "Gruessen": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfen");
            }
            case "Grue\u00dfe": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfe");
            }
            case "Grue\u00dfen": {
                return SuggestedReplacement.topMatch((String)"Gr\u00fc\u00dfen");
            }
            case "nciht": {
                return SuggestedReplacement.topMatch((String)"nicht");
            }
            case "heutejournal": {
                return SuggestedReplacement.topMatch((String)"heute journal");
            }
            case "wikipedia": {
                return SuggestedReplacement.topMatch((String)"Wikipedia");
            }
            case "Einfallspinsel": {
                return SuggestedReplacement.topMatch((String)"Einfaltspinsel");
            }
            case "Einfallspinseln": {
                return SuggestedReplacement.topMatch((String)"Einfaltspinseln");
            }
            case "Parcour": {
                return SuggestedReplacement.topMatch((String)"Parcours");
            }
            case "Sommeliere": {
                return SuggestedReplacement.topMatch((String)"Sommeli\u00e8re");
            }
            case "Sommeli\u00e9re": {
                return SuggestedReplacement.topMatch((String)"Sommeli\u00e8re");
            }
            case "Kosten-Nutzenanalyse": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Analyse");
            }
            case "Kosten-Nutzenanalysen": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Analysen");
            }
            case "Kosten-Nutzenverh\u00e4ltnis": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Verh\u00e4ltnis");
            }
            case "Kosten-Nutzenverh\u00e4ltnisse": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Verh\u00e4ltnisse");
            }
            case "Kosten-Nutzenverh\u00e4ltnisses": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Verh\u00e4ltnisses");
            }
            case "Kosten-Nutzenrechnung": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Rechnung");
            }
            case "Kosten-Nutzenrechnungen": {
                return SuggestedReplacement.topMatch((String)"Kosten-Nutzen-Rechnungen");
            }
            case "Brandwein": {
                return SuggestedReplacement.topMatch((String)"Branntwein");
            }
            case "Brandweins": {
                return SuggestedReplacement.topMatch((String)"Branntweins");
            }
            case "Brandweines": {
                return SuggestedReplacement.topMatch((String)"Branntweines");
            }
            case "Brandweine": {
                return SuggestedReplacement.topMatch((String)"Branntweine");
            }
            case "Brandweinen": {
                return SuggestedReplacement.topMatch((String)"Branntweinen");
            }
            case "IfoInstitut": {
                return SuggestedReplacement.topMatch((String)"ifo Institut");
            }
            case "IfoInstituts": {
                return SuggestedReplacement.topMatch((String)"ifo Instituts");
            }
            case "ifoInstitut": {
                return SuggestedReplacement.topMatch((String)"ifo Institut");
            }
            case "ifoInstituts": {
                return SuggestedReplacement.topMatch((String)"ifo Instituts");
            }
            case "Ifo-Institut": {
                return SuggestedReplacement.topMatch((String)"ifo Institut");
            }
            case "Ifo-Instituts": {
                return SuggestedReplacement.topMatch((String)"ifo Instituts");
            }
            case "ifo-Institut": {
                return SuggestedReplacement.topMatch((String)"ifo Institut");
            }
            case "ifo-Instituts": {
                return SuggestedReplacement.topMatch((String)"ifo Instituts");
            }
            case "MacMini": {
                return SuggestedReplacement.topMatch((String)"Mac mini");
            }
            case "MacMinis": {
                return SuggestedReplacement.topMatch((String)"Mac minis");
            }
            case "Neisse-Verlag": {
                return SuggestedReplacement.topMatch((String)"Neisse Verlag");
            }
            case "Nei\u00dfe-Verlag": {
                return SuggestedReplacement.topMatch((String)"Neisse Verlag");
            }
            case "Neisse-Verlags": {
                return SuggestedReplacement.topMatch((String)"Neisse Verlags");
            }
            case "Nei\u00dfe-Verlags": {
                return SuggestedReplacement.topMatch((String)"Neisse Verlags");
            }
            case "weihnachten": {
                return SuggestedReplacement.topMatch((String)"Weihnachten");
            }
            case "Carlsen-Verlag": {
                return SuggestedReplacement.topMatch((String)"Carlsen Verlag");
            }
            case "Carlsen-Verlags": {
                return SuggestedReplacement.topMatch((String)"Carlsen Verlags");
            }
            case "Sinnflut": {
                return SuggestedReplacement.topMatch((String)"Sintflut");
            }
            case "Orginal": {
                return SuggestedReplacement.topMatch((String)"Original");
            }
            case "Orginals": {
                return SuggestedReplacement.topMatch((String)"Originals");
            }
            case "orginal": {
                return SuggestedReplacement.topMatch((String)"original");
            }
            case "orginale": {
                return SuggestedReplacement.topMatch((String)"originale");
            }
            case "orginalen": {
                return SuggestedReplacement.topMatch((String)"originalen");
            }
            case "orginales": {
                return SuggestedReplacement.topMatch((String)"originales");
            }
            case "Rundumsorglospaket": {
                return SuggestedReplacement.topMatch((String)"Rundum-sorglos-Paket");
            }
            case "Rundumsorglospakets": {
                return SuggestedReplacement.topMatch((String)"Rundum-sorglos-Pakets");
            }
        }
        return Collections.emptyList();
    }

    static {
        GermanSpellerRule.put("lieder", (String w) -> Arrays.asList("leider", "Lieder"));
        GermanSpellerRule.put("Topfen", "Tropfen");
        GermanSpellerRule.put("fr\u00e4gst", "fragst");
        GermanSpellerRule.put("s\u00e4hte", "s\u00e4te");
        GermanSpellerRule.put("s\u00e4ht", "s\u00e4t");
        GermanSpellerRule.put("s\u00e4htest", "s\u00e4test");
        GermanSpellerRule.put("s\u00e4hten", "s\u00e4ten");
        GermanSpellerRule.put("s\u00e4htet", "s\u00e4tet");
        GermanSpellerRule.put("ges\u00e4ht", "ges\u00e4t");
        GermanSpellerRule.put("s\u00e4hend", "s\u00e4end");
        GermanSpellerRule.put("Impflicht", "Impfpflicht");
        GermanSpellerRule.put("Wandererin", "Wanderin");
        GermanSpellerRule.put("da\u00df", "dass");
        GermanSpellerRule.put("eien", "eine");
        GermanSpellerRule.put("wiederrum", "wiederum");
        GermanSpellerRule.put("ne", (String w) -> Arrays.asList("'ne", "eine", "nein", "oder"));
        GermanSpellerRule.put("ner", "einer");
        GermanSpellerRule.put("isses", (String w) -> Arrays.asList("ist es", "Risses"));
        GermanSpellerRule.put("isser", "ist er");
        GermanSpellerRule.put("Vieleicht", "Vielleicht");
        GermanSpellerRule.put("inbetracht", "in Betracht");
        GermanSpellerRule.put("\u00fcberwhatsapp", "\u00fcber WhatsApp");
        GermanSpellerRule.put("\u00fcberzoom", "\u00fcber Zoom");
        GermanSpellerRule.put("\u00fcberwei\u00dft", "\u00fcberweist");
        GermanSpellerRule.put("\u00fcbergoogle", "\u00fcber Google");
        GermanSpellerRule.put("einlogen", "einloggen");
        GermanSpellerRule.put("Kruks", "Krux");
        GermanSpellerRule.put("Filterbubble", "Filterblase");
        GermanSpellerRule.put("Filterbubbles", "Filterblasen");
        GermanSpellerRule.putRepl("Analgen.*", "Analgen", "Anlagen");
        GermanSpellerRule.putRepl("wiedersteh(en|st|t)", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederstan(d|den|dest)", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprech(e|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprich(st|t)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersprach(st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederruf(e|st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederrief(st|t|en)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederleg(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederhall(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiedersetz(e|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("wiederstreb(e|st|t|en|te|ten)?", "wieder", "wider");
        GermanSpellerRule.putRepl("zur\u00fcck(ge|zu)?koppe?l(e|n|t(e(st|n)?)?|nd(e(r|s|m|n)?)?|st|)?", "zur\u00fcck", "r\u00fcck");
        GermanSpellerRule.put("bekomms", "bekomm es");
        GermanSpellerRule.put("Latin", "Latein");
        GermanSpellerRule.put("liegts", "liegt es");
        GermanSpellerRule.put("gesynct", "synchronisiert");
        GermanSpellerRule.put("gesynced", "synchronisiert");
        GermanSpellerRule.put("gesyncht", "synchronisiert");
        GermanSpellerRule.put("gesyngt", "synchronisiert");
        GermanSpellerRule.put("synce", "synchronisiere");
        GermanSpellerRule.put("synche", "synchronisiere");
        GermanSpellerRule.put("syncen", "synchronisieren");
        GermanSpellerRule.put("synchen", "synchronisieren");
        GermanSpellerRule.put("wiederspiegelten", "widerspiegelten");
        GermanSpellerRule.put("wiedererwarten", "wider Erwarten");
        GermanSpellerRule.put("widerholen", "wiederholen");
        GermanSpellerRule.put("wiederhohlen", "wiederholen");
        GermanSpellerRule.put("herrunterladen", "herunterladen");
        GermanSpellerRule.put("dastellen", "darstellen");
        GermanSpellerRule.put("zuviel", "zu viel");
        GermanSpellerRule.put("abgekatertes", "abgekartetes");
        GermanSpellerRule.put("wiederspiegelt", "widerspiegelt");
        GermanSpellerRule.put("Komplexheit", "Komplexit\u00e4t");
        GermanSpellerRule.put("unterschiedet", "unterscheidet");
        GermanSpellerRule.put("einzigst", "einzig");
        GermanSpellerRule.put("Einzigst", "Einzig");
        GermanSpellerRule.put("geschumpfen", "geschimpft");
        GermanSpellerRule.put("Geschumpfen", "Geschimpft");
        GermanSpellerRule.put("Oke", "Okay");
        GermanSpellerRule.put("M\u00fc", "My");
        GermanSpellerRule.put("packs", "pack es");
        GermanSpellerRule.put("abschiednehmen", "Abschied nehmen");
        GermanSpellerRule.put("wars", (String w) -> Arrays.asList("war es", "warst"));
        GermanSpellerRule.put("[aA]wa", (String w) -> Arrays.asList("AWA", "ach was", "aber"));
        GermanSpellerRule.put("[aA]lsallerersten?s", (String w) -> Arrays.asList(w.replaceFirst("lsallerersten?s", "ls allererstes"), w.replaceFirst("lsallerersten?s", "ls Allererstes")));
        GermanSpellerRule.putRepl("(an|auf|ein|zu)gehangen(e[mnrs]?)?$", "hangen", "h\u00e4ngt");
        GermanSpellerRule.putRepl("[oO]key", "ey$", "ay");
        GermanSpellerRule.put("packet", "Paket");
        GermanSpellerRule.put("Thanks", "Danke");
        GermanSpellerRule.put("Ghanesen?", "Ghanaer");
        GermanSpellerRule.put("Thumberg", "Thunberg");
        GermanSpellerRule.put("Allalei", "Allerlei");
        GermanSpellerRule.put("geupdate[dt]$", "upgedatet");
        GermanSpellerRule.put("[pP]roblemhaft(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("haft", "behaftet"), w.replaceFirst("haft", "atisch")));
        GermanSpellerRule.put("rosane[mnrs]?$", (String w) -> Arrays.asList("rosa", w.replaceFirst("^rosan", "rosafarben")));
        GermanSpellerRule.put("Erbung", (String w) -> Arrays.asList("Vererbung", "Erbschaft"));
        GermanSpellerRule.put("Energiesparung", (String w) -> Arrays.asList("Energieeinsparung", "Energieersparnis"));
        GermanSpellerRule.put("Abbrechung", "Abbruch");
        GermanSpellerRule.put("Abbrechungen", (String w) -> Arrays.asList("Abbr\u00fcche", "Abbr\u00fcchen"));
        GermanSpellerRule.put("Urteilung", (String w) -> Arrays.asList("Urteil", "Verurteilung"));
        GermanSpellerRule.put("allm\u00f6glichen?", (String w) -> Arrays.asList("alle m\u00f6glichen", "alle m\u00f6gliche"));
        GermanSpellerRule.put("Krankenhausen", (String w) -> Arrays.asList("Krankenh\u00e4usern", "Krankenh\u00e4user"));
        GermanSpellerRule.put("vorr?auss?etzlich", (String w) -> Arrays.asList("voraussichtlich", "vorausgesetzt"));
        GermanSpellerRule.put("nichtmals", (String w) -> Arrays.asList("nicht mal", "nicht einmal"));
        GermanSpellerRule.put("eingepeilt", "angepeilt");
        GermanSpellerRule.put("gekukt", "geguckt");
        GermanSpellerRule.put("nem", (String w) -> Arrays.asList("'nem", "einem"));
        GermanSpellerRule.put("nen", (String w) -> Arrays.asList("'nen", "einen"));
        GermanSpellerRule.put("geb", "gebe");
        GermanSpellerRule.put("\u00fcberhaut", "\u00fcberhaupt");
        GermanSpellerRule.put("nacher", "nachher");
        GermanSpellerRule.put("jeztz", "jetzt");
        GermanSpellerRule.put("les", "lese");
        GermanSpellerRule.put("wr", "wir");
        GermanSpellerRule.put("bezweifel", "bezweifle");
        GermanSpellerRule.put("verzweifel", "verzweifle");
        GermanSpellerRule.put("zweifel", "zweifle");
        GermanSpellerRule.put("[wW]ah?rscheindlichkeit", "Wahrscheinlichkeit");
        GermanSpellerRule.put("Hijab", "Hidsch\u0101b");
        GermanSpellerRule.put("[lL]eerequiment", "Leerequipment");
        GermanSpellerRule.put("unausl\u00e4sslich", (String w) -> Arrays.asList("unerl\u00e4sslich", "unabl\u00e4ssig", "unausl\u00f6schlich"));
        GermanSpellerRule.put("klappts", (String w) -> Arrays.asList("klappt\u2019s", "klappt es", "klappst"));
        GermanSpellerRule.put("Klappts", (String w) -> Arrays.asList("Klappt\u2019s", "Klappt es", "Klappst"));
        GermanSpellerRule.put("schicks", (String w) -> Arrays.asList("schick\u2019s", "schick es", "schickst"));
        GermanSpellerRule.put("Schicks", (String w) -> Arrays.asList("Schick\u2019s", "Schick es", "Schickst"));
        GermanSpellerRule.put("Registration", "Registrierung");
        GermanSpellerRule.put("Registrationen", "Registrierungen");
        GermanSpellerRule.put("Spinnenweben", "Spinnweben");
        GermanSpellerRule.put("[Tt]uneup", "TuneUp");
        GermanSpellerRule.putRepl("[Ww]ar ne", "ne", "eine");
        GermanSpellerRule.putRepl("[\u00c4\u00e4]nliche[rnms]?", "nlich", "hnlich");
        GermanSpellerRule.putRepl("[Gg]arnix", "nix", "nichts");
        GermanSpellerRule.putRepl("[Ww]i", "i", "ie");
        GermanSpellerRule.putRepl("[uU]nausl\u00e4sslich(e[mnrs]?)?", "aus", "er");
        GermanSpellerRule.putRepl("[vV]erewiglicht(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[zZ]eritifiert(e[mnrs]?)?", "eritifiert", "ertifiziert");
        GermanSpellerRule.putRepl("ger\u00e4hten?", "ger\u00e4ht", "Ger\u00e4t");
        GermanSpellerRule.putRepl("leptops?", "lep", "Lap");
        GermanSpellerRule.putRepl("[pP]ie?rsings?", "[pP]ie?rsing", "Piercing");
        GermanSpellerRule.putRepl("for?melar(en?)?", "for?me", "Formu");
        GermanSpellerRule.putRepl("n\u00e4ste[mnrs]?$", "^n\u00e4s", "n\u00e4chs");
        GermanSpellerRule.putRepl("Erdogans?$", "^Erdogan", "Erdo\u011fan");
        GermanSpellerRule.put("Germanistiker[ns]", "Germanisten");
        GermanSpellerRule.putRepl("Germanistikerin(nen)?", "Germanistiker", "Germanist");
        GermanSpellerRule.putRepl("[iI]ns?z[ie]nie?rung(en)?", "[iI]ns?z[ie]nie?", "Inszenie");
        GermanSpellerRule.putRepl("[eE]rh\u00f6herung(en)?", "[eE]rh\u00f6herung", "Erh\u00f6hung");
        GermanSpellerRule.putRepl("[vV]ersp\u00e4terung(en)?", "sp\u00e4ter", "sp\u00e4t");
        GermanSpellerRule.putRepl("[vV]orallendingen", "orallendingen", "or allen Dingen");
        GermanSpellerRule.putRepl("[aA]ufjede[nm]fall", "jede[nm]fall$", " jeden Fall");
        GermanSpellerRule.putRepl("[aA]us[vf]ersehen[dt]lich", "[vf]ersehen[dt]lich", " Versehen");
        GermanSpellerRule.putRepl("^funk?z[ou]nier.+", "funk?z[ou]nier", "funktionier");
        GermanSpellerRule.putRepl("[wW]\u00f6ruber", "\u00f6ru", "or\u00fc");
        GermanSpellerRule.putRepl("[lL]einensamens?", "[lL]einen", "Lein");
        GermanSpellerRule.putRepl("Feinleiner[ns]?", "Feinlei", "Fineli");
        GermanSpellerRule.putRepl("[hH]eilei[td]s?", "[hH]eilei[td]", "Highlight");
        GermanSpellerRule.putRepl("Oldheimer[ns]?", "he", "t");
        GermanSpellerRule.putRepl("[tT]r\u00e4ner[ns]?", "[tT]r\u00e4", "Trai");
        GermanSpellerRule.putRepl("[tT]eimings?", "[tT]e", "T");
        GermanSpellerRule.putRepl("unternehmensl[u\u00fc]stig(e[mnrs]?)?", "mensl[u\u00fc]st", "mungslust");
        GermanSpellerRule.putRepl("proff?ess?ional(e[mnrs]?)?", "ff?ess?ional", "fessionell");
        GermanSpellerRule.putRepl("zuverl\u00e4sslich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.putRepl("fluoreszenzierend(e[mnrs]?)?", "zen", "");
        GermanSpellerRule.putRepl("revalierend(e[mnrs]?)?", "^reval", "rivalis");
        GermanSpellerRule.putRepl("verh\u00e4uft(e[mnrs]?)?", "^ver", "ge");
        GermanSpellerRule.putRepl("st\u00fcrmig(e[mnrs]?)?", "mig", "misch");
        GermanSpellerRule.putRepl("gr\u00f6\u00dfeste[mnrs]?", "\u00dfes", "\u00df");
        GermanSpellerRule.putRepl("n[a\u00e4]heste[mnrs]?", "n[a\u00e4]he", "n\u00e4ch");
        GermanSpellerRule.putRepl("gesundlich(e[mnrs]?)?", "lich", "heitlich");
        GermanSpellerRule.putRepl("eckel(e|t(en?)?|st)?", "^eck", "ek");
        GermanSpellerRule.putRepl("unhervorgesehen(e[mnrs]?)?", "hervor", "vorher");
        GermanSpellerRule.putRepl("entt?euscht(e[mnrs]?)?", "entt?eusch", "entt\u00e4usch");
        GermanSpellerRule.putRepl("Ph\u00e4hlen?", "^Ph", "Pf");
        GermanSpellerRule.putRepl("Kattermesser[ns]?", "Ka", "Cu");
        GermanSpellerRule.putRepl("gehe?rr?t(e[mnrs]?)?", "he?rr?", "ehr");
        GermanSpellerRule.putRepl("gehrter?", "^ge", "gee");
        GermanSpellerRule.putRepl("[nN]amenhaft(e[mnrs]?)?", "amen", "am");
        GermanSpellerRule.putRepl("hom(o?e|\u00f6)ophatisch(e[mnrs]?)?", "hom(o?e|\u00f6)ophat", "hom\u00f6opath");
        GermanSpellerRule.putRepl("Geschwindlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.putRepl("J\u00e4nners?", "J\u00e4nner", "Januar");
        GermanSpellerRule.putRepl("[\u00e4\u00c4]hlich(e[mnrs]?)?", "lich", "nlich");
        GermanSpellerRule.putRepl("entf[ai]ngen?", "ent", "emp");
        GermanSpellerRule.putRepl("entf[\u00e4i]ngs?t", "ent", "emp");
        GermanSpellerRule.putRepl("[Bb]ehilfreich(e[rnms]?)", "reich", "lich");
        GermanSpellerRule.putRepl("[Bb]zgl", "zgl", "zgl.");
        GermanSpellerRule.putRepl("kaltnass(e[rnms]?)", "kaltnass", "nasskalt");
        GermanSpellerRule.putRepl("Kaltnass(e[rnms]?)", "Kaltnass", "Nasskalt");
        GermanSpellerRule.put("check", "checke");
        GermanSpellerRule.put("R\u00fcckrad", "R\u00fcckgrat");
        GermanSpellerRule.put("ala", "\u00e0 la");
        GermanSpellerRule.put("Ala", "\u00c0 la");
        GermanSpellerRule.put("Reinfolge", "Reihenfolge");
        GermanSpellerRule.put("Schlo\u00df", "Schloss");
        GermanSpellerRule.put("Investion", "Investition");
        GermanSpellerRule.put("Beleidung", "Beleidigung");
        GermanSpellerRule.put("Bole", "Bowle");
        GermanSpellerRule.put("letzens", "letztens");
        GermanSpellerRule.put("Pakur", (String w) -> Arrays.asList("Parcours", "Parkuhr"));
        GermanSpellerRule.put("Dez", (String w) -> Arrays.asList("Dez.", "Der"));
        GermanSpellerRule.put("Jun", "Jun.");
        GermanSpellerRule.put("Sept", "Sept.");
        GermanSpellerRule.put("Aug", (String w) -> Arrays.asList("Aug.", "Auge"));
        GermanSpellerRule.put("Erstsemesterin", (String w) -> Arrays.asList("Erstsemester", "Erstsemesters", "Erstsemesterstudentin"));
        GermanSpellerRule.put("Erstsemesterinnen", (String w) -> Arrays.asList("Erstsemesterstudentinnen", "Erstsemester", "Erstsemestern"));
        GermanSpellerRule.put("kreativlos(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("kreativ", "fantasie"), w.replaceFirst("kreativ", "einfalls"), w.replaceFirst("kreativlos", "unkreativ"), w.replaceFirst("kreativlos", "uninspiriert")));
        GermanSpellerRule.put("Kreativlosigkeit", "Unkreativit\u00e4t");
        GermanSpellerRule.put("hinund?her", "hin und her");
        GermanSpellerRule.put("[lL]ymph?trie?nasche", "Lymphdrainage");
        GermanSpellerRule.put("Interdeterminismus", "Indeterminismus");
        GermanSpellerRule.put("elektrit\u00e4t", "Elektrizit\u00e4t");
        GermanSpellerRule.put("ausgeboten", "ausgebootet");
        GermanSpellerRule.put("nocheinmall", "noch einmal");
        GermanSpellerRule.put("a\u00fc\u00dferst", "\u00e4u\u00dferst");
        GermanSpellerRule.put("Grr\u00f6sse", "Gr\u00f6\u00dfe");
        GermanSpellerRule.put("misverst\u00e4ndniss", "Missverst\u00e4ndnis");
        GermanSpellerRule.put("warheit", "Wahrheit");
        GermanSpellerRule.put("[pP]okemon", "Pok\u00e9mon");
        GermanSpellerRule.put("kreigt", "kriegt");
        GermanSpellerRule.put("Frit\u00f6se", "Fritteuse");
        GermanSpellerRule.put("unerkennlich", "unkenntlich");
        GermanSpellerRule.put("r\u00fcckg[\u00e4e]nglich", "r\u00fcckg\u00e4ngig");
        GermanSpellerRule.put("em?men[sz]", "immens");
        GermanSpellerRule.put("verhing", "verh\u00e4ngte");
        GermanSpellerRule.put("verhingen", "verh\u00e4ngten");
        GermanSpellerRule.put("fangte", "fing");
        GermanSpellerRule.put("fangten", "fingen");
        GermanSpellerRule.put("schlie[s\u00df]te", "schloss");
        GermanSpellerRule.put("schlie[s\u00df]ten", "schlossen");
        GermanSpellerRule.put("past", "passt");
        GermanSpellerRule.put("eingetragt", "eingetragen");
        GermanSpellerRule.put("getrunkt", "getrunken");
        GermanSpellerRule.put("ver\u00e4ht", "verr\u00e4t");
        GermanSpellerRule.put("helfte", "half");
        GermanSpellerRule.put("helften", "halfen");
        GermanSpellerRule.put("lad", "lade");
        GermanSpellerRule.put("befehlte", "befahl");
        GermanSpellerRule.put("befehlten", "befahlen");
        GermanSpellerRule.put("angel\u00fcgt", "angelogen");
        GermanSpellerRule.put("Bitet", "Bittet");
        GermanSpellerRule.put("dagen", "sagen");
        GermanSpellerRule.put("\u00e4ndenr", "\u00e4ndern");
        GermanSpellerRule.put("\u00fcbetragen", "\u00fcbertragen");
        GermanSpellerRule.put("Ihrn", "Ihren");
        GermanSpellerRule.put("Emal", "E-Mail");
        GermanSpellerRule.put("Emai", "E-Mail");
        GermanSpellerRule.put("schuen", "schauen");
        GermanSpellerRule.put("Hasue", "Haus");
        GermanSpellerRule.put("leier", "leider");
        GermanSpellerRule.put("Meschen", "Menschen");
        GermanSpellerRule.put("unsen", "unseren");
        GermanSpellerRule.put("biiten", "bitten");
        GermanSpellerRule.put("gel\u00e4scht", "gel\u00f6scht");
        GermanSpellerRule.put("Kundein", "Kundin");
        GermanSpellerRule.put("amch", "mach");
        GermanSpellerRule.put("amche", "mache");
        GermanSpellerRule.put("forfahren", "fortfahren");
        GermanSpellerRule.put("verate", "verrate");
        GermanSpellerRule.put("interen", "interne");
        GermanSpellerRule.put("Budge", "Budget");
        GermanSpellerRule.put("weiso", "wieso");
        GermanSpellerRule.put("Parter", "Partner");
        GermanSpellerRule.put("wiet", (String w) -> Arrays.asList("weit", "wie"));
        GermanSpellerRule.put("beid", (String w) -> Arrays.asList("beide", "seid", "beim", "bei"));
        GermanSpellerRule.put("Theam", (String w) -> Arrays.asList("Thema", "Team"));
        GermanSpellerRule.put("ind", (String w) -> Arrays.asList("und", "ins", "in", "sind"));
        GermanSpellerRule.put("us", (String w) -> Arrays.asList("US", "aus"));
        GermanSpellerRule.put("soch", (String w) -> Arrays.asList("doch", "sich", "noch"));
        GermanSpellerRule.put("Abe", (String w) -> Arrays.asList("Aber", "Ab", "ABE", "Aue"));
        GermanSpellerRule.put("l\u00fcgte", "log");
        GermanSpellerRule.put("l\u00fcgten", "logen");
        GermanSpellerRule.put("bratete", "briet");
        GermanSpellerRule.put("brateten", "brieten");
        GermanSpellerRule.put("gefahl", "gefiel");
        GermanSpellerRule.put("Komplexibilit\u00e4t", "Komplexit\u00e4t");
        GermanSpellerRule.put("abbonement", "Abonnement");
        GermanSpellerRule.put("zugegebenerweise", "zugegebenerma\u00dfen");
        GermanSpellerRule.put("perse", "per se");
        GermanSpellerRule.put("Schwitch", "Switch");
        GermanSpellerRule.put("[aA]nwesenzeiten", "Anwesenheitszeiten");
        GermanSpellerRule.put("[gG]eizigkeit", "Geiz");
        GermanSpellerRule.put("[fF]lei\u00dfigkeit", "Flei\u00df");
        GermanSpellerRule.put("[bB]equemheit", "Bequemlichkeit");
        GermanSpellerRule.put("[mM]issionarie?sie?rung", "Missionierung");
        GermanSpellerRule.put("[sS]chee?selonge?", "Chaiselongue");
        GermanSpellerRule.put("Re[kc]amiere", "R\u00e9cami\u00e8re");
        GermanSpellerRule.put("Singel", "Single");
        GermanSpellerRule.put("legen[td]lich", "lediglich");
        GermanSpellerRule.put("ein[ua]ndhalb", "eineinhalb");
        GermanSpellerRule.put("[mM]illion(en)?mal", (String w) -> Collections.singletonList(StringTools.uppercaseFirstChar((String)w.replaceFirst("mal", " Mal"))));
        GermanSpellerRule.put("Mysql", "MySQL");
        GermanSpellerRule.put("MWST", "MwSt");
        GermanSpellerRule.put("Opelarena", "Opel Arena");
        GermanSpellerRule.put("Toll-Collect", "Toll Collect");
        GermanSpellerRule.put("[pP][qQ]-Formel", "p-q-Formel");
        GermanSpellerRule.put("desweitere?m", "des Weiteren");
        GermanSpellerRule.put("handzuhaben", "zu handhaben");
        GermanSpellerRule.put("nachvollzuziehe?n", "nachzuvollziehen");
        GermanSpellerRule.put("Porto?folien", "Portfolios");
        GermanSpellerRule.put("[sS]chwie?ri?chkeiten", "Schwierigkeiten");
        GermanSpellerRule.put("[\u00fc\u00dc]bergrifflichkeiten", "\u00dcbergriffigkeiten");
        GermanSpellerRule.put("[aA]r?th?rie?th?is", "Arthritis");
        GermanSpellerRule.put("zugesand", "zugesandt");
        GermanSpellerRule.put("weibt", "wei\u00dft");
        GermanSpellerRule.put("fress", "friss");
        GermanSpellerRule.put("Mamma", "Mama");
        GermanSpellerRule.put("Pr\u00e4se", "Pr\u00e4sentation");
        GermanSpellerRule.put("Pr\u00e4sen", "Pr\u00e4sentationen");
        GermanSpellerRule.put("Orga", "Organisation");
        GermanSpellerRule.put("Orgas", "Organisationen");
        GermanSpellerRule.put("Reorga", "Reorganisation");
        GermanSpellerRule.put("Reorgas", "Reorganisationen");
        GermanSpellerRule.put("instande?zusetzen", "instand zu setzen");
        GermanSpellerRule.put("Lia(si|is)onen", "Liaisons");
        GermanSpellerRule.put("[cC]asemana?ge?ment", "Case Management");
        GermanSpellerRule.put("[aA]nn?[ou]ll?ie?rung", "Annullierung");
        GermanSpellerRule.put("[sS]charm", "Charme");
        GermanSpellerRule.put("[zZ]auberlich(e[mnrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("lich", "isch"), w.replaceFirst("lich", "haft")));
        GermanSpellerRule.put("[eE]rledung", "Erledigung");
        GermanSpellerRule.put("erledigigung", "Erledigung");
        GermanSpellerRule.put("woltest", "wolltest");
        GermanSpellerRule.put("[iI]ntranzparentheit", "Intransparenz");
        GermanSpellerRule.put("dunkellilane[mnrs]?", "dunkellila");
        GermanSpellerRule.put("helllilane[mnrs]?", "helllila");
        GermanSpellerRule.put("Behauptungsthese", "Behauptung");
        GermanSpellerRule.put("genzut", "genutzt");
        GermanSpellerRule.put("[eE\u00e4\u00c4]klerung", "Erkl\u00e4rung");
        GermanSpellerRule.put("[wW]eh?wechen", "Wehwehchen");
        GermanSpellerRule.put("nocheinmals", "noch einmal");
        GermanSpellerRule.put("unverantwortungs?los(e[mnrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("unverantwortungs?", "verantwortungs"), w.replaceFirst("ungs?los", "lich")));
        GermanSpellerRule.putRepl("[eE]rhaltbar(e[mnrs]?)?", "haltbar", "h\u00e4ltlich");
        GermanSpellerRule.putRepl("[aA]ufkeinenfall?", "keinenfall?", " keinen Fall");
        GermanSpellerRule.putRepl("[Dd]rumrum", "rum$", "herum");
        GermanSpellerRule.putRepl("([uU]n)?proff?esionn?ell?(e[mnrs]?)?", "proff?esionn?ell?", "professionell");
        GermanSpellerRule.putRepl("[kK]inderlich(e[mnrs]?)?", "inder", "ind");
        GermanSpellerRule.putRepl("[wW]iedersprichs?t", "ieder", "ider");
        GermanSpellerRule.putRepl("[wW]hite-?[Ll]abels", "[wW]hite-?[Ll]abel", "White Label");
        GermanSpellerRule.putRepl("[wW]iederstand", "ieder", "ider");
        GermanSpellerRule.putRepl("[kK]\u00f6nntes", "es$", "est");
        GermanSpellerRule.putRepl("[aA]ssess?oare?s?", "[aA]ssess?oare?", "Accessoire");
        GermanSpellerRule.putRepl("indifiziert(e[mnrs]?)?", "ind", "ident");
        GermanSpellerRule.putRepl("dreite[mnrs]?", "dreit", "dritt");
        GermanSpellerRule.putRepl("verbl\u00fcte[mnrs]?", "bl\u00fc", "bl\u00fch");
        GermanSpellerRule.putRepl("Einzigste[mnrs]?", "zigst", "zig");
        GermanSpellerRule.putRepl("Invests?", "Invest", "Investment");
        GermanSpellerRule.putRepl("(aller)?einzie?gste[mnrs]?", "(aller)?einzie?gst", "einzig");
        GermanSpellerRule.putRepl("[iI]nterkurell(e[nmrs]?)?", "ku", "kultu");
        GermanSpellerRule.putRepl("[iI]ntersannt(e[mnrs]?)?", "sannt", "essant");
        GermanSpellerRule.putRepl("ubera(g|sch)end(e[nmrs]?)?", "uber", "\u00fcberr");
        GermanSpellerRule.putRepl("[Hh]ello", "ello", "allo");
        GermanSpellerRule.putRepl("[Gg]etagged", "gged", "ggt");
        GermanSpellerRule.putRepl("[wW]olt$", "lt", "llt");
        GermanSpellerRule.putRepl("[zZ]uende", "ue", "u E");
        GermanSpellerRule.putRepl("[iI]nb\u00e4lde", "nb", "n B");
        GermanSpellerRule.putRepl("[lL]etztenendes", "ene", "en E");
        GermanSpellerRule.putRepl("[nN]achwievor", "wievor", " wie vor");
        GermanSpellerRule.putRepl("[zZ]umbeispiel", "beispiel", " Beispiel");
        GermanSpellerRule.putRepl("[gG]ottseidank", "[gG]ottseidank", "Gott sei Dank");
        GermanSpellerRule.putRepl("[gG]rundauf", "[gG]rundauf", "Grund auf");
        GermanSpellerRule.putRepl("[aA]nsichtnach", "[aA]nsicht", "Ansicht ");
        GermanSpellerRule.putRepl("[uU]n[sz]war", "[sz]war", "d zwar");
        GermanSpellerRule.putRepl("[wW]aschte(s?t)?", "aschte", "usch");
        GermanSpellerRule.putRepl("[wW]aschten", "ascht", "usch");
        GermanSpellerRule.putRepl("Probiren?", "ir", "ier");
        GermanSpellerRule.putRepl("[gG]esetztreu(e[nmrs]?)?", "tz", "tzes");
        GermanSpellerRule.putRepl("[wW]ikich(e[nmrs]?)?", "k", "rkl");
        GermanSpellerRule.putRepl("[uU]naufbesichtigt(e[nmrs]?)?", "aufbe", "beauf");
        GermanSpellerRule.putRepl("[nN]utzvoll(e[nmrs]?)?", "utzvoll", "\u00fctzlich");
        GermanSpellerRule.putRepl("Lezte[mnrs]?", "Lez", "Letz");
        GermanSpellerRule.putRepl("Letze[mnrs]?", "Letz", "Letzt");
        GermanSpellerRule.putRepl("[nN]i[vw]os?", "[nN]i[vw]o", "Niveau");
        GermanSpellerRule.putRepl("[dD]illetant(en)?", "[dD]ille", "Dilet");
        GermanSpellerRule.putRepl("Frauenhofer-(Institut|Gesellschaft)", "Frauen", "Fraun");
        GermanSpellerRule.putRepl("Add-?Ons?", "Add-?On", "Add-on");
        GermanSpellerRule.putRepl("Addons?", "on", "-on");
        GermanSpellerRule.putRepl("Internetkaffees?", "kaffee", "caf\u00e9");
        GermanSpellerRule.putRepl("[gG]ehorsamkeitsverweigerung(en)?", "[gG]ehorsamkeit", "Gehorsam");
        GermanSpellerRule.putRepl("[wW]ochende[ns]?", "[wW]ochend", "Wochenend");
        GermanSpellerRule.putRepl("[kK]ongratulier(en?|t(en?)?|st)", "[kK]on", "");
        GermanSpellerRule.putRepl("[wWkKdD]an$", "n$", "nn");
        GermanSpellerRule.putRepl("geh?neh?m[ie]gung(en)?", "geh?neh?m[ie]gung", "Genehmigung");
        GermanSpellerRule.putRepl("Korrigierung(en)?", "igierung", "ektur");
        GermanSpellerRule.putRepl("[kK]orregierung(en)?", "[kK]orregierung", "Korrektur");
        GermanSpellerRule.putRepl("[kK]orrie?girung(en)?", "[kK]orrie?girung", "Korrektur");
        GermanSpellerRule.putRepl("[nN]ocheimal", "eimal", " einmal");
        GermanSpellerRule.putRepl("[aA]benzu", "enzu", " und zu");
        GermanSpellerRule.putRepl("[kK]onflikation(en)?", "[kK]onfli", "Kompli");
        GermanSpellerRule.putRepl("[mM]itanader", "ana", "einan");
        GermanSpellerRule.putRepl("[mM]itenand", "enand", "einander");
        GermanSpellerRule.putRepl("Gelangenheitsbest\u00e4tigung(en)?", "heit", "");
        GermanSpellerRule.putRepl("[jJ]edwillige[mnrs]?", "willig", "wed");
        GermanSpellerRule.putRepl("[qQ]ualit\u00e4ts?bewu\u00dft(e[mnrs]?)?", "ts?bewu\u00dft", "tsbewusst");
        GermanSpellerRule.putRepl("[vV]oraussichtig(e[nmrs]?)?", "sichtig", "sichtlich");
        GermanSpellerRule.putRepl("[gG]leichrechtig(e[nmrs]?)?", "rechtig", "berechtigt");
        GermanSpellerRule.putRepl("[uU]nn\u00fctzlich(e[nmrs]?)?", "n\u00fctzlich", "n\u00fctz");
        GermanSpellerRule.putRepl("[uU]nzerbrechbar(e[nmrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("kolegen?", "ko", "Kol");
        GermanSpellerRule.putRepl("tableten?", "tablet", "Tablett");
        GermanSpellerRule.putRepl("verswinde(n|s?t)", "^vers", "versch");
        GermanSpellerRule.putRepl("unverantwortungsvoll(e[nmrs]?)?", "unverantwortungsvoll", "verantwortungslos");
        GermanSpellerRule.putRepl("[gG]erechtlichkeit", "[gG]erechtlich", "Gerechtig");
        GermanSpellerRule.putRepl("[zZ]uverl\u00e4sslichkeit", "lich", "ig");
        GermanSpellerRule.putRepl("[uU]nverzeilig(e[mnrs]?)?", "zeilig", "zeihlich");
        GermanSpellerRule.putRepl("[zZ]uk(ue?|\u00fc)nftlich(e[mnrs]?)?", "uk(ue?|\u00fc)nftlich", "uk\u00fcnftig");
        GermanSpellerRule.putRepl("[rR]eligi\u00f6sisch(e[nmrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[fF]olklorisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlsvoll(e[nmrs]?)?", "voll", "am");
        GermanSpellerRule.putRepl("Unstimmlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.putRepl("Strebergartens?", "Stre", "Schre");
        GermanSpellerRule.putRepl("[hH]\u00e4hern(e[mnrs]?)?", "\u00e4hern", "\u00e4ren");
        GermanSpellerRule.putRepl("todesbedroh(end|lich)(e[nmrs]?)?", "todes", "lebens");
        GermanSpellerRule.putRepl("^[uU]nabsichtig(e[nmrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[aA]ntisemitistisch(e[mnrs]?)?", "tist", "t");
        GermanSpellerRule.putRepl("[uU]nvorsehbar(e[mnrs]?)?", "vor", "vorher");
        GermanSpellerRule.putRepl("([eE]r|[bB]e|unter|[aA]uf)?h\u00e4lst", "h\u00e4lst", "h\u00e4ltst");
        GermanSpellerRule.put("[wW]ohlf\u00fchlseins?", (String w) -> Arrays.asList("Wellness", w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlbefinden"), w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlf\u00fchlen")));
        GermanSpellerRule.putRepl("[sS]chmett?e?rling(s|en?)?", "[sS]chmett?e?rling", "Schmetterling");
        GermanSpellerRule.putRepl("^[eE]inlamie?nie?r(st|en?|(t(e[nmrs]?)?))?", "^einlamie?nie?r", "laminier");
        GermanSpellerRule.putRepl("[bB]ravur\u00f6s(e[nrms]?)?", "vur", "vour");
        GermanSpellerRule.putRepl("[aA]ss?ecoires?", "[aA]ss?ec", "Access");
        GermanSpellerRule.putRepl("[aA]ufwechse?lungsreich(er|st)?(e[nmrs]?)?", "ufwechse?lung", "bwechslung");
        GermanSpellerRule.putRepl("[iI]nordnung", "ordnung", " Ordnung");
        GermanSpellerRule.putRepl("[iI]mmoment", "moment", " Moment");
        GermanSpellerRule.putRepl("[hH]euteabend", "abend", " Abend");
        GermanSpellerRule.putRepl("[wW]ienerschnitzel[ns]?", "[wW]ieners", "Wiener S");
        GermanSpellerRule.putRepl("[sS]chwarzw\u00e4lderkirschtorten?", "[sS]chwarzw\u00e4lderk", "Schwarzw\u00e4lder K");
        GermanSpellerRule.putRepl("[kK]oxial(e[nmrs]?)?", "x", "ax");
        GermanSpellerRule.putRepl("([\u00fc\u00dc]ber|[uU]unter)?[dD]urs?chnitt?lich(e[nmrs]?)?", "s?chnitt?", "chschnitt");
        GermanSpellerRule.putRepl("[dD]urs?chnitts?", "s?chnitt", "chschnitt");
        GermanSpellerRule.putRepl("[sS]triktlich(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[hH]\u00f6chstwahrlich(e[mnrs]?)?", "wahr", "wahrschein");
        GermanSpellerRule.putRepl("[oO]rganisativ(e[nmrs]?)?", "tiv", "torisch");
        GermanSpellerRule.putRepl("[kK]ontaktfreundlich(e[nmrs]?)?", "ndlich", "dig");
        GermanSpellerRule.putRepl("Helfer?s-Helfer[ns]?", "Helfer?s-H", "Helfersh");
        GermanSpellerRule.putRepl("[iI]ntell?igentsbestien?", "[iI]ntell?igents", "Intelligenz");
        GermanSpellerRule.putRepl("[aA]vantgardisch(e[mnrs]?)?", "gard", "gardist");
        GermanSpellerRule.putRepl("[gG]ewohnheitsbed\u00fcrftig(e[mnrs]?)?", "wohnheit", "w\u00f6hnung");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlungsvoll(e[mnrs]?)?", "f\u00fchlungsvoll", "f\u00fchlsam");
        GermanSpellerRule.putRepl("[vV]erwant(e[mnrs]?)?", "want", "wandt");
        GermanSpellerRule.putRepl("[bB]eanstandigung(en)?", "ig", "");
        GermanSpellerRule.putRepl("[eE]inba(hn|nd)frei(e[mnrs]?)?", "ba(hn|nd)", "wand");
        GermanSpellerRule.putRepl("[\u00e4\u00c4aAeE]rtzten?", "[\u00e4\u00c4aAeE]rt", "\u00c4r");
        GermanSpellerRule.putRepl("pdf-Datei(en)?", "pdf", "PDF");
        GermanSpellerRule.putRepl("rum\u00e4nern?", "rum\u00e4ner", "Rum\u00e4ne");
        GermanSpellerRule.putRepl("[cCKk]o?usengs?", "[cCKk]o?useng", "Cousin");
        GermanSpellerRule.putRepl("Influenzer(in(nen)?|[ns])?", "zer", "cer");
        GermanSpellerRule.putRepl("[vV]ersantdienstleister[ns]?", "[vV]ersant", "Versand");
        GermanSpellerRule.putRepl("[pP]atrolier(s?t|t?en?)", "atrolier", "atrouillier");
        GermanSpellerRule.putRepl("[pP]ropagandiert(e[mnrs]?)?", "and", "");
        GermanSpellerRule.putRepl("[pP]ropagandier(en|st)", "and", "");
        GermanSpellerRule.putRepl("[kK]app?erzit\u00e4t(en)?", "^[kK]app?er", "Kapa");
        GermanSpellerRule.putRepl("k\u00e4nzel(n|s?t)", "k\u00e4nzel", "cancel");
        GermanSpellerRule.put("gek\u00e4nzelt", "gecancelt");
        GermanSpellerRule.putRepl("[\u00fc\u00dc]berstreitung(en)?", "[\u00fc\u00dc]berst", "\u00dcbersch");
        GermanSpellerRule.putRepl("anschliess?lich(e(mnrs)?)?", "anschliess?lich", "anschlie\u00dfend");
        GermanSpellerRule.putRepl("[rR]ethorisch(e(mnrs)?)?", "eth", "het");
        GermanSpellerRule.putRepl("\u00e4nlich(e(mnrs)?)?", "\u00e4n", "\u00e4hn");
        GermanSpellerRule.putRepl("sp\u00e4tm\u00f6glichste(mnrs)?", "sp\u00e4tm\u00f6glichst", "sp\u00e4testm\u00f6glich");
        GermanSpellerRule.put("mogen", "morgen");
        GermanSpellerRule.put("[fF]uss?ill?ien", "Fossilien");
        GermanSpellerRule.put("\u00fcbrings", "\u00fcbrigens");
        GermanSpellerRule.put("[rR]ev\u00fc", "Revue");
        GermanSpellerRule.put("eing\u00e4nglich", "eingangs");
        GermanSpellerRule.put("geerthe", "geehrte");
        GermanSpellerRule.put("interrese", "Interesse");
        GermanSpellerRule.put("[rR]esch\u00e4rschen", "Recherchen");
        GermanSpellerRule.put("[rR]esch\u00e4rsche", "Recherche");
        GermanSpellerRule.put("ic", "ich");
        GermanSpellerRule.put("w[e\u00e4]hret", "w\u00e4ret");
        GermanSpellerRule.put("mahte", "Mathe");
        GermanSpellerRule.put("letzdenendes", "letzten Endes");
        GermanSpellerRule.put("aufgesteht", "aufgestanden");
        GermanSpellerRule.put("ganichts", "gar nichts");
        GermanSpellerRule.put("gesich", "Gesicht");
        GermanSpellerRule.put("glass", "Glas");
        GermanSpellerRule.put("muter", "Mutter");
        GermanSpellerRule.put("[pP]appa", "Papa");
        GermanSpellerRule.put("dier", "dir");
        GermanSpellerRule.put("Referenz-Nr", "Referenz-Nr.");
        GermanSpellerRule.put("Matrikelnr.", "Matrikel-Nr.");
        GermanSpellerRule.put("Rekrutings?prozess", "Recruitingprozess");
        GermanSpellerRule.put("sumarum", "summarum");
        GermanSpellerRule.put("schein", "scheine");
        GermanSpellerRule.put("Innzahlung", (String w) -> Arrays.asList("In Zahlung", "in Zahlung"));
        GermanSpellerRule.put("\u00e4nderen", (String w) -> Arrays.asList("\u00e4ndern", "anderen"));
        GermanSpellerRule.put("wanderen", (String w) -> Arrays.asList("wandern", "Wanderern"));
        GermanSpellerRule.put("Dutzen", (String w) -> Arrays.asList("Duzen", "Dutzend"));
        GermanSpellerRule.put("patien", (String w) -> Arrays.asList("Partien", "Patient"));
        GermanSpellerRule.put("Teammitgliederinnen", (String w) -> Arrays.asList("Teammitgliedern", "Teammitglieder"));
        GermanSpellerRule.put("beidige[mnrs]?", (String w) -> Arrays.asList(w.replaceFirst("ig", ""), w.replaceFirst("beid", "beiderseit"), "beeidigen"));
        GermanSpellerRule.put("Wissbegierigkeit", (String w) -> Arrays.asList("Wissbegier", "Wissbegierde"));
        GermanSpellerRule.put("Nabend", "'n Abend");
        GermanSpellerRule.put("gie?bts", "gibt's");
        GermanSpellerRule.put("vs", "vs.");
        GermanSpellerRule.put("[kK]affeeteria", "Cafeteria");
        GermanSpellerRule.put("[kK]affeeterien", "Cafeterien");
        GermanSpellerRule.put("ber\u00fccksicht", "ber\u00fccksichtigt");
        GermanSpellerRule.put("must", "musst");
        GermanSpellerRule.put("kaffe", "Kaffee");
        GermanSpellerRule.put("zetel", "Zettel");
        GermanSpellerRule.put("wie?daholung", "Wiederholung");
        GermanSpellerRule.put("vie?d(er|a)sehen", "wiedersehen");
        GermanSpellerRule.put("pr[e\u00e4]ventiert", "verhindert");
        GermanSpellerRule.put("pr[e\u00e4]ventieren", "verhindern");
        GermanSpellerRule.put("zur?verf\u00fcgung", "zur Verf\u00fcgung");
        GermanSpellerRule.put("Verwahrlosigkeit", "Verwahrlosung");
        GermanSpellerRule.put("[oO]r?ganisazion", "Organisation");
        GermanSpellerRule.put("[oO]rganisative", "Organisation");
        GermanSpellerRule.put("Emall?iearbeit", "Emaillearbeit");
        GermanSpellerRule.put("[aA]petitt", "Appetit");
        GermanSpellerRule.put("bezuggenommen", "Bezug genommen");
        GermanSpellerRule.put("m\u00e4gt", "m\u00f6gt");
        GermanSpellerRule.put("frug", "fragte");
        GermanSpellerRule.put("ges\u00e4ht", "ges\u00e4t");
        GermanSpellerRule.put("verennt", "verrennt");
        GermanSpellerRule.put("\u00fcberrant", "\u00fcberrannt");
        GermanSpellerRule.put("Gallop", "Galopp");
        GermanSpellerRule.put("Stop", "Stopp");
        GermanSpellerRule.put("Schertz", "Scherz");
        GermanSpellerRule.put("geschied", "geschieht");
        GermanSpellerRule.put("Aku", "Akku");
        GermanSpellerRule.put("Migrationspackt", "Migrationspakt");
        GermanSpellerRule.put("[zZ]ulaufror", "Zulaufrohr");
        GermanSpellerRule.put("[gG]ebrauchss?puhren", "Gebrauchsspuren");
        GermanSpellerRule.put("[pP]reisnachlassung", "Preisnachlass");
        GermanSpellerRule.put("[mM]edikamentation", "Medikation");
        GermanSpellerRule.put("[nN][ei]gliche", "Neglig\u00e9");
        GermanSpellerRule.put("palletten?", (String w) -> Arrays.asList(w.replaceFirst("pall", "Pal"), w.replaceFirst("pa", "Pai")));
        GermanSpellerRule.put("[pP]allete", "Palette");
        GermanSpellerRule.put("Ger\u00e4uch", (String w) -> Arrays.asList("Ger\u00e4usch", "Gestr\u00e4uch"));
        GermanSpellerRule.put("Eon", (String w) -> Arrays.asList("Ein", "E.ON", "Von"));
        GermanSpellerRule.put("[sS]chull?igung", "Entschuldigung");
        GermanSpellerRule.put("Geerte", "geehrte");
        GermanSpellerRule.put("versichen", "versichern");
        GermanSpellerRule.put("hobb?ies", "Hobbys");
        GermanSpellerRule.put("Begierigkeiten", "Begehrlichkeiten");
        GermanSpellerRule.put("selblosigkeit", "Selbstlosigkeit");
        GermanSpellerRule.put("gestyled", "gestylt");
        GermanSpellerRule.put("umstimigkeiten", "Unstimmigkeiten");
        GermanSpellerRule.put("unann?\u00e4h?ml?ichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("unn?ann?ehmichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gte", "\u00fcbertrug");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gten", "\u00fcbertrugen");
        GermanSpellerRule.put("NodeJS", "Node.js");
        GermanSpellerRule.put("Express", "Express.js");
        GermanSpellerRule.put("erlas", "Erlass");
        GermanSpellerRule.put("schlagte", "schlug");
        GermanSpellerRule.put("schlagten", "schlugen");
        GermanSpellerRule.put("\u00fcberwissen", "\u00fcberwiesen");
        GermanSpellerRule.put("einpar", "ein paar");
        GermanSpellerRule.put("sreiben", "schreiben");
        GermanSpellerRule.put("routiene", "Routine");
        GermanSpellerRule.put("ect", "etc");
        GermanSpellerRule.put("giept", "gibt");
        GermanSpellerRule.put("Pann?acott?a", "Panna cotta");
        GermanSpellerRule.put("Fu\u00dfg\u00e4ngerunterwegs?", "Fu\u00dfg\u00e4ngerunterf\u00fchrung");
        GermanSpellerRule.put("angeschriehen", "angeschrien");
        GermanSpellerRule.put("vieviel", "wie viel");
        GermanSpellerRule.put("ent\u00e4scht", "entt\u00e4uscht");
        GermanSpellerRule.put("R\u00e4mchen", "R\u00e4hmchen");
        GermanSpellerRule.put("Seminarbeit", "Seminararbeit");
        GermanSpellerRule.put("Seminarbeiten", "Seminararbeiten");
        GermanSpellerRule.put("[eE]ngangment", "Engagement");
        GermanSpellerRule.put("[lL]eichtah?tleh?t", "Leichtathlet");
        GermanSpellerRule.put("[pP]fane", "Pfanne");
        GermanSpellerRule.put("[iI]ngini?eue?r", "Ingenieur");
        GermanSpellerRule.put("[aA]nligen", "Anliegen");
        GermanSpellerRule.put("Tankungen", (String w) -> Arrays.asList("Betankungen", "Tankvorg\u00e4nge"));
        GermanSpellerRule.put("\u00c4rcker", (String w) -> Arrays.asList("Erker", "\u00c4rger"));
        GermanSpellerRule.put("\u00fcberlasstet", (String w) -> Arrays.asList("\u00fcberlastet", "\u00fcberlie\u00dft"));
        GermanSpellerRule.put("zeren", (String w) -> Arrays.asList("zerren", "zehren"));
        GermanSpellerRule.put("H\u00e4nchen", (String w) -> Arrays.asList("H\u00e4hnchen", "H\u00e4nschen"));
        GermanSpellerRule.put("[sS]itwazion", "Situation");
        GermanSpellerRule.put("geschriehen", "geschrien");
        GermanSpellerRule.put("beratete", "beriet");
        GermanSpellerRule.put("H\u00e4lst", "H\u00e4ltst");
        GermanSpellerRule.put("[kK]aos", "Chaos");
        GermanSpellerRule.put("[pP]upat\u00e4t", "Pubert\u00e4t");
        GermanSpellerRule.put("\u00fcberwendet", "\u00fcberwindet");
        GermanSpellerRule.put("[bB]esichtung", "Besichtigung");
        GermanSpellerRule.put("[hH]ell?owi[eh]?n", "Halloween");
        GermanSpellerRule.put("geschmelt?zt", "geschmolzen");
        GermanSpellerRule.put("gewunschen", "gew\u00fcnscht");
        GermanSpellerRule.put("bittete", "bat");
        GermanSpellerRule.put("nehm", "nimm");
        GermanSpellerRule.put("m\u00f6chst", "m\u00f6chtest");
        GermanSpellerRule.put("Win", "Windows");
        GermanSpellerRule.put("anschein[dt]", "anscheinend");
        GermanSpellerRule.put("Subvestitionen", "Subventionen");
        GermanSpellerRule.put("angeschaffen", "angeschafft");
        GermanSpellerRule.put("Rechtspruch", "Rechtsspruch");
        GermanSpellerRule.put("Second-Hand", "Secondhand");
        GermanSpellerRule.put("[jJ]ahundert", "Jahrhundert");
        GermanSpellerRule.put("Gesochse", "Gesocks");
        GermanSpellerRule.put("Vorraus", "Voraus");
        GermanSpellerRule.put("[vV]orgensweise", "Vorgehensweise");
        GermanSpellerRule.put("[kK]autsch", "Couch");
        GermanSpellerRule.put("guterletzt", "guter Letzt");
        GermanSpellerRule.put("Seminares", "Seminars");
        GermanSpellerRule.put("Mousepad", "Mauspad");
        GermanSpellerRule.put("Mousepads", "Mauspads");
        GermanSpellerRule.put("Wi[Ff]i-Router", "Wi-Fi-Router");
        GermanSpellerRule.putRepl("[Ll]ilane[srm]?", "ilane[srm]?", "ila");
        GermanSpellerRule.putRepl("[zZ]uguterletzt", "guterletzt", " guter Letzt");
        GermanSpellerRule.putRepl("Nootbooks?", "Noot", "Note");
        GermanSpellerRule.putRepl("[vV]ersendlich(e[mnrs]?)?", "send", "sehent");
        GermanSpellerRule.putRepl("[uU]nf\u00e4h?r(e[mnrs]?)?", "f\u00e4h?r", "fair");
        GermanSpellerRule.putRepl("[mM]edikat\u00f6s(e[mnrs]?)?", "ka", "kamen");
        GermanSpellerRule.putRepl("(ein|zwei|drei|vier|f\u00fcnf|sechs|sieben|acht|neun|zehn|elf|zw\u00f6lf)undhalb", "und", "ein");
        GermanSpellerRule.putRepl("[gG]ro\u00dfz\u00fcge[mnrs]?", "z\u00fcg", "z\u00fcgig");
        GermanSpellerRule.putRepl("[\u00e4\u00c4]rtlich(e[mnrs]?)?", "rt", "rzt");
        GermanSpellerRule.putRepl("[sS]chnelligkeitsfehler[ns]?", "[sS]chnell", "Fl\u00fccht");
        GermanSpellerRule.putRepl("[sS]chweinerosane[mnrs]?", "weinerosane[mnrs]?", "weinchenrosa");
        GermanSpellerRule.putRepl("[aA]nstecklich(e[mnrs]?)?", "lich", "end");
        GermanSpellerRule.putRepl("[gG]eflechtet(e[mnrs]?)?", "flechtet", "flochten");
        GermanSpellerRule.putRepl("[gG]enrealistisch(e[mnrs]?)?", "re", "er");
        GermanSpellerRule.putRepl("\u00fcbertr\u00e4gt(e[mnrs]?)?", "^\u00fcbertr\u00e4gt", "\u00fcbertragen");
        GermanSpellerRule.putRepl("[iI]nterresent(e[mnrs]?)?", "rresent", "ressant");
        GermanSpellerRule.putRepl("Simkartenleser[ns]?", "^Simkartenl", "SIM-Karten-L");
        GermanSpellerRule.putRepl("Hilfstmittel[ns]?", "^Hilfst", "Hilfs");
        GermanSpellerRule.putRepl("trationell(e[mnrs]?)?", "^tra", "tradi");
        GermanSpellerRule.putRepl("[bB]erreichs?", "^[bB]er", "Be");
        GermanSpellerRule.putRepl("[fF]uscher[ns]?", "^[fF]u", "Pfu");
        GermanSpellerRule.putRepl("[uU]nausweichbar(e[mnrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("[uU]nabdinglich(e[mnrs]?)?", "lich", "bar");
        GermanSpellerRule.putRepl("[eE]ing\u00e4nglich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.putRepl("ausgew\u00f6h?nlich(e[mnrs]?)?", "^ausgew\u00f6h?n", "au\u00dfergew\u00f6hn");
        GermanSpellerRule.putRepl("achsial(e[mnrs]?)?", "^achs", "ax");
        GermanSpellerRule.putRepl("famielen?", "^famiel", "Famili");
        GermanSpellerRule.putRepl("miter[ns]?", "^mi", "Mie");
        GermanSpellerRule.putRepl("besig(t(e[mnrs]?)?|en?)", "sig", "sieg");
        GermanSpellerRule.putRepl("[vV]erziehr(t(e[mnrs]?)?|en?)", "ieh", "ie");
        GermanSpellerRule.putRepl("^[pP]iek(s?t|en?)", "iek", "ik");
        GermanSpellerRule.putRepl("[mM]atschscheiben?", "[mM]atschsch", "Mattsch");
        GermanSpellerRule.put("schafen?", (String w) -> Arrays.asList(w.replaceFirst("sch", "schl"), w.replaceFirst("af", "arf"), w.replaceFirst("af", "aff")));
        GermanSpellerRule.put("zuschafen", "zu schaffen");
        GermanSpellerRule.putRepl("[hH]ofen?", "of", "off");
        GermanSpellerRule.putRepl("[sS]ommerverien?", "[sS]ommerverien?", "Sommerferien");
        GermanSpellerRule.putRepl("[rR]ecourcen?", "[rR]ec", "Ress");
        GermanSpellerRule.putRepl("[fF]amm?ill?i?[a\u00e4]risch(e[mnrs]?)?", "amm?ill?i?[a\u00e4]risch", "amili\u00e4r");
        GermanSpellerRule.putRepl("Sim-Karten?", "^Sim", "SIM");
        GermanSpellerRule.putRepl("Spax-Schrauben?", "^Spax", "SPAX");
        GermanSpellerRule.putRepl("[aA]leine", "l", "ll");
        GermanSpellerRule.putRepl("Kaput", "t", "tt");
        GermanSpellerRule.putRepl("[fF]estell(s?t|en?)", "est", "estst");
        GermanSpellerRule.putRepl("[Ee]igtl", "igtl", "igtl.");
        GermanSpellerRule.putRepl("(Baden-)?W\u00fcrtenbergs?", "W\u00fcrten", "W\u00fcrttem");
        GermanSpellerRule.putRepl("Betriebsratzimmer[ns]?", "rat", "rats");
        GermanSpellerRule.putRepl("Rechts?schreibungsfehler[ns]?", "Rechts?schreibungs", "Rechtschreib");
        GermanSpellerRule.putRepl("Open[aA]ir-Konzert(en?)?", "Open[aA]ir", "Open-Air");
        GermanSpellerRule.putRepl("Jugenschuhen?", "Jug", "Jung");
        GermanSpellerRule.putRepl("TODO-Listen?", "TODO", "To-do");
        GermanSpellerRule.putRepl("ausiehs?t", "aus", "auss");
        GermanSpellerRule.putRepl("unterbemittel(nd|t)(e[nmrs]?)?", "unterbemittel(nd|t)", "minderbemittelt");
        GermanSpellerRule.putRepl("[xX]te[mnrs]?", "te", "-te");
        GermanSpellerRule.putRepl("verheielt(e[mnrs]?)?", "heiel", "heil");
        GermanSpellerRule.putRepl("[rR]evolutionie?sier(s?t|en?)", "ie?s", "");
        GermanSpellerRule.putRepl("Kohleaustiegs?", "aus", "auss");
        GermanSpellerRule.putRepl("[jJ]urististisch(e[mnrs]?)?", "istist", "ist");
        GermanSpellerRule.putRepl("geh\u00e4ckelt(e[nmrs]?)?", "ck", "k");
        GermanSpellerRule.putRepl("deutsprachig(e[nmrs]?)?", "deut", "deutsch");
        GermanSpellerRule.putRepl("angesehend(st)?e[nmrs]?", "end", "en");
        GermanSpellerRule.putRepl("[iI]slamophobisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[vV]erharkt(e[mnrs]?)?", "ar", "a");
        GermanSpellerRule.putRepl("[dD]es\u00f6fterer?[nm]", "\u00f6fterer?[nm]", " \u00d6fteren");
        GermanSpellerRule.putRepl("[dD]eswei[dt]ere?[mn]", "wei[dt]ere?[mn]", " Weiteren");
        GermanSpellerRule.putRepl("Einkaufstachen?", "ch", "sch");
        GermanSpellerRule.putRepl("Bortmesser[ns]?", "Bor", "Bro");
        GermanSpellerRule.putRepl("Makeupstylist(in(nen)?|en)?", "Makeups", "Make-up-S");
        GermanSpellerRule.putRepl("Fee?db\u00e4cks?", "Fee?db\u00e4ck", "Feedback");
        GermanSpellerRule.putRepl("weirete[nmrs]?", "ret", "ter");
        GermanSpellerRule.putRepl("Ni[vw]oschalter[ns]?", "Ni[vw]o", "Niveau");
        GermanSpellerRule.putRepl("[eE]xhibitionisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("(ein|aus)?[gG]eschalten(e[nmrs]?)?", "ten", "tet");
        GermanSpellerRule.putRepl("[uU]nterschiebene[nmrs]?", "sch", "schr");
        GermanSpellerRule.putRepl("[uU]nbequemlich(st)?e[nmrs]?", "lich", "");
        GermanSpellerRule.putRepl("[uU][nm]bekweh?m(e[nmrs]?)?", "[nm]bekweh?m", "nbequem");
        GermanSpellerRule.putRepl("[dD]esat\u00f6r(s|en?)?", "sat\u00f6r", "serteur");
        GermanSpellerRule.put("Panelen?", (String w) -> Arrays.asList(w.replaceFirst("Panel", "Paneel"), "Panels"));
        GermanSpellerRule.put("D[e\u00e8\u00e9]ja-?[vV]o?ue?", "D\u00e9j\u00e0-vu");
        GermanSpellerRule.put("Cr[e\u00e8\u00e9]me-?fra[i\u00ee]che", "Cr\u00e8me fra\u00eeche");
        GermanSpellerRule.put("[aA]rr?an?gemont", "Arrangement");
        GermanSpellerRule.put("[aA]ngagemon", "Engagement");
        GermanSpellerRule.put("Phyrr?ussieg", "Pyrrhussieg");
        GermanSpellerRule.put("Mio", "Mio.");
        GermanSpellerRule.put("Datein", "Dateien");
        GermanSpellerRule.put("[pP]u(zz|ss)el", "Puzzle");
        GermanSpellerRule.put("Smilies", "Smileys");
        GermanSpellerRule.put("[dD]iseing?", "Design");
        GermanSpellerRule.put("[lL]ieradd?ress?e", "Lieferadresse");
        GermanSpellerRule.put("[bB]o[yi]kutierung", "Boykottierung");
        GermanSpellerRule.put("Mouseclick", "Mausklick");
        GermanSpellerRule.put("[aA]ktuelli?esie?rung", "Aktualisierung");
        GermanSpellerRule.put("H\u00e4ndy", "Handy");
        GermanSpellerRule.put("gewertsch\u00e4tzt", "wertgesch\u00e4tzt");
        GermanSpellerRule.put("tieger", "Tiger");
        GermanSpellerRule.put("Rollade", (String w) -> Arrays.asList("Rollladen", "Roulade"));
        GermanSpellerRule.put("garnichtmehr", "gar nicht mehr");
        GermanSpellerRule.put("vileich", "vielleicht");
        GermanSpellerRule.put("vll?t", "vielleicht");
        GermanSpellerRule.put("aufgew\u00e4gt", "aufgewogen");
        GermanSpellerRule.put("[rR]eflektion", "Reflexion");
        GermanSpellerRule.put("momentmal", "Moment mal");
        GermanSpellerRule.put("satzt", "Satz");
        GermanSpellerRule.put("B\u00fcff?(ee|\u00e9)", (String w) -> Arrays.asList("Buffet", "B\u00fcfett"));
        GermanSpellerRule.put("[fF]r\u00fchst\u00fccksb[u\u00fc]ff?(\u00e9|ee)", "Fr\u00fchst\u00fccksbuffet");
        GermanSpellerRule.put("[aA]lterego", "Alter Ego");
        GermanSpellerRule.put("Copyride", "Copyright");
        GermanSpellerRule.put("Analysierung", "Analyse");
        GermanSpellerRule.put("Exel", "Excel");
        GermanSpellerRule.put("Gl\u00fccklichkeit", "Gl\u00fcck");
        GermanSpellerRule.put("Begierigkeit", "Begierde");
        GermanSpellerRule.put("voralem", "vor allem");
        GermanSpellerRule.put("Unorganisation", (String w) -> Arrays.asList("Desorganisation", "Unorganisiertheit"));
        GermanSpellerRule.put("Cand(el|le)lightdinner", "Candle-Light-Dinner");
        GermanSpellerRule.put("wertgelegt", "Wert gelegt");
        GermanSpellerRule.put("antuhen", "antun");
        GermanSpellerRule.put("komen", "kommen");
        GermanSpellerRule.put("geni\u00dfen", "genie\u00dfen");
        GermanSpellerRule.put("Stationskrankenpflegerin", "Stationsschwester");
        GermanSpellerRule.put("[iI\u00fc\u00dcuU]b[ea]w[ae]isung", "\u00dcberweisung");
        GermanSpellerRule.put("[bB]oxhorn", "Bockshorn");
        GermanSpellerRule.put("[zZ]oolophie", "Zoophilie");
        GermanSpellerRule.put("Makieren", "Markieren");
        GermanSpellerRule.put("Altersheimer", "Alzheimer");
        GermanSpellerRule.put("gesen", "gesehen");
        GermanSpellerRule.put("Neugierigkeit", (String w) -> Arrays.asList("Neugier", "Neugierde"));
        GermanSpellerRule.put("[kK]onn?ekt?schen", "Connection");
        GermanSpellerRule.put("E-Maul", "E-Mail");
        GermanSpellerRule.put("E-Mauls", "E-Mails");
        GermanSpellerRule.put("E-Mal", "E-Mail");
        GermanSpellerRule.put("E-Mals", "E-Mails");
        GermanSpellerRule.put("[nN]ah?richt", "Nachricht");
        GermanSpellerRule.put("[nN]ah?richten", "Nachrichten");
        GermanSpellerRule.put("Getrixe", "Getrickse");
        GermanSpellerRule.put("Ausage", "Aussage");
        GermanSpellerRule.put("gelessen", "gelesen");
        GermanSpellerRule.put("Kanst", "Kannst");
        GermanSpellerRule.put("Unwohlbefinden", "Unwohlsein");
        GermanSpellerRule.put("leiwagen", "Leihwagen");
        GermanSpellerRule.put("krahn", "Kran");
        GermanSpellerRule.put("[hH]ifi", "Hi-Fi");
        GermanSpellerRule.put("chouch", "Couch");
        GermanSpellerRule.put("eh?rgeit?z", "Ehrgeiz");
        GermanSpellerRule.put("solltes", "solltest");
        GermanSpellerRule.put("geklabt", "geklappt");
        GermanSpellerRule.put("angefangt", "angefangen");
        GermanSpellerRule.put("beinh\u00e4lt", "beinhaltet");
        GermanSpellerRule.put("beinhielt", "beinhaltete");
        GermanSpellerRule.put("beinhielten", "beinhalteten");
        GermanSpellerRule.put("einhaltest", "einh\u00e4ltst");
        GermanSpellerRule.put("angeruft", "angerufen");
        GermanSpellerRule.put("erhaltete", "erhielt");
        GermanSpellerRule.put("\u00fcbers\u00e4ht", "\u00fcbers\u00e4t");
        GermanSpellerRule.put("staats?angehoe?rigkeit", "Staatsangeh\u00f6rigkeit");
        GermanSpellerRule.put("[uU]nangeneh?mheiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Humuspaste", "Hummuspaste");
        GermanSpellerRule.put("afarung", "Erfahrung");
        GermanSpellerRule.put("bescheid?t", "Bescheid");
        GermanSpellerRule.put("[mM]iteillung", "Mitteilung");
        GermanSpellerRule.put("Revisionierung", "Revision");
        GermanSpellerRule.put("[eE]inf\u00fchlverm\u00f6gen", "Einf\u00fchlungsverm\u00f6gen");
        GermanSpellerRule.put("[sS]peziellisierung", "Spezialisierung");
        GermanSpellerRule.put("[cC]hangse", "Chance");
        GermanSpellerRule.put("untergangen", "untergegangen");
        GermanSpellerRule.put("geliegt", "gelegen");
        GermanSpellerRule.put("BluRay", "Blu-ray");
        GermanSpellerRule.put("Freiwilligerin", "Freiwillige");
        GermanSpellerRule.put("Mitgliederinnen", (String w) -> Arrays.asList("Mitglieder", "Mitgliedern"));
        GermanSpellerRule.put("Hautreinheiten", "Hautunreinheiten");
        GermanSpellerRule.put("Durf\u00fch?rung", "Durchf\u00fchrung");
        GermanSpellerRule.put("tuhen", "tun");
        GermanSpellerRule.put("tuhe", "tue");
        GermanSpellerRule.put("tip", "Tipp");
        GermanSpellerRule.put("ccm", "cm\u00b3");
        GermanSpellerRule.put("Kilimand?jaro", "Kilimandscharo");
        GermanSpellerRule.put("[hH]erausfor?dung", "Herausforderung");
        GermanSpellerRule.put("[bB]er\u00fccksichtung", "Ber\u00fccksichtigung");
        GermanSpellerRule.put("artzt?", "Arzt");
        GermanSpellerRule.put("[tT]h?elepath?ie", "Telepathie");
        GermanSpellerRule.put("Wi-?Fi-Dire[ck]t", "Wi-Fi Direct");
        GermanSpellerRule.put("gans", "ganz");
        GermanSpellerRule.put("Pearl-Harbou?r", "Pearl Harbor");
        GermanSpellerRule.put("[aA]utonomit\u00e4t", "Autonomie");
        GermanSpellerRule.put("[fF]r[u\u00fc]h?st[u\u00fc]c?k", "Fr\u00fchst\u00fcck");
        GermanSpellerRule.putRepl("(ge)?fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr\u00fchst\u00fcckt");
        GermanSpellerRule.put("zucc?h?inis?", "Zucchini");
        GermanSpellerRule.put("[mM]itag", "Mittag");
        GermanSpellerRule.put("Lexion", "Lexikon");
        GermanSpellerRule.put("[mM]otorisation", "Motorisierung");
        GermanSpellerRule.put("[fF]ormalisation", "Formalisierung");
        GermanSpellerRule.put("ausprache", "Aussprache");
        GermanSpellerRule.put("[mM]enegment", "Management");
        GermanSpellerRule.put("[gG]ebrauspuren", "Gebrauchsspuren");
        GermanSpellerRule.put("viedeo", "Video");
        GermanSpellerRule.put("[hH]erstammung", "Abstammung");
        GermanSpellerRule.put("[iI]nstall?at\u00f6r", "Installateur");
        GermanSpellerRule.put("maletriert", "maltr\u00e4tiert");
        GermanSpellerRule.put("abgeschaffen", "abgeschafft");
        GermanSpellerRule.put("Verschiden", "Verschieden");
        GermanSpellerRule.put("Anschovis", "Anchovis");
        GermanSpellerRule.put("Bravur", "Bravour");
        GermanSpellerRule.put("Grisli", "Grizzly");
        GermanSpellerRule.put("Grislib\u00e4r", "Grizzlyb\u00e4r");
        GermanSpellerRule.put("Grislib\u00e4ren", "Grizzlyb\u00e4ren");
        GermanSpellerRule.put("Frott\u00e9", "Frottee");
        GermanSpellerRule.put("Joga", "Yoga");
        GermanSpellerRule.put("Kalvinismus", "Calvinismus");
        GermanSpellerRule.put("Kollier", "Collier");
        GermanSpellerRule.put("Kolliers", "Colliers");
        GermanSpellerRule.put("Ketschup", "Ketchup");
        GermanSpellerRule.put("Kommunikee", "Kommuniqu\u00e9");
        GermanSpellerRule.put("Negligee", "Neglig\u00e9");
        GermanSpellerRule.put("Nessess\u00e4r", "Necessaire");
        GermanSpellerRule.put("passee", "pass\u00e9");
        GermanSpellerRule.put("Varietee", "Variet\u00e9");
        GermanSpellerRule.put("Varietees", "Variet\u00e9s");
        GermanSpellerRule.put("Wandalismus", "Vandalismus");
        GermanSpellerRule.put("Campagne", "Kampagne");
        GermanSpellerRule.put("Campagnen", "Kampagnen");
        GermanSpellerRule.put("Jockei", "Jockey");
        GermanSpellerRule.put("Roulett", "Roulette");
        GermanSpellerRule.put("Bestellungsdaten", "Bestelldaten");
        GermanSpellerRule.put("Package", "Paket");
        GermanSpellerRule.put("E-mail", "E-Mail");
        GermanSpellerRule.put("geleased", "geleast");
        GermanSpellerRule.put("released", "releast");
        GermanSpellerRule.putRepl("Ballets?", "llet", "llett");
        GermanSpellerRule.putRepl("Saudiarabiens?", "Saudiarabien", "Saudi-Arabien");
        GermanSpellerRule.putRepl("eMail-Adressen?", "eMail-", "E-Mail-");
        GermanSpellerRule.putRepl("[Ww]ieviele?", "ieviel", "ie viel");
        GermanSpellerRule.putRepl("[Aa]dhoc", "dhoc", "d hoc");
        GermanSpellerRule.put("As", "Ass");
        GermanSpellerRule.put("[bB]i[s\u00df](s?[ij]|ch)en", "bisschen");
        GermanSpellerRule.putRepl("Todos?", "Todo", "To-do");
        GermanSpellerRule.put("Kovult", "Konvolut");
        GermanSpellerRule.putRepl("blog(t?en?|t(es?t)?)$", "g", "gg");
        GermanSpellerRule.put("Zombiefizierungen", "Zombifizierungen");
        GermanSpellerRule.put("Tret", (String w) -> Arrays.asList("Tritt", "Trete", "Trat"));
        GermanSpellerRule.put("H\u00fchne", (String w) -> Arrays.asList("B\u00fchne", "H\u00fcne", "H\u00fchner"));
        GermanSpellerRule.put("H\u00fchnen", (String w) -> Arrays.asList("B\u00fchnen", "H\u00fcnen", "H\u00fchnern"));
        GermanSpellerRule.put("tiptop", "tiptopp");
        GermanSpellerRule.put("Briese", "Brise");
        GermanSpellerRule.put("Rechtsschreibreformen", "Rechtschreibreformen");
        GermanSpellerRule.putRepl("gewertsch\u00e4tzte(([mnrs]|re[mnrs]?)?)$", "gewertsch\u00e4tzt", "wertgesch\u00e4tzt");
        GermanSpellerRule.putRepl("knapps(t?en?|t(es?t)?)$", "pp", "p");
        GermanSpellerRule.put("geknappst", "geknapst");
        GermanSpellerRule.putRepl("gepiekste[mnrs]?$", "ie", "i");
        GermanSpellerRule.putRepl("Yings?", "ng", "n");
        GermanSpellerRule.put("Wiederstandes", "Widerstandes");
        GermanSpellerRule.putRepl("veganisch(e?[mnrs]?)$", "isch", "");
        GermanSpellerRule.putRepl("totlangweiligste[mnrs]?$", "tot", "tod");
        GermanSpellerRule.putRepl("tottraurigste[mnrs]?$", "tot", "tod");
        GermanSpellerRule.putRepl("kreir(n|e?nd)(e[mnrs]?)?$", "ire?n", "ieren");
        GermanSpellerRule.putRepl("Pepps?", "pp", "p");
        GermanSpellerRule.putRepl("Pariahs?", "h", "");
        GermanSpellerRule.putRepl("Oeuvres?", "Oe", "\u0152");
        GermanSpellerRule.put("Margarite", "Margerite");
        GermanSpellerRule.put("K\u00fccken", (String w) -> Arrays.asList("R\u00fccken", "K\u00fcken"));
        GermanSpellerRule.put("Kompanten", (String w) -> Arrays.asList("Kompasse", "Kompassen"));
        GermanSpellerRule.put("Kandarren", "Kandaren");
        GermanSpellerRule.put("kniehen", "knien");
        GermanSpellerRule.putRepl("infisziertes?t$", "fisz", "fiz");
        GermanSpellerRule.putRepl("Imbusse(n|s)?$", "m", "n");
        GermanSpellerRule.put("Hollundern", "Holundern");
        GermanSpellerRule.putRepl("handgehabt(e?[mnrs]?)?$", "handgehabt", "gehandhabt");
        GermanSpellerRule.put("Funieres", "Furniers");
        GermanSpellerRule.put("Frohndiensts", "Frondiensts");
        GermanSpellerRule.put("fith\u00e4lst", "fit h\u00e4ltst");
        GermanSpellerRule.putRepl("fitzuhalten(de?[mnrs]?)?$", "fitzuhalten", "fit zu halten");
        GermanSpellerRule.putRepl("(essen|schlafen|schwimmen|spazieren)zugehen$", "zugehen", " zu gehen");
        GermanSpellerRule.put("dilettant", (String w) -> Arrays.asList("Dilettant", "dilettantisch"));
        GermanSpellerRule.putRepl("dilettante[mnrs]?$", "te", "tische");
        GermanSpellerRule.put("Disastern", "Desastern");
        GermanSpellerRule.putRepl("Brandwein(en?|s)$", "d", "nt");
        GermanSpellerRule.putRepl("B\u00f6hen?$", "h", "");
        GermanSpellerRule.putRepl("Aufst\u00e4ndige[mnr]?$", "ig", "isch");
        GermanSpellerRule.putRepl("aufst\u00e4ndig(e[mnrs]?)?$", "ig", "isch");
        GermanSpellerRule.putRepl("duzend(e[mnrs]?)?$", "uzend", "utzend");
        GermanSpellerRule.putRepl("unrelevant(e[mnrs]?)?$", "un", "ir");
        GermanSpellerRule.putRepl("Unrelevant(e[mnrs]?)?$", "Un", "Ir");
        GermanSpellerRule.put("aufgrundedessen", "aufgrund dessen");
        GermanSpellerRule.put("Amalgane", "Amalgame");
        GermanSpellerRule.put("Kafe", (String w) -> Arrays.asList("Kaffee", "Caf\u00e9"));
        GermanSpellerRule.put("Dammbock", (String w) -> Arrays.asList("Dambock", "Rammbock"));
        GermanSpellerRule.put("Dammhirsch", "Damhirsch");
        GermanSpellerRule.put("Fairnis", "Fairness");
        GermanSpellerRule.put("auschluss", (String w) -> Arrays.asList("Ausschluss", "Ausschuss"));
        GermanSpellerRule.put("derikter", (String w) -> Arrays.asList("direkter", "Direktor"));
        GermanSpellerRule.put("[iI]dentifierung", "Identifikation");
        GermanSpellerRule.put("[eE]mphatie", "Empathie");
        GermanSpellerRule.put("[eE]iskrem", "Eiscreme");
        GermanSpellerRule.put("[fF]l\u00fcchtung", "Flucht");
        GermanSpellerRule.put("einamen", "Einnahmen");
        GermanSpellerRule.put("[eE]inbu(ss|\u00df)ung", "Einbu\u00dfe");
        GermanSpellerRule.put("[eE]inbu(ss|\u00df)ungen", "Einbu\u00dfen");
        GermanSpellerRule.put("nachichten", "Nachrichten");
        GermanSpellerRule.put("gegehen", "gegangen");
        GermanSpellerRule.put("Ethnocid", "Ethnozid");
        GermanSpellerRule.put("Exikose", "Exsikkose");
        GermanSpellerRule.put("Schonverm\u00f6gengrenze", "Schonverm\u00f6gensgrenze");
        GermanSpellerRule.put("kontest", "konntest");
        GermanSpellerRule.put("pitza", "Pizza");
        GermanSpellerRule.put("T\u00fct\u00fc", "Tutu");
        GermanSpellerRule.put("gebittet", "gebeten");
        GermanSpellerRule.put("gekricht", "gekriegt");
        GermanSpellerRule.put("Krankenheit", "Krankheit");
        GermanSpellerRule.put("Krankenheiten", "Krankheiten");
        GermanSpellerRule.put("[hH]udd[yi]", "Hoodie");
        GermanSpellerRule.put("Treibel", "Tribal");
        GermanSpellerRule.put("vorort", "vor Ort");
        GermanSpellerRule.put("Brotw\u00fcrfelcro[u\u00fb]tons", "Cro\u00fbtons");
        GermanSpellerRule.put("bess?tetigung", "Best\u00e4tigung");
        GermanSpellerRule.put("[mM]ayonaisse", "Mayonnaise");
        GermanSpellerRule.put("misverstaendnis", "Missverst\u00e4ndnis");
        GermanSpellerRule.put("[vV]erlu(ss|\u00df)t", "Verlust");
        GermanSpellerRule.put("gl\u00fcckigerweise", "gl\u00fccklicherweise");
        GermanSpellerRule.put("[sS]tandtart", "Standard");
        GermanSpellerRule.put("Mainzerstrasse", "Mainzer Stra\u00dfe");
        GermanSpellerRule.put("Genehmigerablauf", "Genehmigungsablauf");
        GermanSpellerRule.put("Bestellerurkunde", "Bestellungsurkunde");
        GermanSpellerRule.put("Selbstmitleidigkeit", "Selbstmitleid");
        GermanSpellerRule.put("[iI]ntuion", "Intuition");
        GermanSpellerRule.put("[cCkK]ontener", "Container");
        GermanSpellerRule.put("Barcadi", "Bacardi");
        GermanSpellerRule.put("Unnanehmigkeit", "Unannehmlichkeit");
        GermanSpellerRule.put("[wW]ischm\u00f6ppen?", "Wischmopps");
        GermanSpellerRule.putRepl("[oO]rdnungswiedrichkeit(en)?", "[oO]rdnungswiedrich", "Ordnungswidrig");
        GermanSpellerRule.putRepl("Mauntenbiker[ns]?", "^Maunten", "Mountain");
        GermanSpellerRule.putRepl("Mauntenbikes?", "Maunten", "Mountain");
        GermanSpellerRule.putRepl("[nN]euhichkeit(en)?", "[nN]euhich", "Neuig");
        GermanSpellerRule.putRepl("Prokopfverbrauchs?", "Prokopfv", "Pro-Kopf-V");
        GermanSpellerRule.putRepl("[Gg]ilst", "ilst", "iltst");
        GermanSpellerRule.putRepl("[vV]ollrichtung(en)?", "[vV]oll", "Ver");
        GermanSpellerRule.putRepl("[vV]ollrichtest", "oll", "er");
        GermanSpellerRule.putRepl("[vV]ollrichten?", "oll", "er");
        GermanSpellerRule.putRepl("[vV]ollrichtet(e([mnrs])?)?", "oll", "er");
        GermanSpellerRule.putRepl("[bB]edingslos(e([mnrs])?)?", "ding", "dingung");
        GermanSpellerRule.putRepl("[eE]insichtbar(e[mnrs]?)?", "sicht", "seh");
        GermanSpellerRule.putRepl("asymetrisch(ere|ste)[mnrs]?$", "ym", "ymm");
        GermanSpellerRule.putRepl("alterw\u00fcrdig(ere|ste)[mnrs]?$", "lter", "ltehr");
        GermanSpellerRule.putRepl("aufst\u00e4ndig(ere|ste)[mnrs]?$", "ig", "isch");
        GermanSpellerRule.putRepl("blutdurstig(ere|ste)[mnrs]?$", "ur", "\u00fcr");
        GermanSpellerRule.putRepl("dilettant(ere|este)[mnrs]?$", "nt", "ntisch");
        GermanSpellerRule.putRepl("eliptisch(ere|ste)[mnrs]?$", "l", "ll");
        GermanSpellerRule.putRepl("angegr\u00f6hlt(e([mnrs])?)?$", "\u00f6h", "\u00f6");
        GermanSpellerRule.putRepl("gothisch(ere|ste)[mnrs]?$", "th", "t");
        GermanSpellerRule.putRepl("kollossal(ere|ste)[mnrs]?$", "ll", "l");
        GermanSpellerRule.putRepl("paralel(lere|lste)[mnrs]?$", "paralel", "paralle");
        GermanSpellerRule.putRepl("symetrischste[mnrs]?$", "ym", "ymm");
        GermanSpellerRule.putRepl("rethorisch(ere|ste)[mnrs]?$", "rethor", "rhetor");
        GermanSpellerRule.putRepl("repetativ(ere|ste)[mnrs]?$", "repetat", "repetit");
        GermanSpellerRule.putRepl("volupt\u00f6s(e|ere|este)?[mnrs]?$", "t\u00f6s", "tu\u00f6s");
        GermanSpellerRule.putRepl("[pP]flanzig(e[mnrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("geblogt(e[mnrs]?)?$", "gt", "ggt");
        GermanSpellerRule.putRepl("herraus.*", "herraus", "heraus");
        GermanSpellerRule.putRepl("[aA]bbonier(en?|s?t|te[mnrst]?)", "bbo", "bon");
        GermanSpellerRule.putRepl("[aA]pelier(en?|s?t|te[nt]?)", "pel", "ppell");
        GermanSpellerRule.putRepl("[vV]oltie?schier(en?|s?t|te[nt]?)", "ie?sch", "ig");
        GermanSpellerRule.putRepl("[mM]eistverkaufteste[mnrs]?", "teste", "te");
        GermanSpellerRule.putRepl("[uU]nleshaft(e[mnrs]?)?", "haft", "erlich");
        GermanSpellerRule.putRepl("[gG]laubensw\u00fcrdig(e[mnrs]?)?", "ens", "");
        GermanSpellerRule.putRepl("[nN]i[vw]ovoll(e[mnrs]?)?", "[vw]ovoll", "veauvoll");
        GermanSpellerRule.putRepl("[nN]otgezwungend?(e[mnrs]?)?", "zwungend?", "drungen");
        GermanSpellerRule.putRepl("[mM]isstraurig(e[mnrs]?)?", "rig", "isch");
        GermanSpellerRule.putRepl("[iI]nflagrantie?", "flagrantie?", " flagranti");
        GermanSpellerRule.putRepl("Aux-Anschl(uss(es)?|\u00fcssen?)", "Aux", "AUX");
        GermanSpellerRule.putRepl("desinfektiert(e[mnrs]?)?", "fekt", "fiz");
        GermanSpellerRule.putRepl("desinfektierend(e[mnrs]?)?", "fekt", "fiz");
        GermanSpellerRule.putRepl("desinfektieren?", "fekt", "fiz");
        GermanSpellerRule.putRepl("[dD]esinfektionier(en?|t(e[mnrs]?)?|st)", "fektionier", "fizier");
        GermanSpellerRule.putRepl("[dD]esinfektionierend(e[mnrs]?)?", "fektionier", "fizier");
        GermanSpellerRule.putRepl("[kK]ompensionier(en?|t(e[mnrs]?)?|st)", "ion", "");
        GermanSpellerRule.putRepl("neuliche[mnrs]?", "neu", "neuer");
        GermanSpellerRule.putRepl("ausb\u00fcchsen?", "chs", "x");
        GermanSpellerRule.putRepl("aus(ge)?b\u00fcchst(en?)?", "chs", "x");
        GermanSpellerRule.putRepl("innoff?iziell?(e[mnrs]?)?", "innoff?iziell?", "inoffiziell");
        GermanSpellerRule.putRepl("[gG]roesste[mnrs]?", "oess", "\u00f6\u00df");
        GermanSpellerRule.putRepl("[tT]efonisch(e[mnrs]?)?", "efon", "elefon");
        GermanSpellerRule.putRepl("[oO]ptimalisiert", "alis", "");
        GermanSpellerRule.putRepl("[iI]ntrovertisch(e[mnrs]?)?", "isch", "iert");
        GermanSpellerRule.putRepl("[aA]miert(e[mnrs]?)?", "mi", "rmi");
        GermanSpellerRule.putRepl("[vV]ersiehrt(e[mnrs]?)?", "h", "");
        GermanSpellerRule.putRepl("[dD]urchsichtbar(e[mnrs]?)?", "bar", "ig");
        GermanSpellerRule.putRepl("[oO]ffensichtig(e[mnrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[zZ]urverf\u00fchgung", "verf\u00fchgung", " Verf\u00fcgung");
        GermanSpellerRule.putRepl("[sS]pendeangebot(e[ns]?)?", "[sS]pende", "Spenden");
        GermanSpellerRule.putRepl("gahrnichts?", "gahr", "gar ");
        GermanSpellerRule.putRepl("[aA]ugensichtlich(e[mnrs]?)?", "sicht", "schein");
        GermanSpellerRule.putRepl("[lL]eidensvoll(e[mnrs]?)?", "ens", "");
        GermanSpellerRule.putRepl("[bB]ewusstlich(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[vV]erschmerzlich(e[mnrs]?)?", "lich", "bar");
        GermanSpellerRule.putRepl("Krankenbruders?", "bruder", "pfleger");
        GermanSpellerRule.putRepl("Krankenbr\u00fcdern?", "br\u00fcder", "pfleger");
        GermanSpellerRule.putRepl("Lan-(Kabel[ns]?|Verbindung)", "Lan", "LAN");
        GermanSpellerRule.putRepl("[sS]epalastschriftmandat(s|en?)?", "[sS]epal", "SEPA-L");
        GermanSpellerRule.putRepl("Pinn?eingaben?", "Pinn?e", "PIN-E");
        GermanSpellerRule.putRepl("[sS]imkarten?", "[sS]imk", "SIM-K");
        GermanSpellerRule.putRepl("[vV]orsich(geht|gehen|ging(en)?|gegangen)", "sich", " sich ");
        GermanSpellerRule.putRepl("mitsich(bringt|bringen|brachten?|gebracht)", "sich", " sich ");
        GermanSpellerRule.putRepl("[ck]arnivorisch(e[mnrs]?)?", "[ck]arnivorisch", "karnivor");
        GermanSpellerRule.putRepl("[pP]erfektest(e[mnrs]?)?", "est", "");
        GermanSpellerRule.putRepl("[gG]leichtig(e[mnrs]?)?", "tig", "zeitig");
        GermanSpellerRule.putRepl("[uU]n(her)?vorgesehen(e[mnrs]?)?", "(her)?vor", "vorher");
        GermanSpellerRule.putRepl("([cC]orona|[gG]rippe)viruss?es", "viruss?es", "virus");
        GermanSpellerRule.putRepl("Zaubererin(nen)?", "er", "");
        GermanSpellerRule.putRepl("Second-Hand-L[\u00e4a]dens?", "Second-Hand-L", "Secondhandl");
        GermanSpellerRule.putRepl("Second-Hand-Shops?", "Second-Hand-S", "Secondhands");
        GermanSpellerRule.putRepl("[mM]editerranisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("interplementier(s?t|en?)", "inter", "im");
        GermanSpellerRule.putRepl("[hH]ochalterlich(e[mnrs]?)?", "alter", "mittelalter");
        GermanSpellerRule.putRepl("posiniert(e[mnrs]?)?", "si", "sitio");
        GermanSpellerRule.putRepl("[rR]ussophobisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[uU]nsachm\u00e4(\u00df|ss?)ig(e[mnrs]?)?", "m\u00e4(\u00df|ss?)ig", "gem\u00e4\u00df");
        GermanSpellerRule.putRepl("[mM]odernisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("intapretation(en)?", "inta", "Inter");
        GermanSpellerRule.putRepl("[rR]ethorikkurs(e[ns]?)?", "eth", "het");
        GermanSpellerRule.putRepl("[uU]nterschreibungsf\u00e4hig(e[mnrs]?)?", "schreibung", "schrift");
        GermanSpellerRule.putRepl("[eE]rrorier(en?|t(e[mnrs]?)?|st)", "ror", "u");
        GermanSpellerRule.putRepl("malediert(e[mnrs]?)?", "malediert", "maltr\u00e4tiert");
        GermanSpellerRule.putRepl("maletriert(e[mnrs]?)?", "maletriert", "maltr\u00e4tiert");
        GermanSpellerRule.putRepl("Ausbildereignerpr\u00fcfung(en)?", "eigner", "eignungs");
        GermanSpellerRule.putRepl("abtrakt(e[mnrs]?)?", "ab", "abs");
        GermanSpellerRule.putRepl("unerfolgreich(e[mnrs]?)?", "unerfolgreich", "erfolglos");
        GermanSpellerRule.putRepl("[bB]attalion(en?|s)?", "[bB]attalion", "Bataillon");
        GermanSpellerRule.putRepl("[bB]esuchungsverbot(e[ns]?)?", "ung", "");
        GermanSpellerRule.putRepl("sp\u00e4trig(e[mnrs]?)?", "rig", "er");
        GermanSpellerRule.putRepl("angehangene[mnrs]?", "hangen", "h\u00e4ngt");
        GermanSpellerRule.putRepl("[ck]amel[ie]onhaft(e[mnrs]?)?", "[ck]am[ie]lion", "cham\u00e4leon");
        GermanSpellerRule.putRepl("[wW]iderspr\u00fcchig(e[mnrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[fF]austig(e[mnrs]?)?", "austig", "austdick");
        GermanSpellerRule.putRepl("Belastungsekgs?", "ekg", "-EKG");
        GermanSpellerRule.putRepl("gehardcode[dt](e[mnrs]?)?", "gehardcode", "hartkodier");
        GermanSpellerRule.putRepl("hardgecode[dt](e[mnrs]?)?", "gehardcode", "hartkodier");
        GermanSpellerRule.putRepl("Flektion(en)?", "Flektion", "Flexion");
        GermanSpellerRule.putRepl("Off-[Ss]hore-[A-Z].+", "Off-[Ss]hore-", "Offshore");
        GermanSpellerRule.put("Deis", "Dies");
        GermanSpellerRule.put("fr", "f\u00fcr");
        GermanSpellerRule.put("abe", (String w) -> Arrays.asList("habe", "aber", "ab"));
        GermanSpellerRule.put("Oster", (String w) -> Arrays.asList("Ostern", "Osten"));
        GermanSpellerRule.put("richen", (String w) -> Arrays.asList("riechen", "reichen", "richten"));
        GermanSpellerRule.put("deien", (String w) -> Arrays.asList("deine", "dein"));
        GermanSpellerRule.put("meien", (String w) -> Arrays.asList("meine", "mein", "meinen"));
        GermanSpellerRule.put("ber\u00fcht", (String w) -> Arrays.asList("ber\u00fchmt", "ber\u00fchrt", "bem\u00fcht"));
        GermanSpellerRule.put("herlich", (String w) -> Arrays.asList("ehrlich", "herrlich"));
        GermanSpellerRule.put("erzeiht", (String w) -> Arrays.asList("erzieht", "verzeiht"));
        GermanSpellerRule.put("schalfen", (String w) -> Arrays.asList("schlafen", "schaffen", "scharfen"));
        GermanSpellerRule.put("Anfage", (String w) -> Arrays.asList("Anfrage", "Anlage"));
        GermanSpellerRule.put("geh\u00f6r", (String w) -> Arrays.asList("geh\u00f6rt", "Geh\u00f6r", "geh\u00f6re"));
        GermanSpellerRule.put("Sep", (String w) -> Arrays.asList("Sepp", "Sept.", "September", "Separator", "Sei"));
        GermanSpellerRule.put("Formulares", "Formulars");
        GermanSpellerRule.put("Danl", "Dank");
        GermanSpellerRule.put("umbennen", "umbenennen");
        GermanSpellerRule.put("bevorzugs", "bevorzugst");
        GermanSpellerRule.put("einhergend", "einhergehend");
        GermanSpellerRule.put("dos", (String w) -> Arrays.asList("das", "des", "DOS", "DoS"));
        GermanSpellerRule.put("mch", (String w) -> Arrays.asList("mich", "ich", "ach"));
        GermanSpellerRule.put("Ihc", (String w) -> Arrays.asList("Ich", "Ihr", "Ihm"));
        GermanSpellerRule.put("ihc", (String w) -> Arrays.asList("ich", "ihr", "ihm"));
        GermanSpellerRule.put("ioch", "ich");
        GermanSpellerRule.put("of", "oft");
        GermanSpellerRule.put("mi", (String w) -> Arrays.asList("im", "mit", "mir"));
        GermanSpellerRule.put("wier", (String w) -> Arrays.asList("wie", "wir", "vier", "hier", "wer"));
        GermanSpellerRule.put("ander", (String w) -> Arrays.asList("an der", "andere", "\u00e4nder", "anders"));
        GermanSpellerRule.put("ech", (String w) -> Arrays.asList("euch", "ich"));
        GermanSpellerRule.put("letzt", (String w) -> Arrays.asList("letzte", "jetzt"));
        GermanSpellerRule.put("beu", (String w) -> Arrays.asList("bei", "peu", "neu"));
        GermanSpellerRule.put("darn", (String w) -> Arrays.asList("daran", "darin", "dann", "dar"));
        GermanSpellerRule.put("zwie", (String w) -> Arrays.asList("zwei", "wie", "sie", "sowie"));
        GermanSpellerRule.put("gebten", (String w) -> Arrays.asList("gebeten", "gaben", "geboten", "gelten"));
        GermanSpellerRule.put("dea", (String w) -> Arrays.asList("der", "den", "des", "dem"));
        GermanSpellerRule.put("neune", (String w) -> Arrays.asList("neuen", "neue", "Neune"));
        GermanSpellerRule.put("geren", (String w) -> Arrays.asList("gegen", "gerne", "g\u00e4ren"));
        GermanSpellerRule.put("wuerden", (String w) -> Arrays.asList("w\u00fcrden", "wurden"));
        GermanSpellerRule.put("wuerde", (String w) -> Arrays.asList("w\u00fcrde", "wurde"));
        GermanSpellerRule.put("git", (String w) -> Arrays.asList("gut", "gibt", "gilt", "mit"));
        GermanSpellerRule.put("voher", (String w) -> Arrays.asList("vorher", "woher", "hoher"));
        GermanSpellerRule.put("hst", (String w) -> Arrays.asList("hast", "ist", "hat"));
        GermanSpellerRule.put("Hst", (String w) -> Arrays.asList("Hast", "Ist", "Hat"));
        GermanSpellerRule.put("herlichen", (String w) -> Arrays.asList("herzlichen", "ehrlichen", "herrlichen"));
        GermanSpellerRule.put("Herlichen", (String w) -> Arrays.asList("Herzlichen", "Ehrlichen", "Herrlichen"));
        GermanSpellerRule.put("herliche", (String w) -> Arrays.asList("herzliche", "ehrliche", "herrliche"));
        GermanSpellerRule.put("Herliche", (String w) -> Arrays.asList("Herzliche", "Ehrliche", "Herrliche"));
        GermanSpellerRule.put("it", (String w) -> Arrays.asList("ist", "IT", "in", "im"));
        GermanSpellerRule.put("ads", (String w) -> Arrays.asList("das", "ADS", "Ads", "als", "aus"));
        GermanSpellerRule.put("hats", (String w) -> Arrays.asList("hat es", "hast", "hat"));
        GermanSpellerRule.put("Hats", (String w) -> Arrays.asList("Hat es", "Hast", "Hat"));
        GermanSpellerRule.put("och", (String w) -> Arrays.asList("ich", "noch", "doch"));
        GermanSpellerRule.put("bein", (String w) -> Arrays.asList("Bein", "beim", "ein", "bei"));
        GermanSpellerRule.put("ser", (String w) -> Arrays.asList("der", "sehr", "er", "sei"));
        GermanSpellerRule.put("Monatg", (String w) -> Arrays.asList("Montag", "Monate", "Monats"));
        GermanSpellerRule.put("leiben", (String w) -> Arrays.asList("lieben", "bleiben", "leben"));
        GermanSpellerRule.put("grad", (String w) -> Arrays.asList("grade", "Grad", "gerade"));
        GermanSpellerRule.put("dnn", (String w) -> Arrays.asList("dann", "denn", "den"));
        GermanSpellerRule.put("vn", (String w) -> Arrays.asList("von", "an", "in"));
        GermanSpellerRule.put("sin", (String w) -> Arrays.asList("ein", "sind", "sie", "in"));
        GermanSpellerRule.put("schein", (String w) -> Arrays.asList("scheine", "Schein", "scheint", "schien"));
        GermanSpellerRule.put("wil", (String w) -> Arrays.asList("will", "wie", "weil", "wir"));
        GermanSpellerRule.put("Ihen", (String w) -> Arrays.asList("Ihren", "Ihnen", "Ihn", "Iren"));
        GermanSpellerRule.put("Iher", (String w) -> Arrays.asList("Ihre", "Ihr"));
        GermanSpellerRule.put("neunen", (String w) -> Arrays.asList("neuen", "neunten"));
        GermanSpellerRule.put("tole", (String w) -> Arrays.asList("tolle", "tote"));
        GermanSpellerRule.put("tolen", (String w) -> Arrays.asList("tollen", "toten"));
        GermanSpellerRule.put("wiel", (String w) -> Arrays.asList("weil", "wie", "viel"));
        GermanSpellerRule.put("brauchts", (String w) -> Arrays.asList("braucht es", "brauchst", "braucht"));
        GermanSpellerRule.put("sch\u00f6en", (String w) -> Arrays.asList("sch\u00f6nen", "sch\u00f6n"));
        GermanSpellerRule.put("ihne", (String w) -> Arrays.asList("ihn", "ihnen"));
        GermanSpellerRule.put("af", (String w) -> Arrays.asList("auf", "an", "an", "als"));
        GermanSpellerRule.put("m\u00e4chte", (String w) -> Arrays.asList("m\u00f6chte", "M\u00e4chte"));
        GermanSpellerRule.put("\u00f6ffen", (String w) -> Arrays.asList("\u00f6ffnen", "offen"));
        GermanSpellerRule.put("fernsehgucken", (String w) -> Arrays.asList("fernsehen", "Fernsehen gucken"));
        GermanSpellerRule.put("Mien", (String w) -> Arrays.asList("Mein", "Wien", "Miene"));
        GermanSpellerRule.put("abgeharkt", (String w) -> Arrays.asList("abgehakt", "abgehackt"));
        GermanSpellerRule.put("beiten", (String w) -> Arrays.asList("beiden", "bieten"));
        GermanSpellerRule.put("ber", (String w) -> Arrays.asList("\u00fcber", "per", "der", "BER"));
        GermanSpellerRule.put("ehr", (String w) -> Arrays.asList("eher", "mehr", "sehr", "er"));
        GermanSpellerRule.put("Meien", (String w) -> Arrays.asList("Meine", "Meinen", "Mein", "Medien"));
        GermanSpellerRule.put("neus", (String w) -> Arrays.asList("neues", "neue", "neu"));
        GermanSpellerRule.put("Sunden", (String w) -> Arrays.asList("S\u00fcnden", "Stunden", "Kunden"));
        GermanSpellerRule.put("Bitt", (String w) -> Arrays.asList("Bitte", "Bett", "Bist"));
        GermanSpellerRule.put("bst", (String w) -> Arrays.asList("bist", "ist"));
        GermanSpellerRule.put("ds", (String w) -> Arrays.asList("des", "das", "es"));
        GermanSpellerRule.put("mn", (String w) -> Arrays.asList("man", "in", "an"));
        GermanSpellerRule.put("hilt", (String w) -> Arrays.asList("gilt", "hilft", "hielt", "h\u00e4lt"));
        GermanSpellerRule.put("nei", (String w) -> Arrays.asList("bei", "nie", "ein", "neu"));
        GermanSpellerRule.put("riesen", (String w) -> Arrays.asList("riesigen", "diesen", "Riesen", "reisen"));
        GermanSpellerRule.put("geduld", (String w) -> Arrays.asList("Geduld", "gedulde"));
        GermanSpellerRule.put("bits", (String w) -> Arrays.asList("bist", "bis", "Bits"));
        GermanSpellerRule.put("aheb", (String w) -> Arrays.asList("habe", "aber"));
        GermanSpellerRule.put("versand", (String w) -> Arrays.asList("versandt", "Versand"));
        GermanSpellerRule.put("os", (String w) -> Arrays.asList("so", "es", "OS"));
        GermanSpellerRule.put("Kriese", (String w) -> Arrays.asList("Krise", "Kreise"));
        GermanSpellerRule.put("Kriesen", (String w) -> Arrays.asList("Krisen", "Kreisen"));
        GermanSpellerRule.put("aufteil", (String w) -> Arrays.asList("aufteile", "aufteilt", "auf Teil"));
        GermanSpellerRule.put("f\u00fcrn", (String w) -> Arrays.asList("f\u00fcr ein", "f\u00fcr den", "f\u00fcr", "f\u00fcrs", "fern"));
        GermanSpellerRule.put("Aliegen", (String w) -> Arrays.asList("Anliegen", "Fliegen"));
        GermanSpellerRule.put("gaz", (String w) -> Arrays.asList("ganz", "gab"));
        GermanSpellerRule.put("vllt", (String w) -> Arrays.asList("vielleicht", "vllt."));
        GermanSpellerRule.put("rauch", (String w) -> Arrays.asList("Rauch", "rauche"));
        GermanSpellerRule.put("liebs", (String w) -> Arrays.asList("liebe es", "liebes", "liebe"));
        GermanSpellerRule.put("as", (String w) -> Arrays.asList("a\u00df", "das", "als"));
        GermanSpellerRule.put("bekommste", (String w) -> Arrays.asList("bekommst du", "bekommst"));
        GermanSpellerRule.put("under", (String w) -> Arrays.asList("unser", "unter"));
        GermanSpellerRule.put("dis", (String w) -> Arrays.asList("die", "dies"));
        GermanSpellerRule.put("veil", (String w) -> Arrays.asList("viel", "weil", "teil"));
        GermanSpellerRule.put("mak", (String w) -> Arrays.asList("mag", "mak", "lag"));
        GermanSpellerRule.put("daum", (String w) -> Arrays.asList("da um", "darum", "kaum", "Raum"));
        GermanSpellerRule.put("gechickt", (String w) -> Arrays.asList("geschickt", "gecheckt"));
        GermanSpellerRule.put("gibs", (String w) -> Arrays.asList("gib es", "gibst"));
        GermanSpellerRule.put("Gibs", (String w) -> Arrays.asList("Gib es", "Gibst", "Gips"));
        GermanSpellerRule.put("Gutan", (String w) -> Arrays.asList("Gut an", "Guten", "Sudan"));
        GermanSpellerRule.put("vol", (String w) -> Arrays.asList("von", "vom", "voll", "vor"));
        GermanSpellerRule.put("einzulogen", (String w) -> Arrays.asList("einzuloggen", "einzulegen"));
        GermanSpellerRule.put("Liben", (String w) -> Arrays.asList("Lieben", "Leben", "Libyen", "Ligen"));
        GermanSpellerRule.put("bruchen", (String w) -> Arrays.asList("brauchen", "brachen", "brechen"));
        GermanSpellerRule.put("gerner", (String w) -> Arrays.asList("gern", "gern er", "ferner"));
        GermanSpellerRule.put("krige", (String w) -> Arrays.asList("kriege", "krieg"));
        GermanSpellerRule.put("Geschnek", (String w) -> Arrays.asList("Geschenk", "Geschmack"));
        GermanSpellerRule.put("meinste", (String w) -> Arrays.asList("meiste", "feinste", "meinte", "meinst du"));
        GermanSpellerRule.put("Meinste", (String w) -> Arrays.asList("Meiste", "Feinste", "Meinte", "Meinst du"));
        GermanSpellerRule.put("Telefones", (String w) -> Arrays.asList("Telefons", "Telefone"));
        GermanSpellerRule.put("wusten", (String w) -> Arrays.asList("wussten", "w\u00fcsten"));
        GermanSpellerRule.put("geschlaffen", (String w) -> Arrays.asList("geschlafen", "geschaffen", "geschliffen"));
        GermanSpellerRule.put("Feb", (String w) -> Arrays.asList("Feb.", "Web", "Pep", "Geb", "G\u00e4b"));
        GermanSpellerRule.put("Mogen", (String w) -> Arrays.asList("M\u00f6gen", "Morgen", "Zogen"));
        GermanSpellerRule.put("Dak", (String w) -> Arrays.asList("Dank", "Das", "Dock"));
        GermanSpellerRule.put("Dake", (String w) -> Arrays.asList("Danke"));
        GermanSpellerRule.put("dake", (String w) -> Arrays.asList("danke"));
        GermanSpellerRule.put("Laola", (String w) -> Arrays.asList("La-Ola", "Paola", "Layla", "Lala"));
        GermanSpellerRule.put("Laolas", (String w) -> Arrays.asList("La-Olas", "Paolas", "Laylas"));
        GermanSpellerRule.put("\u00fcbernohmen", (String w) -> Arrays.asList("\u00fcbernehmen", "\u00fcbernommen"));
        GermanSpellerRule.put("augeschlossen", (String w) -> Arrays.asList("ausgeschlossen", "angeschlossen"));
        GermanSpellerRule.put("Akteures", "Akteurs");
        GermanSpellerRule.put("popup", "Pop-up");
        GermanSpellerRule.put("Gedaken", "Gedanken");
        GermanSpellerRule.put("Wiso", "Wieso");
        GermanSpellerRule.put("gebs", "gebe es");
        GermanSpellerRule.put("angefordet", "angefordert");
        GermanSpellerRule.put("onlein", "online");
        GermanSpellerRule.put("Studen", "Stunden");
        GermanSpellerRule.put("weils", "weil es");
        GermanSpellerRule.put("unterscheid", "Unterschied");
        GermanSpellerRule.put("mags", "mag es");
        GermanSpellerRule.put("abz\u00fcgl", "abzgl");
        GermanSpellerRule.put("gefielts", "gefielt es");
        GermanSpellerRule.put("gefiels", "gefielt es");
        GermanSpellerRule.put("gef\u00e4llts", "gef\u00e4llt es");
        GermanSpellerRule.put("nummer", "Nummer");
        GermanSpellerRule.put("mitgetielt", "mitgeteilt");
        GermanSpellerRule.put("Artal", "Ahrtal");
        GermanSpellerRule.put("wuste", "wusste");
        GermanSpellerRule.put("Kuden", "Kunden");
        GermanSpellerRule.put("austehenden", "ausstehenden");
        GermanSpellerRule.put("eingelogt", "eingeloggt");
        GermanSpellerRule.put("kapput", "kaputt");
        GermanSpellerRule.put("geeehrte", "geehrte");
        GermanSpellerRule.put("geeehrter", "geehrter");
        GermanSpellerRule.put("startup", "Start-up");
        GermanSpellerRule.put("startups", "Start-ups");
        GermanSpellerRule.put("Biite", "Bitte");
        GermanSpellerRule.put("Gutn", "Guten");
        GermanSpellerRule.put("gutn", "guten");
        GermanSpellerRule.put("Ettiket", "Etikett");
        GermanSpellerRule.put("iht", "ihr");
        GermanSpellerRule.put("ligt", "liegt");
        GermanSpellerRule.put("gester", "gestern");
        GermanSpellerRule.put("veraten", "verraten");
        GermanSpellerRule.put("dienem", "deinem");
        GermanSpellerRule.put("Bite", "Bitte");
        GermanSpellerRule.put("Serh", "Sehr");
        GermanSpellerRule.put("serh", "sehr");
        GermanSpellerRule.put("fargen", "fragen");
        GermanSpellerRule.put("abrechen", "abbrechen");
        GermanSpellerRule.put("aufzeichen", "aufzeichnen");
        GermanSpellerRule.put("Geraet", "Ger\u00e4t");
        GermanSpellerRule.put("Geraets", "Ger\u00e4ts");
        GermanSpellerRule.put("Geraete", "Ger\u00e4te");
        GermanSpellerRule.put("Geraeten", "Ger\u00e4ten");
        GermanSpellerRule.put("Fals", "Falls");
        GermanSpellerRule.put("soche", "solche");
        GermanSpellerRule.put("ver\u00fcckt", "verr\u00fcckt");
        GermanSpellerRule.put("austellen", "ausstellen");
        GermanSpellerRule.put("klapt", (String w) -> Arrays.asList("klappt", "klagt"));
        GermanSpellerRule.put("denks", (String w) -> Arrays.asList("denkst", "denkt", "denke", "denk"));
        GermanSpellerRule.put("geerhte", "geehrte");
        GermanSpellerRule.put("geerte", "geehrte");
        GermanSpellerRule.put("gehn", "gehen");
        GermanSpellerRule.put("Sp\u00df", "Spa\u00df");
        GermanSpellerRule.put("kanst", "kannst");
        GermanSpellerRule.put("fregen", "fragen");
        GermanSpellerRule.put("Bingerloch", "Binger Loch");
        GermanSpellerRule.put("[nN]or[dt]rh?einwest(f|ph)alen", "Nordrhein-Westfalen");
        GermanSpellerRule.put("abzusolvieren", "zu absolvieren");
        GermanSpellerRule.put("Schutzflie\u00df", "Schutzvlies");
        GermanSpellerRule.put("Simlock", "SIM-Lock");
        GermanSpellerRule.put("f\u00e4schungen", "F\u00e4lschungen");
        GermanSpellerRule.put("Weinverk\u00f6stigung", "Weinverkostung");
        GermanSpellerRule.put("vertag", "Vertrag");
        GermanSpellerRule.put("geauessert", "ge\u00e4u\u00dfert");
        GermanSpellerRule.put("gef\u00e4h?ten", "Gef\u00e4hrten");
        GermanSpellerRule.put("gef\u00e4h?te", "Gef\u00e4hrte");
        GermanSpellerRule.put("immenoch", "immer noch");
        GermanSpellerRule.put("sevice", "Service");
        GermanSpellerRule.put("verh\u00e4lst", "verh\u00e4ltst");
        GermanSpellerRule.put("[sS]\u00e4usche", "Seuche");
        GermanSpellerRule.put("Schalottenburg", "Charlottenburg");
        GermanSpellerRule.put("senora", "Se\u00f1ora");
        GermanSpellerRule.put("widerrum", "wiederum");
        GermanSpellerRule.put("[dD]epp?risonen", "Depressionen");
        GermanSpellerRule.put("Defribilator", "Defibrillator");
        GermanSpellerRule.put("Defribilatoren", "Defibrillatoren");
        GermanSpellerRule.put("SwatchGroup", "Swatch Group");
        GermanSpellerRule.put("achtungslo[\u00dfs]", "achtlos");
        GermanSpellerRule.put("Boomerang", "Bumerang");
        GermanSpellerRule.put("Boomerangs", "Bumerangs");
        GermanSpellerRule.put("Lg", (String w) -> Arrays.asList("LG", "Liebe Gr\u00fc\u00dfe"));
        GermanSpellerRule.put("gildet", "gilt");
        GermanSpellerRule.put("gleitete", "glitt");
        GermanSpellerRule.put("gleiteten", "glitten");
        GermanSpellerRule.put("Standbay", "Stand-by");
        GermanSpellerRule.put("[vV]ollkommnung", "Vervollkommnung");
        GermanSpellerRule.put("femist", "vermisst");
        GermanSpellerRule.put("stantepede", "stante pede");
        GermanSpellerRule.put("[kK]ostarika", "Costa Rica");
        GermanSpellerRule.put("[kK]ostarikas", "Costa Ricas");
        GermanSpellerRule.put("[aA]uthenzit\u00e4t", "Authentizit\u00e4t");
        GermanSpellerRule.put("anl\u00e4ssig", "anl\u00e4sslich");
        GermanSpellerRule.put("[sS]tieft", "Stift");
        GermanSpellerRule.put("[Ii]nspruchnahme", "Inanspruchnahme");
        GermanSpellerRule.put("h\u00f6stwah?rsch[ea]inlich", "h\u00f6chstwahrscheinlich");
        GermanSpellerRule.put("[aA]lterschbeschr\u00e4nkung", "Altersbeschr\u00e4nkung");
        GermanSpellerRule.put("[kK]unstoff", "Kunststoff");
        GermanSpellerRule.put("[iI]nstergramm?", "Instagram");
        GermanSpellerRule.put("fleicht", "vielleicht");
        GermanSpellerRule.put("[eE]rartens", "Erachtens");
        GermanSpellerRule.put("laufte", "lief");
        GermanSpellerRule.put("lauften", "liefen");
        GermanSpellerRule.put("malzeit", "Mahlzeit");
        GermanSpellerRule.put("[wW]ahts?app", "WhatsApp");
        GermanSpellerRule.put("[wW]elan", (String w) -> Arrays.asList("WLAN", "W-LAN"));
        GermanSpellerRule.put("Pinn", (String w) -> Arrays.asList("Pin", "PIN"));
        GermanSpellerRule.put("Geldmachung", (String w) -> Arrays.asList("Geltendmachung", "Geldmacherei"));
        GermanSpellerRule.put("[uU]nstimm?ichkeiten", "Unstimmigkeiten");
        GermanSpellerRule.put("Teilnehmung", "Teilnahme");
        GermanSpellerRule.put("Teilnehmungen", "Teilnahmen");
        GermanSpellerRule.put("waser", "Wasser");
        GermanSpellerRule.put("Bekennung", "Bekenntnis");
        GermanSpellerRule.put("[hH]irar?chie", "Hierarchie");
        GermanSpellerRule.put("Chr", "Chr.");
        GermanSpellerRule.put("Tiefbaumt", "Tiefbauamt");
        GermanSpellerRule.put("get\u00e4ucht", "get\u00e4uscht");
        GermanSpellerRule.put("[hH]\u00e4hme", "H\u00e4me");
        GermanSpellerRule.put("Wochendruhezeiten", "Wochenendruhezeiten");
        GermanSpellerRule.put("Studiumplatzt?", "Studienplatz");
        GermanSpellerRule.put("Permanent-Make-Up", "Permanent-Make-up");
        GermanSpellerRule.put("woltet", "wolltet");
        GermanSpellerRule.put("B\u00e4ckei", "B\u00e4ckerei");
        GermanSpellerRule.put("B\u00e4ckeien", "B\u00e4ckereien");
        GermanSpellerRule.put("warmweis", "warmwei\u00df");
        GermanSpellerRule.put("kaltweis", "kaltwei\u00df");
        GermanSpellerRule.put("jez", "jetzt");
        GermanSpellerRule.put("hendis", "Handys");
        GermanSpellerRule.put("wie?derwarten", "wider Erwarten");
        GermanSpellerRule.put("[eE]ntercott?e", "Entrec\u00f4te");
        GermanSpellerRule.put("[eE]rwachtung", "Erwartung");
        GermanSpellerRule.put("[aA]nung", "Ahnung");
        GermanSpellerRule.put("[uU]nreimlichkeiten", "Ungereimtheiten");
        GermanSpellerRule.put("[uU]nangeneh?mlichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Messy", "Messie");
        GermanSpellerRule.put("Polover", "Pullover");
        GermanSpellerRule.put("heilwegs", "halbwegs");
        GermanSpellerRule.put("undsoweiter", "und so weiter");
        GermanSpellerRule.put("Gladbeckerstrasse", "Gladbecker Stra\u00dfe");
        GermanSpellerRule.put("Bonnerstra(\u00df|ss)e", "Bonner Stra\u00dfe");
        GermanSpellerRule.put("[bB]range", "Branche");
        GermanSpellerRule.put("Gewebtrauma", "Gewebetrauma");
        GermanSpellerRule.put("Ehrenamtpauschale", "Ehrenamtspauschale");
        GermanSpellerRule.put("Essenzubereitung", "Essenszubereitung");
        GermanSpellerRule.put("[gG]eborgsamkeit", "Geborgenheit");
        GermanSpellerRule.put("gekommt", "gekommen");
        GermanSpellerRule.put("hinwei\u00dfen", "hinweisen");
        GermanSpellerRule.put("Importation", "Import");
        GermanSpellerRule.put("l\u00e4dest", "l\u00e4dst");
        GermanSpellerRule.put("Themabereich", "Themenbereich");
        GermanSpellerRule.put("Werksresett", "Werksreset");
        GermanSpellerRule.put("wiederfahren", "widerfahren");
        GermanSpellerRule.put("wiederspiegelten", "widerspiegelten");
        GermanSpellerRule.put("weicheinlich", "wahrscheinlich");
        GermanSpellerRule.put("schn\u00e4pchen", "Schn\u00e4ppchen");
        GermanSpellerRule.put("Hinduist", "Hindu");
        GermanSpellerRule.put("Hinduisten", "Hindus");
        GermanSpellerRule.put("Konzeptierung", "Konzipierung");
        GermanSpellerRule.put("Phyton", "Python");
        GermanSpellerRule.put("nochnichtmals?", "noch nicht einmal");
        GermanSpellerRule.put("Refelektion", "Reflexion");
        GermanSpellerRule.put("Refelektionen", "Reflexionen");
        GermanSpellerRule.put("[sS]chanse", "Chance");
        GermanSpellerRule.put("nich", (String w) -> Arrays.asList("nicht", "noch"));
        GermanSpellerRule.put("Nich", (String w) -> Arrays.asList("Nicht", "Noch"));
        GermanSpellerRule.put("wat", "was");
        GermanSpellerRule.put("[Ee][Ss]ports", "E-Sports");
        GermanSpellerRule.put("gerelaunch(ed|t)", "relauncht");
        GermanSpellerRule.put("Gerelaunch(ed|t)", "Relauncht");
        GermanSpellerRule.put("Bowl", "Bowle");
        GermanSpellerRule.put("Dark[Ww]eb", "Darknet");
        GermanSpellerRule.put("Sachs?en-Anhal?t", "Sachsen-Anhalt");
        GermanSpellerRule.put("[Ss]chalgen", "schlagen");
        GermanSpellerRule.put("[Ss]chalge", "schlage");
        GermanSpellerRule.put("[dD]eutsche?sprache", "deutsche Sprache");
        GermanSpellerRule.put("eigl", "eigtl");
        GermanSpellerRule.put("ma", "mal");
        GermanSpellerRule.put("leidete", "litt");
        GermanSpellerRule.put("leidetest", "littest");
        GermanSpellerRule.put("leideten", "litten");
        GermanSpellerRule.put("Hoody", "Hoodie");
        GermanSpellerRule.put("Hoodys", "Hoodies");
        GermanSpellerRule.put("Staatsexam", "Staatsexamen");
        GermanSpellerRule.put("Staatsexams", "Staatsexamens");
        GermanSpellerRule.put("Exam", "Examen");
        GermanSpellerRule.put("Exams", "Examens");
        GermanSpellerRule.put("[Rr]eviewing", "Review");
        GermanSpellerRule.put("[Bb]aldm\u00f6glich", "baldm\u00f6glichst");
        GermanSpellerRule.put("[Bb]rudi", "Bruder");
        GermanSpellerRule.put("ih", (String w) -> Arrays.asList("ich", "in", "im", "ah"));
        GermanSpellerRule.put("Ih", (String w) -> Arrays.asList("Ich", "In", "Im", "Ah"));
        GermanSpellerRule.put("[qQ]uicky", "Quickie");
        GermanSpellerRule.put("[qQ]uickys", "Quickies");
        GermanSpellerRule.put("bissl", (String w) -> Arrays.asList("bissel", "bisserl"));
        GermanSpellerRule.put("Keywort", (String w) -> Arrays.asList("Keyword", "Stichwort"));
        GermanSpellerRule.put("Keyworts", (String w) -> Arrays.asList("Keywords", "Stichworts"));
        GermanSpellerRule.put("Keyw\u00f6rter", (String w) -> Arrays.asList("Keywords", "Stichw\u00f6rter"));
        GermanSpellerRule.put("strang", (String w) -> Arrays.asList("Strang", "strengte"));
        GermanSpellerRule.put("Gym", (String w) -> Arrays.asList("Fitnessstudio", "Gymnasium"));
        GermanSpellerRule.put("Wur", (String w) -> Arrays.asList("Wir", "Zur", "War", "Nur"));
        GermanSpellerRule.put("wur", (String w) -> Arrays.asList("wir", "zur", "war", "nur"));
        GermanSpellerRule.put("Gyms", (String w) -> Arrays.asList("Fitnessstudios", "Gymnasiums"));
        GermanSpellerRule.put("g\u00e4ng", (String w) -> Arrays.asList("ging", "gang"));
        GermanSpellerRule.put("di", (String w) -> Arrays.asList("du", "die", "Di.", "der", "den"));
        GermanSpellerRule.put("Di", (String w) -> Arrays.asList("Du", "Die", "Di.", "Der", "Den"));
        GermanSpellerRule.put("Aufn", (String w) -> Arrays.asList("Auf den", "Auf einen", "Auf"));
        GermanSpellerRule.put("aufn", (String w) -> Arrays.asList("auf den", "auf einen", "auf"));
        GermanSpellerRule.put("Aufm", (String w) -> Arrays.asList("Auf dem", "Auf einem", "Auf"));
        GermanSpellerRule.put("aufm", (String w) -> Arrays.asList("auf dem", "auf einem", "auf"));
        GermanSpellerRule.put("Ausm", (String w) -> Arrays.asList("Aus dem", "Aus einem", "Aus"));
        GermanSpellerRule.put("ausm", (String w) -> Arrays.asList("aus dem", "aus einem", "aus"));
        GermanSpellerRule.put("best", (String w) -> Arrays.asList("beste", "bester", "Best"));
        GermanSpellerRule.put("Bitet", (String w) -> Arrays.asList("Bitte", "Bittet", "Bidet", "Bietet"));
        GermanSpellerRule.put("lage", (String w) -> Arrays.asList("lange", "Lage", "l\u00e4ge", "lache"));
        GermanSpellerRule.put("mur", (String w) -> Arrays.asList("mir", "zur", "nur", "f\u00fcr"));
        GermanSpellerRule.put("ass", (String w) -> Arrays.asList("Ass", "a\u00df", "aus", "dass"));
        GermanSpellerRule.put("Blat", (String w) -> Arrays.asList("Blatt", "Blut", "Bald", "Bat"));
        GermanSpellerRule.put("much", (String w) -> Arrays.asList("mich", "auch", "Buch"));
        GermanSpellerRule.put("scheibe", (String w) -> Arrays.asList("Scheibe", "schreibe"));
        GermanSpellerRule.put("vielmal", (String w) -> Arrays.asList("Vielmal", "vielmals", "viermal", "viel mal"));
        GermanSpellerRule.put("bachten", (String w) -> Arrays.asList("brachten", "beachten", "machten", "pachten"));
        GermanSpellerRule.put("brache", (String w) -> Arrays.asList("brauche", "brachte", "brach", "br\u00e4che"));
        GermanSpellerRule.put("beliebn", (String w) -> Arrays.asList("beliebt", "bleiben", "belieben"));
        GermanSpellerRule.put("Kono", (String w) -> Arrays.asList("Kino", "Kongo", "Konto"));
        GermanSpellerRule.put("aich", (String w) -> Arrays.asList("ich", "auch", "sich", "eich"));
        GermanSpellerRule.put("anahme", (String w) -> Arrays.asList("Annahme", "nahmen", "nahe", "nahmen"));
        GermanSpellerRule.put("anleigen", (String w) -> Arrays.asList("anlegen", "Anliegen", "anliegen", "anzeigen"));
        GermanSpellerRule.put("besproch", (String w) -> Arrays.asList("besprach", "besprich", "bespreche", "besprochen"));
        GermanSpellerRule.put("dan", (String w) -> Arrays.asList("dann", "den", "das", "an"));
        GermanSpellerRule.put("lase", (String w) -> Arrays.asList("las", "lasse", "Nase"));
        GermanSpellerRule.put("Shr", (String w) -> Arrays.asList("Sehr", "Ihr", "Uhr", "Sir"));
        GermanSpellerRule.put("start", (String w) -> Arrays.asList("Start", "stark", "statt", "stand"));
        GermanSpellerRule.put("neuse", (String w) -> Arrays.asList("neues", "neue"));
        GermanSpellerRule.put("Standart", (String w) -> Arrays.asList("Standard", "Standort"));
        GermanSpellerRule.put("wiessen", (String w) -> Arrays.asList("wissen", "weisen", "wiesen"));
        GermanSpellerRule.put("schnells", (String w) -> Arrays.asList("schnell", "schnellst"));
        GermanSpellerRule.put("sn", (String w) -> Arrays.asList("an", "in"));
        GermanSpellerRule.put("eie", (String w) -> Arrays.asList("die", "wie", "eine", "sie"));
        GermanSpellerRule.put("Mei", (String w) -> Arrays.asList("Mai", "Bei", "Sei", "Mein"));
        GermanSpellerRule.put("bim", (String w) -> Arrays.asList("bin", "im", "bis", "beim"));
        GermanSpellerRule.put("lehr", (String w) -> Arrays.asList("mehr", "lehrt", "sehr", "leer"));
        GermanSpellerRule.put("sm", (String w) -> Arrays.asList("am", "im", "am", "SM"));
        GermanSpellerRule.put("tuh", (String w) -> Arrays.asList("tun", "tut", "tue", "Kuh"));
        GermanSpellerRule.put("wuden", (String w) -> Arrays.asList("wurden", "w\u00fcrden"));
        GermanSpellerRule.put("Arzte", (String w) -> Arrays.asList("\u00c4rzte", "Arzt"));
        GermanSpellerRule.put("Arzten", "\u00c4rzten");
        GermanSpellerRule.put("Alternatief", "Alternativ");
        GermanSpellerRule.put("Pkt", (String w) -> Arrays.asList("Pkt.", "Pakt", "Punkt", "Akt"));
        GermanSpellerRule.put("intere", (String w) -> Arrays.asList("interne", "innere", "hintere", "untere"));
        GermanSpellerRule.put("Eon", (String w) -> Arrays.asList("Ein", "E.ON"));
        GermanSpellerRule.put("unterschiede", (String w) -> Arrays.asList("Unterschiede", "unterscheide", "unterschiebe", "unterschieden"));
        GermanSpellerRule.put("bi", "bei");
        GermanSpellerRule.put("Aendert", "\u00c4ndert");
        GermanSpellerRule.put("aendert", "\u00e4ndert");
        GermanSpellerRule.put("bizte", "bitte");
        GermanSpellerRule.put("korekkt", "korrekt");
        GermanSpellerRule.put("Erhlich", "Ehrlich");
        GermanSpellerRule.put("gestrest", "gestresst");
        GermanSpellerRule.put("rauschicken", "rausschicken");
        GermanSpellerRule.put("stoniren", "stornieren");
        GermanSpellerRule.put("drinen", "drinnen");
        GermanSpellerRule.put("gestigen", "gestiegen");
        GermanSpellerRule.put("prozes", "Prozess");
        GermanSpellerRule.put("Auschluss", "Ausschluss");
        GermanSpellerRule.put("Anbeot", "Angebot");
        GermanSpellerRule.put("Paleten", "Paletten");
        GermanSpellerRule.put("m\u00e4chten", "m\u00f6chten");
        GermanSpellerRule.put("auschreibung", "Ausschreibung");
        GermanSpellerRule.put("worter", "W\u00f6rter");
        GermanSpellerRule.put("Ihrerer", "Ihrer");
        GermanSpellerRule.put("Modelles", "Modells");
        GermanSpellerRule.put("entchuldigen", "entschuldigen");
        GermanSpellerRule.put("kundne", "Kunden");
        GermanSpellerRule.put("bestellun", "Bestellung");
        GermanSpellerRule.put("[Nn]umber", "Nummer");
        GermanSpellerRule.put("mirgen", "morgen");
        GermanSpellerRule.put("korekkt", "korrekt");
        GermanSpellerRule.put("Bs", "Bis");
        GermanSpellerRule.put("Bi\u00df", "Biss");
        GermanSpellerRule.put("bs", "bis");
        GermanSpellerRule.put("sehn", "sehen");
        GermanSpellerRule.put("zutun", "zu tun");
        GermanSpellerRule.put("M\u00fcllhalte", "M\u00fcllhalde");
        GermanSpellerRule.put("Ent\u00e4uschung", "Entt\u00e4uschung");
        GermanSpellerRule.put("Ent\u00e4uschungen", "Entt\u00e4uschungen");
        GermanSpellerRule.put("kanns", (String w) -> Arrays.asList("kann es", "kannst"));
        GermanSpellerRule.put("verklinken", (String w) -> Arrays.asList("verklinkern", "verlinken", "verklingen"));
        GermanSpellerRule.put("funktionierts", "funktioniert es");
        GermanSpellerRule.put("hbat", "habt");
        GermanSpellerRule.put("ichs", "ich es");
        GermanSpellerRule.put("folgendermassen", "folgenderma\u00dfen");
        GermanSpellerRule.put("Adon", "Add-on");
        GermanSpellerRule.put("Adons", "Add-ons");
        GermanSpellerRule.put("ud", "und");
        GermanSpellerRule.put("vertaggt", (String w) -> Arrays.asList("vertagt", "getaggt"));
        GermanSpellerRule.put("keinsten", (String w) -> Arrays.asList("keinen", "kleinsten"));
        GermanSpellerRule.put("Angehensweise", "Vorgehensweise");
        GermanSpellerRule.put("Angehensweisen", "Vorgehensweisen");
        GermanSpellerRule.put("Neudefinierung", "Neudefinition");
        GermanSpellerRule.put("Definierung", "Definition");
        GermanSpellerRule.put("Definierungen", "Definitionen");
        GermanSpellerRule.putRepl("[\u00dc\u00fc]bergrifflich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.put("l\u00f6chen", (String w) -> Arrays.asList("l\u00f6schen", "l\u00f6chern", "K\u00f6chen"));
        GermanSpellerRule.put("wergen", (String w) -> Arrays.asList("werfen", "werben", "werten"));
        GermanSpellerRule.put("Wasn", (String w) -> Arrays.asList("Was denn", "Was ein", "Was"));
        GermanSpellerRule.putRepl("schammig(e[mnrs]?)?", "schamm", "schwamm");
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".*(Majon\u00e4se|Bravur|Anschovis|Belkanto|Campagne|Frott\u00e9|Grisli|Jockei|Joga|Kalvinismus|Kanossa|Kargo|Ketschup|Kollier|Kommunikee|Masurka|Negligee|Nessess\u00e4r|Poulard|Varietee|Wandalismus|kalvinist|[Ff]ick).*"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".+[*_:]in"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".+[*_:]innen"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".+\\szigste[srnm]?"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+ [a-z\u00f6\u00e4\u00fc\u00df]-[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+- [\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]+-[a-z\u00e4\u00f6\u00fc\u00df]+-[a-z\u00e4\u00f6\u00fc\u00df]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]+- [a-z\u00e4\u00f6\u00fc\u00dfA-Z\u00c4\u00d6\u00dc\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+ [a-z\u00e4\u00f6\u00fc\u00dfA-Z\u00c4\u00d6\u00dc]-[a-z\u00e4\u00f6\u00fc\u00dfA-Z\u00c4\u00d6\u00dc\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+ [a-z\u00e4\u00f6\u00fc\u00df\\-]+-[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+ -[\\w\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+\\.[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df][A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+\\.\\-[a-z\u00e4\u00f6\u00fc\u00df\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[a-z\u00f6\u00e4\u00fc\u00df]{3,20} [A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]{2,20}liche[rnsm]"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df]{2,20}-[a-z\u00e4\u00f6\u00fc\u00df]{2,20}-"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[a-z\u00e4\u00f6\u00fc\u00df]{3,20}-[A-Z\u00c4\u00d6\u00dc][a-z\u00e4\u00f6\u00fc\u00df\\-]{2,20}"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[a-z\u00e4\u00f6\u00fc\u00df]{3,20}-[A-Z\u00c4\u00d6\u00dc\\-]{2,20}"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("([skdm]?ein|viel|sitz|sing|web|h\u00f6r|woh[nl]|kehr|adel|elektiv|wert|wein|wund|wurm|wand|weg|wett|gen|hei[lm]|kenn|vo[rnm]|fein|zu[rm]?|fehl|bei|peil|eckt?|mit|die|das|ehe|f\u00fcr|nur|eure[rn]?|unse?re?|e[sr]|fahr|bar|fern|warn|filz|oft|fort|bot|vote|k\u00e4se|we[rnm]|was|gie(ss|\u00df)|haut|band|heiz|merk|mehr|z[\u00e4a]hl|knie|zie[lr]|braut|brat|park|reiz|wa[rs]|wo|ma(\u00df|ss)|kleb|gabel|brat|rast|rang|lesen?|arm|de[rnms]|s\u00e4mig|sucht?|s\u00e4gen?|steh|bahn|off|uff|auf|a\u00df|also|anno|dank|back(en?)?|bl[oi]ck|fang|kl\u00e4r|macht?|haken?|[lw]agen?|messe?|bad(en?)?|pack|km|ecken?|bis|tauche?|tr?age?|segeln?|stei[lg]|stahl|da(nn)?|h\u00e4ng(en?)?[bt]oten?|plus|tat|lade?|tasten?|druck|fach|fragen?|lern|mag|facto|magre|bald|bau(en?)?|ich|sei[dtln]|gang|angeln?|[wl]ach|bist|[ge]ilt|warten?|turn|h\u00e4rten?|hold|[hg]alt|holt|angle|angab|ankam|anale?)-[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df\\-]+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".+-(gen|tu[etn]|l?ehrt?(en?)?|[fv]iele?n?|g\u00e4rt?en?|igeln?|nein|ja|d?rum|erb(en?)?|vo[rnm]|vors|hat|gab(en)?|gabs?|gibt|km|geb(en?)?|nu[nr]|gay|kalt(e[snr]?)?|la[gd](en?)?|man|r\u00e4ngen?|n\u00e4ssen?|angle|angeln?|angst|stur(en?)?|oft|wo|wann|was|wer|mengen?|spie(\u00df|ss)en?|adeln?|n\u00e4ht?en?|ob|beide[rn]?|g\u00e4rten|zweiten?|h\u00fctt?en?|kehrt?en?|h?orten?|messen?|tr[ea]u|tr\u00fcb|tr\u00fcben?|senden?|gr[uo]b|feinden?|wie|k\u00e4sen?|ih[rmn](e[srnm]?)?|grau|trug(en?)?|weil|dass|sein?|zucken?|kanten?|s?ich|getan|h\u00e4lt|bald|\u00e4rgern?|f\u00e4chern?|wart?(en?)?|leid|weit(e[snr]?)?|weiden?|ruf(en?)?|min|im|bin|zicken?|jo|siegeln?|[ao]ha|ganz|z\u00e4h|j\u00e4h|gehen?|ga[br]|kam|sah|[sr]itzen|kann|mit|ohne|ist|so|war|da[rh]in|\u00fcber|unter|doof|bis|sie|er|aalen?|[lb]aden?|raten?|die|mit|bis|d[ea]s|eifern?|acker[tn]?|z[iu]cken?|j[oe]|j\u00e4h|haha|ger\u00e4t|[wrbfk]etten?|tja|je|kau|nach|haben?|hab|gaga|kicken?|kick|heil|heilen?|altern?|w\u00e4nden?|wert(e[rsnm]?)?|werben?|zoom|genug|gehen?|ums?|und|oder|[sn]ah|ha|de[mnsr]|s\u00fc(\u00df|ss)|ringen?|dingen?|seil|au[fs]|gurten?|munden?|eigen|wenden?|regen?|b?rechen?|legen?|f\u00e4chern?|leger|g[ia]lt|heim|heimen?|[mksdw]?ein|[mksdw]?einen?|erden?|\u00e4ndern?|ernten?|b\u00e4nden?|\u00e4sten?|arten?|kanten?|eichen?|unken?|wunden?|kunden?|runden?|regeln?|kegeln?|kr\u00e4hen?|zechen?|m\u00e4hen?|ehren?|ehen?|enden?|eng(e[srn]?)?|gut(e[srn]?)?|zielt?(en?)?|spielt?(en?)?|\u00e4tzt?(en?)?|riegeln?|segeln?|engt?|engen?|angeln?|kochen?|[lk]ehren?|festen?|essen?|steuern?|ekeln?|irren?|cum|de|da|du|raus|rein|dort|knien?|hin|zu[rm]?|ritten?|riss|rissen?|[tr]ast(en?)?|rasseln?|hieb|w\u00e4ssern?|putz|h\u00e4ngen?|zinken?|a[bnm]|bisher|sch\u00f6ne?|solo|haken?|dr[\u00fcu]ck(en?|tot)?|huren?|pries|hupen?|h\u00fcllen?|lang|joa|sei[dt]|weist|\u00fcben?|ufern?|iss|steck(en?)?|fort|mal|aal|darf|halt(en?)?|eifern?|van|guck(en?|t)?|ganze?|acht(en?)?|auch|solo|[zs]og|lagern?|baggern?|au|haut?|als|uns|bei[m]?|[dm]ir|dich|uni|ergo|eich(en?)?|spick(en?)?|e[rs]|spielt?|we[hg]|wart|wi[rl]d|neue[rns]?|mithin|tags?|eine[snmr]?|wiesen?|rei[sz]en?|wei[sh]en?|siegen?|sag(en?)?|sitzen?|tagen?|all(en?)?|zahlen?|r\u00fcgen?|ruhen?|bar|h\u00fcben?|hick|arm|armen?|plan(en?)?|[fpl]assen?|per|reg|rinnen?|bringen?|\u00f6l(en?)?|alt(en?)?|elf(en?)?|kp|ward|apart|wer[dkt](en?)?|weis(en?)?|sind|mm|wand|wir|licht(en)?|l\u00fcgen?|loch(en?)?|\u00fcbel|peu|[wtm]isch(en?)?|fein(e[rns]?)?|a(\u00df|ss)|mol|neu(en?)?|[dm]ich|rang|obe[nr]|\u00fcbe[nl]?|maxi?|hart(en?)?|hexen?|ab|z\u00fcck(en?)?|zur\u00fcck|k\u00f6pf(en?)?|band(en?)?|schafft?en?|schalt?en?|giften?|sieben?|seil(en?)?|wehen?|sehen?|s[it]?eht?|stocken?|red|r\u00e4t|ma(\u00df|ss)|sch\u00e4men?|innen?|karren?|wer[tf]en?|werft|loch(en?)?|logen?|gossen?|steil(en?)?|fr?isch(en?)?|d[ea]nn|zelt(en?)?|luv|kauf(en?)?|lasch(en?)?|bei(\u00df|ss)(en?)?|leihen?|leid(en?)?|[drsl]icht(en?)?|opfern?|[wz]\u00e4h[mln]en?|w\u00e4r(en?)?|\u00c0|\u00e0|fugen?|la[xs]|zahl(en?)?|[rf]all(en?)?|wichs(en?)?|sog(en?)?|alias|glich(en?)?|w\u00fcrd(en?)?|w\u00e4rm(en?)?|[rhg]eiz(en?)?|stieren?|teils?|trotz|fahr(en?)?|b[oa]u?[dt](en?)?|kl[\u00f6o]n(en?)?|paar|park(en?)?|last|landen?|alle[rnms]?|ad|l[\u00e4a]u[ft](en?)?|[ws]\u00e4g(en?)?|pasch(en?)?|kehl(en?)?|wohl(en?)?|flucht?(en?)?|zeit|rasa|selben?|mehr(en?)?|gabeln?|ordern?|[cw]ach(en?)?|arg(en?)?|brauch(en?)?|hauch(en?)?|[ms]a(\u00df|ss)(en?)?|mm?h|zart(e[snmr]?)?|ehrt?(en?)?|de[rn]en|\u00e4hm?|hui|hmm?|al|f\u00fcr|[bl]au(en?)?|[lr]ahm(en?)?|[bs]uch(en?)?|[wv]ag(en?)?|[tl]os(en?)?|les(en?)?|str?ahl(en?)?|z\u00e4h[mn]t?(en?)?|fest(e[rsnm]?)?|folgt?(en?)?|f[a\u00e4]llt?(en?)?|[tr]oll(en?)?|[mf]\u00fcllt?(en?)?|[rl]eit(en?)?|ras(en?)?|hall(en?)?|well(en?)?|fra(\u00df|ss)(en)?|tat(en)?|pah|buh(en?)?|b\u00e4h|h\u00f6r(en?)?|holz(en?)?|reif(e[rsmn]?)?|litt|fort(an)?|h\u00e4rten?|welche[rnsm]?|wegen|fach(en?)?|bog(en?)?|foul(en?)?|l\u00f6st?(en?)?|lots(en?)?|falls|[bwh][ua]ldige[rsn]?|(st)?reift?(en?)?|t?rei[bh](en?)?|[rb]\u00fcck(en?)?|wett(en?)?|t[o\u00fc]t(en?)?|[ft]est(en?)?|h[a\u00e4]ut(en?)?|knall(en?)?|[dk]\u00e4mpft?(en?)?|h\u00f6rt?(en?)?|patt(en?)?|[tw]ollt?en?|[km]g|[bkps]ack(en?)?|[lf]an?d(en?)?|seifen?|tabu|heft(en?)?|forma?|knall(en?)?|[lm]?acht?(en)?|boot(en?)?|lach(en?)?|[hb]i?eb(en?)?|tut(en?)?|tr?\u00f6t(e[tn]?)?|[sp]ackt?(en?)?|[klnrd]?eckt?(en?)?|beut(en?)?|top|st?att(en?)?|dien(en?)?|[hl]ieb(en?)?|s\u00e4t|satt(en?)?|droh(en?)?|[sr]\u00e4um(en?)?|zeugt?(en?)?|reu(en?)?|nies(en?)?|[gzf]eigt?(en?)?|gie(\u00df|ss)(en?)?|sichern?|zog(en?)?|schert?(en?)?|s[tp]r?ickt?(en?)?|seicht(e[srn]?)?|(be)?sorgt?(en?)?|ehelich(en?)?|link(en?)?|wein(en?)?|r?echt|orangen?|blick(en?)?|kling(en?)?|\u00fcbrig(en?)?|klick(en?)?)"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile("[A-Z\u00d6\u00c4\u00dca-z\u00f6\u00e4\u00fc\u00df] .+"));
        PREVENT_SUGGESTION_PATTERNS.add(Pattern.compile(".+ [a-z\u00f6\u00e4\u00fc\u00dfA-Z\u00d6\u00c4\u00dc]"));
        splitter = GermanSpellerRule.getSplitter();
    }

    static class ExpandingReader
    extends BufferedReader {
        private final List<String> buffer = new ArrayList<String>();
        private final LineExpander lineExpander = new LineExpander();

        ExpandingReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            if (this.buffer.isEmpty()) {
                String line = super.readLine();
                if (line == null) {
                    return null;
                }
                this.buffer.addAll(this.lineExpander.expandLine(line));
            }
            return this.buffer.remove(0);
        }
    }
}

