/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.internal.process.workitem.InvalidTransitionException;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemLifeCycle;
import org.kie.kogito.internal.process.workitem.WorkItemLifeCyclePhase;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.impl.DefaultWorkItemTransitionImpl;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class DefaultWorkItemLifeCycle
implements WorkItemLifeCycle {
    List<WorkItemLifeCyclePhase> phases;

    public DefaultWorkItemLifeCycle(WorkItemLifeCyclePhase ... phases) {
        this.phases = List.of(phases);
    }

    public Optional<WorkItemTransition> transitionTo(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workItem, WorkItemTransition transition) {
        WorkItemLifeCyclePhase phase = this.phaseById(transition.id(), workItem.getPhaseStatus());
        if (phase == null) {
            throw new InvalidTransitionException("transition id " + transition.id() + " is not allowed for handler " + workItem.getName() + " from " + workItem.getPhaseStatus());
        }
        transition.policies().stream().forEach(policy -> policy.enforce(workItem));
        if (workItem instanceof KogitoWorkItemImpl) {
            KogitoWorkItemImpl impl = (KogitoWorkItemImpl)workItem;
            impl.setPhaseId(phase.id());
            impl.setPhaseStatus(phase.targetStatus().getName());
            impl.setResults(transition.data());
        }
        return phase.execute(manager, handler, workItem, transition);
    }

    public Collection<WorkItemLifeCyclePhase> phases() {
        return this.phases;
    }

    public WorkItemTransition newTransition(String transitionId, String currentPhaseStatus, Map<String, Object> data, Policy ... policy) {
        WorkItemLifeCyclePhase phase = this.phaseById(transitionId, currentPhaseStatus);
        if (phase == null) {
            throw new InvalidTransitionException("new transition id " + transitionId + " is not allowed from " + currentPhaseStatus + " is invalid");
        }
        return new DefaultWorkItemTransitionImpl(transitionId, phase.targetStatus().getTermination().orElse(null), data, policy);
    }
}

