/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.defaultvalueplugin;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XmlString;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.xml.sax.ErrorHandler;

public class DefaultValuePlugin
extends Plugin {
    private static final String OPTION_NAME_ALL = "-Xdefault-value:all";
    private boolean all = false;
    private static final String OPTION_NAME = "Xdefault-value";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xdefault-value    : enable rewriting of classes to set default values for fields as specified in XML schema\n [-Xdefault-value:all : enable rewriting of classes for default values of all fields and attributes]";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline co : outline.getClasses()) {
            JFieldVar dtf = null;
            for (FieldOutline f : co.getDeclaredFields()) {
                String typeFullName;
                CPropertyInfo fieldInfo = f.getPropertyInfo();
                XmlString xmlDefaultValue = null;
                if (fieldInfo.getSchemaComponent() instanceof XSParticle) {
                    XSTerm term = ((XSParticle)fieldInfo.getSchemaComponent()).getTerm();
                    if (!term.isElementDecl()) continue;
                    XSElementDecl element = term.asElementDecl();
                    xmlDefaultValue = element.getDefaultValue();
                } else {
                    if (!this.all || !(fieldInfo.getSchemaComponent() instanceof XSAttributeUse)) continue;
                    XSAttributeUse attribute = (XSAttributeUse)fieldInfo.getSchemaComponent();
                    xmlDefaultValue = attribute.getDefaultValue();
                }
                if (xmlDefaultValue == null) continue;
                String defaultValue = xmlDefaultValue.value;
                Map fields = co.implClass.fields();
                JFieldVar var = (JFieldVar)fields.get(fieldInfo.getName(false));
                if (var == null) continue;
                JType type = f.getRawType();
                if (type.isPrimitive()) {
                    type = type.boxify();
                }
                if ("java.lang.String".equals(typeFullName = type.fullName())) {
                    var.init(JExpr.lit((String)defaultValue));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing String variable " + fieldInfo.displayName() + " to \"" + defaultValue + "\"");
                    continue;
                }
                if ("java.lang.Boolean".equals(typeFullName)) {
                    var.init(JExpr.lit((boolean)Boolean.valueOf(defaultValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Boolean variable " + fieldInfo.displayName() + " to " + defaultValue + "");
                    continue;
                }
                if ("java.lang.Byte".equals(typeFullName) || "java.lang.Short".equals(typeFullName) || "java.lang.Integer".equals(typeFullName)) {
                    var.init(JExpr.lit((int)Integer.valueOf(defaultValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Integer variable " + fieldInfo.displayName() + " to " + defaultValue + "");
                    continue;
                }
                if ("java.lang.Long".equals(typeFullName)) {
                    var.init(JExpr.lit((long)Long.valueOf(defaultValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Long variable " + fieldInfo.displayName() + " to " + defaultValue + "");
                    continue;
                }
                if ("java.lang.Float".equals(typeFullName)) {
                    var.init(JExpr.lit((float)Float.valueOf(defaultValue).floatValue()));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Float variable " + fieldInfo.displayName() + " to " + defaultValue + "");
                    continue;
                }
                if ("java.lang.Single".equals(typeFullName) || "java.lang.Double".equals(typeFullName)) {
                    var.init(JExpr.lit((double)Double.valueOf(defaultValue)));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing Double variable " + fieldInfo.displayName() + " to " + defaultValue + "");
                    continue;
                }
                if ("javax.xml.datatype.XMLGregorianCalendar".equals(typeFullName)) {
                    if (dtf == null && (dtf = this.installDtF(co.implClass)) == null) continue;
                    var.init((JExpression)JExpr.invoke(dtf, (String)"newXMLGregorianCalendar").arg(defaultValue));
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing XMLGregorianCalendar variable " + fieldInfo.displayName() + " with value of " + defaultValue);
                    continue;
                }
                if (type instanceof JDefinedClass && ((JDefinedClass)type).getClassType() == ClassType.ENUM) {
                    JEnumConstant constant = this.findEnumConstant(type, defaultValue, outline);
                    if (constant == null) continue;
                    var.init((JExpression)constant);
                    if (!opt.verbose) continue;
                    System.out.println("[INFO] Initializing enum variable " + fieldInfo.displayName() + " with constant " + constant.getName());
                    continue;
                }
                System.out.println("[WARN] Did not create default value for field " + fieldInfo.displayName() + ". Don't know how to create default value expression for fields of type " + typeFullName + ". Default value of \"" + defaultValue + "\" specified in schema");
            }
        }
        return true;
    }

    private JEnumConstant findEnumConstant(JType enumType, String enumStringValue, Outline outline) {
        for (EnumOutline eo : outline.getEnums()) {
            if (eo.clazz != enumType) continue;
            for (EnumConstantOutline eco : eo.constants) {
                if (!eco.target.getLexicalValue().equals(enumStringValue)) continue;
                return eco.constRef;
            }
            System.out.println("[WARN] Could not find EnumConstant for value: " + enumStringValue);
            return null;
        }
        System.out.println("[WARN] Could not find Enum class for type: " + enumType.fullName());
        return null;
    }

    private JFieldVar installDtF(JDefinedClass parentClass) {
        try {
            JCodeModel cm = parentClass.owner();
            JClass dtfClass = cm.ref(DatatypeFactory.class);
            JFieldVar dtf = parentClass.field(28, (JType)dtfClass, "DATATYPE_FACTORY");
            JBlock si = parentClass.init();
            JTryBlock tryBlock = si._try();
            tryBlock.body().assign((JAssignmentTarget)dtf, (JExpression)dtfClass.staticInvoke("newInstance"));
            JCatchBlock catchBlock = tryBlock._catch(cm.ref(DatatypeConfigurationException.class));
            JVar ex = catchBlock.param("ex");
            JClass runtimeException = cm.ref(RuntimeException.class);
            catchBlock.body()._throw((JExpression)JExpr._new((JClass)runtimeException).arg("Unable to initialize DatatypeFactory").arg((JExpression)ex));
            return dtf;
        }
        catch (Exception e) {
            System.out.println("[ERROR] Failed to create code");
            e.printStackTrace();
            return null;
        }
    }

    public int parseArgument(Options opt, String[] args, int i) {
        String arg = args[i].trim();
        if (arg.startsWith(OPTION_NAME_ALL)) {
            this.all = true;
            return 1;
        }
        return 0;
    }
}

