/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Items;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTriggerConfig {
    private final List<AbstractBuildParameters> configs;
    private String projects;
    private final ResultCondition condition;

    public BuildTriggerConfig(String projects, ResultCondition condition, List<AbstractBuildParameters> configs) {
        this.configs = configs;
        this.projects = projects;
        this.condition = condition;
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, AbstractBuildParameters ... configs) {
        this(projects, condition, Arrays.asList(configs));
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public String getProjects() {
        return this.projects;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public List<AbstractProject> getProjectList() {
        return Items.fromNameList((String)this.projects, AbstractProject.class);
    }

    private static ParametersAction mergeParameters(ParametersAction base, ParametersAction overlay) {
        LinkedHashMap<String, ParameterValue> params = new LinkedHashMap<String, ParameterValue>();
        for (ParameterValue param : base.getParameters()) {
            params.put(param.getName(), param);
        }
        for (ParameterValue param : overlay.getParameters()) {
            params.put(param.getName(), param);
        }
        return new ParametersAction(params.values().toArray(new ParameterValue[params.size()]));
    }

    private static ParametersAction getDefaultParameters(AbstractProject<?, ?> project) {
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (property == null) {
            return null;
        }
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        for (ParameterDefinition pd : property.getParameterDefinitions()) {
            ParameterValue param = pd.getDefaultParameterValue();
            if (param == null) continue;
            parameters.add(param);
        }
        return new ParametersAction(parameters);
    }

    List<Action> getBaseActions(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        for (AbstractBuildParameters config : this.configs) {
            Action a = config.getAction(build, listener);
            if (a instanceof ParametersAction) {
                params = params == null ? (ParametersAction)a : BuildTriggerConfig.mergeParameters(params, (ParametersAction)a);
                continue;
            }
            if (a == null) continue;
            actions.add(a);
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    List<Action> getBuildActions(List<Action> baseActions, AbstractProject project) {
        ArrayList<Action> actions = new ArrayList<Action>(baseActions);
        ParametersAction defaultParameters = BuildTriggerConfig.getDefaultParameters(project);
        if (defaultParameters != null) {
            Action a = null;
            ListIterator<ParametersAction> it = actions.listIterator();
            while (it.hasNext()) {
                a = (Action)it.next();
                if (!(a instanceof ParametersAction)) continue;
                it.set(BuildTriggerConfig.mergeParameters(defaultParameters, (ParametersAction)a));
                break;
            }
            if (!(a instanceof ParametersAction)) {
                actions.add((Action)defaultParameters);
            }
        }
        return actions;
    }

    @Deprecated
    public void perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            List<Action> actions;
            if (this.condition.isMet(build.getResult()) && !(actions = this.getBaseActions(build, (TaskListener)listener)).isEmpty()) {
                for (AbstractProject project : this.getProjectList()) {
                    List<Action> list = this.getBuildActions(actions, project);
                    project.scheduleBuild(project.getQuietPeriod(), (Cause)new Cause.UpstreamCause(build), list.toArray(new Action[list.size()]));
                }
            }
        }
        catch (AbstractBuildParameters.DontTriggerException e) {
            return;
        }
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        String[] list = this.projects.split(",");
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].trim().equals(oldName)) continue;
            list[i] = newName;
            changed = true;
        }
        if (changed) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(list[i]);
            }
            this.projects = buf.toString();
        }
        return changed;
    }

    public boolean onDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public String toString() {
        return "BuildTriggerConfig [projects=" + this.projects + ", condition=" + (Object)((Object)this.condition) + ", configs=" + this.configs + "]";
    }
}

