package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          305,  378,  308,   88,   88,  134,  134,  254,  257,  324, 
          250,  250,  250,  228,  427,  276,  250,  250,  230,  465, 
          250,  418,  715,  420,  107,   83,   83,  260,  214,  635, 
          642,  352,  714,  228,  487,  714,  302,  307,  230,  354, 
          702,  215,  215,  292,  292,  440,   88,  292,  133,  133, 
          350,  696,  250,  677,  631,  643,  675,  629,  133,  648, 
          585,  715,  215,  288,  288,  661,  631,  288,  639,  642, 
          387,  644,  691,  806,  360,  331,  335,  256,  417,  642, 
          526,  291,  291,  642,  528,  291,  705,  215,  578,  826, 
          739,  631,  435,  133,    8,  676,  724,  630,  642,  642, 
          350,  301,  870,  835,    8,  304,  576,  760,  762,  631, 
         1031,  639,  562,  330,   17,  570,  642,  431,  642,  387, 
          260,  433,  578,  777,  577,  676,  255,   83,  588,  250, 
          767,   88,  642,  430,  847,  514, 1017,  578,  943,  868, 
          576,  523,  642,  133,  601,  736,  884,  642,  940,  570, 
          393,  376,  500,    8,  642,  576,  756,  779,  577,  676, 
          751,  562,  588,   17,  570,  642,  376,  523,  256,  256, 
          343,  562,   74,  577,  772,  522,  314,  588,   83,  384, 
          385,  106,  106,  461,  676,  408,  432,  310,  106,  106, 
          106,  272,  301,  601,  106,  106,   73,  562,  106,  393, 
          562,  525,  408,  642, 1031,  551,   86,  274,  773,  475, 
          552,  799,  300,  380,   75,  304,  432,  255,  255,  343, 
          501,  502,  819,   72,  106,  373,  757,  742,  849,  850, 
          106,  851,  829,  377, 1011,   88,  378,  487,  770, 1017, 
          570,  562,  655,  297,  381,  509,  562,   71,  377, 1048, 
          960,  585,  631,  547,  601,  715,  304,  637,  470,  471, 
          436,   81,  250,  250,  530,   75,  376,  714,  714,  631, 
          379,  590,  300,  260,  570,  637,  591,  805,  809,  374, 
          811,  273,  324,  534,  642,  377,  466,  810,  375,  570, 
          475,  943,  310,  870,  642,  475,   59,   60,  250,  315, 
          250,  250,  547,  601,  250, 1046,  250,  106,  449,  106, 
           53,   88,   81,  365,  304,  414,  450,   88,  843,   88, 
          367,  814,  415,  416,  576,  292,  868,  292,  250,  897, 
          821,  818,  912,  517,  456,  904,  260,   79,  371,  512, 
         1077,  868,  373,  642,  423,  288,  477,  288,  288,  516, 
          350,  477,  642,  412,  631,  910,  642,  642,   76,  674, 
          102,  102,  818,  291,  467,  291,   17,   17,   17,  585, 
          642,  585,   17,   17,  631,   17,  594,  595,  596,  597, 
          250,  250,  250,  250,   88,  250,  250,  643,   79,  324, 
          643,  289,  295,  133,  947,  296,   83,   96,  424,  951, 
          953,  576,  955,  102,  956,  935,  598,  642,  657,   76, 
          645,  642,  649,  106,  422,  642,  659,  663,  250,  387, 
          629,  957,  642,  250,  428,  250,   88,  350,  964,  250, 
          250,  648,   88,  968,  642,  868,  303,  578,  576,  699, 
          106,  106,  329,  333,  562,  250,   17,   88,  250,  585, 
          530,  585,  665,  640,   83,  839,  640,    8,   88,   83, 
          630,  250,  832,  888,  570,  288,   88,   17, 1084, 1003, 
          133,  576,  715,  577,  642,  250,  106,  588,  106,  106, 
          640,  845,  106,   75,  106,  714,  701,  701,  102,  106, 
          654,   17,  288,  601,  654,  106,  640,  106,  641,  393, 
           92,   92,  135,  135,   74,  250,  106,   88,  288,  228, 
          640,  713,  277,  722,  230,  576,  429, 1005,   88,  310, 
          982,  303,  288,  272,  441,  641,  272,  452,   73,   83, 
           81,  596,  562,  697,  250,  570,  350,  455,  215,  274, 
           91,  641,  274,   92,  640,  380,   75,  351,  547,  601, 
          732, 1050, 1052, 1053, 1054,  641,  462,  373,  106,  106, 
          106,  106,  106,  106,  106,  596,  536,  537,  378,  640, 
          463,  530,  570,  539,   91, 1061,  381,  536,  537,  133, 
          596,  288,  839,  642,  539,  547,  601,  444,  586,  641, 
         1037,   91,  102,   81,  384,  385,  106,  351,  376,  464, 
          778,  106,  379,  106,  106,  570,   79,  106,  106,  785, 
          106,  374, 1086,  273,  641,  467,  273,  377,  547,  601, 
          375,  510,  586,  106,  386,  106,  106,   76,   92,   84, 
          438,  469,  642,  576,  439,  576,  106,  586,  855,  106, 
          472,   86,  585,  319,  106,  460,  783,  476,  846,  785, 
           77,  888, 1070,  106,  789,  888,  401,  350,   72,  792, 
          403,  404,  405,  406,  482,  785,  804,  483,  102,   79, 
          250,   88,  486,  488,  102,  491,  102,  642,  642,  785, 
           84,   88,   82,  106,  803,  106, 1000,  642,  747,  228, 
           76,  676, 1002,  813,  230,  493,  106,  564,  565,  386, 
          133,   77,   95,   95,  812,  836, 1012,  103,  506,  250, 
          785,  782,  106,  510,  278,  530,  511,  215,  215,  788, 
          906,  558,  110,  642,  788,  860,  559,  515,  319,   88, 
          536,  537,   92,   82,  350,  521,  642,  539,  443,  443, 
          527,  102,  544,  529,  443,   95,  840,  860,  535,  888, 
          654,   83,  546,  782,  434,   80,  788,   88,   88,  564, 
          565,  658,   78,  536,  537,  538,  550,  586,  893,  895, 
          539,  110,  642,  589,  900,  902,   88,  133,   88,  666, 
           88,  250,  250,  102,  649,  414,  504,  250,  250,  102, 
          679,  684,  415,  419,  688,  566,  686,  250,  474,  698, 
          717,  350,  718,  510,  102,  719,   80,   16,   92,   91, 
          613,  725,  493,   78,   92,  102,   92,  728,  927,   88, 
          914,  733,  250,  102,  414,  744,  596,  918,  752,  753, 
           95,  415,  443,   88,   88,   88,  256,  765,  754,  493, 
          642,  780,  642,  866,  133,  869,  759,  351,  106,  106, 
          761,  860,  701,  763,  766,  493,   16,  876,  510,  106, 
          444,  769,  771,  596,  102,  510,  510,  797,  796,  493, 
          831,  613,   91,  747,  856,  102,   72,  248,  248,  248, 
          596,   92,  414,  586,  781,  255,  978,  106,  972,  415, 
          459,  642,  613,  786,  285,  787,  596,  800,   84,  250, 
          553,   96,  554,  555,  556,  557,  807,  106,  507,  444, 
          818,  830,  642,   88,   88,  824,  319,  498,  825,   77, 
          586,  997,  460,   92,  351,   88,  827,  828,  493,   92, 
         1041,  133,  842,  857,   95,  106,  106,  586,  891,  518, 
          519,  642,  122,  434,   92,  898,  642,  899,  642,  915, 
          917,   82,  920,  586,  106,   92,  106,  924,  106,  106, 
          106,   84,  928,   92,  133,  106,  106,  332,  553,  929, 
          554,  555,  556,  557, 1034,  106,  642,  642,  930,  110, 
          936,  116,   77,  747,   88,  747,  941,  776,  776, 1049, 
          937,  434,  613,  944,  945,  304,  437,  106,  434,  434, 
          106,   88,  946,   88,   92,   61,   62,   63,   64,   88, 
           95,  106,  106,  106,   82,   92,   95,  133,   95,  948, 
          386,  949,  776,  319,   80,  434,  950,  952,  102,  967, 
          116,   78,  954,  351,  791,  414, 1019,  958,  102,  791, 
          510,  250,  415,  473,  785, 1025,   88,  510,  510, 1029, 
          961,  642,  401,  613,  963,  687,  403,  404,  965,   16, 
           16,   16,  516,  695,  313,   16,   16,  974,   16,  747, 
         1013,  791,  973,  975,  613,  977,  640,  106, 1006,  817, 
          820, 1007,  820,   95, 1010, 1024,  102,   80,  288, 1032, 
          820,  106,  106,  456,   78, 1035,  642, 1036,  313,  122, 
          642,  642,  716,  106, 1047,  536,  537,  541, 1038, 1051, 
          720,  721,  539,  313,  102,  102,   97,  444, 1055, 1057, 
         1059,  641,  709,   96,  653,   95, 1062, 1067,  729,  248, 
          248,   95, 1088,  102,  113,  102, 1075,  102,  747,   16, 
          747, 1085,  861, 1081,  629,  313,   95,  642,  122,  871, 
          642,  536,  537,  541,  351,  630,  631,   95,  539,  414, 
           16,  878,  106,  516,  631,   95,  415,  508,   92,  635, 
          637,  497,  631,  499,  631,  747,  102,  642,   92,  106, 
          434,  106,  635,  113,   16,  375,  115,  106,  480,  444, 
          102,  102,  102,  363,  137,  520,  730,  776, 1074,  588, 
          477,  478,  479,  217,  793,  481,   95,  879,  983,  867, 
          872,  922, 1027, 1026,  926,  513,  905,   95,  533,  106, 
          293,  279,  854, 1078,  106, 1073,   92,  536,  537,  543, 
          293,  351,   94,    0,  539,  115,    0,    0,  116,  853, 
          553,    0,  554,  555,  556,  557,    0,  248,  248,  248, 
          248,    0,  599,  600,   92,   92,  536,  537,  547,    0, 
            0,    0,    0,  539,  286,    0,   94,  515,    0,  798, 
          102,  102,    0,   92,  745,   92,    0,   92,    0,  293, 
            0,    0,  102,   94,    0,  287,  287,    0,    0,  287, 
            0,  553,  808,  554,  555,  556,  557,  558,  351,  516, 
            0,   96,  559,  642,  642,  642,  516,  516,    0,    0, 
          642,  311,  313,  513,    0,  678,   92,  287,  287,    0, 
          353,  355,  536,  537,  587,  560,    0,  820,    0,  539, 
           92,   92,   92,  562,  563,  564,  565,  841, 1018,    0, 
         1020,  102, 1021,  652,  444,  844, 1022,  662,  515,    0, 
         1040,  116,    0, 1030,  864,  865,  122,    0,  102,    0, 
          102,  481,  481,  481,  858,    0,  102,    0,  481,  434, 
           95,  566,  723,  889,    0,  890,    0,  892,    0,    0, 
           95,    0,  313,    0,    0,  135,  652,    0,    0,  313, 
          313,  113,  463,  463,  463,  617,    0,    0,    0,  463, 
          516,  710,  712,  102,  614,  332,    0,  516,  516,    0, 
           92,   92,    0,  313,    0,    0,  923,  434,  998,   98, 
            0,  540,   92,  916,  434,  434,    0,    0,   95,    0, 
          932,  933,  934,    0,    0,  493,    0,    0,  820, 1079, 
            0,  712,    0,  115,  332, 1080,    0, 1082,    0,    0, 
         1083,  434,  513,    0,  887,  414,   95,   95,    0,  513, 
          513,    0,  415,  532,    0,  614,  517,    0,  939,    0, 
          540,  135,    0,    0,    0,   95, 1092,   95,    0,   95, 
            0,   92,  293,  293,  293,    0,  614,  293,  293,  293, 
            0,  293,  126,    0,    0,    0,  653,    0,   92,    0, 
           92,   94,  614,  768,  515,    0,   92,    0,  386,    0, 
          981,  515,  515,  293,  293,  293,  293,  293,   95,    0, 
            0,  107, 1001,    0,  399,  400,    0,    0,    0,    0, 
           99,    0,   95,   95,   95,    0,  115,  248,  505,    0, 
          401,  126,  402,   92,  403,  404,  405,  406,  505,    0, 
          513,  287,  287,  287,  355,  107,  287,  513,  513,  293, 
            0,    0,  293,  614,   94,    0,  794,  287,    0,  287, 
          287,    0,  107,  313,    0,    0,  248,  518,  505,    0, 
            0,  414,  505,  293,  614,  515,    0,  414,  415, 1033, 
            0,    0,  515,  515,  415, 1039,  505,  505, 1042,    0, 
         1043,  505,  313,  815,  206,    0, 1044,  293,  469,  469, 
          469,    0,   95,   95, 1014,  469,  554,  555,  556,  557, 
          999,    0,    0,    0,   95,    0,    0,    0,  837,  505, 
          838,  379,  380,  381,  382,  383,    0,  712,  332,  887, 
            0,    0,  887, 1076,  887,    0,  887,    0,    0,    0, 
            0,    0,    0,  206,  117,    0,  601,  602,  603,  604, 
          605,  606,  607,  608,  609,  610,  611,  612,  613,  614, 
          615,  616,  617,  618,  619,  620,  621,  622,  623,  624, 
          625,  626,    0,   95,    0,    0,    0,  287,  875,  248, 
          105,    0,  646,  124,  650,    0,    0,    0,  287,  664, 
           95,  101,   95,  517,    0,  423,    0,    0,   95,    0, 
          517,  517,    0,    0,  287,  423,  909,  540,    0,  540, 
          540,  540,  540,  540,  105,    0,    0,    0,  540,    0, 
          287,    0,  646,  694,  664,    0,  887,  287,  887,    0, 
          887,  105,  124,  887,  287,   95,    0,    0,  520,  126, 
          931,  540,  287,  287,    0,  510,  287,   97,    0,  540, 
          540,  540,  540,    0,  423,  118,    0,  291,  542,  887, 
          545,  620,  548,    0,  620,    0,    0,  291,  548,    0, 
          726,  727,  553,    0,  554,  555,  556,  557,    0,  510, 
          107,   97,  287,    0,    0,  287,    0,  540,    0,    0, 
          505,  505,  505,  287,  510,  505,  505,  505,   97,  505, 
          313,  287,    0,    0,  518,    0,  745,  313,  313,  505, 
          505,  518,  518,  617,  746,    0,  291,  980,  505,  505, 
            0,  505,  505,  505,  505,  505,  510,  107,  516,  313, 
            0,   91,    0,  505,    0,    0,  313,  313,    0,  199, 
            0,    0,  617,  107,  287,  332,  505,  505,  505,  505, 
          505,  505,  505,  505,  505,  505,  505,  505,  505,    0, 
            0,  505,  505,  505,  505,    0,    0,  505,    0,   94, 
          505,  100,    0,  505,  313,  505,  542,  505,  510,  505, 
            0,  505,  505,  505,  505,  505,  505,  505,  199,  505, 
          206,  505,  206,  206,  206,  206,  206,    0,    0,    0, 
            0,  206,    0,  505,    0,    0,    0,  287,    0,    0, 
            0,    0,  516,    0,    0,  505,  513,    0,  519,    0, 
          516,    0,    0,    0,  206,  206,  120,    0,    0,    0, 
            0,    0,  206,  206,  206,  206,  510,    0,    0,    0, 
          124,    0,    0,    0,  287,  743,  510,    0,    0,  105, 
          620,    0,    0,  620,    0,    0,    0,  423,  423,  423, 
            0,    0,  423,  423,  423,    0,  423,    0,    0,  287, 
          206,  287,    0,    0,    0,  520,  423,    0,  287,  287, 
          510,    0,  520,  520,  743,  423,  423,    0,  423,  423, 
          423,  423,  423,    0,  510,  510,    0,  110,  620,  510, 
            0,  620,    0,    0,    0,  620,  620,    0,  620,  620, 
            0,  616,  105,    0,  616,  613,   97,    0,    0,  291, 
          291,  291,    0,  423,  291,  291,  291,  510,  291,  287, 
          423,  423,  620,    0,    0,  620,    0,  423,    0,    0, 
          894,  896,    0,    0,    0,    0,  901,  903,    0,    0, 
          291,  291,  291,  291,  291,  907,  694,  287,  423,    0, 
            0,  911,  126,  510,    0,  516,  110,  613,  513,    0, 
          510,  510,  516,  516,    0,    0,  613,    0,  513,   97, 
            0,    0,  423,    0,  894,  896,    0,  901,  903,    0, 
            0,  287,    0,    0,  510,    0,  291,  613,    0,  291, 
            0,    0,    0,    0,  113,  614,  119,    0,    0,    0, 
            0,  313,  513,    0,    0,  510,    0,    0,  313,  313, 
          291,    0,  510,  510,  617,    0,  513,  513,  613,  113, 
            0,  513,    0,    0,    0,  199,    0,  199,  199,  199, 
          199,  199,    0,    0,  291,    0,  199,    0,    0,  613, 
            0,  976,    0,  513,    0,  519,    0,  515,  979,  513, 
          513,  513,  519,  519,    0,  515,  614,    0,  287,  199, 
          199,    0,    0,    0,    0,    0,    0,  199,  199,  199, 
          199,    0,    0,    0,    0,    0,    0,  614,  209,  979, 
            0,    0,    0,  613,  613,  613,  287,  613,  510,  510, 
          510,  613,  613,  510,  510,  510,  613,  510,  613,  613, 
          613,  613,  613,  613,  613,  199,  613,  510,  510,  613, 
          613,  613,  613,  613,  613,  613,  510,  510,  613,  510, 
          510,  510,  510,  510,    0,  613,    0,  209,  613,  613, 
          613,  510,  613,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  510,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,    0,    0,  510, 
          510,  510,  510,  613,  522,  510,  613,  613,  510,  613, 
          613,  510,  613,  510,  613,  510,  613,  510,  613,  510, 
          510,  510,  510,  510,  510,  510,  613,  510,  613,  510, 
          287,  613,  613,  613,  613,  613,  613,    0,    0,    0, 
          613,  510,  613,  613,    0,  613,  613,  613,  613,  194, 
          613,  613,  613,  510,    0,  614,  614,  614,    0,  614, 
          513,  513,  513,  614,  614,  513,  513,  513,  614,  513, 
          614,  614,  614,  614,  614,  614,  614,    0,  614,  513, 
          513,  614,  614,  614,  614,  614,  614,  614,  513,  513, 
          614,  513,  513,  513,  513,  513,    0,  614,  194,    0, 
          614,  614,  614,  513,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  102, 
            0,  513,  513,  513,  513,  614,  525,  513,  614,  614, 
          513,  614,  614,  513,  614,  513,  614,  513,  614,  513, 
          614,  513,  513,  513,  513,  513,  513,  513,  614,  513, 
          614,  513,    0,  614,  614,  614,  614,  614,  614,    0, 
            0,  620,  614,  513,  614,  614,  521,  614,  614,  614, 
          614,  620,  614,  614,  614,  513,  629,  629,  629,    0, 
            0,    0,  629,  629,    0,  629,  630,  630,  630,    0, 
            0,    0,  630,  630,    0,  630,    0,    0,  553,    0, 
          554,  555,  556,  557,  209,  620,  209,  209,  209,  209, 
          209,    0,    0,    0,    0,  209,    0,    0,    0,  620, 
          620,    0,  124,    0,  620,  553,  517,  554,  555,  556, 
          557,  558,  745,    0,  517,    0,  559,    0,  209,  209, 
          942,    0,    0,    0,    0,    0,  209,  209,  209,  209, 
            0,    0,  620,    0,    0,    0,  629,  386,    0,  560, 
          561,    0,    0,    0,    0,    0,  630,  562,  563,  564, 
          565,    0,    0,  399,  400,    0,    0,  629,    0,    0, 
            0,    0,    0,    0,  209,    0,    0,  630,    0,  401, 
            0,    0,  616,  403,  404,  405,  406,    0,    0,    0, 
            0,  629,  616,    0,    0,  566,    0,    0,    0,    0, 
            0,  630,    0,    0,    0,    0,    0,    0,  553,    0, 
          554,  555,  556,  557,  558,    0,    0,    0,    0,  559, 
            0,    0,    0,    0,    0,  194,  616,  194,  194,  194, 
          194,  194,    0,    0,    0,    0,  194,    0,    0,    0, 
          616,  616,  560,  123,  121,  616,    0,  518,  386,    0, 
          562,  563,  564,  565,    0,  518,    0,    0,    0,  194, 
          194,    0,    0,    0,  399,  400,    0,  194,  194,  194, 
          194,    0,    0,  616,    0,    0,    0,    0,    0,    0, 
          401,    0,  402,    0,  403,  404,  405,  406,  566,    0, 
          409,    0,  410,  521,    0,    0,    0,    0,    0,    0, 
          521,  521,  176,    0,    0,  194,    0,    0,  616,  616, 
          616,    0,  616,  620,  620,  620,  616,  616,  620,  620, 
          620,  616,  620,  616,  616,  616,  616,  616,  616,  616, 
            0,  620,  620,  620,  616,  616,  616,  616,  616,  616, 
          616,  620,  620,  616,  620,  620,  620,  620,  620,    0, 
          616,  176,    0,  616,  616,  616,  620,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  620,  620, 
          620,  620,   93,    0,  620,  620,  620,  620,  616,    0, 
          620,  616,  616,  620,  616,  616,  620,  616,  620,  616, 
          620,  616,  620,  616,  620,  620,  620,  620,  620,  620, 
          620,  616,  620,  620,  620,    0,  616,  616,  616,  616, 
          616,  616,    0,    0,    0,  616,  620,  616,  616,  512, 
          616,  616,  616,  616,    0,  616,  616,  616,  620,  616, 
          616,  616,    0,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,    0,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
            0,  616,    0,    0,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,   92,    0,  616,  616,  616,  616,  616, 
            0,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,    0,  616,  616,  616, 
          616,  616,  616,    0,    0,  617,  616,  616,  616,  616, 
          511,  616,  616,  616,  616,  617,  616,  616,  616,  616, 
          962,    0,    0,    0,  966,    0,    0,  553,    0,  554, 
          555,  556,  557,  558,    0,    0,    0,    0,  559,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  176,  617, 
          176,  176,  176,  176,  176,    0,    0,    0,    0,  176, 
            0,  560,    0,  617,  617,    0,  125,  112,  617,    0, 
          520,  564,  565,    0,    0,    0,    0,    0,  520,    0, 
            0,    0,  176,  176,    0,    0,    0,    0,    0,    0, 
          176,  176,  176,  176,    0,    0,  617,    0,    0,    0, 
            0,    0,    0,  386,    0,    0,    0,  566,  391,  392, 
            0,    0,    0,    0,    0,    0,  512,    0,    0,  399, 
          400,    0,    0,  512,  512,    0,    0,    0,  176,    0, 
            0,    0,    0,    0,    0,  401,  304,  402,    0,  403, 
          404,  405,  406,  407,  408,  409,  304,  410,    0,  386, 
          387,  388,  389,  390,  391,  392,  393,  394,  395,  396, 
            0,    0,    0,    0, 1056,  399,  400, 1058, 1060,    0, 
            0, 1063, 1064,    0,    0,    0,    0,    0,    0,    0, 
          304,  401,    0,  402,    0,  403,  404,  405,  406,  407, 
          408,  409,    0,  410,  304,  304,    0,    0,  111,  304, 
            0,  386,  387,  388,  389,  390,  391,  392,  393,    0, 
          395,  396,    0,    0,    0,    0,    0,  399,  400,    0, 
            0,    0, 1087, 1089, 1090, 1091,    0,  304,    0,    0, 
            0,    0,    0,  401, 1093,  402,    0,  403,  404,  405, 
          406,  407,  408,  409,    0,  410,    0,  511,    0,    0, 
            0,    0,    0,    0,  511,  511,  177,    0,    0,    0, 
            0,    0,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,    0,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,    0,  617,  177,    0,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,   95,    0,  617,  617, 
          617,  617,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,    0, 
          617,  617,  617,  617,  617,  617,    0,    0,    0,  617, 
          617,  617,  617,  514,  617,  617,  617,  617,    0,  617, 
          617,  617,  617,  615,  615,  615,    0,  615,  304,  304, 
          304,  615,  615,  304,  304,  304,  615,  304,  615,  615, 
          615,  615,  615,  615,  615,    0,  615,  304,  304,  615, 
          615,  615,  615,  615,  615,  615,  304,  304,  615,  304, 
          304,  304,  304,  304,    0,  615,    0,    0,  615,  615, 
          615,  304,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  304,  304,  304,  304,  304,  109,    0,  304, 
          304,  304,  304,  615,    0,  304,  615,  615,  304,  615, 
          615,  304,  615,  304,  615,  304,  615,  304,  615,  304, 
          304,  304,  304,  304,  304,  304,  615,  304,  615,  304, 
            0,  615,  615,  615,  615,  615,  615,    0,    0,  621, 
          615,  304,  615,  615,  303,  615,  615,  615,  615,  621, 
          615,  615,  615,  304,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  177,  621,  177,  177,  177,  177,  177,    0, 
            0,    0,    0,  177,    0,    0,    0,  621,  621,    0, 
            0,  114,  621,    0,  519,  386,  387,  388,  389,  390, 
          391,  392,  519,    0,  395,  396,  177,  177,    0,    0, 
            0,  399,  400,    0,  177,  177,  177,  177,    0,    0, 
          621,    0,    0,    0,    0,    0,    0,  401,    0,  402, 
            0,  403,  404,  405,  406,  407,  408,  409,    0,  410, 
          514,    0,    0,    0,    0,    0,    0,  514,  514,    0, 
            0,    0,  177,    0,    0,    0,    0,    0,    0,    0, 
          622,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          622,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  628,  629,    0,    0,  630,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,  622,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,  300,  622,  622, 
            0,    0,  128,  622,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  622,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,  303,    0,    0,    0,    0,    0,    0,  303,  303, 
          178,    0,    0,    0,    0,    0,  618,  618,  618,    0, 
          618,  621,  621,  621,  618,  618,  621,  621,  621,  618, 
          621,  618,  618,  618,  618,  618,  618,  618,    0,  621, 
          621,  621,  618,  618,  618,  618,  618,  618,  618,  621, 
          621,  618,  621,  621,  621,  621,  621,    0,  618,  178, 
            0,  618,  618,  618,  621,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          108,    0,  621,  621,  621,  621,  618,    0,  621,  618, 
          618,  621,  618,  618,  621,  618,  621,  618,  621,  618, 
          621,  618,  621,  621,  621,  621,  621,  621,  621,  618, 
          621,  621,  621,    0,  618,  618,  618,  618,  618,  618, 
            0,    0,    0,  618,  621,  618,  618,  314,  618,  618, 
          618,  618,    0,  618,  618,  618,  621,  619,  619,  619, 
            0,  619,  622,  622,  622,  619,  619,  622,  622,  622, 
          619,  622,  619,  619,  619,  619,  619,  619,  619,    0, 
          622,  622,  622,  619,  619,  619,  619,  619,  619,  619, 
          622,  622,  619,  622,  622,  622,  622,  622,  411,  619, 
            0,    0,  619,  619,  619,  622,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,    0,    0,  622,  622,  622,  622,  619,    0,  622, 
          619,  619,  622,  619,  619,  622,  619,  622,  619,  622, 
          619,  622,  619,  622,  622,  622,  622,  622,  622,  622, 
          619,  622,  622,  622,    0,  619,  619,  619,  619,  619, 
          619,    0,    0,  313,  619,  622,  619,  619,    0,  619, 
          619,  619,  619,  313,  619,  619,  619,  622,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  178,  313,  178,  178, 
          178,  178,  178,    0,    0,    0,    0,  178,    0,    0, 
            0,  313,  313,    0,  126,  127,  313,    0,  521,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,    0, 
          178,  178,    0,    0,    0,    0,    0,    0,  178,  178, 
          178,  178,    0,    0,  313,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  314,    0,    0,    0,    0,    0, 
            0,  314,  314,    0,    0,    0,  178,    0,    0,    0, 
            0,    0,    0,    0,  433,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  433,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  795,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  433,    0, 
            0,    0,  386,  387,  388,  389,  390,  391,  392,  393, 
          394,  395,  396,  433,  397,  398,    0,  433,  399,  400, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  401,    0,  402,    0,  403,  404, 
          405,  406,  407,  408,  409,  433,  410,    0,    0,    0, 
            0,    0,    0,  134,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          617,  617,  617,    0,  617,  313,  313,  313,  617,  617, 
          313,  313,  313,  617,  313,  617,  617,  617,  617,  617, 
          617,  617,  134,    0,  313,  313,  617,  617,  617,  617, 
          617,  617,  617,  313,  313,  617,  313,  313,  313,  313, 
          313,    0,  617,    0,    0,  617,  617,  617,  313,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          313,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  105,    0,  313,  313,  313,  313, 
          617,    0,  313,  617,  617,  313,  617,  617,  313,  617, 
          313,  617,  313,  617,  313,  617,  313,  313,  313,  313, 
          313,  313,  313,  617,  313,    0,  313,    0,  617,  617, 
          617,  617,  617,  617,    0,    0,    0,  617,  313,  617, 
          617,  620,  617,  617,  617,  617,    0,  617,  617,  617, 
          313,  280,  280,  280,    0,  280,  433,  433,  433,  280, 
          280,  433,  433,  433,  280,  433,  280,  280,  280,  280, 
          280,  280,  280,  411,  433,  433,  433,  280,  280,  280, 
          280,  280,  280,  280,  433,  433,  280,  433,  433,  433, 
          433,  433,    0,  280,    0,    0,  280,  280,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  433,  433,  433,  433,  433,  433,  433,  433,  433, 
          433,  433,  433,  433,  433,  642,    0,  433,  433,  433, 
          433,  280,    0,  433,  280,  642,  433,  280,  280,  433, 
          280,  433,  280,  433,  280,  433,  280,  433,  433,  433, 
          433,  433,  433,  433,  280,  433,  433,  433,    0,  280, 
          280,  280,  280,  280,  280,    0,    0,    0,  280,  642, 
          280,  280,    0,  280,  280,  280,  280,    0,  280,  280, 
          280,  433,    0,    0,  642,    0,    0,    0,  642,  134, 
            0,  134,  134,  134,  134,  134,    0,    0,    0,    0, 
          134,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  510,    0,    0,    0,    0,  642,    0,    0,  510, 
            0,    0,    0,  134,  134,    0,    0,    0,    0,  124, 
          620,  134,  134,  134,  134,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  320,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  320,    0,    0,  134, 
            0,    0,    0,    0,    0,    0,    0,    0,  620,    0, 
            0,    0,    0,    0,    0,  620,  620,    0,    0,    0, 
            0,  616,    0,    0,    0,    0,    0,    0,    0,    0, 
          320,    0,    0,    0,    0,    0,    0,  801,    0,    0, 
            0,    0,  620,    0,    0,  320,    0,    0,    0,  320, 
            0,    0,    0,    0,    0,    0,    0,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,    0,  397, 
          398,    0,    0,  399,  400,    0,    0,  320,    0,    0, 
            0,    0,    0,    0,    0,  135,    0,    0,    0,  401, 
            0,  402,    0,  403,  404,  405,  406,  407,  408,  409, 
            0,  410,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  280,  280,  280,    0,  280,  642,  642,  642, 
          280,  280,  642,  642,  642,  280,  642,  280,  280,  280, 
          280,  280,  280,  280,  135,  642,  642,  642,  280,  280, 
          280,  280,  280,  280,  280,  642,  642,  280,  642,  642, 
          642,  642,  642,    0,  280,    0,    0,  280,  280,  280, 
            0,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  642,  642,  642,  642,  642,  642,  642,  642, 
          642,  642,  642,  642,  642,  642,  104,    0,  642,  642, 
          642,  642,  280,    0,  642,  280,    0,  642,  280,  280, 
          642,  280,  642,  280,  642,  280,  642,  280,  642,  642, 
          642,  642,  642,  642,  642,  280,  642,  642,  642,    0, 
          280,  280,  280,  280,  280,  280,    0,    0,    0,  280, 
            0,  280,  280,  616,  280,  280,  280,  280,    0,  280, 
          280,  280,  642,  280,  280,  280,    0,  280,  320,  320, 
          320,  280,  280,  320,  320,  320,  280,  320,  280,  280, 
          280,  280,  280,  280,  280,  411,    0,  320,  320,  280, 
          280,  280,  280,  280,  280,  280,  320,  320,  280,  320, 
          320,  320,  320,  320,    0,  280,    0,    0,  280,  280, 
          280,    0,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  280,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  510,    0,  320, 
          320,  320,  320,  280,    0,  320,  280,  510,  320,  280, 
          280,  320,  280,  320,  280,  320,  280,  320,  280,  320, 
          320,  320,  320,  320,  320,  320,  280,  320,    0,  320, 
            0,  280,  280,  280,  280,  280,  280,    0,    0,    0, 
          280,   91,  280,  280,    0,  280,  280,  280,  280,    0, 
          280,  280,  280,  320,    0,    0,  510,    0,  110,    0, 
          510,  135,    0,  135,  135,  135,  135,  135,    0,    0, 
            0,    0,  135,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,    0,    0,  510,    0, 
            0,  513,    0,    0,    0,  135,  135,    0,    0,    0, 
            0,  123,  616,  135,  135,  135,  135,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  513,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  513,    0, 
            0,  135,    0,    0,    0,    0,    0,    0,    0,    0, 
          616,    0,    0,    0,    0,    0,    0,  616,  616,    0, 
            0,    0,    0,  616,    0,    0,    0,    0,    0,    0, 
            0,    0,   94,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  616,    0,    0,  513,    0,  113, 
            0,  513,    0,    0,    0,    0,    0,    0,   96,  386, 
          387,  388,  389,  390,  391,  392,  393,  394,  395,  396, 
            0,  397,  398,    0,    0,  399,  400,    0,    0,  513, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  401,   96,  402,    0,  403,  404,  405,  406,  407, 
          408,  409,    0,  410,    0,    0,    0,    0,    0,   96, 
            0,    0,    0,    0,  613,  613,  613,    0,  613,  510, 
          510,  510,  613,  613,    0,  510,  510,  613,  510,  613, 
          613,  613,  613,  613,  613,  613,    0,  613,    0,  515, 
          613,  613,  613,  613,  613,  613,  613,  510,  510,  613, 
          510,  510,  510,  510,  510,    0,  613,  106,    0,  613, 
          613,  613,    0,  613,  613,  613,  613,  613,  613,  613, 
          613,  613,  613,  613,  510,  510,  510,  510,  510,  510, 
          510,  510,  510,  510,  510,  510,  510,  510,    0,    0, 
          510,  510,  510,  510,  613,  522,    0,  613,  613,  510, 
          613,  613,    0,  613,  617,  613,  510,  613,  510,  613, 
          510,  510,  510,  510,  510,  510,  510,  613,  510,  613, 
          510,    0,  613,  613,  613,  613,  613,  613,    0,    0, 
            0,  613,    0,  613,  613,    0,  613,  613,  613,  613, 
            0,  613,  613,  613,  510,  614,  614,  614,    0,  614, 
          513,  513,  513,  614,  614,    0,  513,  513,  614,  513, 
          614,  614,  614,  614,  614,  614,  614,    0,  614,    0, 
            0,  614,  614,  614,  614,  614,  614,  614,  513,  513, 
          614,  513,  513,  513,  513,  513,    0,  614,    0,    0, 
          614,  614,  614,    0,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  614,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,    0, 
            0,  513,  513,  513,  513,  614,  525,   96,  614,  614, 
          513,  614,  614,    0,  614,    0,  614,  513,  614,  513, 
          614,  513,  513,  513,  513,  513,  513,  513,  614,  513, 
          614,  513,    0,  614,  614,  614,  614,  614,  614,    0, 
            0,  620,  614,    0,  614,  614,    0,  614,  614,  614, 
          614,  620,  614,  614,  614,  513,  515,    0,    0,    0, 
            0,    0,    0,  515,  515,    0,    0,    0,    0,    0, 
           96,    0,  125,  617,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  105,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          620,    0,  124,    0,  620,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  617,    0,    0,    0,    0,    0,    0,  617,  617, 
            0,    0,  620,    0,  617,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  636,  637, 
            0,    0,  638,    0,    0,  617,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,  616,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,  616,  300,    0,   98,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  104,    0,    0,   98, 
            0,    0,    0,    0,    0,    0,    0,    0,  213,    0, 
            0,  616,    0,  123,    0,  616,   98,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  616,    0,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  616,  616, 
          616,    0,  616,  620,  620,  620,  616,  616,    0,  620, 
          620,  616,  620,  616,  616,  616,  616,  616,  616,  616, 
            0,  620,    0,    0,  616,  616,  616,  616,  616,  616, 
          616,  620,  620,  616,  620,  620,  620,  620,  620,    0, 
          616,    0,    0,  616,  616,  616,    0,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  620,  620,  620, 
          620,  620,    0,    0,  620,  620,  620,  620,  616,    0, 
            0,  616,  616,  620,  616,  616,    0,  616,    0,  616, 
          620,  616,  620,  616,  620,  620,  620,  620,  620,  620, 
          620,  616,  620,  620,  620,    0,  616,  616,  616,  616, 
          616,  616,    0,    0,    0,  616,    0,  616,  616,    0, 
          616,  616,  616,  616,    0,  616,  616,  616,  620,  616, 
          616,  616,    0,  616,  616,  616,  616,  616,  616,    0, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,    0,  616,    0,   98,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
            0,  616,    0,    0,  616,  616,  616,    0,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  517,    0,  616,  616,  616,  616,  616, 
          517,  517,  616,  616,  616,  616,  616,   98,  616,    0, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  616,    0,  616,  616,  616, 
          616,  616,  616,    0,    0,  617,  616,    0,  616,  616, 
            0,  616,  616,  616,  616,  617,  616,  616,  616,  616, 
            0,    0,    0,    0,    0,    0,    0,  671,  629,    0, 
            0,  672,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,  106, 
            0,    0,  194,  195,  196,  197,    0,    0,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,    0,    0,  300,    0,  617,    0,  125,    0,  617, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  617,    0,    0, 
            0,    0,    0,    0,    0,    0,  642,  637,  213,    0, 
          643,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,  313,    0,    0, 
            0,  300,    0,    0,    0,    0,    0,  313,  199,  200, 
           99,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,  689,  629,  212,    0,  690,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,  107,  192,  193,   99,    0,  213,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,  313,  300,  126,    0, 
          313,   99,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,    0,    0,    0,    0,    0,    0,    0,  313,    0, 
            0,  518,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  617,  617,  617,    0,  617,  617,  617, 
          617,  617,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,    0,  617,    0,    0,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,    0,  617,    0,    0,  617,  617, 
          617,    0,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,    0,    0,  617, 
          617,  617,  617,  617,    0,    0,  617,  617,  617,  617, 
          617,    0,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
            0,  617,  617,  617,  617,  617,  617,    0,    0,  642, 
          617,    0,  617,  617,    0,  617,  617,  617,  617,  642, 
          617,  617,  617,  617,  617,  617,  617,    0,  617,  313, 
          313,  313,  617,  617,    0,  313,  313,  617,  313,  617, 
          617,  617,  617,  617,  617,  617,    0,    0,    0,   99, 
          617,  617,  617,  617,  617,  617,  617,  313,  313,  617, 
          313,  313,  313,  313,  313,    0,  617,    0,  642,  617, 
          617,  617,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  313,  313,  313,  313,  313,  518,    0, 
          313,  313,  313,  313,  617,  518,  518,  617,  617,  313, 
          617,  617,   99,  617,    0,  617,  313,  617,  313,  617, 
          313,  313,  313,  313,  313,  313,  313,  617,  313,    0, 
          313,    0,  617,  617,  617,  617,  617,  617,    0,    0, 
          434,  617,    0,  617,  617,    0,  617,  617,  617,  617, 
          434,  617,  617,  617,  313,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  104,    0,  434,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  434,  434, 
            0,  122,    0,  434,    0,    0,    0,  513,    0,    0, 
            0,    0,    0,    0,    0,    0,  104,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  434,    0,  104,    0,    0,    0,    0,    0,    0, 
            0,  513,    0,    0,    0,    0,    0,    0,  873,    0, 
            0,  873,    0,    0,    0,    0,  513,    0,  883,    0, 
            0,    0,    0,  616,    0,    0,  280,  280,  280,    0, 
          280,  642,  642,  642,  280,  280,  642,  642,  642,  280, 
          642,  280,  280,  280,  280,  280,  280,  280,  513,  642, 
          642,    0,  280,  280,  280,  280,  280,  280,  280,  642, 
          642,  280,  642,  642,  642,  642,  642,    0,  280,    0, 
            0,  280,  280,  280,    0,  280,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  642,    0,    0, 
            0,    0,    0,    0,  642,  642,  280,    0,    0,  280, 
            0,  642,  280,  280,    0,  280,  433,  280,    0,  280, 
            0,  280,    0,    0,    0,    0,  433,    0,    0,  280, 
            0,  642,  642,    0,  280,  280,  280,  280,  280,  280, 
            0,    0,    0,  280,    0,  280,  280,    0,  280,  280, 
          280,  280,    0,  280,  280,  280,  642,    0,    0,    0, 
          433,    0,  434,  434,  434,    0,    0,  434,  434,  434, 
            0,  434,    0,    0,  433,  433,    0,    0,    0,  433, 
          434,  434,  434,    0,    0,    0,    0,    0,    0,    0, 
          434,  434,    0,  434,  434,  434,  434,  434,    0,    0, 
            0,    0,    0,  883,    0,  434,  883,  433,  873,    0, 
          883,  104,  616,    0,    0,    0,    0,  434,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,    0,    0,  434,  434,  434,  434,  614,  516,  434, 
            0,    0,  434,    0,    0,  434,    0,  434,  516,  434, 
            0,  434,    0,  434,  434,  434,  434,  434,  434,  434, 
          616,  434,  434,  434,    0,    0,    0,  616,  616,    0, 
            0,    0,    0,  616,  104,  434,    0,    0,    0,    0, 
            0,    0,  516,    0,    0,  513,    0,  434,    0,    0, 
            0,    0,  513,  513,  616,    0,  516,  516,  614,  116, 
          883,  516,  883,    0,  883,    0,    0,  883,    0,    0, 
            0,    0,    0,    0,    0,    0,  513,    0,    0,  614, 
          620,    0,    0,    0,    0,    0,    0,    0,    0,  516, 
            0,    0,    0,  883,    0,    0,    0,    0,    0,    0, 
            0,    0,  106,    0,    0,    0,  218,    0,    0,    0, 
            0,    0,    0,    0,  620,    0,  218,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  620, 
            0,    0,    0,    0,    0,    0,  106,    0,  433,  433, 
          433,    0,    0,  433,  433,  433,    0,  433,    0,    0, 
          262,    0,    0,  106,    0,    0,  433,  433,  433,    0, 
            0,  620,    0,    0,    0,  218,  433,  433,    0,  433, 
          433,  433,  433,  433,    0,    0,    0,    0,    0,    0, 
            0,  433,  515,  617,    0,    0,    0,    0,    0,    0, 
            0,    0,  515,  433,  433,  433,  433,  433,  433,  433, 
          433,  433,  433,  433,  433,  433,  433,    0,    0,  433, 
          433,  433,  433,    0,    0,  433,    0,    0,  433,    0, 
            0,  433,    0,  433,    0,  433,  515,  433,    0,  433, 
          433,  433,  433,  433,  433,  433,    0,  433,  433,  433, 
          515,  515,    0,  115,    0,  515,    0,    0,    0,    0, 
            0,  433,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,  516,  516,  433,    0,  516,  516,  516,    0,  516, 
            0,    0,    0,  515,    0,    0,    0,    0,    0,  516, 
          516,    0,    0,    0,    0,    0,    0,    0,  516,  516, 
            0,  516,  516,  516,  516,  516,    0,    0,    0,    0, 
            0,    0,    0,  516,  517,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,    0, 
            0,  516,  516,  516,  516,    0,  528,  516,    0,    0, 
          516,    0,    0,  516,    0,  516,    0,  516,  517,  516, 
          620,  516,  516,  516,  516,  516,  516,  516,    0,  516, 
            0,  516,  517,  517,    0,  117,    0,  517,  218,  218, 
          218,  106,  617,  516,  218,  218,    0,  218,    0,    0, 
            0,    0,    0,    0,    0,  516,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  517,  218,  218,  620,  218, 
          218,  218,  218,    0,    0,  620,  620,    0,  103,    0, 
            0,  616,  290,  117,    0,    0,    0,    0,    0,    0, 
          617,    0,  290,    0,    0,    0,    0,  617,  617,  620, 
            0,    0,  620,  617,  106,    0,    0,    0,    0,    0, 
            0,    0,  103,    0,  515,  515,  515,    0,  218,  515, 
          515,  515,    0,  515,  617,    0,  285,    0,    0,  103, 
            0,    0,  117,  515,  515,    0,    0,    0,    0,  218, 
            0,  290,  515,  515,    0,  515,  515,  515,  515,  515, 
            0,    0,    0,    0,    0,    0,    0,  515,  518,  434, 
            0,    0,    0,  218,  517,    0,    0,    0,  518,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,    0,    0,  515,  515,  515,  515,    0, 
          527,  515,    0,    0,  515,    0,    0,  515,    0,  515, 
            0,  515,  518,  515,    0,  515,  515,  515,  515,  515, 
          515,  515,    0,  515,    0,  515,  518,  518,    0,  118, 
            0,  518,    0,    0,    0,    0,    0,  515,    0,    0, 
            0,    0,    0,    0,    0,    0,  517,  517,  517,  515, 
            0,  517,  517,  517,    0,  517,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,  517,  517,    0,    0,    0, 
            0,    0,    0,    0,  517,  517,    0,  517,  517,  517, 
          517,  517,    0,    0,    0,    0,    0,    0,    0,  517, 
          520,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,    0,    0,  517,  517,  517, 
          517,    0,  529,  517,    0,    0,  517,    0,    0,  517, 
            0,  517,    0,  517,  520,  517,    0,  517,  517,  517, 
          517,  517,  517,  517,    0,  517,  118,  517,  520,  520, 
          117,  120,    0,  520,  290,  290,  290,  103,  434,  517, 
          290,  290,    0,  290,    0,    0,    0,    0,    0,    0, 
            0,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  520,    0,    0,    0,  290,  290,  290,  290,  290, 
            0,    0,    0,    0,  101,  118,    0,    0,   43,  120, 
            0,    0,    0,    0,    0,    0,  434,    0,   43,    0, 
            0,  517,    0,  434,  434,    0,    0,    0,  517,  517, 
          103,    0,    0,    0,    0,    0,    0,  518,  101,    0, 
          518,  518,  518,  119,  290,  518,  518,  518,    0,  518, 
          434,    0,    0,    0,    0,  101,    0,    0,  120,  518, 
          518,    0,    0,    0,    0,  290,    0,   43,  518,  518, 
            0,  518,  518,  518,  518,  518,    0,    0,    0,    0, 
            0,    0,    0,  518,  519,  520,    0,    0,    0,  290, 
          520,    0,  119,    0,  519,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,    0, 
            0,  518,  518,  518,  518,    0,  530,  518,    0,    0, 
          518,    0,    0,  518,  519,  518,    0,  518,  519,  518, 
            0,  518,  518,  518,  518,  518,  518,  518,    0,  518, 
            0,  518,  519,  519,    0,  119,    0,  519,    0,    0, 
            0,    0,    0,  518,    0,    0,    0,    0,    0,    0, 
            0,    0,  520,  520,  520,  518,    0,  520,  520,  520, 
            0,  520,    0,    0,    0,  519,    0,    0,    0,    0, 
            0,  520,  520,    0,    0,    0,    0,    0,    0,    0, 
          520,  520,    0,  520,  520,  520,  520,  520,    0,    0, 
            0,    0,    0,    0,    0,  520,  521,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  521,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,    0,    0,  520,  520,  520,  520,    0,  532,  520, 
            0,    0,  520,    0,    0,  520,    0,  520,    0,  520, 
          521,  520,    0,  520,  520,  520,  520,  520,  520,  520, 
            0,  520,    0,  520,  521,  521,  120,  121,    0,  521, 
           43,   43,   43,  101,  518,  520,   43,   43,    0,   43, 
            0,  518,  518,    0,    0,    0,    0,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  521,    0,    0, 
          119,   43,   43,   43,   43,   43,    0,    0,    0,    0, 
            0,  100,    0,    0,   25,  121,    0,    0,    0,    0, 
            0,    0,  520,    0,   25,    0,    0,  520,    0,  520, 
          520,    0,    0,    0,  520,  520,  101,    0,    0,    0, 
            0,    0,    0,    0,    0,  100,  519,  519,  519,    0, 
           43,  519,  519,  519,    0,  519,    0,    0,    0,    0, 
            0,  519,  100,    0,  121,  519,  519,    0,  519,  519, 
            0,   43,    0,   25,  519,  519,    0,  519,  519,  519, 
          519,  519,    0,    0,    0,    0,    0,    0,    0,  519, 
          512,    0,  519,    0,    0,   43,  521,    0,    0,    0, 
          512,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,    0,    0,  519,  519,  519, 
          519,    0,  531,  519,    0,    0,  519,    0,    0,  519, 
            0,  519,    0,  519,  512,  519,    0,  519,  519,  519, 
          519,  519,  519,  519,    0,  519,    0,  519,  512,  512, 
            0,  112,    0,  512,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,  521,  521, 
          521,  519,    0,  521,  521,  521,    0,  521,    0,    0, 
            0,  512,    0,    0,    0,    0,    0,  521,  521,    0, 
            0,    0,    0,    0,    0,    0,  521,  521,    0,  521, 
          521,  521,  521,  521,    0,    0,    0,    0,    0,    0, 
            0,  521,  511,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  511,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,    0,    0,  521, 
          521,  521,  521,    0,  533,  521,    0,    0,  521,    0, 
            0,  521,    0,  521,    0,  521,  511,  521,    0,  521, 
          521,  521,  521,  521,  521,  521,    0,  521,    0,  521, 
          511,  511,  121,  111,    0,  511,   25,   25,   25,    0, 
          100,  521,   25,   25,    0,   25,  123,    0,    0,    0, 
            0,    0,    0,  521,    0,  112,    0,    0,  111,    0, 
            0,    0,    0,  511,    0,    0,    0,   25,   25,   25, 
           25,   25,    0,    0,    0,    0,    0,  102,    0,    0, 
            0,  125,    0,    0,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,  521,    0,  123,  519,  519,    0,    0, 
          521,  521,    0,  100,  112,    0,    0,  111,    0,    0, 
          114,  102,  512,  512,  512,    0,   25,  512,  512,  512, 
            0,  512,    0,    0,    0,    0,    0,  616,  102,    0, 
          125,  512,  512,    0,    0,    0,  512,   25,    0,  511, 
          512,  512,    0,  512,  512,  512,  512,  512,    0,    0, 
            0,    0,    0,    0,    0,  512,  514,    0,  521,  114, 
            0,   25,  617,    0,    0,    0,  514,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,    0,    0,  512,  512,  512,  512,    0,  524,  512, 
            0,  514,  512,    0,    0,  512,    0,  512,    0,  512, 
          514,  512,    0,  512,  512,  512,  512,  512,  512,  512, 
            0,  512,    0,  512,  514,  514,    0,  114,    0,  514, 
            0,    0,    0,    0,    0,  512,    0,    0,    0,    0, 
            0,    0,    0,    0,  511,  511,  511,  512,    0,  511, 
          511,  511,    0,  511,    0,    0,    0,  514,    0,    0, 
            0,    0,    0,  511,  511,    0,    0,    0,    0,    0, 
            0,    0,  511,  511,    0,  511,  511,  511,  511,  511, 
            0,    0,    0,    0,    0,    0,    0,  511,  642,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  642,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  123,    0,  511,  511,  511,  511,    0, 
          523,  511,  112,    0,  511,  111,  616,  511,    0,  511, 
            0,  511,  642,  511,    0,  511,  511,  511,  511,  511, 
          511,  511,    0,  511,    0,  511,  642,  642,  125,    0, 
            0,  642,    0,    0,    0,    0,  102,  511,    0,    0, 
            0,  617,    0,   93,    0,    0,    0,    0,    0,  511, 
            0,    0,  128,    0,  616,    0,    0,  114,    0,  642, 
            0,  616,  616,  512,    0,    0,  511,  616,    0,   92, 
          512,  512,    0,  511,  511,    0,    0,   93,   95,    0, 
            0,    0,    0,    0,    0,  521,    0,    0,  616,  617, 
            0,    0,  521,  521,   93,    0,  617,  617,    0,  102, 
            0,  128,  617,   92,    0,    0,  127,    0,  514,  514, 
          514,    0,   95,  514,  514,  514,    0,  514,  514,    0, 
           92,    0,    0,  617,  512,  514,  514,  514,  514,   95, 
            0,    0,    0,  303,    0,    0,  514,  514,    0,  514, 
          514,  514,  514,  514,    0,    0,    0,    0,    0,    0, 
          511,  514,  303,    0,    0,  127,    0,    0,    0,  514, 
            0,    0,  303,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,    0,    0,  514, 
          514,  514,  514,    0,  526,  514,    0,  314,  514,    0, 
            0,  514,    0,  514,  109,  514,  303,  514,    0,  514, 
          514,  514,  514,  514,  514,  514,    0,  514,    0,  514, 
          303,  303,    0,  128,    0,  303,    0,    0,    0,    0, 
            0,  514,    0,    0,    0,    0,    0,    0,  109,    0, 
          642,  642,  642,  514,    0,  642,  642,  642,    0,  642, 
            0,    0,    0,  303,    0,  109,    0,    0,  642,  642, 
          642,    0,    0,    0,    0,    0,    0,    0,  642,  642, 
            0,  642,  642,  642,  642,  642,    0,    0,    0,    0, 
            0,    0,    0,  642,  314,  303,    0,    0,    0,    0, 
            0,    0,    0,    0,  314,  642,  642,  642,  642,  642, 
          642,  642,  642,  642,  642,  642,  642,  642,  642,    0, 
            0,  642,  642,  642,  642,    0,    0,  642,    0,  128, 
          642,    0,   93,  642,    0,  642,  108,  642,  314,  642, 
            0,  642,  642,  642,  642,  642,  642,  642,    0,  642, 
          642,  642,  314,  314,    0,  127,    0,  314,   92,    0, 
            0,    0,    0,  642,    0,    0,    0,   95,    0,    0, 
          108,    0,    0,    0,    0,  642,    0,    0,    0,    0, 
            0,  512,    0,  127,    0,  314,    0,  108,  512,  512, 
          303,    0,    0,    0,    0,   93,    0,  303,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,  511,    0,    0, 
            0,    0,    0,    0,  511,  511,  514,  314,    0,    0, 
            0,   92,    0,  514,  514,    0,    0,    0,    0,    0, 
           95,    0,    0,    0,  303,  303,  303,    0,    0,  303, 
          303,  303,    0,  303,  314,    0,    0,    0,    0,    0, 
            0,  314,  314,  303,  303,    0,    0,    0,    0,    0, 
            0,    0,  303,  303,    0,  303,  303,  303,  303,  303, 
            0,    0,    0,    0,    0,    0,    0,  303,  454,    0, 
            0,    0,    0,  109,    0,    0,    0,    0,  454,  303, 
          303,  303,  303,  303,  303,  303,  303,  303,  303,  303, 
          303,  303,  303,    0,    0,  303,  303,  303,  303,    0, 
            0,  303,    0,    0,  303,    0,    0,  303,    0,  303, 
            0,  303,  454,  303,    0,  303,  303,  303,  303,  303, 
          303,  303,  303,  303,    0,  303,  454,  454,    0,  303, 
          303,  454,    0,    0,    0,    0,  109,  303,    0,    0, 
            0,    0,    0,    0,    0,    0,  314,  314,  314,  303, 
            0,  314,  314,  314,    0,  314,    0,    0,    0,  454, 
            0,    0,    0,    0,    0,  314,  314,    0,    0,    0, 
            0,    0,    0,    0,  314,  314,    0,  314,  314,  314, 
          314,  314,    0,    0,    0,    0,    0,    0,    0,  314, 
          325,    0,    0,    0,    0,  108,    0,    0,    0,    0, 
          325,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,    0,    0,  314,  314,  314, 
          314,    0,    0,  314,    0,    0,  314,    0,    0,  314, 
            0,  314,    0,  314,  325,  314,    0,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,    0,  314,  325,  325, 
            0,  314,  314,  325,    0,    0,    0,    0,  108,  314, 
            0,    0,    0,    0,    0,    0,    0,    0,  874,    0, 
            0,  314,    0,    0,    0,    0,    0,    0,  886,    0, 
            0,  325,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          454,  454,  454,    0,    0,  454,  454,  454,    0,  454, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  454, 
          454,    0,    0,    0,    0,    0,    0,    0,  454,  454, 
            0,  454,  454,  454,  454,  454,    0,    0,    0,    0, 
            0,    0,    0,  454,  261,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  261,  454,  454,  454,  454,  454, 
          454,  454,  454,  454,  454,  454,  454,  454,  454,    0, 
            0,  454,  454,  454,  454,    0,    0,  454,    0,    0, 
          454,    0,    0,  454,    0,  454,    0,  454,  261,  454, 
            0,  454,  454,  454,  454,  454,  454,  454,    0,  454, 
            0,  454,  261,  261,    0,    0,    0,  261,    0,    0, 
            0,    0,    0,  454,    0,    0,    0,    0,    0,    0, 
            0,    0,  325,  325,  325,  454,    0,  325,  325,  325, 
            0,  325,    0,  886,    0,  357,  886,    0, 1028,    0, 
          886,  325,  325,    0,    0,    0,    0,    0,    0,    0, 
          325,  325,    0,  325,  325,  325,  325,  325,    0,    0, 
            0,    0,    0,    0,    0,  325,  320,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  320,  325,  325,  325, 
          325,  325,  325,  325,  325,  325,  325,  325,  325,  325, 
          325,    0,    0,  325,  325,  325,  325,    0,    0,  325, 
            0,    0,  325,    0,    0,  325,    0,  325,    0,  325, 
          320,  325,    0,  325,  325,  325,  325,  325,  325,  325, 
            0,  325,    0,  325,  320,  320,    0,    0,    0,  320, 
          886,    0,  886,    0,  886,  325,    0,  886,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  325,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  320,    0,    0, 
            0,    0,    0,  886,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  261,  261,  261,    0, 
            0,  261,  261,  261,    0,  261,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  261,  261,    0,    0,    0, 
            0,    0,    0,    0,  261,  261,    0,  261,  261,  261, 
          261,  261,    0,    0,    0,    0,    0,    0,    0,  261, 
          353,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          353,  261,  261,  261,  261,  261,  261,  261,  261,  261, 
          261,  261,  357,  261,  261,    0,    0,  261,  261,  357, 
          357,    0,    0,  261,    0,    0,  261,    0,    0,  261, 
            0,  261,    0,  261,  353,  261,    0,  261,  261,  261, 
          261,  261,  261,  261,    0,  261,    0,  261,    0,  353, 
            0,    0,    0,  353,    0,    0,    0,    0,    0,  261, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,  320, 
          320,  261,    0,  320,  320,  320,    0,  320,    0,    0, 
            0,  353,    0,    0,    0,    0,    0,  320,  320,    0, 
            0,    0,    0,    0,    0,    0,  320,  320,    0,  320, 
          320,  320,  320,  320,    0,    0,    0,    0,    0,    0, 
            0,  320,  354,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  354,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,    0,    0,  320, 
          320,  320,  320,    0,    0,  320,    0,    0,  320,    0, 
            0,  320,    0,  320,    0,  320,  354,  320,    0,  320, 
          320,  320,  320,  320,  320,  320,    0,  320,    0,  320, 
            0,  354,    0,    0,    0,  354,    0,    0,    0,    0, 
            0,  320,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  320,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  354,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           60,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           60,    0,  353,  353,  353,    0,    0,  353,  353,  353, 
            0,  353,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  353,  353,    0,    0,    0,    0,    0,    0,    0, 
          353,  353,    0,  353,  353,  353,  353,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,  317,    0,    0,   60, 
            0,    0,    0,    0,    0,    0,  317,  353,  353,  353, 
          353,  353,  353,  353,  353,  353,  353,  353,  353,  353, 
          353,    0,    0,  353,  353,  353,  353,    0,    0,  353, 
            0,    0,  353,    0,    0,  353,    0,  353,    0,  353, 
          317,  353,    0,  353,  353,  353,  353,  353,  353,  353, 
            0,  353,    0,  353,    0,  317,    0,    0,    0,  317, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  354,  354,  354,  353,    0,  354, 
          354,  354,    0,  354,    0,    0,    0,  317,    0,    0, 
            0,    0,    0,  354,  354,    0,    0,    0,    0,    0, 
            0,    0,  354,  354,    0,  354,  354,  354,  354,  354, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,  354, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
          354,  354,  354,    0,    0,  354,  354,  354,  354,    0, 
            0,  354,    0,    0,  354,    0,    0,  354,    0,  354, 
            0,  354,  239,  354,    0,  354,  354,  354,  354,  354, 
          354,  354,    0,  354,    0,  354,  239,  239,    0,    0, 
            0,  239,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  354, 
            0,    0,   60,   60,   60,    0,    0,   60,   60,   60, 
            0,   60,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   60,   60,    0,    0,    0,    0,    0,    0,    0, 
           60,   60,    0,   60,   60,   60,   60,   60,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,  317,  317, 
          317,    0,    0,  317,  317,  317,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  317,  317,    0, 
            0,    0,   60,  236,    0,   60,  317,  317,    0,  317, 
          317,  317,  317,  317,    0,    0,    0,  236,  236,    0, 
            0,    0,  236,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,   60,    0,  317, 
          317,  317,  317,    0,    0,  317,    0,    0,  317,    0, 
            0,  317,    0,  317,    0,  317,    0,  317,    0,  317, 
          317,  317,  317,  317,  317,  317,    0,  317,    0,  317, 
            0,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
          239,  239,  239,  317,    0,  239,  239,  239,    0,  239, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  239, 
          239,    0,    0,    0,    0,  233,    0,    0,  239,  239, 
            0,  239,  239,  239,  239,  239,    0,    0,    0,  233, 
          233,    0,    0,  239,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  239,  239,  239,  239, 
          239,  239,  239,  239,  239,  239,    0,  239,  239,    0, 
            0,  239,  239,    0,    0,    0,    0,  239,    0,    0, 
          239,    0,    0,  239,    0,  239,    0,  239,    0,  239, 
            0,  239,  239,  239,  239,  239,  239,  239,    0,  239, 
            0,  239,  235,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,  239,    0,    0,    0,    0,    0,    0, 
            0,  236,  236,  236,    0,  239,  236,  236,  236,    0, 
          236,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,    0,    0,    0,    0,  235,    0,    0,  236, 
          236,    0,  236,  236,  236,  236,  236,    0,    0,    0, 
          235,  235,    0,    0,  236,  235,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  236,  236,  236, 
          236,  236,  236,  236,  236,  236,  236,    0,  236,  236, 
            0,    0,  236,  236,    0,    0,    0,    0,  236,    0, 
            0,  236,    0,    0,  236,    0,  236,    0,  236,    0, 
          236,    0,  236,  236,  236,  236,  236,  236,  236,    0, 
          236,    0,  236,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,    0,    0,  236,    0,    0,    0,    0,  234, 
            0,    0,    0,  233,  233,  233,  236,    0,  233,  233, 
          233,    0,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  233,  233,    0,    0,    0,    0,    0,    0, 
            0,  233,  233,  234,  233,  233,  233,  233,  233,    0, 
            0,    0,    0,    0,    0,    0,  233,  234,  234,    0, 
            0,    0,  234,    0,    0,    0,    0,    0,    0,  233, 
          233,  233,  233,  233,  233,  233,  233,  233,  233,    0, 
          233,  233,    0,    0,  233,  233,    0,    0,    0,    0, 
          233,    0,    0,  233,    0,    0,  233,    0,  233,    0, 
          233,  237,  233,    0,  233,  233,  233,  233,  233,  233, 
          233,  237,  233,    0,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,  235,    0,  233,  235, 
          235,  235,    0,  235,    0,  237,    0,    0,    0,    0, 
            0,    0,    0,  235,  235,    0,    0,    0,    0,  237, 
          237,    0,  235,  235,  237,  235,  235,  235,  235,  235, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,  235,  235,  235,  235,  235,  235,  235,  235,  235, 
            0,  235,  235,    0,    0,  235,  235,    0,    0,    0, 
          434,  235,    0,    0,  235,    0,    0,  235,    0,  235, 
          434,  235,    0,  235,    0,  235,  235,  235,  235,  235, 
          235,  235,    0,  235,    0,  235,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,  103,    0,    0,    0,    0,  235, 
            0,  234,  234,  234,    0,    0,  234,  234,  234,  434, 
          234,  122,    0,  434,    0,    0,    0,    0,    0,    0, 
          234,  234,    0,    0,    0,    0,    0,    0,    0,  234, 
          234,    0,  234,  234,  234,  234,  234,    0,    0,    0, 
            0,  434,    0,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,    0,  234,  234, 
            0,    0,  234,  234,    0,    0,    0,    0,  234,    0, 
            0,  234,    0,    0,  234,    0,  234,    0,  234,    0, 
          234,   64,  234,  234,  234,  234,  234,  234,  234,    0, 
          234,   64,  234,  237,  237,  237,    0,    0,  237,  237, 
          237,    0,  237,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,  237,  237,    0,    0,  234,    0,    0,    0, 
            0,  237,  237,    0,  237,  237,  237,  237,  237,    0, 
            0,    0,    0,    0,    0,    0,  237,  516,    0,    0, 
           64,    0,    0,    0,    0,    0,    0,  516,    0,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,  237,    0, 
          237,  237,    0,    0,  237,  237,    0,    0,    0,    0, 
          237,    0,    0,  237,    0,    0,  237,    0,  237,    0, 
          237,   97,  237,    0,  237,  237,  237,  237,  237,  237, 
          237,    0,  237,    0,  237,    0,  516,    0,  116,    0, 
          516,    0,  434,  434,  434,    0,  237,    0,  434,  434, 
            0,  434,    0,    0,    0,    0,    0,    0,  237,    0, 
          434,    0,    0,    0,    0,    0,    0,    0,  516,    0, 
          434,  434,    0,  434,  434,  434,  434,  434,    0,    0, 
            0,    0,    0,    0,    0,    0,  515,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  515,  434,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,    0,    0,  434,  434,  434,  434,    0,    0,    0, 
            0,    0,  434,    0,    0,    0,    0,    0,    0,  434, 
           96,  434,    0,  434,  434,  434,  434,  434,  434,  434, 
            0,  434,  434,  434,    0,  515,    0,  115,    0,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  517,    0,    0,    0,  434,    0,    0, 
            0,    0,    0,  517,    0,    0,    0,  515,    0,    0, 
            0,    0,    0,   64,   64,   64,    0,    0,   64,   64, 
           64,    0,   64,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   64,   64,    0,    0,    0,   98,    0,    0, 
            0,   64,   64,    0,   64,   64,   64,   64,   64,    0, 
            0,    0,  517,    0,  117,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  516, 
          516,  516,    0,    0,    0,  516,  516,    0,  516,    0, 
            0,    0,    0,    0,  517,    0,    0,    0,    0,    0, 
            0,    0,    0,   64,    0,    0,   64,  516,  516,    0, 
          516,  516,  516,  516,  516,    0,    0,    0,  518,    0, 
            0,    0,    0,    0,   64,    0,    0,    0,  518,    0, 
            0,    0,    0,    0,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,   64,    0, 
          516,  516,  516,  516,    0,  528,    0,    0,    0,  516, 
            0,    0,   99,    0,    0,    0,  516,    0,  516,    0, 
          516,  516,  516,  516,  516,  516,  516,  518,  516,  118, 
          516,  518,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,    0,    0,    0,  515,  515,    0,  515,    0,    0, 
            0,    0,    0,    0,  516,  304,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,    0,  515,  515,    0,  515, 
          515,  515,  515,  515,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,    0,  411,  515, 
          515,  515,  515,    0,  527,  517,  517,  517,  515,    0, 
            0,  517,  517,    0,  517,  515,    0,  515,    0,  515, 
          515,  515,  515,  515,  515,  515,    0,  515,    0,  515, 
            0,    0,    0,  517,  517,    0,  517,  517,  517,  517, 
          517,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  520,    0,    0,    0,    0,    0, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,    0,    0,  517,  517,  517,  517, 
            0,  529,    0,    0,    0,  517,    0,    0,  101,    0, 
            0,    0,  517,    0,  517,    0,  517,  517,  517,  517, 
          517,  517,  517,  520,  517,  120,  517,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          518,  518,  518,    0,    0,    0,  518,  518,    0,  518, 
          517,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  518,  518, 
            0,  518,  518,  518,  518,  518,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,    0, 
            0,  518,  518,  518,  518,    0,  530,    0,    0,    0, 
          518,    0,    0,  100,    0,    0,    0,  518,    0,  518, 
            0,  518,  518,  518,  518,  518,  518,  518,  519,  518, 
          119,  518,  519,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,  518,  521,    0,    0,    0, 
          519,    0,  386,  387,  388,  389,  390,  391,  392,  393, 
          394,  395,  396,    0,  397,  398,    0,    0,  399,  400, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          102,    0,    0,    0,  401,    0,  402,    0,  403,  404, 
          405,  406,  407,  408,  409,  521,  410,  121,    0,  521, 
            0,    0,    0,    0,    0,    0,  520,  520,  520,    0, 
            0,    0,  520,  520,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  521,    0,    0, 
            0,    0,    0,    0,  520,  520,    0,  520,  520,  520, 
          520,  520,    0,    0,    0,  512,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  512,    0,    0,    0,    0, 
            0,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,    0,    0,  520,  520,  520, 
          520,    0,  532,    0,    0,    0,  520,    0,    0,   93, 
            0,    0,    0,  520,    0,  520,    0,  520,  520,  520, 
          520,  520,  520,  520,  512,  520,  112,  520,  512,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,  519,  519,    0,    0,    0,  519,  519,    0, 
          519,  520,    0,    0,    0,    0,  512,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  519, 
          519,    0,  519,  519,  519,  519,  519,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
            0,    0,  519,  519,  519,  519,    0,  531,  521,  521, 
          521,  519,    0,    0,  521,  521,    0,  521,  519,    0, 
          519,    0,  519,  519,  519,  519,  519,  519,  519,    0, 
          519,    0,  519,    0,    0,    0,  521,  521,    0,  521, 
          521,  521,  521,  521,    0,    0,    0,  511,    0,    0, 
            0,    0,    0,    0,    0,    0,  519,  511,    0,    0, 
            0,    0,    0,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,    0,    0,  521, 
          521,  521,  521,    0,  533,    0,    0,    0,  521,    0, 
            0,   92,    0,    0,    0,  521,    0,  521,    0,  521, 
          521,  521,  521,  521,  521,  521,  511,  521,  111,  521, 
          511,    0,    0,    0,    0,    0,    0,  512,  512,  512, 
            0,    0,    0,  512,  512,    0,  512,    0,    0,    0, 
            0,    0,    0,  521,    0,    0,    0,    0,  511,    0, 
            0,    0,    0,    0,    0,  512,  512,    0,  512,  512, 
          512,  512,  512,    0,    0,    0,  514,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,    0, 
            0,    0,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,    0,    0,  512,  512, 
          512,  512,    0,  524,    0,    0,    0,  512,    0,    0, 
           95,    0,    0,    0,  512,    0,  512,    0,  512,  512, 
          512,  512,  512,  512,  512,  514,  512,  114,  512,  514, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  303,    0,    0,    0,    0,    0,    0, 
            0,    0,  512,  303,    0,    0,    0,  514,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,  109,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  303,    0,  128,    0,  303,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          511,  511,  511,    0,    0,    0,  511,  511,    0,  511, 
            0,    0,    0,    0,    0,  303,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  511,  511, 
            0,  511,  511,  511,  511,  511,    0,    0,    0,  314, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  314, 
            0,    0,    0,    0,    0,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,    0, 
            0,  511,  511,  511,  511,    0,  523,    0,    0,    0, 
          511,    0,    0,  108,    0,    0,    0,  511,    0,  511, 
            0,  511,  511,  511,  511,  511,  511,  511,  314,  511, 
          127,  511,  314,    0,    0,    0,    0,    0,    0,  514, 
          514,  514,    0,    0,    0,  514,  514,    0,  514,    0, 
            0,    0,    0,    0,    0,  511,    0,    0,    0,    0, 
          314,    0,    0,    0,    0,    0,    0,  514,  514,    0, 
          514,  514,  514,  514,  514,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,    0,    0, 
          514,  514,  514,  514,    0,  526,  303,  303,  303,  514, 
            0,    0,  303,  303,    0,  303,  514,  231,  514,    0, 
          514,  514,  514,  514,  514,  514,  514,    0,  514,    0, 
          514,  231,  231,    0,  303,  303,  231,  303,  303,  303, 
          303,  303,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  514,    0,    0,    0,    0,    0, 
            0,  303,  303,  303,  303,  303,  303,  303,  303,  303, 
          303,  303,  303,  303,  303,  232,    0,  303,  303,  303, 
          303,    0,    0,    0,    0,  232,  303,    0,    0,    0, 
            0,    0,    0,  303,    0,  303,    0,  303,  303,  303, 
          303,  303,  303,  303,    0,  303,    0,  303,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
            0,  314,  314,  314,    0,    0,    0,  314,  314,    0, 
          314,  303,    0,  232,  232,    0,    0,    0,  232,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  314, 
          314,    0,  314,  314,  314,  314,  314,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          255,    0,  314,  314,  314,  314,    0,    0,    0,    0, 
          255,  314,    0,    0,    0,    0,    0,    0,  314,    0, 
          314,    0,  314,  314,  314,  314,  314,  314,  314,    0, 
          314,    0,  314,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  255,  231,  231,  231,    0,    0, 
          231,  231,  231,    0,  231,    0,  314,    0,  255,  255, 
            0,    0,    0,  255,  231,  231,    0,    0,    0,    0, 
            0,    0,    0,  231,  231,    0,  231,  231,  231,  231, 
          231,    0,    0,    0,    0,    0,    0,    0,  231,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  231,  231,  231,  231,  231,  231,  231,  231,  231, 
          231,    0,  231,  231,    0,    0,  231,  231,    0,    0, 
            0,    0,  231,    0,    0,  231,    0,    0,  231,    0, 
          231,    0,    0,  256,  231,    0,    0,    0,  231,  231, 
          231,  231,  231,  256,  231,    0,  231,  232,  232,  232, 
            0,    0,  232,  232,  232,    0,  232,    0,  231,    0, 
            0,    0,    0,    0,    0,    0,  232,  232,    0,    0, 
          231,    0,    0,    0,    0,  232,  232,  256,  232,  232, 
          232,  232,  232,    0,    0,    0,    0,    0,    0,    0, 
          232,  256,  256,    0,    0,    0,  256,    0,    0,    0, 
            0,    0,    0,  232,  232,  232,  232,  232,  232,  232, 
          232,  232,  232,    0,  232,  232,    0,    0,  232,  232, 
            0,    0,    0,    0,  232,    0,    0,  232,    0,    0, 
          232,    0,  232,    0,    0,    0,  232,    0,    0,    0, 
          232,  232,  232,  232,  232,    0,  232,    0,  232,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          232,    0,  255,  255,  255,    0,    0,  255,  255,  255, 
            0,  255,  232,  242,    0,    0,    0,    0,    0,    0, 
            0,  255,  255,  242,    0,    0,    0,    0,    0,    0, 
          255,  255,    0,  255,  255,  255,  255,  255,    0,    0, 
            0,    0,    0,    0,    0,  255,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  242,  255,  255, 
          255,  255,  255,  255,  255,  255,  255,  255,    0,  255, 
          255,  242,  242,  255,  255,    0,  242,    0,    0,  255, 
            0,    0,  255,    0,    0,  255,    0,  255,    0,    0, 
            0,  255,    0,    0,    0,    0,    0,  255,  255,  255, 
            0,  255,    0,  255,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  255,  240,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  240,  255,    0,    0, 
            0,    0,    0,    0,    0,  256,  256,  256,    0,    0, 
          256,  256,  256,    0,  256,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  256,  256,    0,    0,    0,    0, 
          240,    0,    0,  256,  256,    0,  256,  256,  256,  256, 
          256,    0,    0,    0,  240,  240,    0,    0,  256,  240, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  256,  256,  256,  256,  256,  256,  256,  256,  256, 
          256,    0,  256,  256,    0,    0,  256,  256,    0,    0, 
            0,    0,  256,    0,    0,  256,    0,    0,  256,    0, 
          256,    0,    0,    0,  256,    0,    0,    0,    0,    0, 
          256,  256,  256,    0,  256,    0,  256,    0,    0,    0, 
            0,    0,  241,    0,    0,    0,    0,    0,  256,    0, 
            0,    0,  241,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  242,  242,  242,    0,    0, 
          242,  242,  242,    0,  242,    0,  241,    0,    0,    0, 
            0,    0,    0,    0,  242,  242,    0,    0,    0,    0, 
          241,  241,    0,  242,  242,  241,  242,  242,  242,  242, 
          242,    0,    0,    0,    0,    0,    0,    0,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  242,  242,  242,  242,  242,  242,  242,  242,  242, 
          242,    0,  242,  242,    0,    0,    0,    0,    0,    0, 
            0,    0,  242,    0,    0,  242,    0,  245,  242,    0, 
          242,    0,    0,    0,  242,    0,    0,  245,    0,    0, 
          242,  242,  242,    0,  242,    0,  242,    0,  240,  240, 
          240,    0,    0,  240,  240,  240,    0,  240,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,  240,  240,    0, 
          242,  245,    0,    0,    0,    0,  240,  240,    0,  240, 
          240,  240,  240,  240,    0,  245,  245,    0,    0,    0, 
          245,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,  240,  240,  240,  240,  240, 
          240,  240,  240,  240,    0,  240,  240,    0,    0,    0, 
            0,    0,    0,    0,    0,  240,    0,    0,  240,    0, 
            0,  240,    0,  240,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,  240,  240,  240,    0,  240,    0,  240, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  240,  241,  241,  241,    0,    0,  241, 
          241,  241,    0,  241,    0,  247,    0,    0,    0,    0, 
            0,    0,    0,  241,  241,    0,    0,    0,    0,  247, 
          247,    0,  241,  241,  247,  241,  241,  241,  241,  241, 
            0,    0,    0,    0,    0,    0,    0,  241,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          241,  241,  241,  241,  241,  241,  241,  241,  241,  241, 
            0,  241,  241,    0,    0,    0,    0,    0,    0,    0, 
            0,  241,    0,    0,  241,    0,  246,  241,    0,  241, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,  241, 
          241,  241,    0,  241,    0,  241,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  241,    0,  245, 
          245,  245,    0,    0,  245,  245,  245,    0,  245,  241, 
          246,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
            0,    0,    0,    0,  246,  246,    0,  245,  245,  246, 
          245,  245,  245,  245,  245,    0,    0,    0,    0,    0, 
            0,    0,  245,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  245,  245,  245,  245,  245, 
          245,  245,  245,  245,  245,    0,  245,  245,    0,    0, 
            0,    0,    0,    0,    0,    0,  245,    0,    0,  245, 
            0,    0,  245,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,  245,  245,    0,    0,    0,    0, 
          245,    0,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  245,  247,  247,  247,    0,    0,  247,  247, 
          247,    0,  247,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,  247,  247,    0,    0,  244,    0,    0,    0, 
            0,  247,  247,    0,  247,  247,  247,  247,  247,    0, 
          244,  244,    0,    0,    0,  244,  247,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  247, 
          247,  247,  247,  247,  247,  247,  247,  247,  247,    0, 
          247,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  247,    0,  243,  247,    0,  247,    0, 
            0,    0,    0,    0,    0,  243,    0,    0,  247,  247, 
            0,    0,    0,    0,  247,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,  246,  246, 
          246,    0,    0,  246,  246,  246,    0,  246,  247,  243, 
            0,    0,    0,    0,    0,    0,    0,  246,  246,    0, 
            0,    0,    0,  243,  243,    0,  246,  246,  243,  246, 
          246,  246,  246,  246,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,  246,  246,  246,  246,  246, 
          246,  246,  246,  246,    0,  246,  246,    0,    0,    0, 
            0,    0,    0,    0,    0,  246,    0,    0,  246,    0, 
            0,  246,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,  248,    0,  246,  246,    0,    0,    0,    0,  246, 
            0,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  246,  244,  244,  244,    0,    0,  244, 
          244,  244,    0,  244,    0,  248,    0,    0,    0,    0, 
            0,    0,    0,  244,  244,    0,    0,    0,    0,  248, 
          248,    0,  244,  244,  248,  244,  244,  244,  244,  244, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
            0,  244,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,  244,    0,  249,  244,    0,  244, 
            0,    0,    0,    0,    0,    0,  249,    0,    0,  244, 
          244,    0,    0,    0,    0,  244,    0,  243,  243,  243, 
            0,    0,  243,  243,  243,    0,  243,  244,    0,    0, 
            0,    0,    0,    0,    0,    0,  243,  243,    0,  244, 
          249,    0,    0,    0,    0,  243,  243,    0,  243,  243, 
          243,  243,  243,    0,  249,  249,    0,    0,    0,  249, 
          243,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  243, 
          243,    0,    0,    0,  243,  243,    0,    0,    0,    0, 
            0,    0,    0,    0,  243,    0,    0,  243,    0,    0, 
          243,    0,  243,    0,    0,    0,    0,    0,    0,    0, 
          250,    0,    0,    0,    0,    0,    0,    0,  243,    0, 
          250,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          243,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  243,  248,  248,  248,    0,    0,  248,  248, 
          248,    0,  248,    0,  250,    0,    0,    0,    0,    0, 
            0,    0,  248,  248,    0,    0,    0,    0,  250,  250, 
            0,  248,  248,  250,  248,  248,  248,  248,  248,    0, 
            0,    0,    0,    0,    0,    0,  248,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  248,  248,    0,    0,    0, 
          248,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
          248,    0,    0,  248,    0,  257,  248,    0,  248,    0, 
            0,    0,    0,    0,    0,  257,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  248,    0,  249,  249, 
          249,    0,    0,  249,  249,  249,    0,  249,  248,  257, 
            0,    0,    0,    0,    0,    0,    0,  249,  249,    0, 
            0,    0,    0,  257,  257,    0,  249,  249,  257,  249, 
          249,  249,  249,  249,    0,    0,    0,    0,    0,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          249,  249,    0,    0,    0,  249,  249,    0,    0,    0, 
            0,    0,    0,    0,    0,  249,    0,    0,  249,    0, 
            0,  249,    0,  249,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,    0,    0,    0,    0,    0,  249, 
            0,  251,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  249,  250,  250,  250,    0,    0,  250,  250,  250, 
            0,  250,    0,  249,    0,    0,    0,    0,    0,    0, 
            0,  250,  250,    0,    0,  251,    0,    0,    0,    0, 
          250,  250,    0,  250,  250,  250,  250,  250,    0,  251, 
          251,    0,    0,    0,  251,  250,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,  250,    0,    0,    0,  250, 
          250,    0,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,  250,    0,  252,  250,    0,  250,    0,    0, 
            0,    0,    0,    0,  252,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,  257,  257,  257, 
            0,    0,  257,  257,  257,    0,  257,  250,  252,    0, 
            0,    0,    0,    0,    0,    0,  257,  257,    0,    0, 
            0,    0,  252,  252,    0,  257,  257,  252,  257,  257, 
          257,  257,  257,    0,    0,    0,    0,    0,    0,    0, 
          257,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  258,    0,    0,    0,    0,    0,  257, 
          257,    0,    0,  258,  257,  257,    0,    0,    0,    0, 
            0,    0,    0,    0,  257,    0,    0,  257,    0,    0, 
          257,    0,  257,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  258,  257,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          257,  258,  258,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,  257,  251,  251,  251,    0,    0,  251,  251, 
          251,    0,  251,    0,    0,    0,    0,    0,    0,  229, 
            0,    0,  251,  251,    0,    0,    0,    0,    0,  229, 
            0,  251,  251,    0,  251,  251,  251,  251,  251,    0, 
            0,    0,    0,    0,    0,    0,  251,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  229,    0,  251,  251,    0,    0,    0, 
          251,  251,    0,    0,    0,    0,    0,  229,  229,    0, 
          251,    0,  229,  251,    0,    0,  251,    0,  251,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  251,    0,  252,  252,  252,    0, 
            0,  252,  252,  252,    0,  252,  251,  230,    0,    0, 
            0,    0,    0,    0,    0,  252,  252,  230,  251,    0, 
            0,    0,    0,    0,  252,  252,    0,  252,  252,  252, 
          252,  252,    0,    0,    0,    0,    0,    0,    0,  252, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  230,    0,    0,    0,    0,    0,    0,  252,  252, 
            0,    0,    0,  252,  252,  230,  230,    0,    0,    0, 
          230,    0,    0,  252,    0,    0,  252,    0,    0,  252, 
            0,  252,    0,    0,    0,  258,  258,  258,    0,    0, 
          258,  258,  258,    0,  258,    0,  259,  252,    0,    0, 
            0,    0,    0,    0,  258,  258,  259,    0,    0,  252, 
            0,    0,    0,  258,  258,    0,  258,  258,  258,  258, 
          258,  252,    0,    0,    0,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  228,    0,    0,    0,    0, 
          259,    0,    0,    0,    0,  228,    0,    0,  258,    0, 
            0,    0,  258,  258,  259,  259,    0,    0,    0,    0, 
            0,    0,  258,    0,    0,  258,    0,    0,  258,    0, 
          258,  229,  229,  229,    0,    0,  229,  229,  229,  228, 
          229,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
          229,  229,    0,  228,  228,    0,    0,    0,  258,  229, 
          229,    0,  229,  229,  229,  229,  229,    0,    0,    0, 
          258,    0,    0,    0,  229,    0,    0,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,  229,    0,    0,  229,    0,  229,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,    0,    0,  230, 
          230,  230,  229,    0,  230,  230,  230,    0,  230,    0, 
          227,  227,   51,    0,  229,    0,    0,    0,  230,  230, 
            0,    0,   51,    0,    0,    0,  229,  230,  230,    0, 
          230,  230,  230,  230,  230,    0,    0,    0,    0,    0, 
            0,    0,  230,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,  230,    0,    0,  230, 
            0,    0,  230,    0,  230,    0,    0,    0,  259,  259, 
          259,    0,    0,  259,  259,  259,    0,  259,    0,  225, 
          230,    0,    0,    0,    0,    0,    0,  259,  259,    0, 
            0,    0,  230,  225,  225,    0,  259,  259,    0,  259, 
          259,  259,  259,  259,  230,    0,    0,  228,  228,  228, 
            0,  259,  228,  228,  228,    0,  228,    0,    0,    0, 
            0,  226,    0,    0,    0,    0,  228,  228,    0,    0, 
            0,  226,    0,    0,    0,  228,  228,    0,  228,  228, 
          228,  228,  228,    0,    0,  259,    0,    0,  259,    0, 
          228,  259,    0,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  226,    0,    0,    0,  259, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  226, 
          226,  259,    0,    0,  228,    0,    0,  228,    0,    0, 
          228,    0,  228,  259,  227,  227,  227,    0,    0,  227, 
          227,  227,    0,  227,    0,    0,    0,  223,  228,    0, 
            0,    0,    0,  227,  227,    0,    0,  223,    0,    0, 
          228,    0,  227,  227,    0,  227,  227,  227,  227,  227, 
            0,    0,  228,    0,    0,    0,    0,  227,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,    0,    0,   51,   51,   51,    0,    0,   51, 
           51,   51,   52,   51,    0,  223,  223,    0,    0,    0, 
            0,  227,   52,   51,  227,    0,    0,  227,    0,  227, 
            0,    0,   51,   51,    0,   51,   51,   51,   51,   51, 
            0,    0,    0,    0,    0,  227,    0,  225,  225,  225, 
            0,    0,  225,  225,  225,  224,  225,  227,    0,    0, 
            0,    0,    0,    0,    0,  224,  225,  225,    0,  227, 
            0,   52,    0,    0,    0,  225,  225,    0,  225,  225, 
          225,  225,  225,    0,   51,    0,    0,    0,    0,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
            0,    0,    0,  224,  224,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  225,    0,   51, 
          225,    0,  225,  226,  226,  226,    0,    0,  226,  226, 
          226,  219,  226,    0,    0,    0,    0,    0,  225,    0, 
            0,  219,  226,  226,    0,    0,    0,    0,    0,    0, 
          225,  226,  226,    0,  226,  226,  226,  226,  226,    0, 
            0,    0,  225,    0,    0,    0,  226,    0,    0,    0, 
            0,    0,    0,    0,    0,  219,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  219, 
          219,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          226,    0,    0,  226,    0,    0,  226,    0,  226,  223, 
          223,  223,    0,    0,  223,  223,  223,  221,  223,    0, 
            0,    0,    0,    0,  226,    0,    0,  221,  223,  223, 
            0,    0,    0,    0,    0,    0,  226,  223,  223,    0, 
          223,  223,  223,  223,  223,    0,    0,    0,  226,    0, 
            0,    0,  223,    0,    0,    0,    0,    0,    0,    0, 
            0,  221,    0,    0,   52,   52,   52,    0,    0,   52, 
           52,   52,    0,   52,    0,  221,  221,    0,    0,    0, 
            0,    0,    0,   52,    0,    0,  223,    0,    0,  223, 
            0,    0,  223,    0,  223,   52,   52,   52,   52,   52, 
            0,    0,    0,    0,    0,  260,    0,  224,  224,  224, 
          223,    0,  224,  224,  224,  260,  224,    0,    0,    0, 
            0,    0,  223,    0,    0,    0,  224,  224,    0,    0, 
            0,    0,    0,    0,  223,  224,  224,    0,  224,  224, 
          224,  224,  224,    0,   52,    0,    0,    0,    0,  260, 
          224,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  260,  260,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  224,    0,   52, 
          224,  222,  224,  219,  219,  219,    0,    0,  219,  219, 
          219,  222,  219,    0,    0,    0,    0,    0,  224,    0, 
            0,    0,  219,  219,    0,    0,    0,    0,    0,    0, 
          224,  219,  219,    0,  219,  219,  219,  219,  219,    0, 
            0,    0,  224,    0,    0,  222,  219,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
          222,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          219,    0,    0,  219,    0,    0,  219,  262,  219,  221, 
          221,  221,    0,    0,  221,  221,  221,  262,  221,    0, 
            0,    0,    0,    0,  219,    0,    0,    0,  221,  221, 
            0,    0,    0,    0,    0,    0,  219,  221,  221,    0, 
          221,  221,  221,  221,  221,    0,    0,    0,  219,    0, 
            0,  262,  221,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  262,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  221,    0,    0,  221, 
            0,    0,  221,    0,  221,  220,    0,  260,  260,  260, 
            0,    0,  260,  260,  260,  220,  260,    0,    0,    0, 
          221,    0,    0,    0,    0,    0,  260,  260,    0,    0, 
            0,    0,  221,    0,    0,  260,  260,    0,  260,  260, 
          260,  260,  260,    0,  221,    0,    0,    0,    0,  220, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  220,  220,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  260,    0,    0,  260,    0,    0, 
          260,  218,  260,  222,  222,  222,    0,    0,  222,  222, 
          222,  218,  222,    0,    0,    0,    0,    0,  260,    0, 
            0,    0,  222,  222,    0,    0,    0,    0,    0,    0, 
          260,  222,  222,    0,  222,  222,  222,  222,  222,    0, 
            0,    0,  260,    0,    0,  218,  222,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  218, 
          218,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          222,    0,    0,  222,    0,    0,  222,  285,  222,  262, 
          262,  262,    0,    0,  262,  262,  262,  285,  262,    0, 
            0,    0,    0,    0,  222,    0,    0,    0,  262,  262, 
            0,    0,    0,    0,    0,    0,  222,  262,  262,    0, 
          262,  262,  262,  262,  262,    0,    0,    0,  222,    0, 
            0,  285,  262,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  287,  285,    0,    0,    0, 
            0,    0,    0,    0,    0,  287,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  262,    0,    0,  262, 
            0,    0,  262,    0,  262,    0,    0,  220,  220,  220, 
            0,    0,  220,  220,  220,    0,  220,    0,    0,  287, 
          262,    0,    0,    0,    0,    0,  220,  220,    0,    0, 
            0,    0,  262,    0,  287,  220,  220,    0,  220,  220, 
          220,  220,    0,    0,  262,    0,    0,  292,    0,    0, 
          220,    0,    0,    0,    0,    0,    0,  292,    0,    0, 
            0,    0,    0,    0,  643,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  643,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,    0,    0,  220,    0,    0, 
          220,  288,  220,  218,  218,  218,    0,    0,  218,  218, 
          218,   62,  218,    0,    0,    0,  292,    0,  220,    0, 
            0,   62,  218,  218,    0,    0,    0,    0,    0,    0, 
          220,  218,  218,  643,  218,  218,  218,  218,    0,    0, 
            0,    0,  220,    0,    0,    0,  218,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           62,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          218,    0,    0,  218,    0,    0,  218,    0,  218,  285, 
          285,  285,    0,    0,  285,  285,  285,    0,  285,    0, 
           53,    0,    0,    0,  218,    0,    0,    0,  285,  285, 
           53,    0,    0,    0,    0,    0,  218,  285,  285,    0, 
          285,  285,  285,  285,  285,    0,    0,    0,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           55,    0,    0,    0,    0,    0,    0,  287,  287,  287, 
           55,    0,  287,  287,  287,    0,  287,    0,    0,   53, 
            0,    0,    0,    0,    0,    0,  287,  287,    0,  285, 
            0,    0,  285,    0,  285,  287,  287,    0,  287,  287, 
          287,  287,  287,    0,    0,    0,    0,    0,    0,    0, 
          285,    0,    0,    0,    0,    0,    0,    0,   56,   55, 
            0,    0,    0,    0,    0,    0,    0,    0,   56,    0, 
            0,    0,    0,    0,  285,    0,    0,    0,    0,  292, 
          292,  292,    0,    0,  292,  292,  292,  287,  292,    0, 
          287,    0,  287,    0,    0,    0,  643,  643,  643,    0, 
            0,  643,  643,  643,    0,  643,    0,    0,  287,    0, 
          292,  292,  292,  292,  292,  643,  643,   56,    0,    0, 
            0,    0,    0,    0,  643,  643,    0,  643,  643,  643, 
          643,  643,  287,   62,   62,   62,    0,    0,   62,   62, 
           62,    0,   62,    0,    0,    0,    0,    0,    0,    0, 
          304,    0,   62,   62,    0,    0,  292,    0,    0,  292, 
            0,   62,   62,    0,   62,   62,   62,   62,   62,    0, 
            0,    0,    0,    0,    0,    0,  643,    0,    0,  643, 
          292,  643,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  643,    0,    0, 
            0,    0,    0,    0,  292,    0,    0,    0,    0,    0, 
            0,    0,    0,   62,    0,    0,   62,    0,    0,    0, 
            0,  643,   53,   53,   53,    0,    0,   53,   53,   53, 
            0,   53,    0,    0,   62,    0,    0,    0,    0,    0, 
            0,   53,    0,    0,    0,    0,    0,    0,    0,    0, 
           53,   53,    0,   53,   53,   53,   53,   53,   62,    0, 
            0,    0,   55,   55,   55,    0,    0,   55,   55,   55, 
            0,   55,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   55,    0,  129,    0,    0,    0,    0,    0,    0, 
           55,   55,    0,   55,   55,   55,   55,   55,    0,    0, 
            0,    0,   53,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           56,   56,   56,   53,    0,   56,   56,   56,    0,   56, 
            0,    0,  129,    0,    0,    0,    0,    0,    0,   56, 
            0,    0,   55,    0,    0,    0,    0,   53,   56,   56, 
            0,   56,   56,   56,   56,   56,    0,    0,    0,    0, 
            0,    0,    0,   55,  510,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   55,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
           56,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
          130,   56,    0,   19,   20,   21,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,   56,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  130, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  282,    0, 
          283,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,  513,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    0,    0,  129, 
          129,  129,  129,  129,  129,  129,  129,  129,  129,  129, 
            0,    0,  129,  129,    0,  129,  129,  129,  129,  129, 
          129,  129,    0,  613,    0,  129,  129,  129,  129,  129, 
          129,  129,  129,    0,    0,  129,    0,    0,    0,    0, 
            0,  129,  129,    0,  129,  129,  129,  129,    0,  129, 
          129,  129,  129,  129,  129,    0,  129,  129,  129,  129, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  510,    0,    0,  129,    0,    0,    0,  510,  510, 
          129,    0,    0,  129,  613,    0,  129,  129,    0,  129, 
            0,  129,    0,    0,    0,  129,    0,    0,    0,    0, 
          129,    0,    0,  129,    0,  613,  620,    0,  129,  129, 
          129,  129,  129,  129,    0,    0,    0,  129,    0,  129, 
          129,    0,  129,  129,  129,  129,    0,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
          614,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
            0,    0,  130,    0,    0,    0,    0,    0,  130,  130, 
            0,  130,  130,  130,  130,    0,  130,  130,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  513,    0, 
            0,  130,    0,    0,    0,  513,  513,  130,    0,    0, 
          130,  614,    0,  130,  130,    0,  130,    0,  130,    0, 
            0,    0,  130,    0,    0,    0,    0,  130,    0,    0, 
          130,    0,  614,  313,    0,  130,  130,  130,  130,  130, 
          130,    0,    0,    0,  130,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,    0,    0,    0,    0, 
            0,  129,  129,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,    0,    0,  129,  129,    0,  129,  129,  129, 
          129,  129,  129,  129,    0,  620,    0,  130,  129,  129, 
          129,  129,  129,  129,  129,    0,    0,  129,    0,    0, 
            0,    0,    0,  129,  129,    0,  129,  129,  129,  129, 
            0,  129,  129,  129,  129,  129,  129,    0,  129,  129, 
          129,  129,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  620,    0,    0,  130,    0,    0,    0, 
          620,  620,  129,    0,    0,  129,  616,    0,  129,  129, 
            0,  129,    0,  129,    0,    0,    0,  129,    0,    0, 
            0,    0,  129,    0,    0,  129,    0,  620,  314,    0, 
          129,  129,  129,  129,  129,  129,    0,    0,    0,  129, 
            0,  129,  129,    0,  129,  129,  129,  129,    0,  129, 
          129,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,  130,    0, 
            0,  130,  130,    0,  130,  130,  130,  130,  130,  130, 
          130,    0,  358,    0,    0,  130,  130,  130,  130,  130, 
          130,  130,    0,    0,  130,    0,    0,    0,    0,    0, 
          130,  130,    0,  130,  130,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          313,  358,    0,    0,    0,    0,    0,  313,  313,  130, 
            0,    0,  130,  617,    0,  130,  130,    0,  130,    0, 
          130,    0,    0,    0,  130,    0,    0,    0,    0,  130, 
            0,    0,  130,    0,    0,    0,    0,  130,  130,  130, 
          130,  130,  130,    0,    0,    0,  130,    0,  130,  130, 
            0,  130,  130,  130,  130,    0,  130,  130,    0,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,  305,    0,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  314,  305,    0,    0,    0, 
            0,    0,  314,  314,  130,    0,    0,  130,    0,    0, 
          130,  130,    0,  130,    0,  130,    0,    0,    0,  130, 
            0,    0,    0,    0,  130,    0,    0,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,  130,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,  130,  130,    0,    0,    0,    0,    0,  358,  358, 
          358,  358,  358,  358,  358,  358,  358,  358,  358,    0, 
          358,  358,  358,  358,  358,  358,  358,  358,  358,  358, 
          358,  538,    0,    0,    0,  358,  358,  358,  358,  358, 
          358,  358,    0,    0,  358,    0,    0,    0,    0,    0, 
          358,  358,    0,  358,  358,  358,  358,    0,  358,  358, 
          358,  358,  358,  358,    0,  358,  358,  358,  358,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          538,    0,    0,    0,    0,    0,    0,    0,    0,  358, 
            0,    0,  358,    0,    0,  358,  358,    0,  358,    0, 
          358,    0,    0,    0,  358,    0,    0,    0,    0,    0, 
            0,    0,  358,    0,    0,    0,    0,  358,  358,  358, 
          358,  358,  358,    0,    0,    0,  358,    0,  358,  358, 
            0,  358,  358,  358,  358,    0,  358,  358,    0,    0, 
            0,    0,    0,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,    0,    0,  305,  305,    0,  305, 
          305,  305,  305,  305,  305,  305,  642,    0,    0,    0, 
          305,  305,  305,  305,  305,  305,  305,    0,    0,  305, 
            0,    0,    0,    0,    0,  305,  305,    0,  305,  305, 
          305,  305,    0,  305,  305,  305,  305,  305,  305,    0, 
          305,  305,  305,  305,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  642,    0,    0,    0,    0, 
            0,    0,    0,    0,  305,    0,    0,  305,    0,    0, 
          305,  305,    0,  305,    0,  305,    0,    0,    0,  305, 
            0,    0,    0,    0,    0,    0,    0,  305,    0,   18, 
            0,    0,  305,  305,  305,  305,  305,  305,    0,    0, 
            0,  305,    0,  305,  305,    0,  305,  305,  305,  305, 
            0,  305,  305,    0,    0,    0,    0,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,    0,    0, 
          538,  538,    0,  538,  538,  538,  538,  538,  538,  538, 
          642,    0,    0,    0,  538,  538,  538,  538,  538,  538, 
          538,    0,    0,  538,    0,    0,    0,    0,    0,  538, 
          538,    0,  538,  538,  538,  538,    0,  538,  538,  538, 
          538,  538,  538,    0,  538,  538,  538,  538,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  642, 
            0,    0,    0,    0,    0,    0,    0,    0,  538,    0, 
            0,  538,    0,    0,  538,  538,    0,  538,    0,  538, 
            0,    0,    0,  538,    0,    0,    0,    0,    0,    0, 
            0,  538,    0,    0,    0,    0,  538,  538,  538,  538, 
          538,  538,    0,    0,    0,  538,    0,  538,  538,    0, 
          538,  538,  538,  538,    0,  538,  538,    0,    0,    0, 
            0,    0,  642,  642,  642,  642,  642,  642,    0,    0, 
          642,  642,  642,    0,    0,    0,  642,    0,  642,  642, 
          642,  642,  642,  642,  642,  256,    0,    0,    0,  642, 
          642,  642,  642,  642,  642,  642,    0,    0,  642,    0, 
            0,    0,    0,    0,  642,  642,    0,  642,  642,  642, 
          642,    0,  642,  642,  642,  642,  642,  642,    0,  642, 
          642,  642,  642,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  255,    0,    0,    0,    0,    0, 
            0,    0,    0,  642,    0,    0,  642,    0,    0,  642, 
          642,    0,  642,    0,  642,    0,    0,    0,  642,    0, 
            0,    0,    0,    0,    0,    0,  642,    0,    0,    0, 
            0,  642,  642,  642,  642,  642,  642,    0,    0,    0, 
          642,    0,  642,  642,    0,  642,  642,  642,  642,    0, 
          642,  642,    0,    0,    0,    0,  642,  642,  642,  642, 
          642,  642,    0,    0,    0,  642,  642,    0,    0,    0, 
          642,    0,  642,  642,  642,  642,  642,  642,  642,  307, 
            0,    0,    0,  642,  642,  642,  642,  642,  642,  642, 
            0,    0,  642,    0,    0,    0,    0,    0,  642,  642, 
            0,  642,  642,  642,  642,    0,  642,  642,  642,  642, 
          642,  642,    0,  642,  642,  642,  642,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  642,    0,    0, 
          642,    0,    0,  642,  642,    0,  642,    0,  642,    0, 
            0,    0,  642,    0,    0,    0,    0,    0,    0,    0, 
          642,    0,    0,  642,    0,  642,  642,  642,  642,  642, 
          642,    0,    0,    0,  642,    0,  642,  642,    0,  642, 
          642,  642,  642,    0,  642,  642,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           14,   15,   16,   17,   18,  304,    0,    0,    0,   19, 
           20,   21,  235,  236,  237,  238,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  239,  240, 
          241,    0,  242,   35,  243,  244,  245,  246,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  247,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,    0,    0,    0,  309,  309,  309, 
            0,  309,    0,    0,    0,  309,  309,    0,    0,    0, 
          309,    0,  309,  309,  309,  309,  309,  309,  309,    0, 
            0,    0,    0,  309,  309,  309,  309,  309,  309,  309, 
            0,    0,  309,    0,    0,    0,    0,    0,    0,  309, 
            0,    0,  309,  309,  309,    0,  309,  309,  309,  309, 
          309,  309,  349,  309,  309,  309,  309,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  309,    0,    0, 
          309,    0,  307,  309,  309,    0,  309,    0,    0,    0, 
            0,    0,  309,    0,    0,    0,    0,    0,    0,    0, 
          309,    0,    0,    0,    0,  309,  309,  309,  309,  309, 
          309,    0,    0,    0,  309,    0,  309,  309,    0,  309, 
          309,  309,  309,    0,  309,  309,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,  235,  236,  237,  238,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  239,  240,  241, 
            0,  242,   35,  243,  244,  245,  246,  656,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  336,  337,  338,  339,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          340,  341,  342,    0,  343,   35,  344,  345,  346,  347, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,  469,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  348,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  336, 
          337,  338,  339,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,  118,    0,    0,  340,  341,  342,    0,  343, 
           35,  344,  345,  346,  347,    0,   40,    0,    0,  127, 
          469,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          348,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    7,  317,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  165,  166,  167,  168, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  177,  178,  179,    0,  180,  181,  123,  124, 
          182,  126,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,  198,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  219,  220,  221,  222, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,  356,  357, 
          227,  358,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  219,  220,  221,  222, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,  306,    0, 
          227,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  219,  220,  221,  222, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,    0,    0, 
          227,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  219,  220,  221,  222, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,    0,    0, 
          227,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,    0,    0,    0,    0,    0, 
            0,    3,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,  213,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  316,    4,    5,    6,    7,  317,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,  318,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  316,    4,    5,    6,    7,  317,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  282,    0,  283,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  711,    0,  283,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,  280,  280,  280,    0,  280,    0,    0,    0,  280, 
          280,    0,    0,    0,  280,    0,  280,  280,  280,  280, 
          280,  280,  280,    0,    0,    0,    0,  280,  280,  280, 
          280,  280,  280,  280,    0,    0,  280,    0,    0,    0, 
            0,    0,    0,  280,    0,    0,  280,  280,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  280,    0,    0,  280,    0,    0,  280,  280,    0, 
          280,    0,  280,    0,  280,    0,  280,    0,    0,    0, 
            0,    0,    0,    0,  280,    0,    0,    0,    0,  280, 
          280,  280,  280,  280,  280,    0,    0,    0,  280,    0, 
          280,  280,    0,  280,  280,  280,  280,    0,  280,  280, 
          280,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  282,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,  283,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  711,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  235,  236, 
          237,  238,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  239,  240,  241,    0,  242,   35, 
          243,  244,  245,  246,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  247, 
            0,    0,  130,  504,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  284,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  235,  236,  237, 
          238,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  239,  240,  241,    0,  242,   35,  243, 
          244,  245,  246,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,  647, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  284,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  282,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  235,  236,  237,  238,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  239,  240,  241,    0,  242,   35,  243,  244,  245, 
          246,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  647,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  284, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  235,  236,  237,  238,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          239,  240,  241,    0,  242,   35,  243,  244,  245,  246, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  908,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  284,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  235,  236,  237,  238,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  239, 
          240,  241,    0,  242,   35,  243,  244,  245,  246,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  711,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  284,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,  631,  631,  631,    0,  631,    0,    0, 
            0,  631,  631,    0,    0,    0,  631,    0,  631,  631, 
          631,  631,  631,  631,  631,    0,    0,    0,    0,  631, 
          631,  631,  631,  631,  631,  631,    0,    0,  631,    0, 
            0,    0,    0,    0,    0,  631,    0,    0,  631,  631, 
          631,    0,  631,  631,  631,  631,  631,  631,    0,  631, 
          631,  631,  631,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  631,    0,    0,  631,  631,    0,  631, 
          631,    0,  631,    0,    0,    0,    0,    0,  631,    0, 
            0,    0,    0,    0,    0,    0,  631,    0,    0,    0, 
            0,  631,  631,  631,  631,  631,  631,    0,    0,    0, 
          631,    0,  631,  631,    0,  631,  631,  631,  631,    0, 
          631,  631,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,  235,  236,  237,  238,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  239,  240,  241, 
            0,  242,   35,  243,  244,  245,  246,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  235, 
          236,  237,  238,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  239,  240,  241,    0,  242, 
           35,  243,  244,  245,  246,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  631, 
          631,  631,    0,  631,    0,    0,    0,  631,  631,    0, 
            0,    0,  631,    0,  631,  631,  631,  631,  631,  631, 
          631,    0,    0,    0,    0,  631,  631,  631,  631,  631, 
          631,  631,    0,    0,  631,    0,    0,    0,    0,    0, 
            0,  631,    0,    0,  631,  631,  631,    0,  631,  631, 
          631,  631,  631,  631,    0,  631,  631,  631,  631,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  631, 
            0,    0,  631,    0,    0,  631,  631,    0,  631,    0, 
            0,    0,    0,    0,  631,    0,    0,    0,    0,    0, 
            0,    0,  631,    0,    0,    0,    0,  631,  631,  631, 
          631,  631,  631,    0,    0,    0,  631,    0,  631,  631, 
            0,  631,  631,  631,  631,    0,  631,  631,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  113,  114,  115, 
          116,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
          118,    0,    0,  119,  120,  121,    0,  122,   35,  123, 
          124,  125,  126,    0,   40,    0,    0,  127,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  128,    0,    0,    0,  129,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  263,  264,  265,  266, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,  118, 
            0,    0,  267,  268,  269,    0,  270,   35,  271,  272, 
          273,  274,    0,   40,    0,    0,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  275,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  336,  337,  338,  339,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  340,  341,  342,    0,  343,   35,  344,  345,  346, 
          347,    0,   40,    0,    0,  127,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  348,    0,    0,  425, 
            0,    0,   46,   47,    0,   48,    0,  426,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  113,  114,  115,  116,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          119,  120,  121,    0,  122,   35,  123,  124,  125,  126, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  129,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  336,  337,  338,  339,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,  118,    0,    0,  340, 
          341,  342,    0,  343,   35,  344,  345,  346,  347,    0, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  348,    0,    0,  425,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  113,  114,  115,  116,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  119,  120, 
          121,    0,  969,   35,  123,  124,  970,  126,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  971,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  984,  985,  986,  987,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  988,  989,  990, 
            0,  991,   35,  992,  993,  994,  995,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  996,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  692,  637,    0,    0,  693,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  300,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  703,  629,  212, 
            0,  704,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,  213,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  300,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  706,  637,  212,    0,  707,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,  213,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  734, 
          629,  212,    0,  735,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,  300,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  737,  637,  212,    0,  738, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,  213, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          300,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211, 1065,  629,  212,    0, 1066,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,  213,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  300,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211, 1068,  629,  212, 
            0, 1069,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,  213,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  300,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211, 1071,  637,  212,    0, 1072,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,  213,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  642, 
          637,  212,    0,  643,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,    0,    0,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  213, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,   74,   28,    2,    3,    4,    5,   10,   11,   45, 
            9,   10,   11,    7,   99,   14,   15,   16,    7,  254, 
           19,   88,  486,   90,    3,    2,    3,   11,    6,  417, 
           10,   49,  483,   27,  292,  486,   21,   27,   27,   51, 
          471,    6,    7,   15,   16,  129,   45,   19,    4,    5, 
           49,  466,   51,  446,   59,   10,  444,    0,   14,  424, 
          370,  525,   27,   15,   16,  428,  416,   19,  418,   10, 
           10,  421,  460,  675,   52,   47,   48,   10,   91,   59, 
          331,   15,   16,   10,  335,   19,  474,   52,   10,  691, 
          535,   59,  118,   49,    0,  445,  506,    0,   10,   10, 
           99,   21,  761,  705,   10,   10,   10,  574,  575,  459, 
          965,  461,   10,   47,   10,   10,   10,  104,   59,   59, 
          104,  106,   44,  593,   10,  475,   59,   10,   10,  128, 
          583,  130,   59,  104,  736,  318,  945,   59,  857,  759, 
           44,   10,   10,   99,   10,  533,  773,   59,  855,   44, 
           10,  280,  308,   59,   10,   59,  305,  627,   44,  509, 
          561,   59,   44,   59,   59,   59,  280,   10,   10,   10, 
           10,  305,   10,   59,  325,   44,   43,   59,   61,  290, 
          291,    2,    3,  250,  534,  342,  106,   10,    9,   10, 
           11,   10,  112,   59,   15,   16,   10,   10,   19,   59, 
           10,   44,  359,   59, 1059,  373,   44,   10,  359,  276, 
          378,  656,  341,   10,   10,   10,  136,   59,   59,   59, 
          376,  377,  685,   61,   45,   10,  375,   32,  308,  309, 
           51,  311,  695,  362,  941,  234,   10,  495,   32, 1048, 
           10,  375,  425,  341,   10,  312,   59,   61,  362,   44, 
          877,  561,  342,   10,   10,  719,   10,  345,  261,  262, 
          127,   10,  261,  262,  349,   61,   10,  718,  719,  359, 
           10,  373,  341,  257,   44,  363,  378,  670,  679,   10, 
          681,   10,  318,  350,    0,   10,  257,  680,   10,   59, 
          373, 1010,  362,  952,   10,  378,  376,  377,  297,  310, 
          299,  300,   59,   59,  303, 1012,  305,  128,  328,  130, 
          366,  310,   61,   32,   10,  328,  336,  316,  728,  318, 
           32,  684,  335,  336,  370,  297,  946,  299,  327,  783, 
          268,  269,  802,  320,  267,  789,  320,   10,   32,  316, 
         1047,  961,   32,   59,   44,  297,  373,  299,  300,  320, 
          349,  378,  264,  282,  359,  800,  268,  269,   10,  443, 
            2,    3,  269,  297,  271,  299,  262,  263,  264,  679, 
          264,  681,  268,  269,  342,  271,  379,  380,  381,  382, 
          379,  380,  381,  382,  383,  384,  385,  342,   61,  425, 
          345,   15,   16,  349,  861,   19,  279,    2,   61,  866, 
          867,  305,  869,   45,  871,  836,  383,  387,  426,   61, 
          422,  267,  424,  234,  338,  342,  428,  429,  417,  359, 
          363,  874,  363,  422,   61,  424,  425,  426,  881,  428, 
          429,  796,  431,  886,  345, 1055,  341,  359,  342,  281, 
          261,  262,   47,   48,  342,  444,  342,  446,  447,  759, 
          535,  761,  431,  418,  431,  713,  421,  363,  457,  342, 
          363,  460,  697,  773,  359,  417,  465,  363, 1070,  932, 
          426,  375,  936,  359,  342,  474,  297,  359,  299,  300, 
          445,  732,  303,  279,  305,  936,  470,  471,  130,  310, 
          424,  387,  444,  359,  428,  316,  461,  318,  418,  359, 
            2,    3,    4,    5,  342,  504,  327,  506,  460,  503, 
          475,  483,   14,  503,  503,  561,  338,  932,  517,  342, 
          913,  341,  474,  342,  357,  445,  345,   44,  342,  506, 
          279,   10,  342,  467,  533,  305,  535,  310,  503,  342, 
           10,  461,  345,   45,  509,  342,  342,   49,  305,  305, 
          522, 1018, 1019, 1020, 1021,  475,  338,  342,  379,  380, 
          381,  382,  383,  384,  385,   44,  371,  372,  342,  534, 
           61,  656,  342,  378,   44, 1028,  342,  371,  372,  535, 
           59,  533,  840,   10,  378,  342,  342,   91,   10,  509, 
          983,   61,  234,  342,  290,  291,  417,   99,  342,  338, 
          626,  422,  342,  424,  425,  375,  279,  428,  429,  635, 
          431,  342, 1079,  342,  534,  271,  345,  342,  375,  375, 
          342,   91,   44,  444,  317,  446,  447,  279,  130,   10, 
          306,   59,   59,  679,  310,  681,  457,   59,   44,  460, 
          310,   44,  952,   45,  465,   91,  631,  279,  733,  675, 
           10,  961, 1040,  474,  639,  965,  349,  656,   61,  644, 
          353,  354,  355,  356,  339,  691,  669,   44,  310,  342, 
          669,  670,   44,  297,  316,  299,  318,  263,  264,  705, 
           61,  680,   10,  504,  668,  506,  921,   10,  560,  683, 
          342, 1041,  927,  683,  683,  300,  517,  350,  351,  317, 
          656,   61,    2,    3,  682,  708,   44,   44,  362,  708, 
          736,  631,  533,  317,   14,  800,  338,  682,  683,  639, 
          793,  312,   10,   10,  644,  751,  317,  342,  130,  728, 
          371,  372,  234,   61,  733,  345,   59,  378,  263,  264, 
          363,  383,  383,  310,  269,   45,  718,  773,   44, 1059, 
          684,  728,  373,  673,   91,   10,  676,  756,  757,  350, 
          351,   44,   10,  371,  372,  373,  373,  373,  780,  781, 
          378,   59,   59,  373,  786,  787,  775,  733,  777,  347, 
          779,  780,  781,  425,  796,  328,  341,  786,  787,  431, 
          341,  262,  335,  336,  267,  386,  264,  796,   91,  264, 
          342,  800,   44,   91,  446,   44,   61,   10,  310,  279, 
          280,  363,  417,   61,  316,  457,  318,  362,  821,  818, 
          804,   44,  821,  465,  328,   32,  305,  811,  306,  306, 
          130,  335,  336,  832,  833,  834,   10,  306,   44,  444, 
          267,  338,   10,  759,  800,  761,   44,  349,  669,  670, 
           44,  877,  836,   44,   44,  460,   59,  773,  328,  680, 
           10,   61,   32,  342,  506,  335,  336,   44,   61,  474, 
           44,  341,  342,  745,  746,  517,  279,    9,   10,   11, 
          359,  383,  328,  305,  338,   59,  898,  708,  887,  335, 
          336,   59,  362,  338,   44,  338,  375,   44,  279,  898, 
          306,  506,  308,  309,  310,  311,  264,  728,  310,   59, 
          269,  264,  339,  912,  913,  338,  318,  303,  338,  279, 
          342,  920,   91,  425,  426,  924,  338,  338,  533,  431, 
          997,  887,  363,   44,  234,  756,  757,  359,   58,  325, 
          326,  264,  279,  280,  446,  338,  269,  345,  271,  264, 
          264,  279,  339,  375,  775,  457,  777,  263,  779,  780, 
          781,  342,  264,  465,  920,  786,  787,   48,  306,  338, 
          308,  309,  310,  311,  973,  796,  263,  264,  264,  267, 
           44,   10,  342,  855,  983,  857,   44,  592,  593, 1015, 
          363,  328,  280,  342,   59,   10,  128,  818,  335,  336, 
          821, 1000,   44, 1002,  506,  379,  380,  381,  382, 1008, 
          310,  832,  833,  834,  342,  517,  316,  973,  318,  264, 
          317,  363,  627,  425,  279,  362,   44,   44,  670,  359, 
           59,  279,   44,  535,  639,  328,  952,   44,  680,  644, 
          328, 1040,  335,  336, 1070,  961, 1045,  335,  336,  965, 
           44,   10,  349,  341,   44,  457,  353,  354,   44,  262, 
          263,  264,   91,  465,   10,  268,  269,  264,  271,  941, 
          942,  676,   61,  363,  362,  264, 1041,  898,  264,  684, 
          685,  264,  687,  383,   44,  359,  728,  342, 1040,  310, 
          695,  912,  913,  267,  342,  363,  264,  264,   44,   10, 
           59,  269,  488,  924,   44,  371,  372,  373,  310,   44, 
          496,  497,  378,   59,  756,  757,   44,  267,   44,   44, 
           44, 1041,  388,  728,  424,  425,   44,  264,  514,  261, 
          262,  431,   44,  775,   10,  777,  264,  779, 1010,  342, 
         1012,  387,  754, 1059,  271,   91,  446,  363,   59,  761, 
          345,  371,  372,  373,  656,  271,  341,  457,  378,  328, 
          363,  773,  983,   91,  342,  465,  335,  336,  670,  345, 
          345,  303,   58,  305,  345, 1047,  818,  264,  680, 1000, 
           91, 1002,  363,   59,  387,   70,   10, 1008,  285,  339, 
          832,  833,  834,   54,    5,  327,  517,  802, 1043,  372, 
          281,  282,  283,    6,  644,  286,  506,  773,  919,  759, 
          763,  816,  963,  961,  819,   91,  792,  517,   91, 1040, 
            0,   14,  745, 1048, 1045, 1042,  728,  371,  372,  373, 
           10,  733,   10,   -1,  378,   59,   -1,   -1,  267,  741, 
          306,   -1,  308,  309,  310,  311,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  756,  757,  371,  372,  373,   -1, 
           -1,   -1,   -1,  378,   44,   -1,   44,   91,   -1,  655, 
          912,  913,   -1,  775,  340,  777,   -1,  779,   -1,   59, 
           -1,   -1,  924,   61,   -1,   15,   16,   -1,   -1,   19, 
           -1,  306,  678,  308,  309,  310,  311,  312,  800,  328, 
           -1,   44,  317,  262,  263,  264,  335,  336,   -1,   -1, 
          269,   41,   42,   91,   -1,  447,  818,   47,   48,   -1, 
           50,   51,  371,  372,  373,  340,   -1,  932,   -1,  378, 
          832,  833,  834,  348,  349,  350,  351,  723,  950,   -1, 
          952,  983,  954,  424,   91,  731,  958,  428,   91,   -1, 
           91,  279,   -1,  965,  756,  757,  267,   -1, 1000,   -1, 
         1002,  371,  372,  373,  750,   -1, 1008,   -1,  378,  280, 
          670,  386,  504,  775,   -1,  777,   -1,  779,   -1,   -1, 
          680,   -1,  328,   -1,   -1,  887,  467,   -1,   -1,  335, 
          336,  267,  371,  372,  373,  341,   -1,   -1,   -1,  378, 
          328,  482,  483, 1045,  280,  486,   -1,  335,  336,   -1, 
          912,  913,   -1,  359,   -1,   -1,  818,  328,  920,   44, 
           -1,   10,  924,  809,  335,  336,   -1,   -1,  728,   -1, 
          832,  833,  834,   -1,   -1, 1040,   -1,   -1, 1043, 1051, 
           -1,  522,   -1,  267,  525, 1057,   -1, 1059,   -1,   -1, 
         1062,  362,  328,   -1,  773,  328,  756,  757,   -1,  335, 
          336,   -1,  335,  336,   -1,  341,   91,   -1,  854,   -1, 
           59,  973,   -1,   -1,   -1,  775, 1088,  777,   -1,  779, 
           -1,  983,  262,  263,  264,   -1,  362,  267,  268,  269, 
           -1,  271,   10,   -1,   -1,   -1,  796,   -1, 1000,   -1, 
         1002,  279,  280,  584,  328,   -1, 1008,   -1,  317,   -1, 
          912,  335,  336,  293,  294,  295,  296,  297,  818,   -1, 
           -1,   10,  924,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           44,   -1,  832,  833,  834,   -1,  279,  669,    0,   -1, 
          349,   59,  351, 1045,  353,  354,  355,  356,   10,   -1, 
          328,  281,  282,  283,  284,   44,  286,  335,  336,  339, 
           -1,   -1,  342,  341,  342,   -1,  647,  297,   -1,  299, 
          300,   -1,   61,   91,   -1,   -1,  708,   91,  308,   -1, 
           -1,  328,   44,  363,  362,  328,   -1,  328,  335,  336, 
           -1,   -1,  335,  336,  335,  336,   58,   59, 1000,   -1, 
         1002,   63,   91,  684,   10,   -1, 1008,  387,  371,  372, 
          373,   -1,  912,  913,  306,  378,  308,  309,  310,  311, 
          920,   -1,   -1,   -1,  924,   -1,   -1,   -1,  709,   91, 
          711,  293,  294,  295,  296,  297,   -1,  718,  719,  958, 
           -1,   -1,  961, 1045,  963,   -1,  965,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,  279,   -1,  386,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,  397,  398,  399, 
          400,  401,  402,  403,  404,  405,  406,  407,  408,  409, 
          410,  411,   -1,  983,   -1,   -1,   -1,  417,  769,  821, 
           10,   -1,  422,   10,  424,   -1,   -1,   -1,  428,  429, 
         1000,   44, 1002,  328,   -1,    0,   -1,   -1, 1008,   -1, 
          335,  336,   -1,   -1,  444,   10,  797,  306,   -1,  308, 
          309,  310,  311,  312,   44,   -1,   -1,   -1,  317,   -1, 
          460,   -1,  462,  463,  464,   -1, 1055,  467, 1057,   -1, 
         1059,   61,   59, 1062,  474, 1045,   -1,   -1,   91,  267, 
          831,  340,  482,  483,   -1,   10,  486,   10,   -1,  348, 
          349,  350,  351,   -1,   59,  279,   -1,    0,  362, 1088, 
          364,   91,  366,   -1,   91,   -1,   -1,   10,  372,   -1, 
          510,  511,  306,   -1,  308,  309,  310,  311,   -1,   44, 
          279,   44,  522,   -1,   -1,  525,   -1,  386,   -1,   -1, 
          262,  263,  264,  533,   59,  267,  268,  269,   61,  271, 
          328,   44,   -1,   -1,  328,   -1,  340,  335,  336,  281, 
          282,  335,  336,  341,  348,   -1,   59,  908,  290,  291, 
           -1,  293,  294,  295,  296,  297,   91,   44,   91,  328, 
           -1,   44,   -1,  305,   -1,   -1,  335,  336,   -1,   10, 
           -1,   -1,  341,  342,  584,  936,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   44, 
          342,   44,   -1,  345,   91,  347,  480,  349,   91,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   59,  361, 
          306,  363,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,  375,   -1,   -1,   -1,  647,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,  387,   91,   -1,   91,   -1, 
          336,   -1,   -1,   -1,  340,  341,  279,   -1,   -1,   -1, 
           -1,   -1,  348,  349,  350,  351,    0,   -1,   -1,   -1, 
          267,   -1,   -1,   -1,  684,  549,   10,   -1,   -1,  279, 
          280,   -1,   -1,  280,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,  709, 
          386,  711,   -1,   -1,   -1,  328,  281,   -1,  718,  719, 
           44,   -1,  335,  336,  588,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   61,  328,   63, 
           -1,  328,   -1,   -1,   -1,  335,  336,   -1,  335,  336, 
           -1,  341,  342,   -1,  341,  280,  279,   -1,   -1,  262, 
          263,  264,   -1,  328,  267,  268,  269,   91,  271,  769, 
          335,  336,  362,   -1,   -1,  362,   -1,  342,   -1,   -1, 
          780,  781,   -1,   -1,   -1,   -1,  786,  787,   -1,   -1, 
          293,  294,  295,  296,  297,  795,  796,  797,  363,   -1, 
           -1,  801,  279,  328,   -1,  328,  279,  280,    0,   -1, 
          335,  336,  335,  336,   -1,   -1,  341,   -1,   10,  342, 
           -1,   -1,  387,   -1,  824,  825,   -1,  827,  828,   -1, 
           -1,  831,   -1,   -1,  359,   -1,  339,  362,   -1,  342, 
           -1,   -1,   -1,   -1,  279,  280,  279,   -1,   -1,   -1, 
           -1,  328,   44,   -1,   -1,  328,   -1,   -1,  335,  336, 
          363,   -1,  335,  336,  341,   -1,   58,   59,  341,   61, 
           -1,   63,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,  387,   -1,  317,   -1,   -1,  362, 
           -1,  891,   -1,  328,   -1,  328,   -1,  328,  898,   91, 
          335,  336,  335,  336,   -1,  336,  341,   -1,  908,  340, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,  362,   10,  929, 
           -1,   -1,   -1,  257,  258,  259,  936,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  386,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   59,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
         1040,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,  375,  376,  377,   -1,  379,  380,  381,  382,   10, 
          384,  385,  386,  387,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   10,  384,  385,  386,  387,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,  306,  328,  308,  309,  310, 
          311,  312,  340,   -1,  336,   -1,  317,   -1,  340,  341, 
          348,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
           -1,   -1,   91,   -1,   -1,   -1,  342,  317,   -1,  340, 
          341,   -1,   -1,   -1,   -1,   -1,  342,  348,  349,  350, 
          351,   -1,   -1,  333,  334,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,  363,   -1,  349, 
           -1,   -1,    0,  353,  354,  355,  356,   -1,   -1,   -1, 
           -1,  387,   10,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1, 
           58,   59,  340,   61,  279,   63,   -1,  328,  317,   -1, 
          348,  349,  350,  351,   -1,  336,   -1,   -1,   -1,  340, 
          341,   -1,   -1,   -1,  333,  334,   -1,  348,  349,  350, 
          351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  386,   -1, 
          359,   -1,  361,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   10,   -1,   -1,  386,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   59,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   -1,  384,  385,  386,  387,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   44,   -1,  333,  334,  335,  336,  337, 
           -1,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,  375,  376,  377, 
           91,  379,  380,  381,  382,   10,  384,  385,  386,  387, 
          878,   -1,   -1,   -1,  882,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   44, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           -1,  340,   -1,   58,   59,   -1,   61,  279,   63,   -1, 
          328,  350,  351,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,  350,  351,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,   -1,   -1,   -1,  386,  322,  323, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,  333, 
          334,   -1,   -1,  335,  336,   -1,   -1,   -1,  386,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,   -1,   -1,   -1, 1022,  333,  334, 1025, 1026,   -1, 
           -1, 1029, 1030,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   58,   59,   -1,   -1,  279,   63, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
           -1,   -1, 1080, 1081, 1082, 1083,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  349, 1092,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   10,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   59,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   44,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
          375,  376,  377,   91,  379,  380,  381,  382,   -1,  384, 
          385,  386,  387,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   44,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,  375,  376,  377,   91,  379,  380,  381,  382,   10, 
          384,  385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   44,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  317,   -1,   -1,   -1,   58,   59,   -1, 
           -1,  279,   63,   -1,  328,  317,  318,  319,  320,  321, 
          322,  323,  336,   -1,  326,  327,  340,  341,   -1,   -1, 
           -1,  333,  334,   -1,  348,  349,  350,  351,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   44,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   58,   59, 
           -1,   -1,  279,   63,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           44,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,  375,  376,  377,   91,  379,  380, 
          381,  382,   -1,  384,  385,  386,  387,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   63,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,  375,  376,  377,   -1,  379, 
          380,  381,  382,   10,  384,  385,  386,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   58,   59,   -1,   61,  279,   63,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   59,  329,  330,   -1,   63,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   91,  361,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   59,   -1,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   44,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,  375,  376, 
          377,   91,  379,  380,  381,  382,   -1,  384,  385,  386, 
          387,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   63,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,    0,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,   10,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   44, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,   -1,   -1,   59,   -1,   -1,   -1,   63,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   91,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,  279, 
          280,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   59,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   44,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,   -1,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   91,  379,  380,  381,  382,   -1,  384, 
          385,  386,  387,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   63,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,    0,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,   10,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   44,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,  387,   -1,   -1,   59,   -1,   61,   -1, 
           63,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,  279,  280,  348,  349,  350,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,   -1,   -1,   -1,   -1,   61, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   91, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   44,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,  338,   -1,  340,  341,  342, 
          343,  344,   -1,  346,   91,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,  387,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,  338,  279,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   10,  384,  385,  386,  387,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1, 
          342,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   91,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,  362,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,    0,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   10,  341,   -1,   10,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1, 
           -1,   59,   -1,   61,   -1,   63,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,   -1, 
           -1,  340,  341,  342,  343,  344,   -1,  346,   -1,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  386,  387,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,  279,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  328,   -1,  333,  334,  335,  336,  337, 
          335,  336,  340,  341,  342,  343,  344,  342,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,  384,  385,  386,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   44, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,   -1,   -1,  341,   -1,   59,   -1,   61,   -1,   63, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  307,  386,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,    0,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   10,  348,  349, 
           10,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  306,  307,  364,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   44,  326,  327,   44,   -1,  386,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   59,  341,   61,   -1, 
           63,   61,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,   -1,   -1,  340,  341,  342,  343, 
          344,   -1,  346,   -1,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   10, 
          384,  385,  386,  387,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,  279, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   59,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  328,   -1, 
          333,  334,  335,  336,  337,  335,  336,  340,  341,  342, 
          343,  344,  342,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,  384,  385,  386,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   61,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  763,   -1, 
           -1,  766,   -1,   -1,   -1,   -1,   59,   -1,  773,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   91,  280, 
          281,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340, 
           -1,  342,  343,  344,   -1,  346,    0,  348,   -1,  350, 
           -1,  352,   -1,   -1,   -1,   -1,   10,   -1,   -1,  360, 
           -1,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  386,  387,   -1,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,  958,   -1,  305,  961,   91,  963,   -1, 
          965,  279,  280,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  280,    0,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   10,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
          328,  361,  362,  363,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,  342,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  328,   -1,  387,   -1,   -1, 
           -1,   -1,  335,  336,  362,   -1,   58,   59,  341,   61, 
         1055,   63, 1057,   -1, 1059,   -1,   -1, 1062,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,  362, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1, 1088,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           44,   -1,   -1,   61,   -1,   -1,  280,  281,  282,   -1, 
           -1,   91,   -1,   -1,   -1,   59,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,  362,  363, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
          280,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,  262,  263, 
          264,  279,  280,  375,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,  290,  291,  328,  293, 
          294,  295,  296,   -1,   -1,  335,  336,   -1,   10,   -1, 
           -1,  341,    0,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   10,   -1,   -1,   -1,   -1,  335,  336,  359, 
           -1,   -1,  362,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,  342,  267, 
          268,  269,   -1,  271,  362,   -1,   44,   -1,   -1,   61, 
           -1,   -1,   59,  281,  282,   -1,   -1,   -1,   -1,  363, 
           -1,   59,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   91, 
           -1,   -1,   -1,  387,   91,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   58,   59, 
          267,   61,   -1,   63,  262,  263,  264,  279,  280,  375, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   10,   59,   -1,   -1,    0,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   10,   -1, 
           -1,  328,   -1,  335,  336,   -1,   -1,   -1,  335,  336, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,   91,   44,   -1, 
          262,  263,  264,   10,  342,  267,  268,  269,   -1,  271, 
          362,   -1,   -1,   -1,   -1,   61,   -1,   -1,   59,  281, 
          282,   -1,   -1,   -1,   -1,  363,   -1,   59,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1,  387, 
           91,   -1,   59,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   91,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  267,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,  267,   61,   -1,   63, 
          262,  263,  264,  279,  328,  375,  268,  269,   -1,  271, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          267,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,    0,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   10,   -1,   -1,  328,   -1,  335, 
          336,   -1,   -1,   -1,  335,  336,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
          342,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  328,   61,   -1,   59,  281,  282,   -1,  335,  336, 
           -1,  363,   -1,   59,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   91,   -1,   -1,  387,   91,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,  267,   61,   -1,   63,  262,  263,  264,   -1, 
          279,  375,  268,  269,   -1,  271,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   10,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,  328,   -1,   59,  335,  336,   -1,   -1, 
          335,  336,   -1,  342,   59,   -1,   -1,   59,   -1,   -1, 
           10,   44,  262,  263,  264,   -1,  342,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   91,   61,   -1, 
           59,  281,  282,   -1,   -1,   -1,   91,  363,   -1,   91, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   91,   59, 
           -1,  387,   91,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   91,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  267,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  267,   -1,  342,  267,  280,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,  267,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,  279,  375,   -1,   -1, 
           -1,  280,   -1,   10,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   10,   -1,  328,   -1,   -1,  267,   -1,   91, 
           -1,  335,  336,  328,   -1,   -1,  328,  341,   -1,   10, 
          335,  336,   -1,  335,  336,   -1,   -1,   44,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,  362,  328, 
           -1,   -1,  335,  336,   61,   -1,  335,  336,   -1,  342, 
           -1,   59,  341,   44,   -1,   -1,   10,   -1,  262,  263, 
          264,   -1,   44,  267,  268,  269,   -1,  271,  328,   -1, 
           61,   -1,   -1,  362,   91,  335,  336,  281,  282,   61, 
           -1,   -1,   -1,   91,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,  305,    0,   -1,   -1,   59,   -1,   -1,   -1,   91, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   91,  342,   -1, 
           -1,  345,   -1,  347,   10,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   91,   -1,   61,   -1,   -1,  280,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,  267, 
          342,   -1,  279,  345,   -1,  347,   10,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
          362,  363,   58,   59,   -1,   61,   -1,   63,  279,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  279,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,  267,   -1,   91,   -1,   61,  335,  336, 
          328,   -1,   -1,   -1,   -1,  342,   -1,  335,  336,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,  328,   91,   -1,   -1, 
           -1,  342,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1, 
          342,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,  328,  361,   -1,  363,   58,   59,   -1,  335, 
          336,   63,   -1,   -1,   -1,   -1,  342,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,  328,  361,   -1,  363,   58,   59, 
           -1,  335,  336,   63,   -1,   -1,   -1,   -1,  342,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  763,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,  773,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  387,   -1,  267,  268,  269, 
           -1,  271,   -1,  958,   -1,   91,  961,   -1,  963,   -1, 
          965,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
         1055,   -1, 1057,   -1, 1059,  375,   -1, 1062,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1, 1088,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  387,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  342,   44,   -1,  345,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,  387,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  387,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  305,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  387,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           58,   59,   -1,   -1,  305,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  262,  263,  264,  387,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,  387,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
            0,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           10,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  387, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   59, 
          271,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,    0,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   10,  363,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   59,   -1,   61,   -1, 
           63,   -1,  262,  263,  264,   -1,  375,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1, 
          280,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  362,  363,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  345,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,  387,   -1, 
          333,  334,  335,  336,   -1,  338,   -1,   -1,   -1,  342, 
           -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   59,  361,   61, 
          363,   63,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   63,  333, 
          334,  335,  336,   -1,  338,  262,  263,  264,  342,   -1, 
           -1,  268,  269,   -1,  271,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   10,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   59,  361,   61,  363,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
          387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,   -1,   -1,   -1, 
          342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   59,  361, 
           61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   10,   -1,   -1,   -1, 
           91,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   44, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   59,  361,   61,  363,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,  387,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  262,  263, 
          264,  342,   -1,   -1,  268,  269,   -1,  271,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   10,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   59,  361,   61,  363, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   10,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,   -1,   -1,   -1, 
          342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   59,  361, 
           61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  262,  263,  264,  342, 
           -1,   -1,  268,  269,   -1,  271,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,  290,  291,   63,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,    0,   -1,  333,  334,  335, 
          336,   -1,   -1,   -1,   -1,   10,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,  387,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
            0,   -1,  333,  334,  335,  336,   -1,   -1,   -1,   -1, 
           10,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  387,   -1,   58,   59, 
           -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,    0,  351,   -1,   -1,   -1,  355,  356, 
          357,  358,  359,   10,  361,   -1,  363,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,  387,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   58,   59,  333,  334,   -1,   63,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   58,   59,   -1,   -1,  305,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  290,  291,   63,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,    0,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   10,   -1,   -1, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
          387,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,    0,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  387, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  290,  291,   63, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,  357,  358,   -1,   -1,   -1,   -1, 
          363,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           58,   59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,    0,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  357,  358, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  387,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  357,  358,   -1,   -1,   -1,   -1,  363, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  387,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  290,  291,   63,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,    0,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  357, 
          358,   -1,   -1,   -1,   -1,  363,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,  387, 
           44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   -1,   -1,   63, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  290,  291,   63,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,    0,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  387,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   58, 
           59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,    0,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  387,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  290,  291,   63,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   10,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  387,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          339,   -1,   63,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,  375,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   10,  387,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,    0,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1,  375, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  387,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   10,   -1,   -1,  325,   -1, 
           -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262, 
          263,  264,  363,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,    0,   -1,  375,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   10,   -1,   -1,   -1,  387,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   44, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  375,   58,   59,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  387,   -1,   -1,  262,  263,  264, 
           -1,  305,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,  339,   -1,   -1,  342,   -1, 
          305,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  375,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,  387,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,    0,  363,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   10,   -1,   -1, 
          375,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,  387,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,   -1,   58,   59,   -1,   -1,   -1, 
           -1,  339,   10,  281,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,  363,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,    0,  271,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  281,  282,   -1,  387, 
           -1,   59,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,  387, 
          345,   -1,  347,  262,  263,  264,   -1,   -1,  267,  268, 
          269,    0,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   10,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  387,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,  262, 
          263,  264,   -1,   -1,  267,  268,  269,    0,  271,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   10,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,  262,  263,  264, 
          363,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  342,   -1,   -1,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,  387, 
          345,    0,  347,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  387,   -1,   -1,   44,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,    0,  347,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  387,   -1, 
           -1,   44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,    0,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,  387,   -1,   -1,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,    0,  347,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,  387,   -1,   -1,   44,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,    0,  347,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  387,   -1, 
           -1,   44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   44, 
          363,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,  375,   -1,   59,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,  387,   -1,   -1,    0,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   44,  347,  262,  263,  264,   -1,   -1,  267,  268, 
          269,    0,  271,   -1,   -1,   -1,   59,   -1,  363,   -1, 
           -1,   10,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,  290,  291,   59,  293,  294,  295,  296,   -1,   -1, 
           -1,   -1,  387,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,  375,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           10,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,  342, 
           -1,   -1,  345,   -1,  347,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  342,  271,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,  363,   -1, 
          293,  294,  295,  296,  297,  281,  282,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  387,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  281,  282,   -1,   -1,  339,   -1,   -1,  342, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345, 
          363,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  345,   -1,   -1,   -1, 
           -1,  387,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,  387,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  363,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,  387,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  363,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
          342,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           10,  363,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,  387,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   91,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   -1,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   10,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   59,   -1,   -1,   -1,  335,  336, 
          337,   -1,   -1,  340,  341,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
          357,   -1,   -1,  360,   -1,  362,   91,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   10,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   59,   -1,   -1,   -1,  335,  336,  337,   -1,   -1, 
          340,  341,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,  357,   -1,   -1, 
          360,   -1,  362,   91,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   10,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   59,   -1,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,  357,   -1,   -1,  360,   -1,  362,   91,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   10,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   59,   -1,   -1,   -1,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,  341,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,  357, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   10,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   59,   -1,   -1,   -1, 
           -1,   -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
          264,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   44,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,  342,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   44,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,  386,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,  341,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  333,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  386,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  386,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,  386, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,  386,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  386,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  386,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,   -1,  364,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
      };
   }

}
