/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubySocket;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    private static ObjectAllocator IPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyIPSocket(runtime2, klass);
        }
    };

    static void createIPSocket(Ruby runtime2) {
        RubyClass rb_cIPSocket = runtime2.defineClass("IPSocket", runtime2.fastGetClass("BasicSocket"), IPSOCKET_ALLOCATOR);
        rb_cIPSocket.defineAnnotatedMethods(RubyIPSocket.class);
        runtime2.getObject().fastSetConstant("IPsocket", rb_cIPSocket);
    }

    public RubyIPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    protected static RuntimeException sockerr(Ruby runtime2, String msg) {
        return new RaiseException(runtime2, runtime2.fastGetClass("SocketError"), msg, true);
    }

    public IRubyObject packSockaddrFromAddress(InetSocketAddress sock, ThreadContext context) {
        if (sock == null) {
            return RubySocket.pack_sockaddr_in(context, (IRubyObject)this, 0, "");
        }
        return RubySocket.pack_sockaddr_in(context, sock);
    }

    private IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby r = context.getRuntime();
        IRubyObject[] ret = new IRubyObject[4];
        ret[0] = r.newString("AF_INET");
        ret[1] = r.newFixnum(addr2.getPort());
        String hostAddress = addr2.getAddress().getHostAddress();
        ret[2] = !reverse2 || this.doNotReverseLookup(context) ? r.newString(hostAddress) : r.newString(addr2.getHostName());
        ret[3] = r.newString(hostAddress);
        return r.newArrayNoCopy(ret);
    }

    @Deprecated
    public IRubyObject addr() {
        return this.addr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        return this.addrCommon(context, true);
    }

    @JRubyMethod(name={"addr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject addr19(ThreadContext context) {
        return this.addrCommon(context, true);
    }

    @JRubyMethod(name={"addr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject addr19(ThreadContext context, IRubyObject reverse2) {
        return this.addrCommon(context, reverse2.isTrue());
    }

    private IRubyObject addrCommon(ThreadContext context, boolean reverse2) {
        try {
            InetSocketAddress address2 = this.getLocalSocket("addr");
            if (address2 == null) {
                throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
            }
            return this.addrFor(context, address2, reverse2);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Deprecated
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        return this.peeraddrCommon(context, true);
    }

    @JRubyMethod(name={"peeraddr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject peeraddr19(ThreadContext context) {
        return this.peeraddrCommon(context, true);
    }

    @JRubyMethod(name={"peeraddr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject peeraddr19(ThreadContext context, IRubyObject reverse2) {
        return this.peeraddrCommon(context, reverse2.isTrue());
    }

    private IRubyObject peeraddrCommon(ThreadContext context, boolean reverse2) {
        try {
            InetSocketAddress address2 = this.getRemoteSocket();
            if (address2 == null) {
                throw context.getRuntime().newErrnoENOTSOCKError("Not socket or not connected");
            }
            return this.addrFor(context, address2, reverse2);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        try {
            InetSocketAddress sock = this.getLocalSocket(caller2);
            return this.packSockaddrFromAddress(sock, context);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    public IRubyObject getpeername(ThreadContext context) {
        try {
            InetSocketAddress sock = this.getRemoteSocket();
            return this.packSockaddrFromAddress(sock, context);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Deprecated
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        return RubyIPSocket.getaddress(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        try {
            return context.getRuntime().newString(InetAddress.getByName(hostname.convertToString().toString()).getHostAddress());
        }
        catch (UnknownHostException e) {
            throw RubyIPSocket.sockerr(context.getRuntime(), "getaddress: name or service not known");
        }
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        try {
            String hostName;
            String hostAddress;
            int port;
            IRubyObject result2 = this.recv(context, args2);
            InetSocketAddress sender = this.getRemoteSocket();
            if (sender == null) {
                port = 0;
                hostAddress = "0.0.0.0";
                hostName = "0.0.0.0";
            } else {
                port = sender.getPort();
                hostName = sender.getHostName();
                hostAddress = sender.getAddress().getHostAddress();
            }
            RubyArray addressArray = context.getRuntime().newArray(context.getRuntime().newString("AF_INET"), context.getRuntime().newFixnum(port), context.getRuntime().newString(hostName), context.getRuntime().newString(hostAddress));
            return context.getRuntime().newArray(new IRubyObject[]{result2, addressArray});
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }
}

