/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import org.jruby.util.cli.Options;
import org.jruby.util.collections.ClassValueCalculator;
import org.jruby.util.collections.Java7ClassValue;
import org.jruby.util.collections.MapBasedClassValue;

public abstract class ClassValue<T> {
    protected final ClassValueCalculator<T> calculator;
    private static final boolean CLASS_VALUE = (Boolean)Options.INVOKEDYNAMIC_CLASS_VALUES.load();

    public ClassValue(ClassValueCalculator<T> calculator) {
        this.calculator = calculator;
    }

    public abstract T get(Class<?> var1);

    public static <T> ClassValue<T> newInstance(ClassValueCalculator<T> calculator) {
        if (CLASS_VALUE) {
            return ClassValue.newJava7Instance(calculator);
        }
        return new MapBasedClassValue<T>(calculator);
    }

    private static <T> ClassValue<T> newJava7Instance(ClassValueCalculator<T> calculator) {
        return new Java7ClassValue<T>(calculator);
    }
}

