/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jooq.SQLDialect;
import org.jooq.codegen.AbstractGeneratorStrategy;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.Language;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.EmbeddableRecordImpl;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTPathTableFieldImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.ConstraintDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.EnumLiteralDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.ManyToManyKeyDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.SyntheticDaoDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.StringUtils;

public class DefaultGeneratorStrategy
extends AbstractGeneratorStrategy {
    String targetDirectory;
    String targetPackage;
    Locale targetLocale = Locale.getDefault();
    Language targetLanguage = Language.JAVA;
    boolean instanceFields = true;
    boolean javaBeansGettersAndSetters = false;
    boolean useTableNameForUnambiguousFKs = true;

    @Override
    public void setInstanceFields(boolean instanceFields) {
        this.instanceFields = instanceFields;
    }

    @Override
    public boolean getInstanceFields() {
        return this.instanceFields;
    }

    @Override
    public void setJavaBeansGettersAndSetters(boolean javaBeansGettersAndSetters) {
        this.javaBeansGettersAndSetters = javaBeansGettersAndSetters;
    }

    @Override
    public boolean getJavaBeansGettersAndSetters() {
        return this.javaBeansGettersAndSetters;
    }

    @Override
    public void setUseTableNameForUnambiguousFKs(boolean useTableNameForUnambiguousFKs) {
        this.useTableNameForUnambiguousFKs = useTableNameForUnambiguousFKs;
    }

    @Override
    public boolean getUseTableNameForUnambiguousFKs() {
        return this.useTableNameForUnambiguousFKs;
    }

    @Override
    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.targetDirectory = directory;
    }

    @Override
    public String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.targetPackage = packageName;
    }

    @Override
    public Locale getTargetLocale() {
        return this.targetLocale;
    }

    @Override
    public void setTargetLocale(Locale targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    @Override
    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    @Override
    public String getGlobalNamesFileHeader(Definition container, Class<? extends Definition> objectType) {
        return "This file is generated by jOOQ.";
    }

    @Override
    public String getGlobalReferencesFileHeader(Definition container, Class<? extends Definition> objectType) {
        return "This file is generated by jOOQ.";
    }

    @Override
    public String getFileHeader(Definition definition, GeneratorStrategy.Mode mode) {
        return "This file is generated by jOOQ.";
    }

    @Override
    public String getJavaEnumLiteral(EnumDefinition definition, String literal) {
        return GenerationUtil.convertToIdentifier(literal, this.getTargetLanguage());
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        String identifier = this.getFixedJavaIdentifier(definition);
        if (identifier != null) {
            return identifier;
        }
        if (definition instanceof IndexDefinition && Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains(definition.getDatabase().getDialect().family())) {
            return ((IndexDefinition)definition).getTable().getOutputName().toUpperCase(this.targetLocale) + "_" + definition.getOutputName().toUpperCase(this.targetLocale);
        }
        if (definition instanceof UniqueKeyDefinition && Arrays.asList(SQLDialect.SQLITE).contains(definition.getDatabase().getDialect().family())) {
            return ((UniqueKeyDefinition)definition).getTable().getOutputName().toUpperCase(this.targetLocale) + "__" + definition.getOutputName().toUpperCase(this.targetLocale);
        }
        if (definition instanceof ForeignKeyDefinition && Arrays.asList(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB).contains(definition.getDatabase().getDialect().family())) {
            return ((ForeignKeyDefinition)definition).getTable().getOutputName().toUpperCase(this.targetLocale) + "__" + definition.getOutputName().toUpperCase(this.targetLocale);
        }
        if (definition instanceof InverseForeignKeyDefinition && Arrays.asList(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB).contains(definition.getDatabase().getDialect().family())) {
            return ((InverseForeignKeyDefinition)definition).getReferencingTable().getOutputName().toUpperCase(this.targetLocale) + "__" + definition.getOutputName().toUpperCase(this.targetLocale);
        }
        if (definition instanceof EmbeddableDefinition) {
            return ((EmbeddableDefinition)definition).getReferencingOutputName().toUpperCase(this.targetLocale);
        }
        return definition.getOutputName().toUpperCase(this.targetLocale);
    }

    String getterSetterSuffix(Definition definition) {
        if (this.javaBeansGettersAndSetters) {
            String name = this.getJavaMemberName(definition);
            if (Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        if (definition instanceof EmbeddableDefinition) {
            return this.getJavaClassName0(((EmbeddableDefinition)definition).getReferencingOutputName(), GeneratorStrategy.Mode.DEFAULT);
        }
        return this.getJavaClassName0(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "set" + this.getterSetterSuffix(definition);
    }

    @Override
    public boolean getJavaSetterOverride(Definition definition, GeneratorStrategy.Mode mode) {
        return false;
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        return "get" + this.getterSetterSuffix(definition);
    }

    @Override
    public boolean getJavaGetterOverride(Definition definition, GeneratorStrategy.Mode mode) {
        return false;
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        if (this.getUseTableNameForUnambiguousFKs()) {
            if (definition instanceof ForeignKeyDefinition) {
                ForeignKeyDefinition fk = (ForeignKeyDefinition)definition;
                TableDefinition referenced = fk.getReferencedTable();
                if (fk.getTable().getForeignKeys(referenced).size() == 1) {
                    return this.getJavaMethodName((Definition)referenced, mode);
                }
            } else if (definition instanceof InverseForeignKeyDefinition) {
                InverseForeignKeyDefinition fk = (InverseForeignKeyDefinition)definition;
                TableDefinition referencing = fk.getReferencingTable();
                if (fk.getTable().getInverseForeignKeys(referencing).size() == 1) {
                    return this.getJavaMethodName((Definition)referencing, mode);
                }
            } else if (definition instanceof ManyToManyKeyDefinition) {
                TableDefinition t2;
                ManyToManyKeyDefinition k = (ManyToManyKeyDefinition)definition;
                TableDefinition t1 = k.getForeignKey1().getReferencedTable();
                if (t1.getManyToManyKeys(t2 = k.getForeignKey2().getReferencedTable()).size() == 1) {
                    return this.getJavaMethodName((Definition)t2, mode);
                }
                return this.getJavaClassName0LC((Definition)k.getForeignKey2(), GeneratorStrategy.Mode.DEFAULT);
            }
        }
        return this.getJavaClassName0LC(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public boolean getJavaMethodOverride(Definition definition, GeneratorStrategy.Mode mode) {
        return false;
    }

    @Override
    public String getGlobalNamesJavaClassExtends(Definition container, Class<? extends Definition> objectType) {
        return null;
    }

    @Override
    public String getGlobalReferencesJavaClassExtends(Definition container, Class<? extends Definition> objectType) {
        return null;
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof CatalogDefinition) {
            return CatalogImpl.class.getName();
        }
        if (definition instanceof SchemaDefinition) {
            return SchemaImpl.class.getName();
        }
        if (definition instanceof RoutineDefinition) {
            return AbstractRoutine.class.getName();
        }
        if (definition instanceof TableDefinition) {
            TableDefinition t = (TableDefinition)definition;
            switch (mode) {
                case DAO: {
                    return DAOImpl.class.getName();
                }
                case RECORD: {
                    return (t.getPrimaryKey() != null ? UpdatableRecordImpl.class : TableRecordImpl.class).getName();
                }
                case DEFAULT: {
                    return TableImpl.class.getName();
                }
            }
        } else if (definition instanceof UDTDefinition) {
            switch (mode) {
                case PATH: {
                    return UDTPathTableFieldImpl.class.getName();
                }
                case RECORD: {
                    return UDTRecordImpl.class.getName();
                }
                case DEFAULT: {
                    return UDTImpl.class.getName();
                }
            }
        } else if (definition instanceof EmbeddableDefinition) {
            switch (mode) {
                case RECORD: {
                    return EmbeddableRecordImpl.class.getName();
                }
            }
        }
        return null;
    }

    @Override
    public List<String> getGlobalNamesJavaClassImplements(Definition container, Class<? extends Definition> objectType) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getGlobalReferencesJavaClassImplements(Definition container, Class<? extends Definition> objectType) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        return new ArrayList<String>();
    }

    @Override
    public String getGlobalNamesJavaClassName(Definition container, Class<? extends Definition> objectType) {
        if (ArrayDefinition.class.isAssignableFrom(objectType)) {
            return "ArrayNames";
        }
        if (AttributeDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container) + "AttributeNames";
        }
        if (CatalogDefinition.class.isAssignableFrom(objectType)) {
            return "CatalogNames";
        }
        if (ColumnDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container) + "ColumnNames";
        }
        if (DomainDefinition.class.isAssignableFrom(objectType)) {
            return "DomainNames";
        }
        if (EmbeddableDefinition.class.isAssignableFrom(objectType)) {
            return "EmbeddableNames";
        }
        if (EnumDefinition.class.isAssignableFrom(objectType)) {
            return "EnumNames";
        }
        if (EnumLiteralDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container) + "LiteralNames";
        }
        if (ForeignKeyDefinition.class.isAssignableFrom(objectType)) {
            return "ForeignKeyNames";
        }
        if (IdentityDefinition.class.isAssignableFrom(objectType)) {
            return "IdentityNames";
        }
        if (IndexDefinition.class.isAssignableFrom(objectType)) {
            return "IndexNames";
        }
        if (UDTDefinition.class.isAssignableFrom(objectType)) {
            return "UDTNames";
        }
        if (PackageDefinition.class.isAssignableFrom(objectType)) {
            return "PackageNames";
        }
        if (ParameterDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container) + "ParameterNames";
        }
        if (RoutineDefinition.class.isAssignableFrom(objectType)) {
            return "RoutineNames";
        }
        if (SchemaDefinition.class.isAssignableFrom(objectType)) {
            return "SchemaNames";
        }
        if (SequenceDefinition.class.isAssignableFrom(objectType)) {
            return "SequenceNames";
        }
        if (TableDefinition.class.isAssignableFrom(objectType)) {
            return "TableNames";
        }
        if (UniqueKeyDefinition.class.isAssignableFrom(objectType)) {
            return "UniqueKeyNames";
        }
        return "UnknownTypeNames";
    }

    @Override
    public String getGlobalReferencesJavaClassName(Definition container, Class<? extends Definition> objectType) {
        if (ArrayDefinition.class.isAssignableFrom(objectType)) {
            return "Arrays";
        }
        if (AttributeDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container);
        }
        if (CatalogDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container);
        }
        if (ConstraintDefinition.class.isAssignableFrom(objectType)) {
            return "Keys";
        }
        if (ColumnDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container);
        }
        if (DomainDefinition.class.isAssignableFrom(objectType)) {
            return "Domains";
        }
        if (EmbeddableDefinition.class.isAssignableFrom(objectType)) {
            return "Embeddables";
        }
        if (EnumDefinition.class.isAssignableFrom(objectType)) {
            return "Enums";
        }
        if (IdentityDefinition.class.isAssignableFrom(objectType)) {
            return "Identities";
        }
        if (IndexDefinition.class.isAssignableFrom(objectType)) {
            return "Indexes";
        }
        if (PackageDefinition.class.isAssignableFrom(objectType)) {
            return "UDTs";
        }
        if (ParameterDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container);
        }
        if (RoutineDefinition.class.isAssignableFrom(objectType)) {
            return "Routines";
        }
        if (SchemaDefinition.class.isAssignableFrom(objectType)) {
            return this.getJavaClassName(container);
        }
        if (SequenceDefinition.class.isAssignableFrom(objectType)) {
            return "Sequences";
        }
        if (TableDefinition.class.isAssignableFrom(objectType)) {
            return "Tables";
        }
        if (UDTDefinition.class.isAssignableFrom(objectType)) {
            return "UDTs";
        }
        return "UnknownTypes";
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String name = this.getFixedJavaClassName(definition);
        if (name != null) {
            return name;
        }
        return this.getJavaClassName0(definition, mode);
    }

    @Override
    public String getGlobalNamesJavaPackageName(Definition container, Class<? extends Definition> objectType) {
        return this.getGlobalObjectJavaPackageName0(container, this.getGlobalReferencesJavaClassName(container, objectType), TableDefinition.class.isAssignableFrom(objectType) || RoutineDefinition.class.isAssignableFrom(objectType) || UDTDefinition.class.isAssignableFrom(objectType) || AttributeDefinition.class.isAssignableFrom(objectType) || ConstraintDefinition.class.isAssignableFrom(objectType) || ColumnDefinition.class.isAssignableFrom(objectType) || DomainDefinition.class.isAssignableFrom(objectType) || EnumDefinition.class.isAssignableFrom(objectType) || IndexDefinition.class.isAssignableFrom(objectType) || ParameterDefinition.class.isAssignableFrom(objectType) || SequenceDefinition.class.isAssignableFrom(objectType) ? "names" : "");
    }

    @Override
    public String getGlobalReferencesJavaPackageName(Definition container, Class<? extends Definition> objectType) {
        return this.getGlobalObjectJavaPackageName0(container, this.getGlobalReferencesJavaClassName(container, objectType), TableDefinition.class.isAssignableFrom(objectType) || RoutineDefinition.class.isAssignableFrom(objectType) || UDTDefinition.class.isAssignableFrom(objectType) ? "references" : null);
    }

    private String getGlobalObjectJavaPackageName0(Definition container, String fileClassName, String kotlinSubpackage) {
        Object packageName = this.getJavaPackageName(container);
        if (container instanceof PackageDefinition && !(container instanceof UDTDefinition)) {
            packageName = (String)packageName + "." + this.getJavaIdentifier(container).toLowerCase(this.targetLocale);
        }
        if (this.targetLanguage == Language.KOTLIN) {
            String className = fileClassName.toLowerCase(this.targetLocale);
            packageName = kotlinSubpackage != null ? (String)packageName + "." + className + "." + kotlinSubpackage : (String)packageName + "." + className;
        }
        return packageName;
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetPackage());
        if (definition.getDatabase().getCatalogs().size() > 1) {
            sb.append(".");
            sb.append(this.getJavaIdentifier((Definition)definition.getCatalog()).toLowerCase(this.targetLocale));
        }
        if (!(definition instanceof CatalogDefinition)) {
            if (definition.getDatabase().getSchemata().size() > 1) {
                sb.append(".");
                sb.append(this.getJavaIdentifier((Definition)definition.getSchema()).toLowerCase(this.targetLocale));
            }
            if (!(definition instanceof SchemaDefinition)) {
                String subPackage = this.getSubPackage(definition, mode);
                if (!StringUtils.isBlank((String)subPackage)) {
                    sb.append(".");
                    sb.append(subPackage);
                }
                if (mode == GeneratorStrategy.Mode.RECORD) {
                    sb.append(".records");
                } else if (mode == GeneratorStrategy.Mode.RECORD_TYPE) {
                    sb.append(".recordtypes");
                } else if (mode == GeneratorStrategy.Mode.POJO) {
                    sb.append(".pojos");
                } else if (mode == GeneratorStrategy.Mode.DAO) {
                    sb.append(".daos");
                } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
                    sb.append(".interfaces");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof EmbeddableDefinition) {
            return this.getJavaClassName0LC(((EmbeddableDefinition)definition).getReferencingOutputName(), GeneratorStrategy.Mode.DEFAULT);
        }
        return this.getJavaClassName0LC(definition, GeneratorStrategy.Mode.DEFAULT);
    }

    @Override
    public boolean getJavaMemberOverride(Definition definition, GeneratorStrategy.Mode mode) {
        return false;
    }

    private String getJavaClassName0LC(Definition definition, GeneratorStrategy.Mode mode) {
        String result = this.getJavaClassName0(definition, mode);
        return result.substring(0, 1).toLowerCase(this.targetLocale) + result.substring(1);
    }

    private String getJavaClassName0LC(String outputName, GeneratorStrategy.Mode mode) {
        String result = this.getJavaClassName0(outputName, mode);
        return result.substring(0, 1).toLowerCase(this.targetLocale) + result.substring(1);
    }

    private String getJavaClassName0(Definition definition, GeneratorStrategy.Mode mode) {
        return this.getJavaClassName0(definition.getOutputName(), mode);
    }

    private String getJavaClassName0(String outputName, GeneratorStrategy.Mode mode) {
        StringBuilder result = new StringBuilder();
        result.append(this.toPascalCase(outputName.replace(' ', '_').replace('-', '_').replace('.', '_')));
        if (mode == GeneratorStrategy.Mode.RECORD) {
            result.append("Record");
        } else if (mode == GeneratorStrategy.Mode.DAO) {
            result.append("Dao");
        } else if (mode == GeneratorStrategy.Mode.INTERFACE) {
            result.insert(0, "I");
        } else if (mode == GeneratorStrategy.Mode.RECORD_TYPE) {
            result.append("RecordType");
        } else if (mode == GeneratorStrategy.Mode.PATH) {
            result.append("Path");
        }
        return result.toString();
    }

    private String getSubPackage(Definition definition, GeneratorStrategy.Mode mode) {
        if (definition instanceof TableDefinition) {
            return "tables";
        }
        if (definition instanceof EmbeddableDefinition) {
            return "embeddables";
        }
        if (definition instanceof UDTDefinition) {
            UDTDefinition u = (UDTDefinition)definition;
            if (u.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)u.getPackage()).toLowerCase(this.targetLocale) + ".udt";
            }
            if (mode == GeneratorStrategy.Mode.PATH) {
                return "udt.paths";
            }
            return "udt";
        }
        if (definition instanceof PackageDefinition) {
            return "packages";
        }
        if (definition instanceof RoutineDefinition) {
            RoutineDefinition r = (RoutineDefinition)definition;
            if (r.getPackage() instanceof UDTDefinition) {
                return "udt." + this.getJavaIdentifier((Definition)r.getPackage()).toLowerCase(this.targetLocale);
            }
            if (r.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)r.getPackage()).toLowerCase(this.targetLocale);
            }
            return "routines";
        }
        if (definition instanceof EnumDefinition) {
            return "enums";
        }
        if (definition instanceof DomainDefinition) {
            return "domains";
        }
        if (definition instanceof ArrayDefinition) {
            ArrayDefinition a = (ArrayDefinition)definition;
            if (a.getPackage() != null) {
                return "packages." + this.getJavaIdentifier((Definition)a.getPackage()).toLowerCase(this.targetLocale) + ".udt";
            }
            return "udt";
        }
        if (definition instanceof SyntheticDaoDefinition) {
            return "daos";
        }
        return "";
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return overloadIndex;
    }

    String toPascalCase(String name) {
        return StringUtils.toCamelCase((String)name);
    }

    static Case getCase(String name) {
        if (name.toUpperCase().equals(name)) {
            return Case.UPPER;
        }
        if (name.toLowerCase().equals(name)) {
            return Case.LOWER;
        }
        return Case.MIXED;
    }

    static enum Case {
        UPPER,
        LOWER,
        MIXED;

    }
}

