/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jolokia.server.core.service.api.LogHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class SpringJolokiaLogHandlerHolder
implements InitializingBean {
    private LogHandler logHandler;
    private String type;
    private String category;

    public void afterPropertiesSet() {
        if (this.logHandler == null) {
            if (StringUtils.hasLength((String)this.type)) {
                LogHandlerType lht = LogHandlerType.byType(this.type);
                if (lht == null) {
                    throw new IllegalArgumentException("No loghandler with type " + this.type + " known");
                }
                this.logHandler = lht.createLogHandler(StringUtils.hasLength((String)this.category) ? this.category : null);
            } else {
                throw new IllegalArgumentException("Neither 'log-ref' nor 'type' given. Please provide one of them");
            }
        }
    }

    public void setLogHandler(LogHandler pLogHandler) {
        this.logHandler = pLogHandler;
    }

    public void setType(String pType) {
        this.type = pType;
    }

    public void setCategory(String pCategory) {
        this.category = pCategory;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    static enum LogHandlerType {
        STDOUT("stdout", "org.jolokia.server.core.service.impl.StdoutLogHandler"),
        QUIET("quiet", "org.jolokia.server.core.service.impl.QuietLogHandler"),
        JUL("jul", "org.jolokia.server.core.service.impl.JulLogHandler"),
        LOG4J2("log4j2", "org.jolokia.support.spring.log.Log4j2LogHandler"),
        SLF4J("slf4j", "org.jolokia.support.spring.log.Slf4jLogHandler"),
        COMMONS("commons", "org.jolokia.support.spring.log.CommonsLogHandler");

        private final String className;
        private final String type;

        private LogHandlerType(String pType, String pClassName) {
            this.className = pClassName;
            this.type = pType;
        }

        static LogHandlerType byType(String name) {
            for (LogHandlerType t : LogHandlerType.values()) {
                if (!t.type.equals(name)) continue;
                return t;
            }
            return null;
        }

        LogHandler createLogHandler(String category) {
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.className);
                Constructor<?> ctr = clazz.getConstructor(String.class);
                return (LogHandler)ctr.newInstance(category);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

