/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaEvaluator;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.impl.base.KaErrorConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseIllegalPsiExceptionKt;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseSessionComponent;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\rH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirEvaluator;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSessionComponent;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "Lorg/jetbrains/kotlin/analysis/api/components/KaEvaluator;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSessionProvider", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;", "evaluate", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "evaluateAsAnnotationValue", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "evaluateFir", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirEvaluator\n+ 2 KaBaseIllegalPsiException.kt\norg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseIllegalPsiExceptionKt\n+ 3 KaLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerKt\n+ 4 KaLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenKt\n*L\n1#1,62:1\n104#2:63\n105#2,3:87\n104#2:90\n105#2,3:114\n47#3:64\n36#3:65\n37#3:85\n48#3:86\n47#3:91\n36#3:92\n37#3:112\n48#3:113\n47#4,19:66\n47#4,19:93\n*S KotlinDebug\n*F\n+ 1 KaFirEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirEvaluator\n*L\n27#1:63\n27#1:87,3\n31#1:90\n31#1:114,3\n27#1:64\n27#1:65\n27#1:85\n27#1:86\n31#1:91\n31#1:92\n31#1:112\n31#1:113\n27#1:66,19\n31#1:93,19\n*E\n"})
public final class KaFirEvaluator
extends KaBaseSessionComponent<KaFirSession>
implements KaEvaluator,
KaFirSessionComponent {
    @NotNull
    private final Function0<KaFirSession> analysisSessionProvider;

    public KaFirEvaluator(@NotNull Function0<KaFirSession> analysisSessionProvider) {
        Intrinsics.checkNotNullParameter(analysisSessionProvider, (String)"analysisSessionProvider");
        this.analysisSessionProvider = analysisSessionProvider;
    }

    @Override
    @NotNull
    public Function0<KaFirSession> getAnalysisSessionProvider() {
        return this.analysisSessionProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KaConstantValue evaluate(@NotNull KtExpression $this$evaluate) {
        void component$iv;
        Intrinsics.checkNotNullParameter((Object)$this$evaluate, (String)"<this>");
        KaBaseSessionComponent kaBaseSessionComponent = this;
        PsiElement $this$withPsiValidityAssertion$iv = (PsiElement)$this$evaluate;
        boolean $i$f$withPsiValidityAssertionAsReceiver = false;
        KaLifetimeOwner $this$withValidityAssertion$iv$iv = (KaLifetimeOwner)component$iv;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv$iv = $this$withValidityAssertion$iv$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        KaBaseIllegalPsiExceptionKt.checkValidity(component$iv, $this$withPsiValidityAssertion$iv);
        boolean bl2 = false;
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$evaluate, this.getResolutionFacade()), $this$evaluate);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KaAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression $this$evaluateAsAnnotationValue) {
        KaAnnotationValue kaAnnotationValue;
        void component$iv;
        Intrinsics.checkNotNullParameter((Object)$this$evaluateAsAnnotationValue, (String)"<this>");
        KaBaseSessionComponent kaBaseSessionComponent = this;
        PsiElement $this$withPsiValidityAssertion$iv = (PsiElement)$this$evaluateAsAnnotationValue;
        boolean $i$f$withPsiValidityAssertionAsReceiver = false;
        KaLifetimeOwner $this$withValidityAssertion$iv$iv = (KaLifetimeOwner)component$iv;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv$iv = $this$withValidityAssertion$iv$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        KaBaseIllegalPsiExceptionKt.checkValidity(component$iv, $this$withPsiValidityAssertion$iv);
        boolean bl2 = false;
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir((KtElement)$this$evaluateAsAnnotationValue, this.getResolutionFacade());
        FirExpression firExpression = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl3 = false;
            kaAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, ((KaFirSession)this.getAnalysisSession()).getFirSymbolBuilder$analysis_api_fir());
        } else {
            kaAnnotationValue = null;
        }
        return kaAnnotationValue;
    }

    private final KaConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi) {
        KaConstantValue kaConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KaConstantValue kaConstantValue2;
            try {
                kaConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir, ((KaFirSession)this.getAnalysisSession()).getFirSession$analysis_api_fir());
            }
            catch (ArithmeticException e) {
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                kaConstantValue2 = new KaErrorConstantValueImpl(string, (KtElement)sourcePsi);
            }
            kaConstantValue = kaConstantValue2;
        } else {
            kaConstantValue = null;
        }
        return kaConstantValue;
    }
}

