/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.work.WorkStatus;

public class ParallelFlowReport
implements WorkReport {
    private List<WorkReport> reports;

    public ParallelFlowReport() {
        this(new ArrayList<WorkReport>());
    }

    public ParallelFlowReport(List<WorkReport> reports) {
        this.reports = reports;
    }

    public List<WorkReport> getReports() {
        return this.reports;
    }

    void add(WorkReport workReport) {
        this.reports.add(workReport);
    }

    void addAll(List<WorkReport> workReports) {
        this.reports.addAll(workReports);
    }

    @Override
    public WorkStatus getStatus() {
        for (WorkReport report : this.reports) {
            if (!report.getStatus().equals((Object)WorkStatus.FAILED)) continue;
            return WorkStatus.FAILED;
        }
        return WorkStatus.COMPLETED;
    }

    @Override
    public Throwable getError() {
        for (WorkReport report : this.reports) {
            Throwable error = report.getError();
            if (error == null) continue;
            return error;
        }
        return null;
    }

    @Override
    public WorkContext getWorkContext() {
        WorkContext workContext = new WorkContext();
        for (WorkReport report : this.reports) {
            WorkContext partialContext = report.getWorkContext();
            for (Map.Entry<String, Object> entry : partialContext.getEntrySet()) {
                workContext.put(entry.getKey(), entry.getValue());
            }
        }
        return workContext;
    }
}

