/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.work;

import java.util.concurrent.atomic.AtomicInteger;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.work.WorkStatus;

@FunctionalInterface
public interface WorkReportPredicate {
    public static final WorkReportPredicate ALWAYS_TRUE = workReport -> true;
    public static final WorkReportPredicate ALWAYS_FALSE = workReport -> false;
    public static final WorkReportPredicate COMPLETED = workReport -> workReport.getStatus().equals((Object)WorkStatus.COMPLETED);
    public static final WorkReportPredicate FAILED = workReport -> workReport.getStatus().equals((Object)WorkStatus.FAILED);

    public boolean apply(WorkReport var1);

    public static class TimesPredicate
    implements WorkReportPredicate {
        private int times;
        private AtomicInteger counter = new AtomicInteger();

        public TimesPredicate(int times) {
            this.times = times;
        }

        @Override
        public boolean apply(WorkReport workReport) {
            return this.counter.incrementAndGet() != this.times;
        }

        public static TimesPredicate times(int times) {
            return new TimesPredicate(times);
        }
    }
}

