/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.config.internal.ConfigCache;
import org.jdbi.v3.core.config.internal.ConfigCaches;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.OnDemandExtensions;
import org.jdbi.v3.sqlobject.GenerateSqlObject;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorators;
import org.jdbi.v3.sqlobject.Handlers;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;
import org.jdbi.v3.sqlobject.internal.SqlObjectInitData;

public class SqlObjectFactory
implements ExtensionFactory,
OnDemandExtensions.Factory {
    private final ConfigCache<Class<?>, SqlObjectInitData> sqlObjectCache = ConfigCaches.declare(SqlObjectFactory::initDataFor);

    SqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        if (this.looksLikeSqlObject(extensionType)) {
            if (extensionType.getAnnotation(GenerateSqlObject.class) != null) {
                return true;
            }
            if (!extensionType.isInterface()) {
                throw new IllegalArgumentException("SQL Objects are only supported for interfaces.");
            }
            return true;
        }
        return false;
    }

    private boolean looksLikeSqlObject(Class<?> extensionType) {
        if (SqlObject.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(a -> a.annotationType().isAnnotationPresent(SqlOperation.class));
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        SqlObjectInitData sqlObjectInitData = (SqlObjectInitData)this.sqlObjectCache.get(extensionType, handleSupplier.getConfig());
        ConfigRegistry instanceConfig = sqlObjectInitData.configureInstance(handleSupplier.getConfig().createCopy());
        if (sqlObjectInitData.isConcrete()) {
            return sqlObjectInitData.instantiate(extensionType, handleSupplier, instanceConfig);
        }
        ((Extensions)instanceConfig.get(Extensions.class)).onCreateProxy();
        HashMap handlers = new HashMap();
        Object proxy = Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, (proxyInstance, method, args) -> ((SqlObjectInitData.InContextInvoker)((Supplier)handlers.get(method)).get()).invoke(args));
        sqlObjectInitData.forEachMethodHandler((method, handler) -> handlers.put(method, sqlObjectInitData.lazyInvoker(proxy, (Method)method, handleSupplier, instanceConfig)));
        return extensionType.cast(proxy);
    }

    public Optional<Object> onDemand(Jdbi jdbi, Class<?> extensionType, Class<?> ... extraTypes) {
        SqlObjectInitData sqlObjectInitData = (SqlObjectInitData)this.sqlObjectCache.get(extensionType, (Configurable)jdbi);
        if (!sqlObjectInitData.isConcrete()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Class.forName(extensionType.getPackage().getName() + "." + extensionType.getSimpleName() + "Impl$OnDemand").getConstructor(Jdbi.class).newInstance(jdbi));
        }
        catch (ExceptionInInitializerError | ReflectiveOperationException e) {
            throw new UnableToCreateSqlObjectException(e);
        }
    }

    private static Map<Method, Handler> buildMethodHandlers(Class<?> sqlObjectType, Handlers registry, HandlerDecorators decorators) {
        HashMap<Method, Handler> handlerMap = new HashMap<Method, Handler>();
        SqlObjectFactory.addMethodHandler(handlerMap, (target, args, handleSupplier) -> "Jdbi sqlobject proxy for " + sqlObjectType.getName() + "@" + Integer.toHexString(target.hashCode()), Object.class, "toString", new Class[0]);
        SqlObjectFactory.addMethodHandler(handlerMap, (target, args, handleSupplier) -> target == args[0], Object.class, "equals", Object.class);
        SqlObjectFactory.addMethodHandler(handlerMap, (target, args, handleSupplier) -> System.identityHashCode(target), Object.class, "hashCode", new Class[0]);
        SqlObjectFactory.addMethodHandler(handlerMap, (target, args, handleSupplier) -> handleSupplier.getHandle(), SqlObject.class, "getHandle", new Class[0]);
        try {
            SqlObjectFactory.addMethodHandler(handlerMap, (target, args, handleSupplier) -> null, sqlObjectType, "finalize", new Class[0]);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        methods.addAll(Arrays.asList(sqlObjectType.getMethods()));
        methods.addAll(Arrays.asList(sqlObjectType.getDeclaredMethods()));
        HashSet seen = new HashSet(handlerMap.keySet());
        for (Method method : methods) {
            if (Modifier.isStatic(method.getModifiers()) || !seen.add(method)) continue;
            handlerMap.put(method, decorators.applyDecorators(registry.findFor(sqlObjectType, method).orElseGet(() -> {
                Supplier<IllegalStateException> x = () -> new IllegalStateException(String.format("Method %s.%s must have an implementation or be annotated with a SQL method annotation.", method.getDeclaringClass().getSimpleName(), method.getName()));
                if (!(SqlObjectInitData.isConcrete(sqlObjectType) || method.isSynthetic() || Modifier.isPrivate(method.getModifiers()))) {
                    throw x.get();
                }
                return (target, args, handleSupplier) -> {
                    throw (IllegalStateException)x.get();
                };
            }), sqlObjectType, method));
        }
        methods.stream().filter(m -> !m.isSynthetic()).collect(Collectors.groupingBy(m -> Arrays.asList(m.getName(), Arrays.asList(m.getParameterTypes())))).values().stream().filter(l -> l.size() > 1).findAny().ifPresent(ms -> {
            throw new UnableToCreateSqlObjectException(sqlObjectType + " has ambiguous methods " + ms + ", please resolve with an explicit override");
        });
        return handlerMap;
    }

    private static void addMethodHandler(Map<Method, Handler> handlerMap, Handler handler, Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        Method method = Handlers.methodLookup(klass, methodName, parameterTypes);
        handlerMap.put(method, handler);
    }

    private static UnaryOperator<ConfigRegistry> buildConfigurers(Stream<AnnotatedElement> elements, ConfigurerMethod consumer) {
        List myConfigurers = elements.flatMap(ae -> Arrays.stream(ae.getAnnotations())).filter(a -> a.annotationType().isAnnotationPresent(ConfiguringAnnotation.class)).map(a -> {
            ConfiguringAnnotation meta = a.annotationType().getAnnotation(ConfiguringAnnotation.class);
            Configurer configurer = SqlObjectFactory.getConfigurer(meta.value());
            return config -> consumer.configure(configurer, (ConfigRegistry)config, (Annotation)a);
        }).collect(Collectors.toList());
        return config -> {
            myConfigurers.forEach(configurer -> configurer.accept(config));
            return config;
        };
    }

    private static Configurer getConfigurer(Class<? extends Configurer> factoryClass) {
        try {
            return factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to instantiate configurer factory class " + factoryClass, e);
        }
    }

    static SqlObjectInitData initDataFor(ConfigRegistry handlersConfig, Class<?> sqlObjectType) {
        Map<Method, Handler> methodHandlers = SqlObjectFactory.buildMethodHandlers(sqlObjectType, (Handlers)handlersConfig.get(Handlers.class), (HandlerDecorators)handlersConfig.get(HandlerDecorators.class));
        UnaryOperator<ConfigRegistry> instanceConfigurer = SqlObjectFactory.buildConfigurers(Stream.concat(SqlObjectFactory.superTypes(sqlObjectType), Stream.of(sqlObjectType)), (configurer, config, annotation) -> configurer.configureForType(config, annotation, sqlObjectType));
        Map<Method, UnaryOperator<ConfigRegistry>> methodConfigurers = methodHandlers.keySet().stream().collect(Collectors.toMap(Function.identity(), method -> SqlObjectFactory.buildConfigurers(Stream.of(method), (configurer, config, annotation) -> configurer.configureForMethod(config, annotation, sqlObjectType, (Method)method))));
        return new SqlObjectInitData(sqlObjectType, instanceConfigurer, methodConfigurers, methodHandlers);
    }

    private static Stream<Class<?>> superTypes(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        return Stream.concat(Arrays.stream(interfaces).flatMap(SqlObjectFactory::superTypes), Arrays.stream(interfaces));
    }

    static interface ConfigurerMethod {
        public void configure(Configurer var1, ConfigRegistry var2, Annotation var3);
    }
}

