/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;

public final class BeanArchives {
    private BeanArchives() {
    }

    public static <B extends BeanDeploymentArchive> Multimap<String, BeanDeploymentArchive> findBeanClassesDeployedInMultipleBeanArchives(Set<B> beanArchives) {
        HashMultimap<String, BeanDeploymentArchive> problems;
        block7: {
            block6: {
                if (beanArchives.size() == 1) {
                    return ImmutableSetMultimap.of();
                }
                problems = HashMultimap.create();
                if (beanArchives.size() != 2) break block6;
                Iterator<B> iterator = beanArchives.iterator();
                BeanDeploymentArchive first = (BeanDeploymentArchive)iterator.next();
                BeanDeploymentArchive beanDeploymentArchive = (BeanDeploymentArchive)iterator.next();
                HashSet<String> intersection = new HashSet<String>(first.getBeanClasses());
                intersection.retainAll(beanDeploymentArchive.getBeanClasses());
                if (intersection.isEmpty()) break block7;
                ImmutableList<BeanDeploymentArchive> bdas = ImmutableList.of(first, beanDeploymentArchive);
                for (String beanClass : intersection) {
                    problems.putAll(beanClass, bdas);
                }
                break block7;
            }
            if (beanArchives.size() > 2) {
                HashMultimap<String, BeanDeploymentArchive> beanClassOccurrences = HashMultimap.create();
                for (BeanDeploymentArchive beanDeploymentArchive : beanArchives) {
                    for (String beanClass : beanDeploymentArchive.getBeanClasses()) {
                        beanClassOccurrences.put(beanClass, beanDeploymentArchive);
                    }
                }
                for (Map.Entry entry : beanClassOccurrences.asMap().entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    problems.putAll((String)entry.getKey(), (Iterable<BeanDeploymentArchive>)((Iterable)entry.getValue()));
                }
            }
        }
        return problems;
    }
}

