/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.util.Servlets;
import org.jboss.weld.resources.spi.ResourceLoader;

public class WebAppBeanArchiveScanner
extends DefaultBeanArchiveScanner {
    static final String WEB_INF = "/WEB-INF";
    static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    static final String WEB_INF_CLASSES_BEANS_XML = "/WEB-INF/classes/META-INF/beans.xml";
    static final String WEB_INF_CLASSES_FILE_PATH = File.separatorChar + "WEB-INF" + File.separatorChar + "classes";
    static final String[] RESOURCES = new String[]{"/WEB-INF/beans.xml", "/WEB-INF/classes/META-INF/beans.xml"};
    private final ServletContext servletContext;
    private final ResourceLoader resourceLoader;

    public WebAppBeanArchiveScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, ServletContext servletContext) {
        super(resourceLoader, bootstrap);
        this.resourceLoader = resourceLoader;
        this.servletContext = servletContext;
    }

    @Override
    public Map<URL, BeanArchiveScanner.ScanResult> scan() {
        String separator = this.servletContext.getContextPath();
        if (separator.length() == 0) {
            separator = WEB_INF;
        }
        Map<URL, BeanArchiveScanner.ScanResult> resultsMap = super.scan();
        Iterator<Map.Entry<URL, BeanArchiveScanner.ScanResult>> iterator = resultsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] entry = iterator.next();
            String path = ((URL)entry.getKey()).toString();
            if (path.contains(WEB_INF_CLASSES_FILE_PATH) || path.contains(WEB_INF_CLASSES)) {
                iterator.remove();
                continue;
            }
            ((BeanArchiveScanner.ScanResult)entry.getValue()).extractBeanArchiveId(separator);
        }
        try {
            BeansXml beansXml;
            URL beansXmlUrl = null;
            for (String resource : RESOURCES) {
                URL resourceUrl = this.servletContext.getResource(resource);
                if (resourceUrl == null) continue;
                if (beansXmlUrl != null) {
                    WeldServletLogger.LOG.foundBothConfiguration(beansXmlUrl);
                    continue;
                }
                beansXmlUrl = resourceUrl;
            }
            if (beansXmlUrl != null && this.accept(beansXml = this.bootstrap.parse(beansXmlUrl))) {
                File webInfClasses = Servlets.getRealFile(this.servletContext, WEB_INF_CLASSES);
                if (webInfClasses != null) {
                    resultsMap.put(beansXmlUrl, new BeanArchiveScanner.ScanResult(beansXml, webInfClasses.getPath()).extractBeanArchiveId(separator));
                } else {
                    resultsMap.put(beansXmlUrl, new BeanArchiveScanner.ScanResult(beansXml, WEB_INF_CLASSES));
                }
            }
        }
        catch (MalformedURLException e) {
            throw WeldServletLogger.LOG.errorLoadingResources(e);
        }
        return resultsMap;
    }
}

