/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.exporter.ExplodedExporterDelegate;

public class ExplodedExporterImpl
extends AssignableBase<Archive<?>>
implements ExplodedExporter {
    private static final Logger log = Logger.getLogger(ExplodedExporterImpl.class.getName());

    public ExplodedExporterImpl(Archive<?> archive) {
        super(archive);
    }

    public File exportExploded(File baseDirectory) {
        return this.exportExploded(baseDirectory, this.getArchive().getName());
    }

    public File exportExploded(File baseDirectory, String directoryName) {
        Object archive = this.getArchive();
        Validate.notNull(archive, "No archive provided");
        Validate.notNull(baseDirectory, "No baseDirectory provided");
        if (!baseDirectory.exists()) {
            throw new IllegalArgumentException("Parent directory does not exist");
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided parent directory is not a valid directory");
        }
        return this.export((Archive<?>)archive, new File(baseDirectory, directoryName));
    }

    public File exportExplodedInto(File directory) {
        Object archive = this.getArchive();
        Validate.notNull(archive, "No archive provided");
        return this.export((Archive<?>)archive, directory);
    }

    private File export(Archive<?> archive, File outputDirectory) {
        ExplodedExporterDelegate exporterDelegate = new ExplodedExporterDelegate(archive, outputDirectory);
        File explodedDirectory = (File)exporterDelegate.export();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created Exploded Archive: " + explodedDirectory.getAbsolutePath());
        }
        return explodedDirectory;
    }
}

