/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormatterProfileReader {
    private final Map<String, Properties> profiles = new LinkedHashMap<String, Properties>();

    public static FormatterProfileReader fromEclipseXml(InputStream inputStream) throws IOException {
        return new FormatterProfileReader(inputStream);
    }

    private FormatterProfileReader(InputStream inputStream) throws IOException {
        EclipseFormatterProfileHandler handler = new EclipseFormatterProfileHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(inputStream), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Error while creating the parser", e);
        }
        catch (SAXException e) {
            throw new IOException("Error while parsing formatter XML", e);
        }
    }

    public Properties getDefaultProperties() {
        return this.profiles.values().iterator().next();
    }

    public Properties getPropertiesFor(String formatterName) {
        return this.profiles.get(formatterName);
    }

    public Set<String> getProfileNames() {
        return Collections.unmodifiableSet(this.profiles.keySet());
    }

    private class EclipseFormatterProfileHandler
    extends DefaultHandler {
        private static final String XML_NODE_PROFILE = "profile";
        private static final String XML_NODE_SETTING = "setting";
        private static final String XML_ATTRIBUTE_ID = "id";
        private static final String XML_ATTRIBUTE_NAME = "name";
        private static final String XML_ATTRIBUTE_VALUE = "value";
        private String currentProfileName;
        private Properties currentProperties;

        private EclipseFormatterProfileHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (XML_NODE_PROFILE.equals(qName)) {
                this.currentProfileName = attributes.getValue(XML_ATTRIBUTE_NAME);
                this.currentProperties = new Properties();
            } else if (XML_NODE_SETTING.equals(qName)) {
                String key = attributes.getValue(XML_ATTRIBUTE_ID);
                String value = attributes.getValue(XML_ATTRIBUTE_VALUE);
                this.currentProperties.setProperty(key, value);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (XML_NODE_PROFILE.equals(qName)) {
                FormatterProfileReader.this.profiles.put(this.currentProfileName, this.currentProperties);
                this.currentProfileName = null;
                this.currentProperties = null;
            }
        }
    }
}

