/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.NotFoundException;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedVoidType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistAnnotationDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;

public class JavassistFactory {
    public static ResolvedType typeUsageFor(CtClass ctClazz, TypeSolver typeSolver) {
        try {
            if (ctClazz.isArray()) {
                return new ResolvedArrayType(JavassistFactory.typeUsageFor(ctClazz.getComponentType(), typeSolver));
            }
            if (ctClazz.isPrimitive()) {
                if (ctClazz.getName().equals("void")) {
                    return ResolvedVoidType.INSTANCE;
                }
                return ResolvedPrimitiveType.byName(ctClazz.getName());
            }
            if (ctClazz.isInterface()) {
                return new ReferenceTypeImpl(new JavassistInterfaceDeclaration(ctClazz, typeSolver));
            }
            if (ctClazz.isEnum()) {
                return new ReferenceTypeImpl(new JavassistEnumDeclaration(ctClazz, typeSolver));
            }
            return new ReferenceTypeImpl(new JavassistClassDeclaration(ctClazz, typeSolver));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ResolvedReferenceTypeDeclaration toTypeDeclaration(CtClass ctClazz, TypeSolver typeSolver) {
        if (ctClazz.isAnnotation()) {
            return new JavassistAnnotationDeclaration(ctClazz, typeSolver);
        }
        if (ctClazz.isInterface()) {
            return new JavassistInterfaceDeclaration(ctClazz, typeSolver);
        }
        if (ctClazz.isEnum()) {
            return new JavassistEnumDeclaration(ctClazz, typeSolver);
        }
        if (ctClazz.isArray()) {
            throw new IllegalArgumentException("This method should not be called passing an array");
        }
        return new JavassistClassDeclaration(ctClazz, typeSolver);
    }

    static AccessSpecifier modifiersToAccessLevel(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return AccessSpecifier.PUBLIC;
        }
        if (Modifier.isProtected(modifiers)) {
            return AccessSpecifier.PROTECTED;
        }
        if (Modifier.isPrivate(modifiers)) {
            return AccessSpecifier.PRIVATE;
        }
        return AccessSpecifier.NONE;
    }
}

