/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.dom;

import org.htmlunit.cyberneko.xerces.dom.CharacterDataImpl;
import org.htmlunit.cyberneko.xerces.dom.CoreDocumentImpl;
import org.htmlunit.cyberneko.xerces.dom.DOMMessageFormatter;
import org.htmlunit.cyberneko.xerces.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl(CoreDocumentImpl ownerDoc, String data) {
        super(ownerDoc, data);
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    public void setIgnorableWhitespace(boolean ignore) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIgnorableWhitespace(ignore);
    }

    @Override
    public boolean isElementContentWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    @Override
    public String getWholeText() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        StringBuffer buffer = new StringBuffer();
        if (this.data != null && this.data.length() != 0) {
            buffer.append(this.data);
        }
        this.getWholeTextBackward(this.getPreviousSibling(), buffer, this.getParentNode());
        String temp = buffer.toString();
        buffer.setLength(0);
        this.getWholeTextForward(this.getNextSibling(), buffer, this.getParentNode());
        return String.valueOf(temp) + buffer;
    }

    protected void insertTextContent(StringBuffer buf) throws DOMException {
        String content = this.getNodeValue();
        if (content != null) {
            buf.insert(0, content);
        }
    }

    private boolean getWholeTextForward(Node node, StringBuffer buffer, Node parent) {
        boolean inEntRef = false;
        if (parent != null) {
            inEntRef = parent.getNodeType() == 5;
        }
        while (node != null) {
            short type = node.getNodeType();
            if (type == 5) {
                if (this.getWholeTextForward(node.getFirstChild(), buffer, node)) {
                    return true;
                }
            } else if (type == 3 || type == 4) {
                ((NodeImpl)node).getTextContent(buffer);
            } else {
                return true;
            }
            node = node.getNextSibling();
        }
        if (inEntRef) {
            this.getWholeTextForward(parent.getNextSibling(), buffer, parent.getParentNode());
            return true;
        }
        return false;
    }

    private boolean getWholeTextBackward(Node node, StringBuffer buffer, Node parent) {
        boolean inEntRef = false;
        if (parent != null) {
            inEntRef = parent.getNodeType() == 5;
        }
        while (node != null) {
            short type = node.getNodeType();
            if (type == 5) {
                if (this.getWholeTextBackward(node.getLastChild(), buffer, node)) {
                    return true;
                }
            } else if (type == 3 || type == 4) {
                ((TextImpl)node).insertTextContent(buffer);
            } else {
                return true;
            }
            node = node.getPreviousSibling();
        }
        if (inEntRef) {
            this.getWholeTextBackward(parent.getPreviousSibling(), buffer, parent.getParentNode());
            return true;
        }
        return false;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        Node parent = this.getParentNode();
        if (content == null || content.length() == 0) {
            if (parent != null) {
                parent.removeChild(this);
            }
            return null;
        }
        if (!(!this.ownerDocument().errorChecking || this.canModifyPrev(this) && this.canModifyNext(this))) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        this.setData(content);
        TextImpl currentNode = this;
        Node prev = currentNode.getPreviousSibling();
        while (prev != null) {
            if (prev.getNodeType() != 3 && prev.getNodeType() != 4 && (prev.getNodeType() != 5 || !this.hasTextOnlyChildren(prev))) break;
            parent.removeChild(prev);
            prev = currentNode;
            prev = prev.getPreviousSibling();
        }
        Node next = currentNode.getNextSibling();
        while (next != null) {
            if (next.getNodeType() != 3 && next.getNodeType() != 4 && (next.getNodeType() != 5 || !this.hasTextOnlyChildren(next))) break;
            parent.removeChild(next);
            next = currentNode;
            next = next.getNextSibling();
        }
        return currentNode;
    }

    /*
     * Unable to fully structure code
     */
    private boolean canModifyPrev(Node node) {
        textLastChild = false;
        prev = node.getPreviousSibling();
        while (prev != null) {
            block9: {
                block8: {
                    type = prev.getNodeType();
                    if (type != 5) break block8;
                    lastChild = prev.getLastChild();
                    if (lastChild != null) ** GOTO lbl20
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        lType = lastChild.getNodeType();
                        if (lType == 3 || lType == 4) {
                            textLastChild = true;
                        } else if (lType == 5) {
                            if (!this.canModifyPrev(lastChild)) {
                                return false;
                            }
                            textLastChild = true;
                        } else {
                            return textLastChild == false;
                        }
                        lastChild = lastChild.getPreviousSibling();
lbl20:
                        // 2 sources

                        ** while (lastChild != null)
                    }
lbl21:
                    // 1 sources

                    break block9;
                }
                if (type != 3 && type != 4) {
                    return true;
                }
            }
            prev = prev.getPreviousSibling();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean canModifyNext(Node node) {
        textFirstChild = false;
        next = node.getNextSibling();
        while (next != null) {
            block9: {
                block8: {
                    type = next.getNodeType();
                    if (type != 5) break block8;
                    firstChild = next.getFirstChild();
                    if (firstChild != null) ** GOTO lbl20
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        lType = firstChild.getNodeType();
                        if (lType == 3 || lType == 4) {
                            textFirstChild = true;
                        } else if (lType == 5) {
                            if (!this.canModifyNext(firstChild)) {
                                return false;
                            }
                            textFirstChild = true;
                        } else {
                            return textFirstChild == false;
                        }
                        firstChild = firstChild.getNextSibling();
lbl20:
                        // 2 sources

                        ** while (firstChild != null)
                    }
lbl21:
                    // 1 sources

                    break block9;
                }
                if (type != 3 && type != 4) {
                    return true;
                }
            }
            next = next.getNextSibling();
        }
        return true;
    }

    private boolean hasTextOnlyChildren(Node node) {
        Node child = node;
        if (child == null) {
            return false;
        }
        child = child.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 5) {
                return this.hasTextOnlyChildren(child);
            }
            if (type != 3 && type != 4) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    public boolean isIgnorableWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    @Override
    public Text splitText(int offset) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (offset < 0 || offset > this.data.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        Text newText = this.getOwnerDocument().createTextNode(this.data.substring(offset));
        this.setNodeValue(this.data.substring(0, offset));
        Node parentNode = this.getParentNode();
        if (parentNode != null) {
            parentNode.insertBefore(newText, this.nextSibling);
        }
        return newText;
    }

    public void replaceData(String value) {
        this.data = value;
    }

    public String removeData() {
        String olddata = this.data;
        this.data = "";
        return olddata;
    }
}

