/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.functions;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.compiler.Compiler;
import org.htmlunit.xpath.functions.WrongNumberArgsException;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.res.XPATHMessages;

public abstract class Function
extends Expression {
    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        this.reportWrongNumberArgs();
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum != 0) {
            this.reportWrongNumberArgs();
        }
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XPATHMessages.createXPATHMessage("zero", null));
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        System.out.println("Error! Function.execute should not be called!");
        return null;
    }

    public void callArgVisitors(XPathVisitor visitor) {
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        if (visitor.visitFunction(this)) {
            this.callArgVisitors(visitor);
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        return this.isSameClass(expr);
    }

    public void postCompileStep(Compiler compiler) {
    }
}

