/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.ForeignKeyUtils;
import org.hibernate.tool.internal.reveng.binder.ManyToOneBinder;
import org.hibernate.tool.internal.reveng.binder.OneToManyBinder;
import org.hibernate.tool.internal.reveng.binder.OneToOneBinder;

class ForeignKeyBinder
extends AbstractBinder {
    private static Logger LOGGER = Logger.getLogger(ForeignKeyBinder.class.getName());
    private final OneToOneBinder oneToOneBinder;
    private final OneToManyBinder oneToManyBinder;
    private final ManyToOneBinder manyToOneBinder;

    static ForeignKeyBinder create(BinderContext binderContext) {
        return new ForeignKeyBinder(binderContext);
    }

    private ForeignKeyBinder(BinderContext binderContext) {
        super(binderContext);
        this.oneToOneBinder = OneToOneBinder.create(binderContext);
        this.oneToManyBinder = OneToManyBinder.create(binderContext);
        this.manyToOneBinder = ManyToOneBinder.create(binderContext);
    }

    void bindIncoming(ForeignKey foreignKey, PersistentClass persistentClass, Set<Column> processed) {
        if (this.excludeForeignKeyAsCollection(foreignKey)) {
            LOGGER.log(Level.INFO, "Rev.eng excluded one-to-many or one-to-one for foreignkey " + foreignKey.getName());
        } else if (this.getRevengStrategy().isOneToOne(foreignKey)) {
            this.addOneToOne(foreignKey, persistentClass, processed, false);
        } else {
            this.addOneToMany(foreignKey, persistentClass);
        }
    }

    void bindOutgoing(ForeignKey foreignKey, Table table, PersistentClass rc, Set<Column> processedColumns, boolean mutable) {
        if (this.excludeForeignKeyAsManyToOne(foreignKey)) {
            LOGGER.log(Level.INFO, "Rev.eng excluded *-to-one for foreignkey " + foreignKey.getName());
        } else if (this.isOneToOne(foreignKey)) {
            this.addOneToOne(foreignKey, rc, processedColumns, true);
        } else {
            this.addManyToOne(foreignKey, table, rc, processedColumns, mutable);
        }
    }

    private String getForeignKeyToEntityName(ForeignKey foreignKey) {
        return this.getRevengStrategy().foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), ForeignKeyUtils.isUniqueReference(foreignKey));
    }

    private void addManyToOne(ForeignKey foreignKey, Table table, PersistentClass rc, Set<Column> processedColumns, boolean mutable) {
        Property property = this.manyToOneBinder.bind(BinderUtils.makeUnique(rc, this.getForeignKeyToEntityName(foreignKey)), mutable, table, foreignKey, processedColumns);
        rc.addProperty(property);
    }

    private void addOneToOne(ForeignKey foreignKey, PersistentClass rc, Set<Column> processedColumns, boolean outgoing) {
        Table table = outgoing ? foreignKey.getReferencedTable() : foreignKey.getTable();
        Property property = this.oneToOneBinder.bind(rc, table, foreignKey, processedColumns, outgoing, !outgoing);
        rc.addProperty(property);
    }

    private void addOneToMany(ForeignKey foreignKey, PersistentClass persistentClass) {
        persistentClass.addProperty(this.oneToManyBinder.bind(persistentClass, foreignKey));
    }

    private boolean excludeForeignKeyAsCollection(ForeignKey foreignKey) {
        return this.getRevengStrategy().excludeForeignKeyAsCollection(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns());
    }

    private boolean excludeForeignKeyAsManyToOne(ForeignKey foreignKey) {
        return this.getRevengStrategy().excludeForeignKeyAsManytoOne(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns());
    }

    private boolean isOneToOne(ForeignKey foreignKey) {
        return this.getRevengStrategy().isOneToOne(foreignKey);
    }
}

