/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "my" locale.
 */
public class LocalizedNamesImpl_my extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MM",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "KE",
        "CM",
        "CA",
        "IC",
        "KH",
        "CP",
        "KG",
        "KZ",
        "QA",
        "BQ",
        "CV",
        "CC",
        "XK",
        "KM",
        "CO",
        "CR",
        "CI",
        "UN",
        "KW",
        "KY",
        "CW",
        "CU",
        "CK",
        "CD",
        "CG",
        "CX",
        "HR",
        "KI",
        "CZ",
        "TD",
        "CL",
        "GM",
        "GL",
        "GR",
        "GD",
        "GH",
        "GA",
        "GY",
        "GN",
        "GW",
        "GU",
        "JP",
        "JM",
        "JE",
        "DE",
        "GI",
        "DJ",
        "GE",
        "JO",
        "GG",
        "GT",
        "GP",
        "SX",
        "SG",
        "ES",
        "SJ",
        "KN",
        "PM",
        "VC",
        "BL",
        "MF",
        "LC",
        "SH",
        "SM",
        "WS",
        "EA",
        "SK",
        "SI",
        "RS",
        "CY",
        "SO",
        "SN",
        "SL",
        "SY",
        "SD",
        "SR",
        "ST",
        "SA",
        "SB",
        "SC",
        "CH",
        "SZ",
        "SE",
        "ZW",
        "ZM",
        "TC",
        "TZ",
        "CN",
        "TJ",
        "TM",
        "TK",
        "TG",
        "TN",
        "TV",
        "TR",
        "KR",
        "GS",
        "SS",
        "ZA",
        "TO",
        "TA",
        "TT",
        "TW",
        "TH",
        "DK",
        "DO",
        "DM",
        "DG",
        "NA",
        "NC",
        "NZ",
        "NL",
        "NE",
        "NG",
        "NI",
        "NP",
        "NU",
        "NF",
        "NR",
        "NO",
        "PN",
        "PA",
        "PW",
        "PK",
        "PG",
        "PY",
        "PS",
        "PL",
        "PE",
        "PR",
        "PT",
        "FR",
        "GF",
        "TF",
        "PF",
        "FI",
        "FO",
        "PH",
        "FJ",
        "FK",
        "VE",
        "VU",
        "CF",
        "VA",
        "VN",
        "IO",
        "VG",
        "BD",
        "BE",
        "BR",
        "BN",
        "BZ",
        "BS",
        "BF",
        "BB",
        "BM",
        "BH",
        "BO",
        "BJ",
        "BY",
        "BT",
        "BV",
        "BI",
        "BG",
        "BA",
        "BW",
        "MO",
        "MX",
        "MK",
        "MG",
        "IM",
        "MY",
        "MQ",
        "MH",
        "MW",
        "ML",
        "FM",
        "MZ",
        "MC",
        "YT",
        "MS",
        "MU",
        "MT",
        "MD",
        "MA",
        "MR",
        "MV",
        "MM",
        "KP",
        "MP",
        "MN",
        "ME",
        "YE",
        "UA",
        "UG",
        "GB",
        "UM",
        "VI",
        "AE",
        "RW",
        "RO",
        "RE",
        "RU",
        "LB",
        "LI",
        "LY",
        "LT",
        "LV",
        "LA",
        "LR",
        "LS",
        "LU",
        "WF",
        "QO",
        "LK",
        "HM",
        "HU",
        "HT",
        "HK",
        "HN",
        "EE",
        "ID",
        "IL",
        "AC",
        "AZ",
        "EH",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AD",
        "AS",
        "US",
        "DZ",
        "SV",
        "AL",
        "TL",
        "AR",
        "AF",
        "AM",
        "AW",
        "AX",
        "IN",
        "IS",
        "IE",
        "OM",
        "GQ",
        "EC",
        "EG",
        "IT",
        "IQ",
        "IR",
        "ER",
        "ET",
        "UZ",
        "UY",
        "EZ",
        "EU",
        "AT",
        "AU",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ကမ္ဘာ");
    namesMap.put("002", "အာဖရိက");
    namesMap.put("003", "မြောက် အမေရိကတိုက်");
    namesMap.put("005", "တောင် အမေရိက");
    namesMap.put("009", "သမုဒ္ဒရာဒေသ");
    namesMap.put("011", "အနောက် အာဖရိက");
    namesMap.put("013", "ဗဟို အမေရိက");
    namesMap.put("014", "အရှေ့ အာဖရိက");
    namesMap.put("015", "မြောက် အာဖရိက");
    namesMap.put("017", "အလယ် အာဖရိက");
    namesMap.put("018", "အာဖရိက တောင်ပိုင်း");
    namesMap.put("019", "အမေရိကန်");
    namesMap.put("021", "မြောက် အမေရိက");
    namesMap.put("029", "ကာရစ်ဘီယံ");
    namesMap.put("030", "အရှေ့အာရှ");
    namesMap.put("034", "တောင်အာရှ");
    namesMap.put("035", "အရှေ့တောင်အာရှ");
    namesMap.put("039", "တောင်ဥရောပ");
    namesMap.put("053", "ဩစတြေးလျနှင့် နယူးဇီလန်");
    namesMap.put("054", "မီလာနီးရှား");
    namesMap.put("057", "မိုက်ခရိုနီးရှား ဒေသ");
    namesMap.put("061", "ပိုလီနီရှား");
    namesMap.put("142", "အာရှ");
    namesMap.put("143", "အလယ်အာရှ");
    namesMap.put("145", "အနောက်အာရှ");
    namesMap.put("150", "ဥရောပ");
    namesMap.put("151", "အရှေ့ ဥရောပ");
    namesMap.put("154", "မြောက် ဥရောပ");
    namesMap.put("155", "အနောက် ဥရောပ");
    namesMap.put("202", "ဆာဟာရ-အောက်ပိုင်း အာဖရိက");
    namesMap.put("419", "လက်တင်အမေရိက");
    namesMap.put("AC", "အဆန်းရှင်းကျွန်း");
    namesMap.put("AD", "အန်ဒိုရာ");
    namesMap.put("AE", "ယူအေအီး");
    namesMap.put("AF", "အာဖဂန်နစ္စတန်");
    namesMap.put("AG", "အန်တီဂွါနှင့် ဘာဘူဒါ");
    namesMap.put("AI", "အန်ဂီလာ");
    namesMap.put("AL", "အယ်လ်ဘေးနီးယား");
    namesMap.put("AM", "အာမေးနီးယား");
    namesMap.put("AO", "အန်ဂိုလာ");
    namesMap.put("AQ", "အန်တာတိက");
    namesMap.put("AR", "အာဂျင်တီးနား");
    namesMap.put("AS", "အမေရိကန် ဆမိုးအား");
    namesMap.put("AT", "ဩစတြီးယား");
    namesMap.put("AU", "ဩစတြေးလျ");
    namesMap.put("AW", "အာရူးဗား");
    namesMap.put("AX", "အာလန်ကျွန်း");
    namesMap.put("AZ", "အဇာဘိုင်ဂျန်");
    namesMap.put("BA", "ဘော့စနီးယားနှင့် ဟာဇီဂိုဗီနား");
    namesMap.put("BB", "ဘာဘေးဒိုးစ်");
    namesMap.put("BD", "ဘင်္ဂလားဒေ့ရှ်");
    namesMap.put("BE", "ဘယ်လ်ဂျီယမ်");
    namesMap.put("BF", "ဘာကီးနား ဖားဆို");
    namesMap.put("BG", "ဘူလ်ဂေးရီးယား");
    namesMap.put("BH", "ဘာရိန်း");
    namesMap.put("BI", "ဘူရွန်ဒီ");
    namesMap.put("BJ", "ဘီနင်");
    namesMap.put("BL", "စိန့်ဘာသယ်လ်မီ");
    namesMap.put("BM", "ဘာမြူဒါ");
    namesMap.put("BN", "ဘရူနိုင်း");
    namesMap.put("BO", "ဘိုလီးဗီးယား");
    namesMap.put("BQ", "ကာရစ်ဘီယံ နယ်သာလန်");
    namesMap.put("BR", "ဘရာဇီး");
    namesMap.put("BS", "ဘဟားမား");
    namesMap.put("BT", "ဘူတန်");
    namesMap.put("BV", "ဘူဗက်ကျွန်း");
    namesMap.put("BW", "ဘော့ဆွာနာ");
    namesMap.put("BY", "ဘီလာရုစ်");
    namesMap.put("BZ", "ဘလိဇ်");
    namesMap.put("CA", "ကနေဒါ");
    namesMap.put("CC", "ကိုကိုးကျွန်း");
    namesMap.put("CD", "ကွန်ဂို");
    namesMap.put("CF", "ဗဟို အာဖရိက ပြည်ထောင်စု");
    namesMap.put("CG", "ကွန်ဂို-ဘရာဇာဗီးလ်");
    namesMap.put("CH", "ဆွစ်ဇာလန်");
    namesMap.put("CI", "ကို့တ် ဒီဗွာ");
    namesMap.put("CK", "ကွတ် ကျွန်းစု");
    namesMap.put("CL", "ချီလီ");
    namesMap.put("CM", "ကင်မရွန်း");
    namesMap.put("CN", "တရုတ်");
    namesMap.put("CO", "ကိုလံဘီယာ");
    namesMap.put("CP", "ကလစ်ပါတန်ကျွန်း");
    namesMap.put("CR", "ကို့စ်တာရီကာ");
    namesMap.put("CU", "ကျူးဘား");
    namesMap.put("CV", "ကိတ်ဗာဒီ");
    namesMap.put("CW", "ကျူရေးကိုးစ်");
    namesMap.put("CX", "ခရစ်စမတ် ကျွန်း");
    namesMap.put("CY", "ဆိုက်ပရပ်စ်");
    namesMap.put("CZ", "ချက်ကီယား");
    namesMap.put("DE", "ဂျာမနီ");
    namesMap.put("DG", "ဒီအဲဂိုဂါစီရာ");
    namesMap.put("DJ", "ဂျီဘူတီ");
    namesMap.put("DK", "ဒိန်းမတ်");
    namesMap.put("DM", "ဒိုမီနီကာ");
    namesMap.put("DO", "ဒိုမီနီကန်");
    namesMap.put("DZ", "အယ်လ်ဂျီးရီးယား");
    namesMap.put("EA", "ဆယ်ဥတာနှင့်မယ်လီလ်လာ");
    namesMap.put("EC", "အီကွေဒေါ");
    namesMap.put("EE", "အက်စတိုးနီးယား");
    namesMap.put("EG", "အီဂျစ်");
    namesMap.put("EH", "အနောက် ဆာဟာရ");
    namesMap.put("ER", "အီရီထရီးယား");
    namesMap.put("ES", "စပိန်");
    namesMap.put("ET", "အီသီယိုးပီးယား");
    namesMap.put("EU", "ဥရောပသမဂ္ဂ");
    namesMap.put("EZ", "ဥရောပဒေသ");
    namesMap.put("FI", "ဖင်လန်");
    namesMap.put("FJ", "ဖီဂျီ");
    namesMap.put("FK", "ဖော့ကလန် ကျွန်းစု");
    namesMap.put("FM", "မိုင်ခရိုနီရှား");
    namesMap.put("FO", "ဖာရိုး ကျွန်းစုများ");
    namesMap.put("FR", "ပြင်သစ်");
    namesMap.put("GA", "ဂါဘွန်");
    namesMap.put("GB", "ယူနိုက်တက်ကင်းဒမ်း");
    namesMap.put("GD", "ဂရီနေဒါ");
    namesMap.put("GE", "ဂျော်ဂျီယာ");
    namesMap.put("GF", "ပြင်သစ် ဂီယာနာ");
    namesMap.put("GG", "ဂွန်းဇီ");
    namesMap.put("GH", "ဂါနာ");
    namesMap.put("GI", "ဂျီဘရော်လ်တာ");
    namesMap.put("GL", "ဂရင်းလန်း");
    namesMap.put("GM", "ဂမ်ဘီရာ");
    namesMap.put("GN", "ဂီနီ");
    namesMap.put("GP", "ဂွါဒီလု");
    namesMap.put("GQ", "အီကွေတာ ဂီနီ");
    namesMap.put("GR", "ဂရိ");
    namesMap.put("GS", "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ");
    namesMap.put("GT", "ဂွါတီမာလာ");
    namesMap.put("GU", "ဂူအမ်");
    namesMap.put("GW", "ဂီနီ-ဘီစော");
    namesMap.put("GY", "ဂိုင်ယာနာ");
    namesMap.put("HK", "ဟောင်ကောင် (တရုတ်ပြည်)");
    namesMap.put("HM", "ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု");
    namesMap.put("HN", "ဟွန်ဒူးရပ်စ်");
    namesMap.put("HR", "ခရိုအေးရှား");
    namesMap.put("HT", "ဟေတီ");
    namesMap.put("HU", "ဟန်ဂေရီ");
    namesMap.put("IC", "ကနေရီ ကျွန်းစု");
    namesMap.put("ID", "အင်ဒိုနီးရှား");
    namesMap.put("IE", "အိုင်ယာလန်");
    namesMap.put("IL", "အစ္စရေး");
    namesMap.put("IM", "မန်ကျွန်း");
    namesMap.put("IN", "အိန္ဒိယ");
    namesMap.put("IO", "ဗြိတိသျှပိုင် အိန္ဒိယသမုဒ္ဒရာကျွန်းများ");
    namesMap.put("IQ", "အီရတ်");
    namesMap.put("IR", "အီရန်");
    namesMap.put("IS", "အိုက်စလန်");
    namesMap.put("IT", "အီတလီ");
    namesMap.put("JE", "ဂျာစီ");
    namesMap.put("JM", "ဂျမေကာ");
    namesMap.put("JO", "ဂျော်ဒန်");
    namesMap.put("JP", "ဂျပန်");
    namesMap.put("KE", "ကင်ညာ");
    namesMap.put("KG", "ကာဂျစ္စတန်");
    namesMap.put("KH", "ကမ္ဘောဒီးယား");
    namesMap.put("KI", "ခီရီဘာတီ");
    namesMap.put("KM", "ကိုမိုရိုစ်");
    namesMap.put("KN", "စိန့်ကစ်နှင့်နီဗီစ်");
    namesMap.put("KP", "မြောက်ကိုရီးယား");
    namesMap.put("KR", "တောင်ကိုရီးယား");
    namesMap.put("KW", "ကူဝိတ်");
    namesMap.put("KY", "ကေမန် ကျွန်းစု");
    namesMap.put("KZ", "ကာဇက်စတန်");
    namesMap.put("LA", "လာအို");
    namesMap.put("LB", "လက်ဘနွန်");
    namesMap.put("LC", "စိန့်လူစီယာ");
    namesMap.put("LI", "လစ်တန်စတိန်း");
    namesMap.put("LK", "သီရိလင်္ကာ");
    namesMap.put("LR", "လိုက်ဘေးရီးယား");
    namesMap.put("LS", "လီဆိုသို");
    namesMap.put("LT", "လစ်သူယေးနီးယား");
    namesMap.put("LU", "လူဇင်ဘတ်");
    namesMap.put("LV", "လတ်ဗီးယား");
    namesMap.put("LY", "လစ်ဗျား");
    namesMap.put("MA", "မော်ရိုကို");
    namesMap.put("MC", "မိုနာကို");
    namesMap.put("MD", "မောလ်ဒိုဗာ");
    namesMap.put("ME", "မွန်တီနိဂရိုး");
    namesMap.put("MF", "စိန့်မာတင်");
    namesMap.put("MG", "မဒါဂတ်စကား");
    namesMap.put("MH", "မာရှယ် ကျွန်းစု");
    namesMap.put("MK", "မက်ဆီဒိုးနီးယား");
    namesMap.put("ML", "မာလီ");
    namesMap.put("MM", "မြန်မာ");
    namesMap.put("MN", "မွန်ဂိုးလီးယား");
    namesMap.put("MO", "မကာအို (တရုတ်ပြည်)");
    namesMap.put("MP", "မြောက်ပိုင်းမာရီအာနာကျွန်းစု");
    namesMap.put("MQ", "မာတီနိခ်");
    namesMap.put("MR", "မော်ရီတေးနီးယား");
    namesMap.put("MS", "မောင့်စဲရက်");
    namesMap.put("MT", "မောလ်တာ");
    namesMap.put("MU", "မောရစ်ရှ");
    namesMap.put("MV", "မော်လ်ဒိုက်");
    namesMap.put("MW", "မာလာဝီ");
    namesMap.put("MX", "မက်ကဆီကို");
    namesMap.put("MY", "မလေးရှား");
    namesMap.put("MZ", "မိုဇမ်ဘစ်");
    namesMap.put("NA", "နမီးဘီးယား");
    namesMap.put("NC", "နယူး ကယ်လီဒိုနီးယား");
    namesMap.put("NE", "နိုင်ဂျာ");
    namesMap.put("NF", "နောဖုတ်ကျွန်း");
    namesMap.put("NG", "နိုင်ဂျီးရီးယား");
    namesMap.put("NI", "နီကာရာဂွါ");
    namesMap.put("NL", "နယ်သာလန်");
    namesMap.put("NO", "နော်ဝေ");
    namesMap.put("NP", "နီပေါ");
    namesMap.put("NR", "နော်ရူး");
    namesMap.put("NU", "နီဥူအေ");
    namesMap.put("NZ", "နယူးဇီလန်");
    namesMap.put("OM", "အိုမန်");
    namesMap.put("PA", "ပနားမား");
    namesMap.put("PE", "ပီရူး");
    namesMap.put("PF", "ပြင်သစ် ပေါ်လီနီးရှား");
    namesMap.put("PG", "ပါပူအာ နယူးဂီနီ");
    namesMap.put("PH", "ဖိလစ်ပိုင်");
    namesMap.put("PK", "ပါကစ္စတန်");
    namesMap.put("PL", "ပိုလန်");
    namesMap.put("PM", "စိန့်ပီအဲရ်နှင့် မီကွီလွန်");
    namesMap.put("PN", "ပစ်တ်ကိန်းကျွန်းစု");
    namesMap.put("PR", "ပေါ်တိုရီကို");
    namesMap.put("PS", "ပါလက်စတိုင်း ပိုင်နက်");
    namesMap.put("PT", "ပေါ်တူဂီ");
    namesMap.put("PW", "ပလာအို");
    namesMap.put("PY", "ပါရာဂွေး");
    namesMap.put("QA", "ကာတာ");
    namesMap.put("QO", "သမုဒ္ဒရာ အပြင်ဘက်ရှိ ကျွန်းနိုင်ငံများ");
    namesMap.put("RE", "ရီယူနီယန်");
    namesMap.put("RO", "ရိုမေးနီးယား");
    namesMap.put("RS", "ဆားဘီးယား");
    namesMap.put("RU", "ရုရှား");
    namesMap.put("RW", "ရဝန်ဒါ");
    namesMap.put("SA", "ဆော်ဒီအာရေးဘီးယား");
    namesMap.put("SB", "ဆော်လမွန်ကျွန်းစု");
    namesMap.put("SC", "ဆေးရှဲ");
    namesMap.put("SD", "ဆူဒန်");
    namesMap.put("SE", "ဆွီဒင်");
    namesMap.put("SG", "စင်္ကာပူ");
    namesMap.put("SH", "စိန့်ဟယ်လယ်နာ");
    namesMap.put("SI", "ဆလိုဗေးနီးယား");
    namesMap.put("SJ", "စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်");
    namesMap.put("SK", "ဆလိုဗက်ကီးယား");
    namesMap.put("SL", "ဆီယာရာ လီယွန်း");
    namesMap.put("SM", "ဆန်မာရီနို");
    namesMap.put("SN", "ဆီနီဂေါ");
    namesMap.put("SO", "ဆိုမာလီယာ");
    namesMap.put("SR", "ဆူရာနမ်");
    namesMap.put("SS", "တောင် ဆူဒန်");
    namesMap.put("ST", "ဆောင်တူမေးနှင့် ပရင်စီပီ");
    namesMap.put("SV", "အယ်လ်ဆာဗေးဒိုး");
    namesMap.put("SX", "စင့်မာတင်");
    namesMap.put("SY", "ဆီးရီးယား");
    namesMap.put("SZ", "ဆွာဇီလန်");
    namesMap.put("TA", "ထရစ္စတန် ဒါ ကွန်ဟာ");
    namesMap.put("TC", "တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု");
    namesMap.put("TD", "ချဒ်");
    namesMap.put("TF", "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ");
    namesMap.put("TG", "တိုဂို");
    namesMap.put("TH", "ထိုင်း");
    namesMap.put("TJ", "တာဂျီကစ္စတန်");
    namesMap.put("TK", "တိုကလောင်");
    namesMap.put("TL", "အရှေ့တီမော");
    namesMap.put("TM", "တာ့ခ်မင်နစ္စတန်");
    namesMap.put("TN", "တူနီးရှား");
    namesMap.put("TO", "တွန်ဂါ");
    namesMap.put("TR", "တူရကီ");
    namesMap.put("TT", "ထရီနီဒတ်နှင့် တိုဘက်ဂို");
    namesMap.put("TV", "တူဗားလူ");
    namesMap.put("TW", "ထိုင်ဝမ်");
    namesMap.put("TZ", "တန်ဇန်းနီးယား");
    namesMap.put("UA", "ယူကရိန်း");
    namesMap.put("UG", "ယူဂန်းဒါး");
    namesMap.put("UM", "ယူနိုက်တက်စတိတ် ကျွန်းနိုင်ငံများ");
    namesMap.put("UN", "ကုလသမဂ္ဂ");
    namesMap.put("US", "အမေရိကန် ပြည်ထောင်စု");
    namesMap.put("UY", "ဥရုဂွေး");
    namesMap.put("UZ", "ဥဇဘက်ကစ္စတန်");
    namesMap.put("VA", "ဗာတီကန်စီးတီး");
    namesMap.put("VC", "စိန့်ဗင်းဆင့်နှင့် ဂရိနေဒိုင်");
    namesMap.put("VE", "ဗင်နီဇွဲလား");
    namesMap.put("VG", "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VI", "ယူအက်စ် ဗာဂျင်း ကျွန်းစု");
    namesMap.put("VN", "ဗီယက်နမ်");
    namesMap.put("VU", "ဗနွားတူ");
    namesMap.put("WF", "ဝေါလစ်နှင့် ဖူကျူးနား");
    namesMap.put("WS", "ဆမိုးအား");
    namesMap.put("XK", "ကိုဆိုဗို");
    namesMap.put("YE", "ယီမင်");
    namesMap.put("YT", "မေယော့");
    namesMap.put("ZA", "တောင်အာဖရိက");
    namesMap.put("ZM", "ဇမ်ဘီယာ");
    namesMap.put("ZW", "ဇင်ဘာဘွေ");
    namesMap.put("ZZ", "မသိ (သို့) မရှိသော ဒေသ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ကမ္ဘာ",
        "002": "အာဖရိက",
        "003": "မြောက် အမေရိကတိုက်",
        "005": "တောင် အမေရိက",
        "009": "သမုဒ္ဒရာဒေသ",
        "011": "အနောက် အာဖရိက",
        "013": "ဗဟို အမေရိက",
        "014": "အရှေ့ အာဖရိက",
        "015": "မြောက် အာဖရိက",
        "017": "အလယ် အာဖရိက",
        "018": "အာဖရိက တောင်ပိုင်း",
        "019": "အမေရိကန်",
        "021": "မြောက် အမေရိက",
        "029": "ကာရစ်ဘီယံ",
        "030": "အရှေ့အာရှ",
        "034": "တောင်အာရှ",
        "035": "အရှေ့တောင်အာရှ",
        "039": "တောင်ဥရောပ",
        "053": "ဩစတြေးလျနှင့် နယူးဇီလန်",
        "054": "မီလာနီးရှား",
        "057": "မိုက်ခရိုနီးရှား ဒေသ",
        "061": "ပိုလီနီရှား",
        "142": "အာရှ",
        "143": "အလယ်အာရှ",
        "145": "အနောက်အာရှ",
        "150": "ဥရောပ",
        "151": "အရှေ့ ဥရောပ",
        "154": "မြောက် ဥရောပ",
        "155": "အနောက် ဥရောပ",
        "202": "ဆာဟာရ-အောက်ပိုင်း အာဖရိက",
        "419": "လက်တင်အမေရိက",
        "AC": "အဆန်းရှင်းကျွန်း",
        "AD": "အန်ဒိုရာ",
        "AE": "ယူအေအီး",
        "AF": "အာဖဂန်နစ္စတန်",
        "AG": "အန်တီဂွါနှင့် ဘာဘူဒါ",
        "AI": "အန်ဂီလာ",
        "AL": "အယ်လ်ဘေးနီးယား",
        "AM": "အာမေးနီးယား",
        "AO": "အန်ဂိုလာ",
        "AQ": "အန်တာတိက",
        "AR": "အာဂျင်တီးနား",
        "AS": "အမေရိကန် ဆမိုးအား",
        "AT": "ဩစတြီးယား",
        "AU": "ဩစတြေးလျ",
        "AW": "အာရူးဗား",
        "AX": "အာလန်ကျွန်း",
        "AZ": "အဇာဘိုင်ဂျန်",
        "BA": "ဘော့စနီးယားနှင့် ဟာဇီဂိုဗီနား",
        "BB": "ဘာဘေးဒိုးစ်",
        "BD": "ဘင်္ဂလားဒေ့ရှ်",
        "BE": "ဘယ်လ်ဂျီယမ်",
        "BF": "ဘာကီးနား ဖားဆို",
        "BG": "ဘူလ်ဂေးရီးယား",
        "BH": "ဘာရိန်း",
        "BI": "ဘူရွန်ဒီ",
        "BJ": "ဘီနင်",
        "BL": "စိန့်ဘာသယ်လ်မီ",
        "BM": "ဘာမြူဒါ",
        "BN": "ဘရူနိုင်း",
        "BO": "ဘိုလီးဗီးယား",
        "BQ": "ကာရစ်ဘီယံ နယ်သာလန်",
        "BR": "ဘရာဇီး",
        "BS": "ဘဟားမား",
        "BT": "ဘူတန်",
        "BV": "ဘူဗက်ကျွန်း",
        "BW": "ဘော့ဆွာနာ",
        "BY": "ဘီလာရုစ်",
        "BZ": "ဘလိဇ်",
        "CA": "ကနေဒါ",
        "CC": "ကိုကိုးကျွန်း",
        "CD": "ကွန်ဂို",
        "CF": "ဗဟို အာဖရိက ပြည်ထောင်စု",
        "CG": "ကွန်ဂို-ဘရာဇာဗီးလ်",
        "CH": "ဆွစ်ဇာလန်",
        "CI": "ကို့တ် ဒီဗွာ",
        "CK": "ကွတ် ကျွန်းစု",
        "CL": "ချီလီ",
        "CM": "ကင်မရွန်း",
        "CN": "တရုတ်",
        "CO": "ကိုလံဘီယာ",
        "CP": "ကလစ်ပါတန်ကျွန်း",
        "CR": "ကို့စ်တာရီကာ",
        "CU": "ကျူးဘား",
        "CV": "ကိတ်ဗာဒီ",
        "CW": "ကျူရေးကိုးစ်",
        "CX": "ခရစ်စမတ် ကျွန်း",
        "CY": "ဆိုက်ပရပ်စ်",
        "CZ": "ချက်ကီယား",
        "DE": "ဂျာမနီ",
        "DG": "ဒီအဲဂိုဂါစီရာ",
        "DJ": "ဂျီဘူတီ",
        "DK": "ဒိန်းမတ်",
        "DM": "ဒိုမီနီကာ",
        "DO": "ဒိုမီနီကန်",
        "DZ": "အယ်လ်ဂျီးရီးယား",
        "EA": "ဆယ်ဥတာနှင့်မယ်လီလ်လာ",
        "EC": "အီကွေဒေါ",
        "EE": "အက်စတိုးနီးယား",
        "EG": "အီဂျစ်",
        "EH": "အနောက် ဆာဟာရ",
        "ER": "အီရီထရီးယား",
        "ES": "စပိန်",
        "ET": "အီသီယိုးပီးယား",
        "EU": "ဥရောပသမဂ္ဂ",
        "EZ": "ဥရောပဒေသ",
        "FI": "ဖင်လန်",
        "FJ": "ဖီဂျီ",
        "FK": "ဖော့ကလန် ကျွန်းစု",
        "FM": "မိုင်ခရိုနီရှား",
        "FO": "ဖာရိုး ကျွန်းစုများ",
        "FR": "ပြင်သစ်",
        "GA": "ဂါဘွန်",
        "GB": "ယူနိုက်တက်ကင်းဒမ်း",
        "GD": "ဂရီနေဒါ",
        "GE": "ဂျော်ဂျီယာ",
        "GF": "ပြင်သစ် ဂီယာနာ",
        "GG": "ဂွန်းဇီ",
        "GH": "ဂါနာ",
        "GI": "ဂျီဘရော်လ်တာ",
        "GL": "ဂရင်းလန်း",
        "GM": "ဂမ်ဘီရာ",
        "GN": "ဂီနီ",
        "GP": "ဂွါဒီလု",
        "GQ": "အီကွေတာ ဂီနီ",
        "GR": "ဂရိ",
        "GS": "တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ",
        "GT": "ဂွါတီမာလာ",
        "GU": "ဂူအမ်",
        "GW": "ဂီနီ-ဘီစော",
        "GY": "ဂိုင်ယာနာ",
        "HK": "ဟောင်ကောင် (တရုတ်ပြည်)",
        "HM": "ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု",
        "HN": "ဟွန်ဒူးရပ်စ်",
        "HR": "ခရိုအေးရှား",
        "HT": "ဟေတီ",
        "HU": "ဟန်ဂေရီ",
        "IC": "ကနေရီ ကျွန်းစု",
        "ID": "အင်ဒိုနီးရှား",
        "IE": "အိုင်ယာလန်",
        "IL": "အစ္စရေး",
        "IM": "မန်ကျွန်း",
        "IN": "အိန္ဒိယ",
        "IO": "ဗြိတိသျှပိုင် အိန္ဒိယသမုဒ္ဒရာကျွန်းများ",
        "IQ": "အီရတ်",
        "IR": "အီရန်",
        "IS": "အိုက်စလန်",
        "IT": "အီတလီ",
        "JE": "ဂျာစီ",
        "JM": "ဂျမေကာ",
        "JO": "ဂျော်ဒန်",
        "JP": "ဂျပန်",
        "KE": "ကင်ညာ",
        "KG": "ကာဂျစ္စတန်",
        "KH": "ကမ္ဘောဒီးယား",
        "KI": "ခီရီဘာတီ",
        "KM": "ကိုမိုရိုစ်",
        "KN": "စိန့်ကစ်နှင့်နီဗီစ်",
        "KP": "မြောက်ကိုရီးယား",
        "KR": "တောင်ကိုရီးယား",
        "KW": "ကူဝိတ်",
        "KY": "ကေမန် ကျွန်းစု",
        "KZ": "ကာဇက်စတန်",
        "LA": "လာအို",
        "LB": "လက်ဘနွန်",
        "LC": "စိန့်လူစီယာ",
        "LI": "လစ်တန်စတိန်း",
        "LK": "သီရိလင်္ကာ",
        "LR": "လိုက်ဘေးရီးယား",
        "LS": "လီဆိုသို",
        "LT": "လစ်သူယေးနီးယား",
        "LU": "လူဇင်ဘတ်",
        "LV": "လတ်ဗီးယား",
        "LY": "လစ်ဗျား",
        "MA": "မော်ရိုကို",
        "MC": "မိုနာကို",
        "MD": "မောလ်ဒိုဗာ",
        "ME": "မွန်တီနိဂရိုး",
        "MF": "စိန့်မာတင်",
        "MG": "မဒါဂတ်စကား",
        "MH": "မာရှယ် ကျွန်းစု",
        "MK": "မက်ဆီဒိုးနီးယား",
        "ML": "မာလီ",
        "MM": "မြန်မာ",
        "MN": "မွန်ဂိုးလီးယား",
        "MO": "မကာအို (တရုတ်ပြည်)",
        "MP": "မြောက်ပိုင်းမာရီအာနာကျွန်းစု",
        "MQ": "မာတီနိခ်",
        "MR": "မော်ရီတေးနီးယား",
        "MS": "မောင့်စဲရက်",
        "MT": "မောလ်တာ",
        "MU": "မောရစ်ရှ",
        "MV": "မော်လ်ဒိုက်",
        "MW": "မာလာဝီ",
        "MX": "မက်ကဆီကို",
        "MY": "မလေးရှား",
        "MZ": "မိုဇမ်ဘစ်",
        "NA": "နမီးဘီးယား",
        "NC": "နယူး ကယ်လီဒိုနီးယား",
        "NE": "နိုင်ဂျာ",
        "NF": "နောဖုတ်ကျွန်း",
        "NG": "နိုင်ဂျီးရီးယား",
        "NI": "နီကာရာဂွါ",
        "NL": "နယ်သာလန်",
        "NO": "နော်ဝေ",
        "NP": "နီပေါ",
        "NR": "နော်ရူး",
        "NU": "နီဥူအေ",
        "NZ": "နယူးဇီလန်",
        "OM": "အိုမန်",
        "PA": "ပနားမား",
        "PE": "ပီရူး",
        "PF": "ပြင်သစ် ပေါ်လီနီးရှား",
        "PG": "ပါပူအာ နယူးဂီနီ",
        "PH": "ဖိလစ်ပိုင်",
        "PK": "ပါကစ္စတန်",
        "PL": "ပိုလန်",
        "PM": "စိန့်ပီအဲရ်နှင့် မီကွီလွန်",
        "PN": "ပစ်တ်ကိန်းကျွန်းစု",
        "PR": "ပေါ်တိုရီကို",
        "PS": "ပါလက်စတိုင်း ပိုင်နက်",
        "PT": "ပေါ်တူဂီ",
        "PW": "ပလာအို",
        "PY": "ပါရာဂွေး",
        "QA": "ကာတာ",
        "QO": "သမုဒ္ဒရာ အပြင်ဘက်ရှိ ကျွန်းနိုင်ငံများ",
        "RE": "ရီယူနီယန်",
        "RO": "ရိုမေးနီးယား",
        "RS": "ဆားဘီးယား",
        "RU": "ရုရှား",
        "RW": "ရဝန်ဒါ",
        "SA": "ဆော်ဒီအာရေးဘီးယား",
        "SB": "ဆော်လမွန်ကျွန်းစု",
        "SC": "ဆေးရှဲ",
        "SD": "ဆူဒန်",
        "SE": "ဆွီဒင်",
        "SG": "စင်္ကာပူ",
        "SH": "စိန့်ဟယ်လယ်နာ",
        "SI": "ဆလိုဗေးနီးယား",
        "SJ": "စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်",
        "SK": "ဆလိုဗက်ကီးယား",
        "SL": "ဆီယာရာ လီယွန်း",
        "SM": "ဆန်မာရီနို",
        "SN": "ဆီနီဂေါ",
        "SO": "ဆိုမာလီယာ",
        "SR": "ဆူရာနမ်",
        "SS": "တောင် ဆူဒန်",
        "ST": "ဆောင်တူမေးနှင့် ပရင်စီပီ",
        "SV": "အယ်လ်ဆာဗေးဒိုး",
        "SX": "စင့်မာတင်",
        "SY": "ဆီးရီးယား",
        "SZ": "ဆွာဇီလန်",
        "TA": "ထရစ္စတန် ဒါ ကွန်ဟာ",
        "TC": "တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု",
        "TD": "ချဒ်",
        "TF": "ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ",
        "TG": "တိုဂို",
        "TH": "ထိုင်း",
        "TJ": "တာဂျီကစ္စတန်",
        "TK": "တိုကလောင်",
        "TL": "အရှေ့တီမော",
        "TM": "တာ့ခ်မင်နစ္စတန်",
        "TN": "တူနီးရှား",
        "TO": "တွန်ဂါ",
        "TR": "တူရကီ",
        "TT": "ထရီနီဒတ်နှင့် တိုဘက်ဂို",
        "TV": "တူဗားလူ",
        "TW": "ထိုင်ဝမ်",
        "TZ": "တန်ဇန်းနီးယား",
        "UA": "ယူကရိန်း",
        "UG": "ယူဂန်းဒါး",
        "UM": "ယူနိုက်တက်စတိတ် ကျွန်းနိုင်ငံများ",
        "UN": "ကုလသမဂ္ဂ",
        "US": "အမေရိကန် ပြည်ထောင်စု",
        "UY": "ဥရုဂွေး",
        "UZ": "ဥဇဘက်ကစ္စတန်",
        "VA": "ဗာတီကန်စီးတီး",
        "VC": "စိန့်ဗင်းဆင့်နှင့် ဂရိနေဒိုင်",
        "VE": "ဗင်နီဇွဲလား",
        "VG": "ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု",
        "VI": "ယူအက်စ် ဗာဂျင်း ကျွန်းစု",
        "VN": "ဗီယက်နမ်",
        "VU": "ဗနွားတူ",
        "WF": "ဝေါလစ်နှင့် ဖူကျူးနား",
        "WS": "ဆမိုးအား",
        "XK": "ကိုဆိုဗို",
        "YE": "ယီမင်",
        "YT": "မေယော့",
        "ZA": "တောင်အာဖရိက",
        "ZM": "ဇမ်ဘီယာ",
        "ZW": "ဇင်ဘာဘွေ",
        "ZZ": "မသိ (သို့) မရှိသော ဒေသ"
    };
  }-*/;
}
