/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapperupgrade;

import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.util.internal.VersionNumber;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;

public class PullRequestUtils {
    private static final String BRANCH_PREFIX = "wrapperbot/%s/%s-wrapper-";
    private final Set<GHPullRequest> pullRequests;

    PullRequestUtils(Set<GHPullRequest> pullRequests) {
        this.pullRequests = pullRequests;
    }

    static String branchPrefix(String project, String buildTool) {
        return String.format(BRANCH_PREFIX, project, buildTool.toLowerCase());
    }

    Set<GHPullRequest> pullRequestsToClose(String project, String buildTool, String latestBuildToolVersion) {
        VersionNumber latest = VersionNumber.parse((String)latestBuildToolVersion);
        return this.pullRequests.stream().filter(p -> p.getState() != GHIssueState.CLOSED).filter(p -> {
            String prefix;
            String branch = p.getHead().getRef();
            int index = branch.lastIndexOf(prefix = PullRequestUtils.branchPrefix(project, buildTool));
            return index == 0 && latest.compareTo(VersionNumber.parse((String)branch.substring(prefix.length()))) > 0;
        }).collect(Collectors.toSet());
    }

    boolean closedPrExists(String branch) {
        return this.pullRequests.stream().anyMatch(p -> branch.equals(p.getHead().getRef()) && p.getState() == GHIssueState.CLOSED);
    }
}

