/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapperupgrade;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.gradle.process.ExecOperations;
import org.gradle.wrapperupgrade.BuildToolStrategy;
import org.gradle.wrapperupgrade.ExecUtils;
import org.gradle.wrapperupgrade.GradleMetadataFetcher;

public final class GradleBuildToolStrategy
implements BuildToolStrategy {
    private final GradleMetadataFetcher gradleMetadataFetcher = new GradleMetadataFetcher();

    @Override
    public String buildToolName() {
        return "Gradle";
    }

    @Override
    public BuildToolStrategy.VersionInfo lookupLatestVersion(boolean allowPreRelease) throws IOException {
        JsonNode latestVersion = this.gradleMetadataFetcher.fetchLatestVersion(allowPreRelease).orElseThrow(() -> new IllegalStateException("Could not determine latest Gradle version"));
        JsonNode checksumUrl = latestVersion.get("checksumUrl");
        if (checksumUrl != null) {
            URL url = new URL(checksumUrl.asText());
            String checksum = new Scanner(url.openStream()).useDelimiter("\\A").next();
            return new BuildToolStrategy.VersionInfo(latestVersion.get("version").asText(), checksum);
        }
        return new BuildToolStrategy.VersionInfo(latestVersion.get("version").asText(), null);
    }

    @Override
    public BuildToolStrategy.VersionInfo extractCurrentVersion(Path rootProjectDir) throws IOException {
        return BuildToolStrategy.extractBuildToolVersion(rootProjectDir, "gradle/wrapper/gradle-wrapper.properties", "distributionUrl", "distributionSha256Sum", "distributions(?:-snapshots)?/gradle-(.*)-(bin|all).zip");
    }

    @Override
    public void runWrapper(ExecOperations execOperations, Path rootProjectDir, BuildToolStrategy.VersionInfo version) {
        if (version.checksum.isPresent()) {
            ExecUtils.execGradleCmd(execOperations, rootProjectDir, "--console=plain", "wrapper", "--gradle-version", version.version, "--gradle-distribution-sha256-sum", version.checksum.get());
        } else {
            ExecUtils.execGradleCmd(execOperations, rootProjectDir, "--console=plain", "wrapper", "--gradle-version", version.version);
        }
    }

    @Override
    public List<Path> wrapperFiles(Path rootProjectDir) {
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(rootProjectDir.resolve("gradlew"));
        paths.add(rootProjectDir.resolve("gradlew.bat"));
        paths.add(rootProjectDir.resolve("gradle").resolve("wrapper"));
        return paths;
    }

    @Override
    public String releaseNotesLink(String buildToolVersion) {
        return "https://docs.gradle.org/$VERSION/release-notes.html".replace("$VERSION", buildToolVersion);
    }
}

