/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.dependencygraph.extractor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.dependencygraph.DependencyGraphRenderer;
import org.gradle.dependencygraph.extractor.ResolvedConfigurationFilter;
import org.gradle.dependencygraph.model.BuildLayout;
import org.gradle.dependencygraph.model.DependencyCoordinates;
import org.gradle.dependencygraph.model.DependencyOrigin;
import org.gradle.dependencygraph.model.DependencyScope;
import org.gradle.dependencygraph.model.ResolvedConfiguration;
import org.gradle.dependencygraph.model.ResolvedDependency;
import org.gradle.dependencygraph.util.PluginParameters;
import org.gradle.initialization.EvaluateSettingsBuildOperationType;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 b2\u00020\u00012\u00020\u0002:\u0003bcdB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0002J0\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010H\u0002J\u0018\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020%2\u0006\u0010;\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020%2\u0006\u00109\u001a\u00020@H\u0016J\u0018\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010F\u001a\u00020.2\u0006\u0010'\u001a\u00020(2\u0006\u0010G\u001a\u00020.H\u0002J\b\u0010H\u001a\u00020\u001cH\u0002J\b\u0010I\u001a\u00020\u0010H&J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020(0\u001a2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010K\u001a\u00020%2\b\u0010L\u001a\u0004\u0018\u00010#Ja\u0010M\u001a\u00020%\"\u0006\b\u0000\u0010N\u0018\u0001\"\u0006\b\u0001\u0010O\u0018\u00012\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E26\u0010P\u001a2\u0012\u0013\u0012\u0011HN\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(9\u0012\u0013\u0012\u0011HO\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020%0QH\u0082\bJa\u0010T\u001a\u00020%\"\u0006\b\u0000\u0010N\u0018\u0001\"\u0006\b\u0001\u0010O\u0018\u00012\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E26\u0010P\u001a2\u0012\u0013\u0012\u0011HN\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(9\u0012\u0013\u0012\u0011HO\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020%0QH\u0082\bJ\u0018\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0016J\u0018\u0010Z\u001a\u00020%2\u0006\u0010B\u001a\u00020C2\u0006\u0010[\u001a\u00020\\H\u0016J\u0012\u0010]\u001a\u0004\u0018\u00010(2\u0006\u0010^\u001a\u00020(H\u0002J(\u0010_\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010G\u001a\u00020.2\u0006\u00100\u001a\u0002012\u0006\u0010`\u001a\u00020\u0018H\u0002J\b\u0010a\u001a\u00020%H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\"\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010#0# \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010#0#\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lorg/gradle/dependencygraph/extractor/DependencyExtractor;", "Lorg/gradle/internal/operations/BuildOperationListener;", "Ljava/lang/AutoCloseable;", "()V", "buildCompleted", "", "buildFailed", "buildLayout", "Lorg/gradle/dependencygraph/model/BuildLayout;", "configurationFilter", "Lorg/gradle/dependencygraph/extractor/ResolvedConfigurationFilter;", "getConfigurationFilter", "()Lorg/gradle/dependencygraph/extractor/ResolvedConfigurationFilter;", "configurationFilter$delegate", "Lkotlin/Lazy;", "dependencyGraphReportDir", "", "getDependencyGraphReportDir", "()Ljava/lang/String;", "dependencyGraphReportDir$delegate", "pluginParameters", "Lorg/gradle/dependencygraph/util/PluginParameters;", "resolvedConfigurations", "", "Lorg/gradle/dependencygraph/model/ResolvedConfiguration;", "kotlin.jvm.PlatformType", "", "rootProjectBuildDirectory", "Ljava/io/File;", "getRootProjectBuildDirectory", "()Ljava/io/File;", "setRootProjectBuildDirectory", "(Ljava/io/File;)V", "settingsEvaluated", "thrownExceptions", "", "close", "", "componentId", "component", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "coordinates", "Lorg/gradle/dependencygraph/model/DependencyCoordinates;", "createComponentNode", "Lorg/gradle/dependencygraph/model/ResolvedDependency;", "origin", "Lorg/gradle/dependencygraph/model/DependencyOrigin;", "isDirectDependency", "repositoryLookup", "Lorg/gradle/dependencygraph/extractor/DependencyExtractor$RepositoryUrlLookup;", "createRenderer", "Lorg/gradle/dependencygraph/DependencyGraphRenderer;", "dependencyScope", "Lorg/gradle/dependencygraph/model/DependencyScope;", "rootPath", "configurationName", "extractConfigurationDependencies", "details", "Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Details;", "result", "Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Result;", "extractProjects", "Lorg/gradle/initialization/LoadProjectsBuildOperationType$Result;", "extractSettings", "Lorg/gradle/initialization/EvaluateSettingsBuildOperationType$Details;", "finished", "buildOperation", "Lorg/gradle/internal/operations/BuildOperationDescriptor;", "finishEvent", "Lorg/gradle/internal/operations/OperationFinishEvent;", "getOrigin", "parentOrigin", "getOutputDir", "getRendererClassName", "getResolvedDependencies", "handleBuildCompletion", "failure", "handleBuildOperationType", "D", "R", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "handleBuildOperationTypeRaw", "progress", "operationIdentifier", "Lorg/gradle/internal/operations/OperationIdentifier;", "progressEvent", "Lorg/gradle/internal/operations/OperationProgressEvent;", "started", "startEvent", "Lorg/gradle/internal/operations/OperationStartEvent;", "traversePluginMarker", "rawComponent", "walkComponentDependencies", "resolvedConfiguration", "writeDependencyGraph", "Companion", "LoggingDependencyGraphRenderer", "RepositoryUrlLookup", "plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyExtractor.kt\norg/gradle/dependencygraph/extractor/DependencyExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n95#1,2:406\n108#1,15:408\n97#1,5:423\n95#1,2:428\n108#1,15:430\n97#1,5:445\n95#1,2:450\n108#1,15:452\n97#1,5:467\n108#1,15:472\n800#2,11:487\n1549#2:498\n1620#2,3:499\n1603#2,9:502\n1855#2:511\n1856#2:513\n1612#2:514\n766#2:515\n857#2,2:516\n800#2,11:518\n1549#2:529\n1620#2,3:530\n1#3:512\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyExtractor.kt\norg/gradle/dependencygraph/extractor/DependencyExtractor\n*L\n76#1,2:406\n76#1,15:408\n76#1,5:423\n81#1,2:428\n81#1,15:430\n81#1,5:445\n85#1,2:450\n85#1,15:452\n85#1,5:467\n96#1,15:472\n238#1,11:487\n239#1:498\n239#1,3:499\n240#1,9:502\n240#1:511\n240#1:513\n240#1:514\n241#1:515\n241#1,2:516\n265#1,11:518\n265#1:529\n265#1,3:530\n240#1:512\n*E\n"})
public abstract class DependencyExtractor
implements BuildOperationListener,
AutoCloseable {
    private final PluginParameters pluginParameters = new PluginParameters();
    private boolean settingsEvaluated;
    private boolean buildCompleted;
    private boolean buildFailed;
    private final List<ResolvedConfiguration> resolvedConfigurations = Collections.synchronizedList(new ArrayList());
    private final List<Throwable> thrownExceptions = Collections.synchronizedList(new ArrayList());
    @Nullable
    private File rootProjectBuildDirectory;
    private final BuildLayout buildLayout = new BuildLayout();
    private final Lazy configurationFilter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResolvedConfigurationFilter>(this){
        final /* synthetic */ DependencyExtractor this$0;

        @NotNull
        public final ResolvedConfigurationFilter invoke() {
            return new ResolvedConfigurationFilter(DependencyExtractor.access$getPluginParameters$p(this.this$0));
        }
        {
            this.this$0 = dependencyExtractor;
            super(0);
        }
    }));
    private final Lazy dependencyGraphReportDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ DependencyExtractor this$0;

        @Nullable
        public final String invoke() {
            return DependencyExtractor.access$getPluginParameters$p(this.this$0).loadOptional("DEPENDENCY_GRAPH_REPORT_DIR");
        }
        {
            this.this$0 = dependencyExtractor;
            super(0);
        }
    }));
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final File getRootProjectBuildDirectory() {
        return this.rootProjectBuildDirectory;
    }

    public final void setRootProjectBuildDirectory(@Nullable File file) {
        this.rootProjectBuildDirectory = file;
    }

    private final ResolvedConfigurationFilter getConfigurationFilter() {
        Lazy lazy = this.configurationFilter$delegate;
        DependencyExtractor dependencyExtractor = this;
        Object var3_3 = null;
        return (ResolvedConfigurationFilter)lazy.getValue();
    }

    private final String getDependencyGraphReportDir() {
        Lazy lazy = this.dependencyGraphReportDir$delegate;
        DependencyExtractor dependencyExtractor = this;
        Object var3_3 = null;
        return (String)lazy.getValue();
    }

    @NotNull
    public abstract String getRendererClassName();

    public void started(@NotNull BuildOperationDescriptor buildOperation, @NotNull OperationStartEvent startEvent) {
        Intrinsics.checkParameterIsNotNull((Object)buildOperation, (String)"buildOperation");
        Intrinsics.checkParameterIsNotNull((Object)startEvent, (String)"startEvent");
    }

    public void progress(@NotNull OperationIdentifier operationIdentifier, @NotNull OperationProgressEvent progressEvent) {
        Intrinsics.checkParameterIsNotNull((Object)operationIdentifier, (String)"operationIdentifier");
        Intrinsics.checkParameterIsNotNull((Object)progressEvent, (String)"progressEvent");
    }

    public void finished(@NotNull BuildOperationDescriptor buildOperation, @NotNull OperationFinishEvent finishEvent) {
        ResolveConfigurationDependenciesBuildOperationType.Result result;
        ResolveConfigurationDependenciesBuildOperationType.Details details;
        ResolveConfigurationDependenciesBuildOperationType.Result result$iv$iv;
        Object failure$iv$iv;
        Object details$iv$iv;
        boolean bl;
        Object it$iv$iv;
        boolean $i$f$handleBuildOperationTypeRaw;
        DependencyExtractor this_$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)buildOperation, (String)"buildOperation");
        Intrinsics.checkParameterIsNotNull((Object)finishEvent, (String)"finishEvent");
        DependencyExtractor this_$iv = this;
        boolean $i$f$handleBuildOperationType = false;
        try {
            Object object;
            this_$iv$iv = this_$iv;
            $i$f$handleBuildOperationTypeRaw = false;
            it$iv$iv = object = buildOperation.getDetails();
            bl = false;
            details$iv$iv = it$iv$iv instanceof ResolveConfigurationDependenciesBuildOperationType.Details ? it$iv$iv : null;
            if (details$iv$iv != null) {
                failure$iv$iv = finishEvent.getFailure();
                if (failure$iv$iv != null) {
                    throw failure$iv$iv;
                }
                Object object2 = finishEvent.getResult();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType.Result");
                }
                ResolveConfigurationDependenciesBuildOperationType.Result result2 = result$iv$iv = (ResolveConfigurationDependenciesBuildOperationType.Result)object2;
                details = (ResolveConfigurationDependenciesBuildOperationType.Details)details$iv$iv;
                boolean bl2 = false;
                this.extractConfigurationDependencies(details, result);
            }
        }
        catch (Throwable e$iv) {
            this_$iv.thrownExceptions.add(e$iv);
            throw e$iv;
        }
        this_$iv = this;
        $i$f$handleBuildOperationType = false;
        try {
            this_$iv$iv = this_$iv;
            $i$f$handleBuildOperationTypeRaw = false;
            it$iv$iv = failure$iv$iv = buildOperation.getDetails();
            bl = false;
            details$iv$iv = it$iv$iv instanceof LoadProjectsBuildOperationType.Details ? it$iv$iv : null;
            if (details$iv$iv != null) {
                failure$iv$iv = finishEvent.getFailure();
                if (failure$iv$iv != null) {
                    throw failure$iv$iv;
                }
                Object object = finishEvent.getResult();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.initialization.LoadProjectsBuildOperationType.Result");
                }
                result = result$iv$iv = (LoadProjectsBuildOperationType.Result)object;
                LoadProjectsBuildOperationType.Details $noName_0 = (LoadProjectsBuildOperationType.Details)details$iv$iv;
                boolean bl3 = false;
                this.extractProjects((LoadProjectsBuildOperationType.Result)result);
            }
        }
        catch (Throwable e$iv) {
            this_$iv.thrownExceptions.add(e$iv);
            throw e$iv;
        }
        this_$iv = this;
        $i$f$handleBuildOperationType = false;
        try {
            this_$iv$iv = this_$iv;
            $i$f$handleBuildOperationTypeRaw = false;
            it$iv$iv = failure$iv$iv = buildOperation.getDetails();
            bl = false;
            details$iv$iv = it$iv$iv instanceof EvaluateSettingsBuildOperationType.Details ? it$iv$iv : null;
            if (details$iv$iv != null) {
                failure$iv$iv = finishEvent.getFailure();
                if (failure$iv$iv != null) {
                    throw failure$iv$iv;
                }
                Object object = finishEvent.getResult();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.initialization.EvaluateSettingsBuildOperationType.Result");
                }
                result = result$iv$iv = (EvaluateSettingsBuildOperationType.Result)object;
                details = (EvaluateSettingsBuildOperationType.Details)details$iv$iv;
                boolean bl4 = false;
                this.extractSettings((EvaluateSettingsBuildOperationType.Details)details);
            }
        }
        catch (Throwable e$iv) {
            this_$iv.thrownExceptions.add(e$iv);
            throw e$iv;
        }
    }

    private final /* synthetic */ <D, R> void handleBuildOperationType(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, Function2<? super D, ? super R, Unit> handler) {
        int $i$f$handleBuildOperationType = 0;
        try {
            Object object;
            DependencyExtractor this_$iv = this;
            boolean $i$f$handleBuildOperationTypeRaw = false;
            Object it$iv = object = buildOperation.getDetails();
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"D");
            Object details$iv = it$iv instanceof Object ? it$iv : null;
            if (details$iv != null) {
                Throwable failure$iv = finishEvent.getFailure();
                if (failure$iv != null) {
                    throw failure$iv;
                }
                Object object2 = finishEvent.getResult();
                Intrinsics.reifiedOperationMarker((int)1, (String)"R");
                Object result$iv = object2;
                handler.invoke(details$iv, result$iv);
            }
        }
        catch (Throwable e) {
            this.thrownExceptions.add(e);
            throw e;
        }
    }

    private final /* synthetic */ <D, R> void handleBuildOperationTypeRaw(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, Function2<? super D, ? super R, Unit> handler) {
        Object object;
        int $i$f$handleBuildOperationTypeRaw = 0;
        Object it = object = buildOperation.getDetails();
        boolean bl = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"D");
        Object details = it instanceof Object ? it : null;
        if (details == null) {
            return;
        }
        Throwable failure = finishEvent.getFailure();
        if (failure != null) {
            throw failure;
        }
        Object object2 = finishEvent.getResult();
        Intrinsics.reifiedOperationMarker((int)1, (String)"R");
        Object result = object2;
        handler.invoke(details, result);
    }

    public void extractSettings(@NotNull EvaluateSettingsBuildOperationType.Details details) {
        Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
        this.settingsEvaluated = true;
        String settingsFile = details.getSettingsFile();
        if (settingsFile != null) {
            String string = details.getBuildPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.buildPath");
            this.buildLayout.addSettings(string, settingsFile);
        }
    }

    private final void extractProjects(LoadProjectsBuildOperationType.Result result) {
        Function1<Set<? extends LoadProjectsBuildOperationType.Result.Project>, Unit> $fun$recursivelyExtractProjects$1 = new Function1<Set<? extends LoadProjectsBuildOperationType.Result.Project>, Unit>(this){
            final /* synthetic */ DependencyExtractor this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Set<? extends LoadProjectsBuildOperationType.Result.Project> projects) {
                while (true) {
                    Set newProjects;
                    void $this$flatMapTo$iv$iv;
                    Object element$iv2;
                    Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
                    if (projects.isEmpty()) {
                        return;
                    }
                    Iterable $this$forEach$iv = projects;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        LoadProjectsBuildOperationType.Result.Project project = (LoadProjectsBuildOperationType.Result.Project)element$iv2;
                        boolean bl = false;
                        BuildLayout buildLayout = DependencyExtractor.access$getBuildLayout$p(this.this$0);
                        String string = project.getIdentityPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.identityPath");
                        String string2 = project.getBuildFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.buildFile");
                        buildLayout.addProject(string, string2);
                    }
                    Iterable $this$flatMap$iv = projects;
                    boolean $i$f$flatMap = false;
                    element$iv2 = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        LoadProjectsBuildOperationType.Result.Project it = (LoadProjectsBuildOperationType.Result.Project)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = it.getChildren();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    projects = newProjects = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                }
            }
            {
                this.this$0 = dependencyExtractor;
                super(1);
            }
        };
        $fun$recursivelyExtractProjects$1.invoke((Set<? extends LoadProjectsBuildOperationType.Result.Project>)SetsKt.setOf((Object)result.getRootProject()));
    }

    private final void extractConfigurationDependencies(ResolveConfigurationDependenciesBuildOperationType.Details details, ResolveConfigurationDependenciesBuildOperationType.Result result) {
        DefaultProjectComponentIdentifier defaultProjectComponentIdentifier;
        String projectIdentityPath;
        String string;
        ResolvedComponentResult rootComponent;
        RepositoryUrlLookup repositoryLookup = new RepositoryUrlLookup(details, result);
        ResolvedComponentResult resolvedComponentResult = rootComponent = result.getRootComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"rootComponent");
        if (resolvedComponentResult.getDependencies().isEmpty()) {
            return;
        }
        ComponentIdentifier componentIdentifier = rootComponent.getId();
        if (!(componentIdentifier instanceof DefaultProjectComponentIdentifier)) {
            componentIdentifier = null;
        }
        if ((string = (projectIdentityPath = (defaultProjectComponentIdentifier = (DefaultProjectComponentIdentifier)componentIdentifier) != null && (defaultProjectComponentIdentifier = defaultProjectComponentIdentifier.getIdentityPath()) != null ? defaultProjectComponentIdentifier.getPath() : null)) == null) {
            string = details.getBuildPath();
        }
        String rootPath = string;
        String configurationName = details.getConfigurationName();
        ResolvedConfigurationFilter resolvedConfigurationFilter = this.getConfigurationFilter();
        String string2 = rootPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rootPath");
        String string3 = configurationName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"configurationName");
        if (!resolvedConfigurationFilter.include(string2, string3)) {
            LOGGER.info("Excluding resolved configuration from dependency graph: " + rootPath + " - " + configurationName);
            return;
        }
        LOGGER.info("Including resolved configuration in dependency graph: " + rootPath + " - " + configurationName);
        DependencyScope scope = this.dependencyScope(rootPath, configurationName);
        String rootId = projectIdentityPath == null ? "build " + rootPath : this.componentId(rootComponent);
        DependencyOrigin rootOrigin = new DependencyOrigin(rootId, rootPath);
        ResolvedConfiguration resolvedConfiguration = new ResolvedConfiguration(rootOrigin, configurationName, scope, null, 8, null);
        for (ResolvedComponentResult dependencyComponent : this.getResolvedDependencies(rootComponent)) {
            ResolvedDependency directDep = this.createComponentNode(this.componentId(dependencyComponent), rootOrigin, true, dependencyComponent, repositoryLookup);
            resolvedConfiguration.addDependency(directDep);
            this.walkComponentDependencies(dependencyComponent, directDep.getOrigin(), repositoryLookup, resolvedConfiguration);
        }
        this.resolvedConfigurations.add(resolvedConfiguration);
    }

    private final DependencyScope dependencyScope(String rootPath, String configurationName) {
        if (this.getConfigurationFilter().scopesAreConfigured()) {
            return this.getConfigurationFilter().isRuntime(rootPath, configurationName) ? DependencyScope.Runtime : DependencyScope.Development;
        }
        return DependencyScope.Unknown;
    }

    private final void walkComponentDependencies(ResolvedComponentResult component, DependencyOrigin parentOrigin, RepositoryUrlLookup repositoryLookup, ResolvedConfiguration resolvedConfiguration) {
        DependencyOrigin componentOrigin = this.getOrigin(component, parentOrigin);
        boolean direct = Intrinsics.areEqual((Object)componentOrigin, (Object)parentOrigin) ^ true;
        for (ResolvedComponentResult dependencyComponent : this.getResolvedDependencies(component)) {
            String dependencyId = this.componentId(dependencyComponent);
            if (resolvedConfiguration.hasDependency(dependencyId)) continue;
            ResolvedDependency dependencyNode = this.createComponentNode(dependencyId, componentOrigin, direct, dependencyComponent, repositoryLookup);
            resolvedConfiguration.addDependency(dependencyNode);
            this.walkComponentDependencies(dependencyComponent, componentOrigin, repositoryLookup, resolvedConfiguration);
        }
    }

    private final DependencyOrigin getOrigin(ResolvedComponentResult component, DependencyOrigin parentOrigin) {
        ComponentIdentifier componentId = component.getId();
        if (componentId instanceof DefaultProjectComponentIdentifier) {
            String string = this.componentId(component);
            Path path = ((DefaultProjectComponentIdentifier)componentId).getIdentityPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"componentId.identityPath");
            String string2 = path.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"componentId.identityPath.path");
            return new DependencyOrigin(string, string2);
        }
        return parentOrigin;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResolvedComponentResult> getResolvedDependencies(ResolvedComponentResult component) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ResolvedComponentResult it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Set set = component.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"component.dependencies");
        Iterable $this$filterIsInstance$iv = set;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ResolvedDependencyResult resolvedDependencyResult = (ResolvedDependencyResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it.getSelected();
            collection.add(resolvedComponentResult);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ResolvedComponentResult resolvedComponentResult;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            ResolvedComponentResult it2 = (ResolvedComponentResult)element$iv$iv;
            boolean bl2 = false;
            ResolvedComponentResult resolvedComponentResult2 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult2, (String)"it");
            if (this.traversePluginMarker(resolvedComponentResult2) == null) continue;
            ResolvedComponentResult it$iv$iv = resolvedComponentResult;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)component) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ResolvedComponentResult traversePluginMarker(ResolvedComponentResult rawComponent) {
        if (rawComponent.getId() instanceof ModuleComponentIdentifier) {
            ComponentIdentifier componentIdentifier = rawComponent.getId();
            if (componentIdentifier == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
            }
            ModuleComponentIdentifier componentId = (ModuleComponentIdentifier)componentIdentifier;
            if (Intrinsics.areEqual((Object)componentId.getModule(), (Object)(componentId.getGroup() + ".gradle.plugin"))) {
                if (rawComponent.getDependencies().isEmpty()) {
                    return null;
                }
                if (rawComponent.getDependencies().size() == 1) {
                    ResolvedDependencyResult pluginDep;
                    Object e = rawComponent.getDependencies().iterator().next();
                    if (!(e instanceof ResolvedDependencyResult)) {
                        e = null;
                    }
                    ResolvedDependencyResult resolvedDependencyResult = pluginDep = (ResolvedDependencyResult)e;
                    return resolvedDependencyResult != null ? resolvedDependencyResult.getSelected() : null;
                }
            }
        }
        return rawComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedDependency createComponentNode(String componentId, DependencyOrigin origin, boolean isDirectDependency, ResolvedComponentResult component, RepositoryUrlLookup repositoryLookup) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Set set = component.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"component.dependencies");
        Iterable $this$filterIsInstance$iv = set;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedDependencyResult)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedDependencyResult resolvedDependencyResult = (ResolvedDependencyResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it.getSelected();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"it.selected");
            String string = this.componentId(resolvedComponentResult);
            collection.add(string);
        }
        List componentDependencies = (List)destination$iv$iv;
        String repositoryUrl = repositoryLookup.doLookup(component);
        boolean isProjectDependency = component.getId() instanceof ProjectComponentIdentifier;
        return new ResolvedDependency(componentId, origin, isDirectDependency, isProjectDependency, this.coordinates(component), repositoryUrl, componentDependencies);
    }

    private final String componentId(ResolvedComponentResult component) {
        ComponentIdentifier componentIdentifier = component.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"component.id");
        String string = componentIdentifier.getDisplayName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.id.displayName");
        return string;
    }

    private final DependencyCoordinates coordinates(ResolvedComponentResult component) {
        DependencyCoordinates dependencyCoordinates;
        ModuleVersionIdentifier mv = component.getModuleVersion();
        if (mv != null) {
            String string = mv.getGroup();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mv.group");
            String string2 = mv.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mv.name");
            String string3 = mv.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mv.version");
            dependencyCoordinates = new DependencyCoordinates(string, string2, string3);
        } else {
            dependencyCoordinates = new DependencyCoordinates("unknown", "unknown", "unknown");
        }
        return dependencyCoordinates;
    }

    private final void writeDependencyGraph() {
        File outputDirectory = this.getOutputDir();
        outputDirectory.mkdirs();
        DependencyGraphRenderer dependencyGraphRenderer = this.createRenderer();
        List<ResolvedConfiguration> list = this.resolvedConfigurations;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"resolvedConfigurations");
        dependencyGraphRenderer.outputDependencyGraph(this.pluginParameters, this.buildLayout, list, outputDirectory);
    }

    private final DependencyGraphRenderer createRenderer() {
        LOGGER.lifecycle("Constructing renderer: " + this.getRendererClassName());
        Object obj = Class.forName(this.getRendererClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (obj == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.dependencygraph.DependencyGraphRenderer");
        }
        DependencyGraphRenderer dependencyGraphRenderer = (DependencyGraphRenderer)obj;
        Logger logger = LOGGER;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOGGER");
        if (logger.isInfoEnabled()) {
            return new LoggingDependencyGraphRenderer(dependencyGraphRenderer);
        }
        return dependencyGraphRenderer;
    }

    private final File getOutputDir() {
        if (this.getDependencyGraphReportDir() != null) {
            return new File(this.getDependencyGraphReportDir());
        }
        if (this.rootProjectBuildDirectory == null) {
            throw (Throwable)new RuntimeException("Cannot determine report file location");
        }
        return new File(this.rootProjectBuildDirectory, "reports/dependency-graph-snapshots");
    }

    public final void handleBuildCompletion(@Nullable Throwable failure) {
        this.buildCompleted = true;
        if (failure != null) {
            this.buildFailed = true;
        }
    }

    @Override
    public void close() {
        List<Throwable> list = this.thrownExceptions;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"thrownExceptions");
        Collection collection = list;
        if (!collection.isEmpty()) {
            throw (Throwable)new DefaultMultiCauseException("The dependency-graph extractor plugin encountered errors while extracting dependencies. Please report this issue at: https://github.com/gradle/github-dependency-graph-gradle-plugin/issues", (Iterable)this.thrownExceptions);
        }
        if (!this.settingsEvaluated) {
            LOGGER.lifecycle("Gradle build state was reused from the configuration-cache: Dependency Graph file will not be generated.");
            return;
        }
        if (!this.buildCompleted || this.buildFailed) {
            LOGGER.lifecycle("Gradle Build did not complete successfully: Dependency Graph file will not be generated.");
            return;
        }
        try {
            this.writeDependencyGraph();
        }
        catch (RuntimeException e) {
            throw (Throwable)new DefaultMultiCauseException("Failed to write dependency-graph to file", new Throwable[]{e});
        }
    }

    static {
        Companion = new Companion(null);
        LOGGER = Logging.getLogger(DependencyExtractor.class);
    }

    public static final /* synthetic */ void access$handleBuildOperationTypeRaw(DependencyExtractor $this, BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, Function2 handler) {
        $this.handleBuildOperationTypeRaw(buildOperation, finishEvent, handler);
    }

    public static final /* synthetic */ BuildLayout access$getBuildLayout$p(DependencyExtractor $this) {
        return $this.buildLayout;
    }

    public static final /* synthetic */ PluginParameters access$getPluginParameters$p(DependencyExtractor $this) {
        return $this.pluginParameters;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gradle/dependencygraph/extractor/DependencyExtractor$RepositoryUrlLookup;", "", "details", "Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Details;", "result", "Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Result;", "(Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Details;Lorg/gradle/api/internal/artifacts/configurations/ResolveConfigurationDependenciesBuildOperationType$Result;)V", "doLookup", "", "resolvedComponentResult", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getRepositoryUrlForId", "id", "plugin"})
    @SourceDebugExtension(value={"SMAP\nDependencyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyExtractor.kt\norg/gradle/dependencygraph/extractor/DependencyExtractor$RepositoryUrlLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n1#2:406\n*E\n"})
    private static final class RepositoryUrlLookup {
        private final ResolveConfigurationDependenciesBuildOperationType.Details details;
        private final ResolveConfigurationDependenciesBuildOperationType.Result result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getRepositoryUrlForId(String id) {
            Object v3;
            Object object;
            Object object2;
            block2: {
                List list = this.details.getRepositories();
                object2 = list;
                if (list == null) return null;
                object = (Iterable)object2;
                Iterable iterable = object;
                for (Object t : iterable) {
                    ResolveConfigurationDependenciesBuildOperationType.Repository it = (ResolveConfigurationDependenciesBuildOperationType.Repository)t;
                    boolean bl = false;
                    ResolveConfigurationDependenciesBuildOperationType.Repository repository = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)repository, (String)"it");
                    if (!Intrinsics.areEqual((Object)repository.getId(), (Object)id)) continue;
                    v3 = t;
                    break block2;
                }
                v3 = null;
            }
            ResolveConfigurationDependenciesBuildOperationType.Repository repository = v3;
            object2 = repository;
            if (repository == null) return null;
            Map map = object2.getProperties();
            object2 = map;
            if (map == null) return null;
            Object it = object = object2;
            boolean bl = false;
            Object v = it.get("URL");
            if (!(v instanceof URI)) {
                v = null;
            }
            URI uRI = (URI)v;
            object2 = uRI;
            if (uRI == null) return null;
            String string = ((URI)object2).toString();
            object2 = string;
            if (string == null) return null;
            String string2 = StringsKt.removeSuffix((String)object2, (CharSequence)"/");
            return string2;
        }

        @Nullable
        public final String doLookup(@NotNull ResolvedComponentResult resolvedComponentResult) {
            String string;
            String repositoryId;
            Intrinsics.checkParameterIsNotNull((Object)resolvedComponentResult, (String)"resolvedComponentResult");
            String string2 = repositoryId = this.result.getRepositoryId(resolvedComponentResult);
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = this.getRepositoryUrlForId(it);
            } else {
                string = null;
            }
            return string;
        }

        public RepositoryUrlLookup(@NotNull ResolveConfigurationDependenciesBuildOperationType.Details details, @NotNull ResolveConfigurationDependenciesBuildOperationType.Result result) {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            this.details = details;
            this.result = result;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/dependencygraph/extractor/DependencyExtractor$LoggingDependencyGraphRenderer;", "Lorg/gradle/dependencygraph/DependencyGraphRenderer;", "delegate", "(Lorg/gradle/dependencygraph/DependencyGraphRenderer;)V", "outputDependencyGraph", "", "pluginParameters", "Lorg/gradle/dependencygraph/util/PluginParameters;", "buildLayout", "Lorg/gradle/dependencygraph/model/BuildLayout;", "resolvedConfigurations", "", "Lorg/gradle/dependencygraph/model/ResolvedConfiguration;", "outputDirectory", "Ljava/io/File;", "plugin"})
    private static final class LoggingDependencyGraphRenderer
    implements DependencyGraphRenderer {
        private final DependencyGraphRenderer delegate;

        @Override
        public void outputDependencyGraph(@NotNull PluginParameters pluginParameters, @NotNull BuildLayout buildLayout, @NotNull List<ResolvedConfiguration> resolvedConfigurations, @NotNull File outputDirectory) {
            Intrinsics.checkParameterIsNotNull((Object)pluginParameters, (String)"pluginParameters");
            Intrinsics.checkParameterIsNotNull((Object)buildLayout, (String)"buildLayout");
            Intrinsics.checkParameterIsNotNull(resolvedConfigurations, (String)"resolvedConfigurations");
            Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
            for (ResolvedConfiguration configuration : resolvedConfigurations) {
                for (ResolvedDependency dependency : configuration.getAllDependencies()) {
                    LOGGER.info("Detected dependency '" + dependency.getId() + "': project = '" + configuration.getRootOrigin().getPath() + "', configuration = '" + configuration.getConfigurationName() + '\'');
                }
            }
            this.delegate.outputDependencyGraph(pluginParameters, buildLayout, resolvedConfigurations, outputDirectory);
        }

        public LoggingDependencyGraphRenderer(@NotNull DependencyGraphRenderer delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gradle/dependencygraph/extractor/DependencyExtractor$Companion;", "", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

