/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradlewebtools.minify.minifier.MinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Event;
import org.gradlewebtools.minify.minifier.result.Report;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\u0006H\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0006H\u0004J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H$J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H$R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lorg/gradlewebtools/minify/minifier/Minifier;", "", "<init>", "()V", "acceptedFileExtensions", "", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "minifierName", "getMinifierName", "()Ljava/lang/String;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/MinifierOptions;", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/MinifierOptions;", "report", "Lorg/gradlewebtools/minify/minifier/result/Report;", "getReport", "()Lorg/gradlewebtools/minify/minifier/result/Report;", "minify", "", "srcDir", "Ljava/io/File;", "dstDir", "minifyInternal", "shouldMinify", "", "f", "Ljava/nio/file/Path;", "handleFile", "it", "minifyFileInternal", "srcFile", "dstFile", "createReport", "writeToFile", "string", "minifyFile", "rename", "oldName", "Companion", "gradle-minify-plugin"})
@SourceDebugExtension(value={"SMAP\nMinifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minifier.kt\norg/gradlewebtools/minify/minifier/Minifier\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n13309#2,2:109\n1855#3,2:111\n1855#3,2:113\n*S KotlinDebug\n*F\n+ 1 Minifier.kt\norg/gradlewebtools/minify/minifier/Minifier\n*L\n37#1:109,2\n83#1:111,2\n86#1:113,2\n*E\n"})
public abstract class Minifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Report report = new Report();
    private static final Logger LOGGER = LoggerFactory.getLogger(Minifier.class);

    @NotNull
    public abstract List<String> getAcceptedFileExtensions();

    @NotNull
    public abstract String getMinifierName();

    @NotNull
    public abstract MinifierOptions getMinifierOptions();

    @NotNull
    public final Report getReport() {
        return this.report;
    }

    public final void minify(@NotNull File srcDir, @NotNull File dstDir) {
        Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
        Intrinsics.checkNotNullParameter((Object)dstDir, (String)"dstDir");
        this.minifyInternal(srcDir, dstDir);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(this.createReport());
        }
        if (!((Collection)this.report.getErrors()).isEmpty()) {
            throw new GradleException(this.report.getErrors() + " Errors in " + this.getMinifierName());
        }
    }

    private final void minifyInternal(File srcDir, File dstDir) {
        try {
            File[] fileArray = srcDir.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Path f = it.toPath();
                    if (it.isFile()) {
                        Intrinsics.checkNotNull((Object)f);
                        Intrinsics.checkNotNull((Object)it);
                        this.handleFile(f, dstDir, it);
                        continue;
                    }
                    if (!it.isDirectory()) continue;
                    Intrinsics.checkNotNull((Object)it);
                    this.minifyInternal(it, new File(dstDir, ((Object)f.getFileName()).toString()));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final boolean shouldMinify(Path f) {
        return !this.getMinifierOptions().getIgnoreMinFiles() || !StringsKt.contains$default((CharSequence)((Object)f.getFileName()).toString(), (CharSequence)".min.", (boolean)false, (int)2, null);
    }

    private final void handleFile(Path f, File dstDir, File it) {
        Path dst = dstDir.toPath();
        String fileName = ((Object)f.getFileName()).toString();
        File copy = new File(((Object)dst).toString(), fileName);
        if (!this.getMinifierOptions().getOriginalFileNames()) {
            fileName = this.rename(fileName);
        }
        File dstFile = new File(((Object)dst).toString(), fileName);
        dstFile.getParentFile().mkdirs();
        if (this.getAcceptedFileExtensions().contains(FilesKt.getExtension((File)it))) {
            if (this.getMinifierOptions().getCopyOriginalFile() && !this.getMinifierOptions().getOriginalFileNames() || !this.shouldMinify(f)) {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(f, copy.toPath(), copyOptionArray);
            }
            if (this.shouldMinify(f)) {
                File file = f.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                this.minifyFileInternal(file, dstFile);
            }
        }
    }

    private final void minifyFileInternal(File srcFile, File dstFile) {
        try {
            this.minifyFile(srcFile, dstFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final String createReport() {
        Event it;
        StringBuilder stringBuilder;
        StringBuilder $this$createReport_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this.report.getErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Error)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = $this$createReport_u24lambda_u243.append("Error: " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        $this$forEach$iv = this.report.getWarnings();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Warning)element$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder3 = $this$createReport_u24lambda_u243.append("Warning: " + (Warning)it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder4 = $this$createReport_u24lambda_u243.append(this.getMinifierName() + ": " + this.report.getErrors().size() + " error(s), " + this.report.getWarnings().size() + " warning(s)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final void writeToFile(@NotNull File dstFile, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            Object object = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            StandardOpenOption[] options = object;
            Path path = dstFile.toPath();
            object = string;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(path, byArray, (OpenOption[])Arrays.copyOf(options, options.length));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void minifyFile(@NotNull File var1, @NotNull File var2);

    @NotNull
    protected abstract String rename(@NotNull String var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gradlewebtools/minify/minifier/Minifier$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "gradle-minify-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

