/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCodeInstallBridge;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.truffle.api.utilities.TriState;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.ComparableWord;

public final class IsolatedTruffleRuntimeSupport {
    public static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle;
        if (optimizedAssumptionConstant instanceof IsolatedObjectConstant) {
            ClientHandle<OptimizedAssumption> assumptionHandle = ((IsolatedObjectConstant)optimizedAssumptionConstant).getHandle();
            consumerHandle = IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency0(IsolatedCompileContext.get().getClient(), assumptionHandle);
        } else {
            ImageHeapRef<OptimizedAssumption> assumptionRef = ImageHeapObjects.ref(SubstrateObjectConstant.asObject(OptimizedAssumption.class, optimizedAssumptionConstant));
            consumerHandle = IsolatedTruffleRuntimeSupport.registerImageHeapOptimizedAssumptionDependency0(IsolatedCompileContext.get().getClient(), assumptionRef);
        }
        if (consumerHandle.equal((ComparableWord)IsolatedHandles.nullHandle())) {
            return null;
        }
        return codeInstallBridge -> {
            ClientHandle<? extends SubstrateInstalledCode> installedCodeHandle = (ClientHandle<? extends SubstrateInstalledCode>)IsolatedHandles.nullHandle();
            if (codeInstallBridge != null) {
                installedCodeHandle = ((IsolatedCodeInstallBridge)((Object)codeInstallBridge)).getSubstrateInstalledCodeHandle();
            }
            ClientHandle<? extends SubstrateInstalledCode> dependencyAccessHandle = installedCodeHandle;
            IsolatedTruffleRuntimeSupport.notifyAssumption0(IsolatedCompileContext.get().getClient(), consumerHandle, dependencyAccessHandle);
        };
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerOptimizedAssumptionDependency0(ClientIsolateThread client, ClientHandle<OptimizedAssumption> assumptionHandle) {
        OptimizedAssumption assumption = IsolatedCompileClient.get().unhand(assumptionHandle);
        return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency1(assumption);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerImageHeapOptimizedAssumptionDependency0(ClientIsolateThread client, ImageHeapRef<OptimizedAssumption> assumptionRef) {
        OptimizedAssumption assumption = ImageHeapObjects.deref(assumptionRef);
        return IsolatedTruffleRuntimeSupport.registerOptimizedAssumptionDependency1(assumption);
    }

    private static ClientHandle<Consumer<OptimizedAssumptionDependency>> registerOptimizedAssumptionDependency1(OptimizedAssumption assumption) {
        Consumer observer = assumption.registerDependency();
        return IsolatedCompileClient.get().hand(observer);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void notifyAssumption0(ClientIsolateThread client, ClientHandle<Consumer<OptimizedAssumptionDependency>> consumerHandle, ClientHandle<? extends OptimizedAssumptionDependency> dependencyHandle) {
        OptimizedAssumptionDependency dependency = null;
        if (dependencyHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
            dependency = IsolatedCompileClient.get().unhand(dependencyHandle);
        }
        IsolatedCompileClient.get().unhand(consumerHandle).accept(dependency);
    }

    public static JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        ClientHandle<OptimizedDirectCallNode> callNodeHandle = ((IsolatedObjectConstant)callNodeConstant).getHandle();
        return new IsolatedObjectConstant(IsolatedTruffleRuntimeSupport.getCallTargetForCallNode0(IsolatedCompileContext.get().getClient(), callNodeHandle), false);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<OptimizedCallTarget> getCallTargetForCallNode0(ClientIsolateThread client, ClientHandle<OptimizedDirectCallNode> callNode) {
        OptimizedDirectCallNode node = IsolatedCompileClient.get().unhand(callNode);
        OptimizedCallTarget callTarget = node.getCallTarget();
        return IsolatedCompileClient.get().hand(callTarget);
    }

    public static CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        ClientHandle<SubstrateCompilableTruffleAST> handle = ((IsolatedObjectConstant)constant).getHandle();
        return new IsolatedCompilableTruffleAST(handle);
    }

    public static boolean tryLog(String loggerId, CompilableTruffleAST compilable, String message) {
        if (compilable instanceof IsolatedCompilableTruffleAST) {
            ClientHandle<String> id = IsolatedCompileContext.get().createStringInClient(loggerId);
            ClientHandle<SubstrateCompilableTruffleAST> handle = ((IsolatedCompilableTruffleAST)compilable).getHandle();
            ClientHandle<String> msg = IsolatedCompileContext.get().createStringInClient(message);
            IsolatedTruffleRuntimeSupport.log0(IsolatedCompileContext.get().getClient(), id, handle, msg);
            return true;
        }
        return false;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void log0(ClientIsolateThread client, ClientHandle<String> id, ClientHandle<SubstrateCompilableTruffleAST> ast, ClientHandle<String> msg) {
        SubstrateTruffleRuntime runtime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        String loggerId = IsolatedCompileClient.get().unhand(id);
        OptimizedCallTarget callTarget = (OptimizedCallTarget)IsolatedCompileClient.get().unhand(ast);
        String message = IsolatedCompileClient.get().unhand(msg);
        runtime.log(loggerId, (CompilableTruffleAST)callTarget, message);
    }

    public static TriState tryIsSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
        if (compilable instanceof IsolatedCompilableTruffleAST) {
            ClientHandle<SubstrateCompilableTruffleAST> handle = ((IsolatedCompilableTruffleAST)compilable).getHandle();
            return IsolatedTruffleRuntimeSupport.isSuppressedFailure0(IsolatedCompileContext.get().getClient(), handle, IsolatedCompileContext.get().hand(serializedException)) ? TriState.TRUE : TriState.FALSE;
        }
        return TriState.UNDEFINED;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static boolean isSuppressedFailure0(ClientIsolateThread client, ClientHandle<SubstrateCompilableTruffleAST> ast, CompilerHandle<Supplier<String>> serializedExceptionHandle) {
        Supplier<String> serializedException = () -> {
            ClientHandle<String> resultHandle = IsolatedTruffleRuntimeSupport.getReasonAndStackTrace0(IsolatedCompileClient.get().getCompiler(), serializedExceptionHandle);
            return IsolatedCompileClient.get().unhand(resultHandle);
        };
        SubstrateTruffleRuntime runtime = (SubstrateTruffleRuntime)SubstrateTruffleRuntime.getRuntime();
        return runtime.isSuppressedFailure(IsolatedCompileClient.get().unhand(ast), serializedException);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ClientHandle<String> getReasonAndStackTrace0(CompilerIsolateThread compiler, CompilerHandle<Supplier<String>> reasonAndStackTraceHandle) {
        Supplier<String> supplier = IsolatedCompileContext.get().unhand(reasonAndStackTraceHandle);
        return IsolatedCompileContext.get().createStringInClient(supplier.get());
    }

    private IsolatedTruffleRuntimeSupport() {
    }
}

