/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;

public class StructBitfieldInfo
extends ElementInfo {
    private final PropertyInfo<Integer> byteOffset = this.adoptChild(new PropertyInfo("byteOffset"));
    private final PropertyInfo<Integer> startBit = this.adoptChild(new PropertyInfo("startBit"));
    private final PropertyInfo<Integer> endBit = this.adoptChild(new PropertyInfo("endBit"));
    private final PropertyInfo<SizableInfo.SignednessValue> signednessInfo = this.adoptChild(new PropertyInfo("signedness"));

    public StructBitfieldInfo(String name) {
        super(name);
    }

    public PropertyInfo<Integer> getByteOffsetInfo() {
        return this.byteOffset;
    }

    public PropertyInfo<Integer> getStartBitInfo() {
        return this.startBit;
    }

    public PropertyInfo<Integer> getEndBitInfo() {
        return this.endBit;
    }

    public PropertyInfo<SizableInfo.SignednessValue> getSignednessInfo() {
        return this.signednessInfo;
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitStructBitfieldInfo(this);
    }

    @Override
    public Object getAnnotatedElement() {
        for (ElementInfo child : this.getChildren()) {
            if (!(child instanceof AccessorInfo)) continue;
            return child.getAnnotatedElement();
        }
        throw VMError.shouldNotReachHere("must have at least one accessor method that defined the field");
    }

    public boolean isUnsigned() {
        return this.getSignednessInfo().getProperty() == SizableInfo.SignednessValue.UNSIGNED;
    }
}

