/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

public abstract class NativeVMOperation
extends VMOperation {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected NativeVMOperation(VMOperationInfo info) {
        super(info);
    }

    public void enqueue(NativeVMOperationData data) {
        data.setNativeVMOperation(this);
        VMOperationControl.get().enqueue(data);
    }

    @Uninterruptible(reason="Called from a non-Java thread.")
    public void enqueueFromNonJavaThread(NativeVMOperationData data) {
        assert (data.getNativeVMOperation() == this);
        VMOperationControl.get().enqueueFromNonJavaThread(data);
    }

    @Override
    protected IsolateThread getQueuingThread(NativeVMOperationData data) {
        return data.getQueuingThread();
    }

    @Override
    protected long getQueuingThreadId(NativeVMOperationData data) {
        return data.getQueuingThreadId();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean isFinished(NativeVMOperationData data) {
        return data.getFinished();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void markAsQueued(NativeVMOperationData data) {
        data.setFinished(false);
        data.setQueuingThread(CurrentIsolate.getCurrentThread());
        data.setQueuingThreadId(JavaThreads.getCurrentThreadIdOrZero());
    }

    @Override
    protected void markAsFinished(NativeVMOperationData data) {
        data.setQueuingThread((IsolateThread)WordFactory.nullPointer());
        data.setQueuingThreadId(0L);
        data.setFinished(true);
    }
}

