/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.properties;

import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import java.util.Arrays;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class RuntimePropertyParser {
    private static final String PROPERTY_PREFIX = "-D";

    public static String[] parse(String[] args) {
        int newIdx = 0;
        EconomicMap properties = EconomicMap.create();
        for (int oldIdx = 0; oldIdx < args.length; ++oldIdx) {
            String arg = args[oldIdx];
            if (arg.startsWith(PROPERTY_PREFIX) && RuntimePropertyParser.parseProperty(arg.substring(PROPERTY_PREFIX.length()), (EconomicMap<String, String>)properties)) continue;
            assert (newIdx <= oldIdx);
            args[newIdx] = arg;
            ++newIdx;
        }
        MapCursor cursor = properties.getEntries();
        while (cursor.advance()) {
            SystemPropertiesSupport.singleton().initializeProperty((String)cursor.getKey(), (String)cursor.getValue(), false);
        }
        if (newIdx == args.length) {
            return args;
        }
        return Arrays.copyOf(args, newIdx);
    }

    private static boolean parseProperty(String property, EconomicMap<String, String> parsedProperties) {
        int splitIndex = property.indexOf(61);
        if (splitIndex == -1) {
            return false;
        }
        String key = property.substring(0, splitIndex);
        String value = property.substring(splitIndex + 1);
        parsedProperties.put((Object)key, (Object)value);
        return true;
    }
}

