/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.thread.VMThreads;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class PosixLogHandler
implements LogHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(CCharPointer bytes, UnsignedWord length) {
        int savedErrno = LibC.errno();
        try {
            if (!PosixUtils.writeBytes(PosixLogHandler.getOutputFile(), bytes, length)) {
                this.fatalError();
            }
        }
        finally {
            LibC.setErrno(savedErrno);
        }
    }

    public void flush() {
        int savedErrno = LibC.errno();
        try {
            PosixUtils.flush(PosixLogHandler.getOutputFile());
        }
        finally {
            LibC.setErrno(savedErrno);
        }
    }

    public void fatalError() {
        if (SubstrateDiagnostics.isFatalErrorHandlingInProgress()) {
            VMThreads.singleton().nativeSleep(3000);
        }
        LibC.abort();
    }

    private static FileDescriptor getOutputFile() {
        return FileDescriptor.err;
    }
}

