/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK17OrEarlier;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jvmstat.PerfDataSupport;
import java.nio.ByteBuffer;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(className="jdk.internal.perf.Perf")
public final class Target_jdk_internal_perf_Perf {
    @Substitute
    @TargetElement(name="attach", onlyWith={JDK17OrEarlier.class})
    public ByteBuffer attachJDK17(String user, int lvmid, int mode) {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).attach(lvmid);
    }

    @Substitute
    @TargetElement(name="attach", onlyWith={JDK19OrLater.class})
    public ByteBuffer attachJDK19(int lvmid) {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).attach(lvmid);
    }

    @Substitute
    public void detach(ByteBuffer bb) {
        ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).detach(bb);
    }

    @Substitute
    public long highResCounter() {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).highResCounter();
    }

    @Substitute
    public long highResFrequency() {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).highResFrequency();
    }

    @Substitute
    public ByteBuffer createLong(String name, int variability, int units, long value) {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).createLong(name, variability, units, value);
    }

    @Substitute
    public ByteBuffer createByteArray(String name, int variability, int units, byte[] value, int maxLength) {
        return ((PerfDataSupport)ImageSingletons.lookup(PerfDataSupport.class)).createByteArray(name, variability, units, value, maxLength);
    }

    @Substitute
    private static void registerNatives() {
    }
}

