/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.jvmstat.NoPerfDataSupport;
import com.oracle.svm.core.jvmstat.PerfDataSupport;
import com.oracle.svm.core.jvmstat.PerfDataSupportImpl;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemory;
import com.oracle.svm.core.jvmstat.SystemCounters;
import com.oracle.svm.core.thread.VMOperationListenerSupport;
import com.oracle.svm.core.thread.VMOperationListenerSupportFeature;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class PerfDataFeature
implements InternalFeature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(VMOperationListenerSupportFeature.class, RuntimeSupportFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (VMInspectionOptions.hasJvmstatSupport()) {
            ImageSingletons.add(PerfMemory.class, (Object)new PerfMemory());
            ImageSingletons.add(PerfDataSupport.class, (Object)new PerfDataSupportImpl());
            PerfManager manager = new PerfManager();
            ImageSingletons.add(PerfManager.class, (Object)manager);
            SystemCounters systemCounters = new SystemCounters(manager);
            manager.register(systemCounters);
            VMOperationListenerSupport.get().register(systemCounters);
            RuntimeSupport runtime = RuntimeSupport.getRuntimeSupport();
            runtime.addInitializationHook(manager.initializationHook());
            runtime.addTearDownHook(manager.teardownHook());
        } else {
            ImageSingletons.add(PerfDataSupport.class, (Object)new NoPerfDataSupport());
        }
    }
}

