/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ReferenceHandlerThread
implements Runnable {
    private final Thread thread = new Thread((Runnable)this, "Reference Handler");
    private volatile IsolateThread isolateThread;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ReferenceHandlerThread() {
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
    }

    public static void start() {
        if (ReferenceHandlerThread.isSupported()) {
            ReferenceHandlerThread.singleton().thread.start();
        }
    }

    public static boolean isReferenceHandlerThread() {
        if (ReferenceHandlerThread.isSupported()) {
            return CurrentIsolate.getCurrentThread() == ReferenceHandlerThread.singleton().isolateThread;
        }
        return false;
    }

    public static boolean isReferenceHandlerThread(Thread other) {
        if (ReferenceHandlerThread.isSupported()) {
            return other == ReferenceHandlerThread.singleton().thread;
        }
        return false;
    }

    @Override
    public void run() {
        ThreadingSupportImpl.pauseRecurringCallback("An exception in a recurring callback must not interrupt pending reference processing because it could result in a memory leak.");
        this.isolateThread = CurrentIsolate.getCurrentThread();
        try {
            while (true) {
                ReferenceInternals.waitForPendingReferences();
                ReferenceInternals.processPendingReferences();
                ReferenceHandler.processCleaners();
            }
        }
        catch (InterruptedException e) {
            VMError.guarantee(VMThreads.isTearingDown(), "Reference Handler should only be interrupted during tear-down");
        }
        catch (Throwable t) {
            VMError.shouldNotReachHere("Reference processing and cleaners must handle all potential exceptions", t);
        }
    }

    @Fold
    static ReferenceHandlerThread singleton() {
        return (ReferenceHandlerThread)ImageSingletons.lookup(ReferenceHandlerThread.class);
    }

    @Fold
    static boolean isSupported() {
        return SubstrateOptions.MultiThreaded.getValue() != false && SubstrateOptions.AllowVMInternalThreads.getValue() != false;
    }
}

