/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AbstractImageHeapLayouter;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapAllocator;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.TreeMap;

public class ChunkedImageHeapPartition
extends AbstractImageHeapLayouter.AbstractImageHeapPartition {
    private final boolean hugeObjects;
    Object firstObject;
    Object lastObject;
    long startOffset = -1L;
    long endOffset = -1L;
    private final int minimumObjectSize;

    ChunkedImageHeapPartition(String name, boolean writable, boolean hugeObjects) {
        super(name, writable);
        this.hugeObjects = hugeObjects;
        this.minimumObjectSize = ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize();
    }

    boolean usesUnalignedObjects() {
        return this.hugeObjects;
    }

    void layout(ChunkedImageHeapAllocator allocator) {
        if (this.hugeObjects) {
            this.layoutInUnalignedChunks(allocator);
        } else {
            this.layoutInAlignedChunks(allocator);
        }
    }

    private void layoutInUnalignedChunks(ChunkedImageHeapAllocator allocator) {
        allocator.finishAlignedChunk();
        allocator.alignBetweenChunks(this.getStartAlignment());
        this.startOffset = allocator.getPosition();
        for (ImageHeapObject info : this.getObjects()) {
            this.appendAllocatedObject(info, allocator.allocateUnalignedChunkForObject(info, this.isWritable()));
        }
        allocator.alignBetweenChunks(this.getEndAlignment());
        this.endOffset = allocator.getPosition();
    }

    private void layoutInAlignedChunks(ChunkedImageHeapAllocator allocator) {
        allocator.maybeStartAlignedChunk();
        allocator.alignInAlignedChunk(this.getStartAlignment());
        this.startOffset = allocator.getPosition();
        this.allocateObjectsInAlignedChunks(allocator);
        allocator.alignInAlignedChunk(this.getEndAlignment());
        this.endOffset = allocator.getPosition();
    }

    private void allocateObjectsInAlignedChunks(ChunkedImageHeapAllocator allocator) {
        NavigableMap<Long, Queue<ImageHeapObject>> objects = ChunkedImageHeapPartition.createSortedObjectsMap(this.getObjects());
        while (!objects.isEmpty()) {
            ImageHeapObject info = this.dequeueBestFit(objects, allocator.getRemainingBytesInAlignedChunk());
            if (info == null) {
                allocator.startNewAlignedChunk();
                continue;
            }
            this.appendAllocatedObject(info, allocator.allocateObjectInAlignedChunk(info, this.isWritable()));
        }
    }

    private ImageHeapObject dequeueBestFit(NavigableMap<Long, Queue<ImageHeapObject>> objects, long nbytes) {
        if (nbytes < (long)this.minimumObjectSize) {
            return null;
        }
        Map.Entry<Long, Queue<ImageHeapObject>> entry = objects.floorEntry(nbytes);
        if (entry == null) {
            return null;
        }
        Queue<ImageHeapObject> queue = entry.getValue();
        ImageHeapObject info = queue.remove();
        if (queue.isEmpty()) {
            objects.remove(entry.getKey());
        }
        return info;
    }

    private static NavigableMap<Long, Queue<ImageHeapObject>> createSortedObjectsMap(List<ImageHeapObject> objects) {
        ImageHeapObject[] sorted = objects.toArray(new ImageHeapObject[0]);
        Arrays.sort(sorted, new SizeComparator());
        TreeMap<Long, Queue<ImageHeapObject>> map = new TreeMap<Long, Queue<ImageHeapObject>>();
        ArrayDeque<ImageHeapObject> currentQueue = null;
        long currentObjectsSize = -1L;
        for (ImageHeapObject obj : sorted) {
            long objSize = obj.getSize();
            if (objSize != currentObjectsSize) {
                assert (objSize > currentObjectsSize && objSize >= (long)ConfigurationValues.getObjectLayout().getMinImageHeapObjectSize());
                currentObjectsSize = objSize;
                currentQueue = new ArrayDeque<ImageHeapObject>();
                map.put(currentObjectsSize, currentQueue);
            }
            currentQueue.add(obj);
        }
        return map;
    }

    private void appendAllocatedObject(ImageHeapObject info, long allocationOffset) {
        if (this.firstObject == null) {
            this.firstObject = ChunkedImageHeapPartition.extractObject(info);
        }
        assert (info.getPartition() == this);
        long offsetInPartition = allocationOffset - this.startOffset;
        assert (ConfigurationValues.getObjectLayout().isAligned(offsetInPartition)) : "start: " + offsetInPartition + " must be aligned.";
        info.setOffsetInPartition(offsetInPartition);
        this.lastObject = ChunkedImageHeapPartition.extractObject(info);
    }

    private static Object extractObject(ImageHeapObject info) {
        if (info.getConstant() instanceof SubstrateObjectConstant) {
            return info.getObject();
        }
        return info.getConstant();
    }

    @Override
    public long getStartOffset() {
        assert (this.startOffset >= 0L) : "Start offset not yet set";
        return this.startOffset;
    }

    public long getEndOffset() {
        assert (this.endOffset >= 0L) : "End offset not yet set";
        return this.endOffset;
    }

    @Override
    public long getSize() {
        return this.getEndOffset() - this.getStartOffset();
    }

    private static class SizeComparator
    implements Comparator<ImageHeapObject> {
        private SizeComparator() {
        }

        @Override
        public int compare(ImageHeapObject o1, ImageHeapObject o2) {
            return Long.signum(o1.getSize() - o2.getSize());
        }
    }
}

