/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.SubstrateUtil;

class CgroupInfo {
    private final String name;
    private final int hierarchyId;
    private final boolean enabled;

    private CgroupInfo(String name, int hierarchyId, boolean enabled) {
        this.name = name;
        this.hierarchyId = hierarchyId;
        this.enabled = enabled;
    }

    String getName() {
        return this.name;
    }

    int getHierarchyId() {
        return this.hierarchyId;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    static CgroupInfo fromCgroupsLine(String line) {
        String[] tokens = SubstrateUtil.split(line, "\t");
        if (tokens.length != 4) {
            return null;
        }
        return new CgroupInfo(tokens[0], Integer.parseInt(tokens[1]), Integer.parseInt(tokens[3]) == 1);
    }
}

