/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.SerializationConfigurationParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.serialize.hosted.SerializationBuilder;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class SerializationFeature
implements Feature {
    private int loadedConfigurations;

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        SerializationBuilder serializationBuilder = new SerializationBuilder(access);
        HashMap deniedClasses = new HashMap();
        SerializationConfigurationParser denyCollectorParser = new SerializationConfigurationParser((strTargetSerializationClass, checksums) -> {
            Class<?> serializationTargetClass = SerializationFeature.resolveClass(strTargetSerializationClass, access);
            if (serializationTargetClass != null) {
                deniedClasses.put(serializationTargetClass, true);
            }
        });
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        ConfigurationParserUtils.parseAndRegisterConfigurations(denyCollectorParser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationDenyConfigurationFiles, ConfigurationFiles.Options.SerializationDenyConfigurationResources, "serialization-deny-config.json");
        SerializationConfigurationParser.SerializationParserFunction serializationAdapter = (strTargetSerializationClass, checksums) -> {
            Class<?> serializationTargetClass = SerializationFeature.resolveClass(strTargetSerializationClass, access);
            UserError.guarantee(serializationTargetClass != null, "Cannot find serialization target class %s. The missing of this class can't be ignored even if -H:+AllowIncompleteClasspath is set. Please make sure it is in the classpath", strTargetSerializationClass);
            if (Serializable.class.isAssignableFrom(serializationTargetClass)) {
                if (deniedClasses.containsKey(serializationTargetClass)) {
                    if (((Boolean)deniedClasses.get(serializationTargetClass)).booleanValue()) {
                        deniedClasses.put(serializationTargetClass, false);
                        SerializationFeature.println("Warning: Serialization deny list contains " + serializationTargetClass.getName() + ". Image will not support serialization/deserialization of this class.");
                    }
                } else {
                    Class<?> targetConstructor = serializationBuilder.addConstructorAccessor(serializationTargetClass, checksums);
                    SerializationFeature.addReflections(serializationTargetClass, targetConstructor);
                }
            }
        };
        SerializationConfigurationParser parser = new SerializationConfigurationParser(serializationAdapter);
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "serialization", ConfigurationFiles.Options.SerializationConfigurationFiles, ConfigurationFiles.Options.SerializationConfigurationResources, "serialization-config.json");
    }

    public static void addReflections(Class<?> serializationTargetClass, Class<?> targetConstructorClass) {
        if (targetConstructorClass != null) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(targetConstructorClass, (Class[])new Class[0])});
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupConstructor(serializationTargetClass, (Class[])null)});
        }
        RuntimeReflection.register((Class[])new Class[]{serializationTargetClass});
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredConstructors());
        SerializationFeature.registerMethods(serializationTargetClass);
        SerializationFeature.registerFields(serializationTargetClass);
    }

    private static void registerMethods(Class<?> serializationTargetClass) {
        RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredMethods());
        Method computeDefaultSUID = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"computeDefaultSUID", (Class[])new Class[]{Class.class});
        RuntimeReflection.register((Executable[])new Executable[]{computeDefaultSUID});
    }

    private static void registerFields(Class<?> serializationTargetClass) {
        int staticFinalMask = 24;
        int privateStaticFinalMask = 2 | staticFinalMask;
        HashSet<String> serialPersistentFieldNames = new HashSet<String>();
        try {
            Field f = ReflectionUtil.lookupField(serializationTargetClass, (String)"serialPersistentFields");
            if ((f.getModifiers() & privateStaticFinalMask) == privateStaticFinalMask) {
                ObjectStreamField[] serialPersistentFields;
                for (ObjectStreamField serialPersistentField : serialPersistentFields = (ObjectStreamField[])f.get(null)) {
                    serialPersistentFieldNames.add(serialPersistentField.getName());
                }
            }
        }
        catch (ReflectionUtil.ReflectionUtilError | IllegalAccessException throwable) {
            // empty catch block
        }
        for (Field f : serializationTargetClass.getDeclaredFields()) {
            int modifiers = f.getModifiers();
            boolean allowWrite = false;
            boolean allowUnsafeAccess = false;
            if ((modifiers & staticFinalMask) != staticFinalMask) {
                allowWrite = Modifier.isFinal(f.getModifiers());
                allowUnsafeAccess = !Modifier.isStatic(f.getModifiers());
            }
            RuntimeReflection.register((boolean)allowWrite, (boolean)allowUnsafeAccess, (Field[])new Field[]{f});
        }
    }

    private static Class<?> resolveClass(String typeName, Feature.FeatureAccess a) {
        Class ret;
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        if ((ret = a.findClassByName(name)) == null) {
            SerializationFeature.handleError("Could not resolve " + name + " for serialization configuration.");
        }
        return ret;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest serializationFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).serializationFallback;
        if (serializationFallback != null && this.loadedConfigurations == 0) {
            throw serializationFallback;
        }
    }

    private static void handleError(String message) {
        boolean allowIncompleteClasspath = NativeImageOptions.AllowIncompleteClasspath.getValue();
        if (!allowIncompleteClasspath) {
            throw new JSONParserException(message + " To allow unresolvable reflection configuration, use option -H:+AllowIncompleteClasspath");
        }
        SerializationFeature.println("WARNING: " + message);
    }

    static void println(String str) {
        System.out.println(str);
    }
}

