/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import java.util.Map;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

@NodeInfo
public final class SubstrateMethodCallTargetNode
extends MethodCallTargetNode {
    public static final NodeClass<SubstrateMethodCallTargetNode> TYPE = NodeClass.create(SubstrateMethodCallTargetNode.class);
    protected final StaticAnalysisResults staticAnalysisResults;
    protected final int bci;

    public SubstrateMethodCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, StaticAnalysisResults staticAnalysisResults, int bci) {
        super(TYPE, invokeKind, targetMethod, arguments, returnStamp, staticAnalysisResults.getTypeProfile(bci));
        this.staticAnalysisResults = staticAnalysisResults;
        this.bci = bci;
    }

    public StaticAnalysisResults getStaticAnalysisResults() {
        return this.staticAnalysisResults;
    }

    public int getBci() {
        return this.bci;
    }

    public JavaTypeProfile getTypeProfile() {
        return this.getProfile();
    }

    public JavaMethodProfile getMethodProfile() {
        return this.staticAnalysisResults.getMethodProfile(this.bci);
    }

    public JavaTypeProfile getInvokeResultTypeProfile() {
        return this.staticAnalysisResults.getInvokeResultTypeProfile(this.bci);
    }

    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        map.put("typeProfile", this.getTypeProfile());
        map.put("methodProfile", this.getMethodProfile());
        map.put("resultTypeProfile", this.getInvokeResultTypeProfile());
        return super.getDebugProperties(map);
    }
}

