/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent.jdk8.lambda;

import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.agent.NativeImageBytecodeInstrumentationAgent;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Handle;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class LambdaMetaFactoryRewriteVisitor
extends ClassVisitor {
    private final ClassLoader loader;
    private final String className;

    public LambdaMetaFactoryRewriteVisitor(ClassLoader loader, String className, ClassWriter writer) {
        super(327680, writer);
        this.loader = loader;
        this.className = className;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.instrumentationSupported()) {
            return new LambdaMetaFactoryMethodVisitor(methodVisitor);
        }
        return methodVisitor;
    }

    private boolean instrumentationSupported() {
        if (NativeImageBytecodeInstrumentationAgent.getJavaVersion() == 8) {
            return this.className != null && NativeImageSystemClassLoader.singleton().isNativeImageClassLoader(this.loader);
        }
        return false;
    }

    public class LambdaMetaFactoryMethodVisitor
    extends MethodVisitor {
        LambdaMetaFactoryMethodVisitor(MethodVisitor methodVisitor) {
            super(327680, methodVisitor);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.isMetaFactoryCall(bootstrapMethodHandle.getOwner(), bootstrapMethodHandle.getName())) {
                Handle handle = new Handle(bootstrapMethodHandle.getTag(), "com/oracle/svm/hosted/agent/jdk8/lambda/LambdaMetafactory", bootstrapMethodHandle.getName(), bootstrapMethodHandle.getDesc());
                super.visitInvokeDynamicInsn(name, descriptor, handle, bootstrapMethodArguments);
            } else {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }

        private boolean isMetaFactoryCall(String owner, String name) {
            return owner.equals("java/lang/invoke/LambdaMetafactory") && (name.equals("metafactory") || name.equals("altMetafactory"));
        }
    }
}

