/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public final class ExceptionSynthesizer {
    private static final Map<Key, Method> exceptionMethods = new HashMap<Key, Method>();

    private static void registerMethod(Class<?> exceptionClass) {
        try {
            exceptionMethods.put(Key.from(exceptionClass), ImplicitExceptions.class.getDeclaredMethod("throw" + exceptionClass.getSimpleName(), new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static void registerMethod(Class<?> exceptionClass, Class<?> paramterClass) {
        try {
            exceptionMethods.put(Key.from(exceptionClass, paramterClass), ImplicitExceptions.class.getDeclaredMethod("throw" + exceptionClass.getSimpleName(), paramterClass));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private ExceptionSynthesizer() {
    }

    public static Method throwExceptionMethod(Class<?> ... methodDescriptor) {
        Method method = exceptionMethods.get(Key.from(methodDescriptor));
        VMError.guarantee(method != null, "Exception synthesizer method " + Arrays.toString(methodDescriptor) + " not found.");
        return method;
    }

    public static void throwException(GraphBuilderContext b, Class<?> exceptionClass, String message) {
        ExceptionSynthesizer.throwException(b, ExceptionSynthesizer.throwExceptionMethod(exceptionClass, String.class), message);
    }

    public static void throwException(GraphBuilderContext b, Method throwExceptionMethod, String message) {
        ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(message), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        ResolvedJavaMethod exceptionMethod = b.getMetaAccess().lookupJavaMethod((Executable)throwExceptionMethod);
        assert (exceptionMethod.isStatic());
        Invoke invoke = b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, exceptionMethod, new ValueNode[]{messageNode}, false);
        if (invoke != null) {
            b.add((ValueNode)new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.UnreachedCode));
        }
    }

    static {
        ExceptionSynthesizer.registerMethod(ClassNotFoundException.class, String.class);
        ExceptionSynthesizer.registerMethod(NoSuchFieldException.class, String.class);
        ExceptionSynthesizer.registerMethod(NoSuchMethodException.class, String.class);
        ExceptionSynthesizer.registerMethod(LinkageError.class, String.class);
        ExceptionSynthesizer.registerMethod(ClassCircularityError.class, String.class);
        ExceptionSynthesizer.registerMethod(IncompatibleClassChangeError.class, String.class);
        ExceptionSynthesizer.registerMethod(NoSuchFieldError.class, String.class);
        ExceptionSynthesizer.registerMethod(InstantiationError.class, String.class);
        ExceptionSynthesizer.registerMethod(NoSuchMethodError.class, String.class);
        ExceptionSynthesizer.registerMethod(IllegalAccessError.class, String.class);
        ExceptionSynthesizer.registerMethod(AbstractMethodError.class, String.class);
        ExceptionSynthesizer.registerMethod(BootstrapMethodError.class, String.class);
        ExceptionSynthesizer.registerMethod(ClassFormatError.class, String.class);
        ExceptionSynthesizer.registerMethod(GenericSignatureFormatError.class, String.class);
        ExceptionSynthesizer.registerMethod(UnsupportedClassVersionError.class, String.class);
        ExceptionSynthesizer.registerMethod(UnsatisfiedLinkError.class, String.class);
        ExceptionSynthesizer.registerMethod(NoClassDefFoundError.class, String.class);
        ExceptionSynthesizer.registerMethod(ExceptionInInitializerError.class, String.class);
        ExceptionSynthesizer.registerMethod(VerifyError.class, String.class);
        ExceptionSynthesizer.registerMethod(VerifyError.class);
    }

    static final class Key {
        private final Class<?>[] elements;

        static Key from(Class<?> ... values) {
            return new Key(values);
        }

        private Key(Class<?>[] values) {
            this.elements = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.elements, key.elements);
        }

        public int hashCode() {
            return Arrays.hashCode(this.elements);
        }
    }
}

