/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.graalvm.buildtools.maven.AbstractNativeImageMojo;
import org.graalvm.buildtools.maven.NativeExtension;
import org.graalvm.buildtools.utils.JUnitPlatformNativeDependenciesHelper;
import org.graalvm.buildtools.utils.JUnitUtils;
import org.graalvm.buildtools.utils.NativeImageConfigurationUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class NativeTestMojo
extends AbstractNativeImageMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipNativeTests", defaultValue="false")
    private boolean skipNativeTests;
    @Parameter(property="skipTestExecution", defaultValue="false")
    private boolean skipTestExecution;
    @Parameter(property="failNoTests", defaultValue="true")
    private boolean failNoTests;

    @Override
    protected void populateApplicationClasspath() throws MojoExecutionException {
        super.populateApplicationClasspath();
        this.imageClasspath.add(Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
        this.project.getBuild().getTestResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(this.imageClasspath::add);
    }

    @Override
    protected List<String> getDependencyScopes() {
        return Arrays.asList("compile", "runtime", "test", "compile+runtime", "provided");
    }

    @Override
    protected void addInferredDependenciesToClasspath() {
        super.addInferredDependenciesToClasspath();
        HashSet<Module> modules = new HashSet<Module>();
        this.pluginArtifacts.stream().map(a -> {
            modules.add(new Module(a.getGroupId(), a.getArtifactId()));
            return a;
        }).filter(it -> it.getGroupId().startsWith("org.graalvm.buildtools") || it.getGroupId().startsWith("org.junit")).map(it -> it.getFile().toPath()).forEach(this.imageClasspath::add);
        List<Path> jars = this.findJunitPlatformNativeJars(modules);
        this.imageClasspath.addAll(jars);
    }

    public void execute() throws MojoExecutionException {
        if (this.skipTests || this.skipNativeTests) {
            this.logger.info("Skipping native-image tests (parameter 'skipTests' or 'skipNativeTests' is true).");
            return;
        }
        if (!this.hasTests()) {
            this.logger.info("Skipped native-image tests since there are no test classes.");
            return;
        }
        if (!this.hasTestIds()) {
            if (this.failNoTests) {
                this.logger.error("Test configuration file wasn't found. Make sure that test execution wasn't skipped.");
                throw new IllegalStateException("Test configuration file wasn't found.");
            }
            this.logger.info("No tests found, skipping.");
            return;
        }
        this.logger.info("====================");
        this.logger.info("Initializing project: " + this.project.getName());
        this.logger.info("====================");
        this.configureEnvironment();
        this.buildArgs.add("--features=org.graalvm.junit.platform.JUnitPlatformFeature");
        this.buildArgs.addAll(JUnitUtils.excludeJUnitClassInitializationFiles());
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap();
        }
        this.systemProperties.put("junit.platform.listeners.uid.tracking.output.dir", NativeExtension.testIdsDirectory(this.outputDirectory.getAbsolutePath()));
        if (this.runtimeArgs == null) {
            this.runtimeArgs = new ArrayList();
        }
        this.imageName = NativeImageConfigurationUtils.NATIVE_TESTS_EXE;
        this.mainClass = "org.graalvm.junit.platform.NativeImageJUnitLauncher";
        this.buildImage();
        if (!this.skipTestExecution) {
            this.runNativeTests(this.outputDirectory.toPath().resolve(NativeImageConfigurationUtils.NATIVE_TESTS_EXE));
        }
    }

    private void configureEnvironment() {
        Plugin failsafe;
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        Plugin surefire = this.project.getPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (surefire != null) {
            plugins.add(surefire);
        }
        if ((failsafe = this.project.getPlugin("org.apache.maven.plugins:maven-failsafe-plugin")) != null) {
            plugins.add(failsafe);
        }
        for (Plugin plugin : plugins) {
            Object configuration = plugin.getConfiguration();
            if (!(configuration instanceof Xpp3Dom)) continue;
            Xpp3Dom dom = (Xpp3Dom)configuration;
            this.applyPluginProperties(dom.getChild("environmentVariables"), this.environment);
            this.applyPluginProperties(dom.getChild("systemPropertyVariables"), this.systemProperties);
        }
    }

    private void applyPluginProperties(Xpp3Dom pluginProperty, Map<String, String> values) {
        if (pluginProperty != null) {
            Xpp3Dom[] children = pluginProperty.getChildren();
            if (values == null) {
                values = new HashMap<String, String>(children.length);
            }
            for (Xpp3Dom child : children) {
                values.put(child.getName(), child.getValue());
            }
        }
    }

    private boolean hasTests() {
        Path testOutputPath = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        if (Files.exists(testOutputPath, new LinkOption[0]) && Files.isDirectory(testOutputPath, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> testClasses = Files.walk(testOutputPath, new FileVisitOption[0]);
                try {
                    bl = testClasses.anyMatch(p -> p.getFileName().toString().endsWith(".class"));
                    if (testClasses == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (testClasses != null) {
                            try {
                                testClasses.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                testClasses.close();
            }
            return bl;
        }
        return false;
    }

    private void runNativeTests(Path executable) throws MojoExecutionException {
        Path xmlLocation = this.outputDirectory.toPath().resolve("native-test-reports");
        if (!xmlLocation.toFile().exists() && !xmlLocation.toFile().mkdirs()) {
            throw new MojoExecutionException("Failed creating xml output directory");
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(executable.toAbsolutePath().toString());
            processBuilder.inheritIO();
            processBuilder.directory(this.session.getCurrentProject().getBasedir());
            ArrayList<String> command = new ArrayList<String>();
            command.add("--xml-output-dir");
            command.add(xmlLocation.toString());
            this.systemProperties.forEach((key, value) -> command.add("-D" + key + "=" + value));
            command.addAll(this.runtimeArgs);
            processBuilder.command().addAll(command);
            processBuilder.environment().putAll(this.environment);
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("native-image test run failed");
        }
    }

    private boolean hasTestIds() {
        try {
            Path buildDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            return this.readAllFiles(buildDir, "junit-platform-unique-ids").anyMatch(contents -> !contents.isEmpty());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return NativeTestMojo.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }

    private DependencyResult resolveDependencies(Consumer<? super CollectRequest> configurer) {
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(repositorySession);
        CollectRequest collectRequest = new CollectRequest();
        List repositories = this.project.getRemoteProjectRepositories();
        collectRequest.setRepositories(repositories);
        configurer.accept((CollectRequest)collectRequest);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        try {
            return this.repositorySystem.resolveDependencies((RepositorySystemSession)newSession, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            return e.getResult();
        }
    }

    private List<Path> findJunitPlatformNativeJars(Set<Module> modulesAlreadyOnClasspath) {
        DependencyResult dependencyResult = this.resolveDependencies(collectRequest -> {
            DefaultArtifact artifact = new DefaultArtifact("org.graalvm.buildtools", "junit-platform-native", null, "jar", "0.11.4");
            Dependency dependency = new Dependency((Artifact)artifact, "runtime");
            collectRequest.addDependency(dependency);
            this.addMissingDependencies((CollectRequest)collectRequest);
        });
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).filter(Objects::nonNull).filter(a -> !modulesAlreadyOnClasspath.contains(new Module(a.getGroupId(), a.getArtifactId()))).map(a -> a.getFile().toPath()).collect(Collectors.toList());
    }

    private void addMissingDependencies(CollectRequest collectRequest) {
        DependencyResult current = this.resolveDependencies(request -> {
            for (org.apache.maven.model.Dependency dependency : this.project.getDependencies()) {
                if (dependency.isOptional()) continue;
                request.addDependency(new Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), "jar", dependency.getVersion()), "runtime"));
            }
        });
        List<JUnitPlatformNativeDependenciesHelper.DependencyNotation> currentClasspath = current.getArtifactResults().stream().map(result -> new JUnitPlatformNativeDependenciesHelper.DependencyNotation(result.getArtifact().getGroupId(), result.getArtifact().getArtifactId(), result.getArtifact().getVersion())).toList();
        List deps = JUnitPlatformNativeDependenciesHelper.inferMissingDependenciesForTestRuntime(currentClasspath);
        for (JUnitPlatformNativeDependenciesHelper.DependencyNotation missing : deps) {
            Dependency missingDependency = new Dependency((Artifact)new DefaultArtifact(missing.groupId(), missing.artifactId(), null, null, missing.version()), "runtime");
            collectRequest.addDependency(missingDependency);
        }
    }

    private static final class Module {
        private final String groupId;
        private final String artifactId;

        private Module(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Module module = (Module)o;
            if (!this.groupId.equals(module.groupId)) {
                return false;
            }
            return this.artifactId.equals(module.artifactId);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }
    }
}

