/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.utils.AgentUtils;
import org.graalvm.buildtools.utils.NativeImageConfigurationUtils;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="native-build-tools")
public class NativeExtension
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED = "junit.platform.listeners.uid.tracking.enabled";
    private static final String JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR = "junit.platform.listeners.uid.tracking.output.dir";
    private static final String NATIVEIMAGE_IMAGECODE = "org.graalvm.nativeimage.imagecode";
    private static Logger logger;

    public void enableLogging(Logger logger) {
        NativeExtension.logger = logger;
    }

    static String testIdsDirectory(String baseDir) {
        return baseDir + File.separator + "test-ids";
    }

    static String buildAgentArgument(String baseDir, Context context, List<String> agentOptions) {
        List<String> options = new ArrayList<String>(agentOptions);
        Object effectiveOutputDir = NativeExtension.agentOutputDirectoryFor(baseDir, context);
        if (context == Context.test) {
            effectiveOutputDir = (String)effectiveOutputDir + File.separator + "session-{pid}-{datetime}";
        }
        String finalEffectiveOutputDir = effectiveOutputDir;
        options = options.stream().map(option -> option.contains("{output_dir}") ? option.replace("{output_dir}", finalEffectiveOutputDir) : option).collect(Collectors.toList());
        return "-agentlib:native-image-agent=" + String.join((CharSequence)",", options);
    }

    static String agentOutputDirectoryFor(String baseDir, Context context) {
        return (baseDir + "/native/agent-output/" + String.valueOf((Object)context)).replace('/', File.separatorChar);
    }

    public void afterProjectsRead(MavenSession session) {
        for (MavenProject project : session.getProjects()) {
            Build build = project.getBuild();
            NativeExtension.withPlugin(build, "native-maven-plugin", nativePlugin -> {
                AgentConfiguration agent;
                String target = build.getDirectory();
                String testIdsDir = NativeExtension.testIdsDirectory(target);
                Xpp3Dom configurationRoot = (Xpp3Dom)nativePlugin.getConfiguration();
                try {
                    agent = AgentUtils.collectAgentProperties(session, configurationRoot);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                List<String> plugins = List.of("maven-surefire-plugin", "maven-failsafe-plugin");
                for (String pluginName : plugins) {
                    NativeExtension.withPlugin(build, pluginName, plugin -> {
                        NativeExtension.configureJunitListener(plugin, testIdsDir);
                        if (agent.isEnabled()) {
                            List agentOptions = agent.getAgentCommandLine();
                            NativeExtension.configureAgentForPlugin(plugin, NativeExtension.buildAgentArgument(target, Context.test, agentOptions));
                        }
                    });
                }
                if (agent.isEnabled()) {
                    NativeExtension.withPlugin(build, "exec-maven-plugin", execPlugin -> NativeExtension.updatePluginConfiguration(execPlugin, (exec, config) -> {
                        if ("java-agent".equals(exec.getId())) {
                            Xpp3Dom commandlineArgs = NativeExtension.findOrAppend(config, "arguments");
                            Xpp3Dom[] arrayOfChildren = commandlineArgs.getChildren();
                            for (int i = 0; i < arrayOfChildren.length; ++i) {
                                commandlineArgs.removeChild(0);
                            }
                            ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
                            Collections.addAll(children, arrayOfChildren);
                            Xpp3Dom arg = new Xpp3Dom("argument");
                            List agentOptions = agent.getAgentCommandLine();
                            arg.setValue(NativeExtension.buildAgentArgument(target, Context.main, agentOptions));
                            children.add(0, arg);
                            arg = new Xpp3Dom("argument");
                            arg.setValue("-Dorg.graalvm.nativeimage.imagecode=agent");
                            children.add(1, arg);
                            for (Xpp3Dom child : children) {
                                commandlineArgs.addChild(child);
                            }
                            NativeExtension.findOrAppend(config, "executable").setValue(NativeExtension.getGraalvmJava());
                        }
                    }));
                    NativeExtension.updatePluginConfiguration(nativePlugin, (exec, configuration) -> {
                        Context context = exec.getGoals().stream().anyMatch("test"::equals) ? Context.test : Context.main;
                        Xpp3Dom agentResourceDirectory = NativeExtension.findOrAppend(configuration, "agentResourceDirectory");
                        agentResourceDirectory.setValue(NativeExtension.agentOutputDirectoryFor(target, context));
                        NativeExtension.setupMergeAgentFiles(exec, configuration, context);
                    });
                }
            });
        }
    }

    private static void setupMergeAgentFiles(PluginExecution exec, Xpp3Dom configuration, Context context) {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("merge-agent-files");
        goals.addAll(exec.getGoals());
        exec.setGoals(goals);
        Xpp3Dom agentContext = NativeExtension.findOrAppend(configuration, "context");
        agentContext.setValue(context.name());
    }

    private static void withPlugin(Build build, String artifactId, Consumer<? super Plugin> consumer) {
        build.getPlugins().stream().filter(p -> artifactId.equals(p.getArtifactId())).findFirst().ifPresent(consumer);
    }

    private static void configureAgentForPlugin(Plugin plugin, String agentArgument) {
        NativeExtension.updatePluginConfiguration(plugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom agent = NativeExtension.findOrAppend(systemProperties, NATIVEIMAGE_IMAGECODE);
            agent.setValue("agent");
            Xpp3Dom argLine = new Xpp3Dom("argLine");
            argLine.setValue(agentArgument);
            configuration.addChild(argLine);
            NativeExtension.findOrAppend(configuration, "jvm").setValue(NativeExtension.getGraalvmJava());
        });
    }

    private static void configureJunitListener(Plugin surefirePlugin, String testIdsDir) {
        NativeExtension.updatePluginConfiguration(surefirePlugin, (exec, configuration) -> {
            Xpp3Dom systemProperties = NativeExtension.findOrAppend(configuration, "systemProperties");
            Xpp3Dom junitTracking = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_ENABLED);
            Xpp3Dom testIdsProperty = NativeExtension.findOrAppend(systemProperties, JUNIT_PLATFORM_LISTENERS_UID_TRACKING_OUTPUT_DIR);
            junitTracking.setValue("true");
            testIdsProperty.setValue(testIdsDir);
        });
    }

    private static void updatePluginConfiguration(Plugin plugin, BiConsumer<PluginExecution, ? super Xpp3Dom> consumer) {
        plugin.getExecutions().forEach(exec -> {
            Xpp3Dom configuration = NativeExtension.configurationBlockOf(exec);
            consumer.accept((PluginExecution)exec, (Xpp3Dom)configuration);
        });
    }

    private static Xpp3Dom configurationBlockOf(PluginExecution exec) {
        Xpp3Dom configuration = (Xpp3Dom)exec.getConfiguration();
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
            exec.setConfiguration((Object)configuration);
        }
        return configuration;
    }

    private static Xpp3Dom findOrAppend(Xpp3Dom parent, String childName) {
        Xpp3Dom child = parent.getChild(childName);
        if (child == null) {
            child = new Xpp3Dom(childName);
            parent.addChild(child);
        }
        return child;
    }

    private static String getGraalvmJava() {
        try {
            return NativeImageConfigurationUtils.getNativeImage(logger).getParent().resolve("java").toString();
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static enum Context {
        main,
        test;

    }
}

